#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Tue 01/Oct/1991")
(component 0 "Context"
 (name "Manufacturing Test Example")
 (description 4 2
  This example is to demonstrate user interaction,
  sequencing of multiple tests, and how to 
  generate and display a report.
  
 )
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "ExitProcess"
   (interface
    (sequence in)
   )
   (implementation
    (comp code 0)
   )
   (views
    (icon
     (origin 61 568)
     (extent 78 64)
     (iconImage "stop.icon")
    )
    (detail
     (origin 70 563)
     (extent 120 34)
    )
    (active icon)
   )
  )
  (component 1 "RepeatUntilBreak"
   (name "Repeat Choices")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 42 388)
     (extent 136 64)
     (iconImage "/usr/lib/veetest/bitmaps/loop.icon")
    )
    (detail
     (origin 55 380)
     (extent 70 40)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "TimeStamp"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "TimeStamp")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 454 396)
     (extent 112 28)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "ToFile"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "tim")
     (optional yes)
    )
   )
   (implementation
    (attr iopath file write "/tmp/mfgdata"
     (readTerm "\n")
     (fs "\n")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "    " QSTR EOL
      WRITE TEXT tim DATE:WDMY TIME:HMS:H12 EOL
      WRITE TEXT "        " QSTR EOL
    )
   )
   (views
    (icon
     (origin 581 393)
     (extent 78 34)
    )
    (detail
     (origin 247 271)
     (extent 457 178)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "DeMultiplexer"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Addr")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Addr 0")
     (lock name constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "Addr 1")
     (lock name constraints)
     (optional yes)
    )
    (output 3
     (type data)
     (name "Addr 2")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 437 148)
     (extent 127 25)
    )
    (detail
     (origin 520 478)
     (extent 70 124)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 5 "IfThenElse"
   (name "If a[i]")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "i")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "a[i]")
   )
   (views
    (icon
     (origin 321 488)
     (extent 78 25)
    )
    (detail
     (origin 243 458)
     (extent 64 104)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "Context"
   (name "User Name")
   (description 3 4
    This object will prompt the user for who they 
    are.  If they select none, it will prompt them
    to get added to the list....
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "EnumConstant"
     (name "Select your Name")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Enum")
       (lock name constraints)
      )
     )
     (implementation
      (component value Enum
       (name "Select your Name")
       (values
        ( "Joe" 0)
        ( "Fred" 1)
        ( "Sally" 2)
        ( "None" 3)
       )
       (datum "Joe")
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Enum
       (shared yes)
       (datum "Joe")
      )
     )
     (views
      (icon
       (origin 63 148)
       (extent 154 25)
      )
      (detail
       (origin 55 187)
       (extent 230 26)
       (format list)
      )
      (active detail)
     )
    )
    (component 1 "IfThenElse"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a==\"None\"")
     )
     (views
      (icon
       (origin 142 340)
       (extent 78 25)
      )
      (detail
       (origin 142 307)
       (extent 149 70)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Confirm"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 151 472)
       (extent 58 37)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Gate"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (tag "InData")
      )
      (output 1
       (type data)
       (name "X")
       (tag "OutData")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 207 398)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "Do"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Do")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 307 398)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "ExitProcess"
     (interface
      (sequence in)
     )
     (implementation
      (comp code 0)
     )
     (views
      (icon
       (origin 291 458)
       (extent 78 64)
       (iconImage "stop.icon")
      )
      (detail
       (origin 531 555)
       (extent 120 34)
      )
      (active icon)
     )
    )
    (component 6 "Context"
     (name "Sorry")
     (description 4 6
      This is just a message box to inform them that
      they were rejected and must be added to the list
      of allowable users.
      
     )
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Note"
       (interface
       )
       (implementation
        (component text 3 9
         ASK YOUR TEST DEVELOPER TO
         ADD YOUR NAME TO THE LIST.
         
        )
       )
       (views
        (icon
         (iconImage "notepad.icon")
        )
        (detail
         (origin 428 272)
         (extent 285 56)
         (editing enabled)
        )
        (active detail)
       )
      )
      (component 1 "Confirm"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 526 380)
         (extent 128 80)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 442 311)
       (extent 378 238)
       (panel
        (origin 143 270)
        (extent 374 200)
        (widget 0 detail
         (title off)
         (origin 190 286)
         (extent 285 56)
         (editing enabled)
        )
        (widget 1 icon
         (title off)
         (origin 269 370)
         (extent 128 80)
        )
       )
      )
     )
     (views
      (icon
       (origin 291 358)
       (extent 78 25)
      )
      (detail
       (origin 415 230)
       (extent 350 300)
       (configuration
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D2:0 D0:0)
     (connect D4:1 D0:1)
     (connect D0:1 D1:1)
     (connect D1:2 D3:0)
     (connect D0:1 D3:1)
     (connect D6:0 D4:0)
     (connect D4:0 D5:0)
     (connect D1:1 D6:0)
     (connect D3:1 O1:1)
    )
    (ShowOnExecPanel
     (origin 333 239)
     (extent 319 312)
     (panel
      (origin 33 113)
      (extent 315 274)
      (widget 0 detail
       (title on)
       (origin 88 161)
       (extent 230 104)
       (format buttons)
      )
      (widget 2 icon
       (title off)
       (origin 97 293)
       (extent 220 49)
      )
     )
    )
   )
   (views
    (icon
     (origin 55 168)
     (extent 110 25)
    )
    (detail
     (origin 37 115)
     (extent 526 450)
     (configuration
      (connect D2:0 D0:0
       (Point 180 511)
       (Point 180 530)
       (Point 20 530)
       (Point 20 130)
       (Point 170 130)
       (Point 170 154)
      )
      (connect D4:1 D0:1
       (Point 355 410)
       (Point 510 410)
       (Point 510 320)
       (Point 30 320)
       (Point 30 200)
       (Point 52 200)
      )
      (connect D0:1 D1:1
       (Point 287 200)
       (Point 310 200)
       (Point 310 240)
       (Point 120 240)
       (Point 120 352)
       (Point 139 352)
      )
      (connect D1:2 D3:0
       (Point 222 362)
       (Point 230 362)
       (Point 230 395)
      )
      (connect D0:1 D3:1
       (Point 287 200)
       (Point 310 200)
       (Point 310 240)
       (Point 120 240)
       (Point 120 410)
       (Point 204 410)
      )
      (connect D6:0 D4:0
       (Point 330 385)
       (Point 330 390)
       (Point 330 390)
       (Point 330 395)
      )
      (connect D4:0 D5:0
       (Point 330 425)
       (Point 330 455)
      )
      (connect D1:1 D6:0
       (Point 222 342)
       (Point 330 342)
       (Point 330 355)
      )
      (connect D3:1 O1:1
       (Point 255 410)
       (Point 269 410)
       (Point 269 435)
       (Point 519 435)
       (Point 519 350)
       (Point 560 350)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "Start"
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 77 92)
     (extent 67 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "ToFile"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "who")
     (optional yes)
    )
   )
   (implementation
    (attr iopath file write "/tmp/mfgdata"
     (readTerm "\n")
     (fs "\n")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "OPERATOR IS: ",who EOL
      WRITE TEXT "            " QSTR EOL
    )
   )
   (views
    (icon
     (origin 201 163)
     (extent 78 34)
    )
    (detail
     (origin 87 111)
     (extent 457 178)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "Context"
   (name "Select a Choice")
   (description 11 4
    This object allows users to select multiple 
    choices.  We could have used an "Enum" choice
    box, but then the user could have only selected
    one at a time. 
    
    The "ALL TESTS" choice simply sends a 1 as the
    new default value to all other toggles.  
    
    The "Concatenator" sends out a single string
    of 1's and 0's that specifies the correct
    test sequence.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "TestVector")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "TotSize")
     (lock constraints)
     (optional yes)
    )
    (output 3
     (type data)
     (name "Toggle")
     (lock constraints)
     (optional yes)
    )
    (output 4
     (type exception)
     (name "Error")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked yes)
    (component 0 "RepeatUntilBreak"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 5 468)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Generate Report")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Default Value")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Toggle")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Generate Report")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate on)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 174 607)
       (extent 192 27)
       (format check box)
      )
      (detail
       (origin 390 570)
       (extent 40 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Toggle"
     (name "Test #2        ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Default Value")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Toggle")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Test #2        ")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate on)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 174 507)
       (extent 192 27)
       (format check box)
      )
      (detail
       (origin 250 440)
       (extent 44 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Toggle"
     (name "Test #1        ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Default Value")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Toggle")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Test #1        ")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate on)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 174 457)
       (extent 192 27)
       (format check box)
      )
      (detail
       (origin 250 390)
       (extent 40 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "Confirm"
     (name "All Tests")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin -1 562)
       (extent 103 37)
      )
      (detail
       (origin 378 550)
       (extent 95 40)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "Constant"
     (name "1")
     (subType "Integer")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Int32")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "1")
       (datum 1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 87 608)
       (extent 46 25)
      )
      (detail
       (origin 75 464)
       (extent 150 32)
       (showFormat int)
      )
      (active icon)
     )
    )
    (component 6 "Toggle"
     (name "Test #3        ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Default Value")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Toggle")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Test #3        ")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate on)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 174 557)
       (extent 192 27)
       (format check box)
      )
      (detail
       (origin 280 510)
       (extent 47 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "ExitContext"
     (interface
      (sequence in)
     )
     (implementation
     )
     (views
      (icon
       (origin 8 418)
       (extent 145 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 8 "Confirm"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 51 372)
       (extent 58 37)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 9 "Confirm"
     (name "Exit")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 291 372)
       (extent 58 37)
      )
      (detail
       (origin 241 550)
       (extent 68 40)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 10 "Escape"
     (interface
      (sequence in)
     )
     (implementation
      (component code 0)
      (component message "")
     )
     (views
      (icon
       (origin 331 418)
       (extent 78 25)
      )
      (detail
       (origin 166 639)
       (extent 149 63)
      )
      (active icon)
     )
    )
    (component 11 "VectorConcatenator"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (optional yes)
      )
      (input 3
       (type data)
       (name "C")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 401 508)
       (extent 118 45)
      )
      (detail
       (origin 335 480)
       (extent 90 160)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 12 "FromArray"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (tag "Ary")
      )
      (output 1
       (type data)
       (name "SubAry")
       (tag "Result")
       (lock constraints)
      )
      (output 2
       (type data)
       (name "Type")
       (tag "Type")
       (lock constraints)
      )
      (output 3
       (type data)
       (name "NumDims")
       (tag "NumDims")
       (lock constraints)
      )
      (output 4
       (type data)
       (name "DimSizes")
       (tag "DimSizes")
       (lock constraints)
      )
      (output 5
       (type data)
       (name "TotSize")
       (tag "TotSize")
       (lock constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary")
     )
     (views
      (icon
       (origin 435 418)
       (extent 110 64)
       (iconImage "unbuild.icon")
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 13 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a")
     )
     (views
      (icon
       (origin 397 588)
       (extent 46 25)
      )
      (detail
       (origin 298 605)
       (extent 55 70)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 14 "Gate"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (tag "InData")
      )
      (output 1
       (type data)
       (name "X")
       (tag "OutData")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 457 618)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D6:0 D1:0)
     (connect D5:1 D1:1)
     (connect D3:0 D2:0)
     (connect D5:1 D2:1)
     (connect D8:1 D3:0)
     (connect D5:1 D3:1)
     (connect D0:1 D4:0)
     (connect D4:1 D5:0)
     (connect D2:0 D6:0)
     (connect D5:1 D6:1)
     (connect D8:0 D7:0)
     (connect D9:1 D10:0)
     (connect D3:1 D11:1)
     (connect D2:1 D11:2)
     (connect D6:1 D11:3)
     (connect D11:1 D12:1)
     (connect D1:1 D13:1)
     (connect D13:1 D14:0)
     (connect I1:1 D14:1)
     (connect D11:1 O1:1)
     (connect D12:5 O2:1)
     (connect D14:1 O3:1)
    )
    (ShowOnExecPanel
     (origin 315 259)
     (extent 356 271)
     (panel
      (origin 4 434)
      (extent 352 233)
      (widget 4 icon
       (title off)
       (origin 238 479)
       (extent 103 37)
      )
      (widget 6 icon
       (title off)
       (origin 22 520)
       (extent 192 27)
       (format check box)
      )
      (widget 1 icon
       (title off)
       (origin 21 557)
       (extent 192 27)
       (format check box)
      )
      (widget 8 icon
       (title off)
       (origin 98 607)
       (extent 58 37)
      )
      (widget 9 icon
       (title off)
       (origin 208 609)
       (extent 58 37)
      )
      (widget 3 icon
       (title off)
       (origin 22 447)
       (extent 192 27)
       (format check box)
      )
      (widget 2 icon
       (title off)
       (origin 22 484)
       (extent 192 27)
       (format check box)
      )
     )
    )
   )
   (views
    (icon
     (origin 38 488)
     (extent 145 45)
    )
    (detail
     (origin 1 359)
     (extent 578 303)
     (configuration
      (connect D6:0 D1:0
       (Point 270 586)
       (Point 270 604)
      )
      (connect D5:1 D1:1
       (Point 135 620)
       (Point 171 620)
      )
      (connect D3:0 D2:0
       (Point 270 486)
       (Point 270 504)
      )
      (connect D5:1 D2:1
       (Point 135 620)
       (Point 150 620)
       (Point 150 520)
       (Point 171 520)
      )
      (connect D8:1 D3:0
       (Point 111 390)
       (Point 270 390)
       (Point 270 454)
      )
      (connect D5:1 D3:1
       (Point 135 620)
       (Point 150 620)
       (Point 150 470)
       (Point 171 470)
      )
      (connect D0:1 D4:0
       (Point 117 500)
       (Point 130 500)
       (Point 130 550)
       (Point 50 550)
       (Point 50 559)
      )
      (connect D4:1 D5:0
       (Point 104 580)
       (Point 110 580)
       (Point 110 605)
      )
      (connect D2:0 D6:0
       (Point 270 536)
       (Point 270 554)
      )
      (connect D5:1 D6:1
       (Point 135 620)
       (Point 150 620)
       (Point 150 570)
       (Point 171 570)
      )
      (connect D8:0 D7:0
       (Point 80 411)
       (Point 80 415)
      )
      (connect D9:1 D10:0
       (Point 351 390)
       (Point 370 390)
       (Point 370 415)
      )
      (connect D3:1 D11:1
       (Point 368 470)
       (Point 390 470)
       (Point 390 520)
       (Point 398 520)
      )
      (connect D2:1 D11:2
       (Point 368 520)
       (Point 380 520)
       (Point 380 530)
       (Point 398 530)
      )
      (connect D6:1 D11:3
       (Point 368 570)
       (Point 390 570)
       (Point 390 540)
       (Point 398 540)
      )
      (connect D11:1 D12:1
       (Point 521 530)
       (Point 540 530)
       (Point 540 500)
       (Point 420 500)
       (Point 420 450)
       (Point 432 450)
      )
      (connect D1:1 D13:1
       (Point 368 620)
       (Point 380 620)
       (Point 380 600)
       (Point 394 600)
      )
      (connect D13:1 D14:0
       (Point 445 590)
       (Point 480 590)
       (Point 480 615)
      )
      (connect I1:1 D14:1
       (Point 3 520)
       (Point 10 520)
       (Point 10 650)
       (Point 390 650)
       (Point 390 630)
       (Point 454 630)
      )
      (connect D11:1 O1:1
       (Point 521 530)
       (Point 540 530)
       (Point 540 500)
       (Point 420 500)
       (Point 420 400)
       (Point 576 400)
      )
      (connect D12:5 O2:1
       (Point 547 470)
       (Point 560 470)
       (Point 560 480)
       (Point 576 480)
      )
      (connect D14:1 O3:1
       (Point 505 630)
       (Point 540 630)
       (Point 540 560)
       (Point 576 560)
      )
     )
    )
    (active icon)
   )
  )
  (component 10 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 592 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 11 "ForCount"
   (name "Step thru")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Count")
     (tag "Count")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Count")
     (lock name constraints)
    )
    (buffers in
     (buffer "Count")
    )
   )
   (implementation
    (component count 3)
   )
   (views
    (icon
     (origin 305 538)
     (extent 110 64)
     (iconImage "loop.icon")
    )
    (detail
     (origin 525 553)
     (extent 170 34)
    )
    (active icon)
   )
  )
  (component 12 "Context"
   (name "Data from Tests")
   (description 4 4
    This object just reads in the information that
    was stored to the mfgdata file in the other
    user objects.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Confirm"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 261 542)
       (extent 58 37)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Break"
     (interface
      (sequence in)
     )
     (implementation
     )
     (views
      (icon
       (origin 251 658)
       (extent 78 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "ToFile"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
     )
     (implementation
      (attr iopath file write "/tmp/mfgdata"
       (readTerm "\n")
       (fs "\n")
       (eol "\n")
       (multiField fullSyntax)
       (arrayFormat block)
      )
      (procedure
        WRITE TEXT "OPERATOR is: ",a EOL
        WRITE TEXT "   " EOL
      )
     )
     (views
      (icon
       (origin 251 603)
       (extent 78 34)
      )
      (detail
       (origin 98 466)
       (extent 395 148)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "ScrollingTextDisplay"
     (name "Data from Tests")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (origin 875 368)
       (extent 145 25)
      )
      (detail
       (origin 379 428)
       (extent 442 225)
       (bufferSize 256)
      )
      (active detail)
     )
    )
    (component 4 "FromFile"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "X")
       (lock constraints)
       (optional yes)
      )
      (output 2
       (type data)
       (name "EOF")
       (tag "EOF")
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (attr iopath file read "/tmp/mfgdata"
       (readTerm "\n")
       (fs " ")
       (eol "\n")
       (multiField fullSyntax)
       (arrayFormat block)
      )
      (procedure
        READ TEXT x STR COUNT:1
      )
     )
     (views
      (icon
       (origin 155 478)
       (extent 110 25)
      )
      (detail
       (origin 43 414)
       (extent 324 153)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "RepeatUntilBreak"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 55 398)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D4:2 D0:0)
     (connect D2:0 D1:0)
     (connect D0:1 D2:0)
     (connect I1:1 D2:1)
     (connect D4:1 D3:1)
     (connect D5:1 D4:0)
    )
    (ShowOnExecPanel
     (origin 267 164)
     (extent 448 552)
     (panel
      (origin 138 173)
      (extent 444 514)
      (widget 3 detail
       (title off)
       (origin 147 179)
       (extent 415 423)
       (bufferSize 256)
      )
      (widget 0 icon
       (title off)
       (origin 156 612)
       (extent 398 66)
      )
     )
    )
   )
   (views
    (icon
     (origin 288 628)
     (extent 145 25)
    )
    (detail
     (origin 9 362)
     (extent 742 336)
     (configuration
      (connect D4:2 D0:0
       (Point 267 500)
       (Point 290 500)
       (Point 290 539)
      )
      (connect D2:0 D1:0
       (Point 290 639)
       (Point 290 655)
      )
      (connect D0:1 D2:0
       (Point 321 560)
       (Point 330 560)
       (Point 330 590)
       (Point 290 590)
       (Point 290 600)
      )
      (connect I1:1 D2:1
       (Point 11 540)
       (Point 150 540)
       (Point 150 620)
       (Point 248 620)
      )
      (connect D4:1 D3:1
       (Point 267 480)
       (Point 340 480)
       (Point 340 540)
       (Point 376 540)
      )
      (connect D5:1 D4:0
       (Point 167 430)
       (Point 210 430)
       (Point 210 475)
      )
     )
    )
    (active icon)
   )
  )
  (component 13 "Context"
   (name "Test #1")
   (description 4 4
    Test one is to show how to view data as it is
    received and then to have the option of viewing
    additional choices.
    
   )
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "ForCount"
     (name "For Count 50")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component count 50)
     )
     (views
      (icon
       (origin 101 368)
       (extent 118 64)
       (iconImage "loop.icon")
      )
      (detail
       (origin 54 213)
       (extent 192 34)
      )
      (active icon)
     )
    )
    (component 1 "RandomNumber"
     (name "Random Number")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Rand Val")
       (lock name constraints)
      )
     )
     (implementation
      (component lowerLimit -1)
      (component upperLimit 1)
     )
     (views
      (icon
       (origin 277 418)
       (extent 127 25)
      )
      (detail
       (origin 237 180)
       (extent 222 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "YPlot"
     (name "Data Being Collected...")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Trace1")
       (lock constraints)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
      (component tracePin 1)
      (component graphMode strip)
     )
     (views
      (icon
       (extent 217 0)
       (iconImage "display.icon")
      )
      (detail
       (origin 475 356)
       (extent 291 149)
       (displayMode graphOnly)
       (graphType cartesian)
       (gridType axis)
       (scale 0
        (name "Y name")
        (domainName "X name")
        (pen 9)
        (show 1)
        (range -1 1 3 linear)
       )
       (domain 0 49.00000000000053 4 linear)
       (trace 0 onScale 0
        (name "Trace1")
        (pen 4)
        (lineType 1)
        (pointType 0)
       )
       (stepSize 1)
       (trackingEnabled 1)
      )
      (active detail)
     )
    )
    (component 3 "Start"
     (interface
      (sequence out)
     )
     (implementation
     )
     (views
      (icon
       (origin 127 302)
       (extent 67 37)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "Collector"
     (name "Collector")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
      (input 2
       (type trigger)
       (name "XEQ")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (origin 285 488)
       (extent 110 25)
      )
      (detail
       (origin 175 448)
       (extent 33 104)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "Formula"
     (name "movingAvg(x,numPts)")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "numPts")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "movingAvg(x,numPts)")
     )
     (views
      (icon
       (origin 270 558)
       (extent 181 25)
      )
      (detail
       (origin 688 315)
       (extent 205 110)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 6 "Context"
     (name "More Info ?")
     (description 3 6
      This is just to prompt for showing more 
      information.
      
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (optional yes)
      )
      (input 2
       (type data)
       (name "Average")
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "ExitContext"
       (interface
        (sequence in)
       )
       (implementation
       )
       (views
        (icon
         (origin 958 588)
         (extent 145 25)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Confirm"
       (name "No, Exit")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type trigger)
         (name "XEQ")
         (lock name constraints)
         (optional yes)
        )
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 973 512)
         (extent 94 37)
        )
        (detail
         (origin 872 420)
         (extent 76 40)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "Confirm"
       (name "YES, More Info")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 716 522)
         (extent 148 37)
        )
        (detail
         (origin 535 360)
         (extent 140 40)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 3 "Note"
       (name "More Information ?")
       (interface
       )
       (implementation
        (component text 1 9
         Do yh
        )
       )
       (views
        (icon
         (origin 794 398)
         (extent 172 64)
         (iconImage "notepad.icon")
        )
        (detail
         (origin 492 225)
         (extent 417 90)
         (editing enabled)
        )
        (active icon)
       )
      )
      (component 4 "Context"
       (name "Final Data")
       (description 6 8
        After choosing more info...Note that this
        object actually finds the Min Point and 
        Max Point, and then must build the line.
        
        Note also that the Standard Deviation could
        have been plotted as well.
       )
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (optional yes)
        )
        (input 2
         (type data)
         (name "Average")
         (optional yes)
        )
        (output 1
         (type exception)
         (name "Error")
         (lock name constraints)
         (optional yes)
        )
       )
       (implementation
        (trigMode deg)
        (locked no)
        (component 0 "YPlot"
         (name "Final Data")
         (interface
          (sequence in)
          (sequence out)
          (input 1
           (type data)
           (name "Data")
           (lock constraints)
          )
          (input 2
           (type data)
           (name "Average")
           (lock constraints)
           (optional yes)
          )
          (input 3
           (type data)
           (name "Min Pt.")
           (lock constraints)
           (optional yes)
          )
          (input 4
           (type data)
           (name "Max Pt.")
           (lock constraints)
           (optional yes)
          )
         )
         (implementation
          (component clearAtPrerun 1)
          (component clearAtActivate 0)
          (component tracePin 1)
          (component tracePin 2)
          (component tracePin 3)
          (component tracePin 4)
          (component graphMode strip)
         )
         (views
          (icon
           (origin 915 458)
           (extent 110 64)
           (iconImage "display.icon")
          )
          (detail
           (origin 342 278)
           (extent 336 304)
           (displayMode annotGraph)
           (graphType cartesian)
           (gridType frame)
           (scale 0
            (name "Y name")
            (domainName "X name")
            (pen 9)
            (show 1)
            (range -1.2 1.2 3 linear)
           )
           (domain 0 49 4 linear)
           (trace 0 onScale 0
            (name "Data")
            (pen 4)
            (lineType 1)
            (pointType 0)
           )
           (trace 1 onScale 0
            (name "Average")
            (pen 7)
            (lineType 1)
            (pointType 0)
           )
           (trace 2 onScale 0
            (name "Min Pt.")
            (pen 6)
            (lineType 1)
            (pointType 0)
           )
           (trace 3 onScale 0
            (name "Max Pt.")
            (pen 2)
            (lineType 1)
            (pointType 0)
           )
           (stepSize 1)
           (trackingEnabled 1)
          )
          (active detail)
         )
        )
        (component 1 "Formula"
         (name "sdev(x)")
         (interface
          (sequence in)
          (sequence out)
          (input 1
           (type data)
           (name "X")
           (lock name constraints)
          )
          (output 1
           (type data)
           (name "Result")
           (lock name constraints)
          )
         )
         (implementation
          (component isLocked yes)
          (component expr 1 "sdev(x)")
         )
         (views
          (icon
           (origin 301 608)
           (extent 78 25)
          )
          (detail
          )
          (terminals on)
          (active icon)
         )
        )
        (component 2 "AllocateArray"
         (name "Build Max")
         (interface
          (sequence in)
          (sequence out)
          (input 1
           (type data)
           (name "Init Value")
           (tag "Init Value")
           (requires
            (datatype Real)
            (shape "Scalar")
           )
           (lock constraints)
           (optional yes)
          )
          (output 1
           (type data)
           (name "Array")
           (tag "Array")
           (lock constraints)
          )
          (buffers in
           (buffer "Init Value")
          )
         )
         (implementation
          (component numDims 1)
          (component dimSizes "50")
          (component type "Real")
          (component initEnum "Init Value")
          (component initialValue
           (name "Init Value")
           (datum 0.9305492803934357)
          )
          (component from 0)
          (component thru 0)
         )
         (views
          (icon
           (origin 212 515)
           (extent 96 31)
          )
          (detail
           (origin 404 543)
           (extent 220 134)
          )
          (terminals on)
          (active icon)
         )
        )
        (component 3 "AllocateArray"
         (name "Build Min")
         (interface
          (sequence in)
          (sequence out)
          (input 1
           (type data)
           (name "Init Value")
           (tag "Init Value")
           (requires
            (datatype Real)
            (shape "Scalar")
           )
           (lock constraints)
           (optional yes)
          )
          (output 1
           (type data)
           (name "Array")
           (tag "Array")
           (lock constraints)
          )
          (buffers in
           (buffer "Init Value")
          )
         )
         (implementation
          (component numDims 1)
          (component dimSizes "50")
          (component type "Real")
          (component initEnum "Init Value")
          (component initialValue
           (name "Init Value")
           (datum -0.9754673441717543)
          )
          (component from 0)
          (component thru 0)
         )
         (views
          (icon
           (origin 204 443)
           (extent 92 35)
          )
          (detail
           (origin 395 443)
           (extent 220 134)
          )
          (terminals on)
          (active icon)
         )
        )
        (component 4 "Formula"
         (name "min(x)")
         (interface
          (sequence in)
          (sequence out)
          (input 1
           (type data)
           (name "X")
           (lock name constraints)
          )
          (output 1
           (type data)
           (name "Result")
           (lock name constraints)
          )
         )
         (implementation
          (component isLocked yes)
          (component expr 1 "min(x)")
         )
         (views
          (icon
           (origin 91 448)
           (extent 78 25)
          )
          (detail
           (origin 301 483)
           (extent 88 54)
          )
          (terminals on)
          (active icon)
         )
        )
        (component 5 "Formula"
         (name "max(x)")
         (interface
          (sequence in)
          (sequence out)
          (input 1
           (type data)
           (name "X")
           (lock name constraints)
          )
          (output 1
           (type data)
           (name "Result")
           (lock name constraints)
          )
         )
         (implementation
          (component isLocked yes)
          (component expr 1 "max(x)")
         )
         (views
          (icon
           (origin 111 518)
           (extent 78 25)
          )
          (detail
          )
          (terminals on)
          (active icon)
         )
        )
        (component 6 "TextDisplay"
         (name "Std Deviation")
         (interface
          (sequence in)
          (sequence out)
          (input 1
           (type data)
           (name "Data")
          )
         )
         (implementation
          (component clearAtPrerun 1)
          (component clearAtActivate 1)
         )
         (views
          (icon
           (origin 997 668)
           (extent 127 25)
          )
          (detail
           (origin 505 603)
           (extent 201 34)
          )
          (active detail)
         )
        )
        (component 7 "Confirm"
         (interface
          (sequence in)
          (sequence out)
          (output 1
           (type data)
           (name "Go")
           (lock name constraints)
          )
         )
         (implementation
         )
         (views
          (icon
           (origin 106 242)
           (extent 58 37)
          )
          (detail
          )
          (terminals on)
          (active icon)
         )
        )
        (component 8 "Escape"
         (interface
          (sequence in)
         )
         (implementation
          (component code 0)
          (component message "")
         )
         (views
          (icon
           (origin 196 278)
           (extent 78 25)
          )
          (detail
           (origin 486 289)
           (extent 149 63)
          )
          (active icon)
         )
        )
        (configuration
         (connect I1:1 D0:1)
         (connect I2:1 D0:2)
         (connect D3:1 D0:3)
         (connect D2:1 D0:4)
         (connect I1:1 D1:1)
         (connect D5:1 D2:1)
         (connect D4:1 D3:1)
         (connect I1:1 D4:1)
         (connect I1:1 D5:1)
         (connect D1:1 D6:1)
         (connect D7:1 D8:0)
        )
        (ShowOnExecPanel
         (origin 261 200)
         (extent 401 511)
         (panel
          (origin 302 404)
          (extent 397 473)
          (widget 0 detail
           (title on)
           (origin 335 454)
           (extent 336 304)
           (displayMode annotGraph)
           (graphType cartesian)
           (gridType frame)
           (scale 0
            (name "Y name")
            (domainName "X name")
            (pen 9)
            (show 1)
            (range -1.2 1.2 3 linear)
           )
           (domain 0 49 4 linear)
           (trace 0 onScale 0
            (name "Data")
            (pen 4)
            (lineType 1)
            (pointType 0)
           )
           (trace 1 onScale 0
            (name "Average")
            (pen 7)
            (lineType 1)
            (pointType 0)
           )
           (trace 2 onScale 0
            (name "Min Pt.")
            (pen 6)
            (lineType 1)
            (pointType 0)
           )
           (trace 3 onScale 0
            (name "Max Pt.")
            (pen 2)
            (lineType 1)
            (pointType 0)
           )
           (stepSize 1)
           (trackingEnabled 1)
          )
          (widget 7 icon
           (title off)
           (origin 600 782)
           (extent 58 37)
          )
          (widget 6 detail
           (title on)
           (origin 339 803)
           (extent 201 34)
          )
         )
        )
       )
       (views
        (icon
         (origin 435 628)
         (extent 110 25)
        )
        (detail
         (origin 66 211)
         (extent 668 459)
         (configuration
          (connect I1:1 D0:1
           (Point 68 330)
           (Point 75 330)
           (Point 75 320)
           (Point 339 320)
          )
          (connect I2:1 D0:2
           (Point 68 570)
           (Point 115 570)
           (Point 115 500)
           (Point 185 500)
           (Point 185 390)
           (Point 339 390)
          )
          (connect D3:1 D0:3
           (Point 298 460)
           (Point 315 460)
           (Point 315 460)
           (Point 339 460)
          )
          (connect D2:1 D0:4
           (Point 310 530)
           (Point 325 530)
           (Point 325 530)
           (Point 339 530)
          )
          (connect I1:1 D1:1
           (Point 68 330)
           (Point 75 330)
           (Point 75 530)
           (Point 95 530)
           (Point 95 620)
           (Point 298 620)
          )
          (connect D5:1 D2:1
           (Point 191 530)
           (Point 209 530)
          )
          (connect D4:1 D3:1
           (Point 171 460)
           (Point 201 460)
          )
          (connect I1:1 D4:1
           (Point 68 330)
           (Point 75 330)
           (Point 75 460)
           (Point 88 460)
          )
          (connect I1:1 D5:1
           (Point 68 330)
           (Point 75 330)
           (Point 75 530)
           (Point 108 530)
          )
          (connect D1:1 D6:1
           (Point 381 620)
           (Point 502 620)
          )
          (connect D7:1 D8:0
           (Point 166 260)
           (Point 235 260)
           (Point 235 275)
          )
         )
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
       (connect D1:1 D0:0)
       (connect D4:1 D1:1)
       (connect D2:1 D4:0)
       (connect I1:1 D4:1)
       (connect I2:1 D4:2)
      )
      (ShowOnExecPanel
       (origin 107 283)
       (extent 269 185)
       (panel
        (origin 493 517)
        (extent 265 147)
        (widget 2 icon
         (title off)
         (origin 501 603)
         (extent 148 37)
        )
        (widget 3 icon
         (title off)
         (origin 543 528)
         (extent 172 64)
         (iconImage "notepad.icon")
        )
        (widget 1 icon
         (title off)
         (origin 658 603)
         (extent 94 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 565 588)
       (extent 110 25)
      )
      (detail
       (origin 212 286)
       (extent 687 629)
       (configuration
        (connect D1:1 D0:0
         (Point 1069 530)
         (Point 1110 530)
         (Point 1110 570)
         (Point 1030 570)
         (Point 1030 585)
        )
        (connect D4:1 D1:1
         (Point 547 640)
         (Point 880 640)
         (Point 880 530)
         (Point 970 530)
        )
        (connect D2:1 D4:0
         (Point 866 540)
         (Point 890 540)
         (Point 890 490)
         (Point 1070 490)
         (Point 1070 350)
         (Point 490 350)
         (Point 490 625)
        )
        (connect I1:1 D4:1
         (Point 214 450)
         (Point 201 450)
         (Point 201 630)
         (Point 432 630)
        )
        (connect I2:1 D4:2
         (Point 214 770)
         (Point 201 770)
         (Point 201 650)
         (Point 432 650)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "ToFile"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "dta")
       (optional yes)
      )
     )
     (implementation
      (attr iopath file write "/tmp/mfgdata"
       (readTerm "\n")
       (fs "\n")
       (eol "\n")
       (multiField fullSyntax)
       (arrayFormat block)
      )
      (procedure
        WRITE TEXT "    " QSTR EOL
        WRITE TEXT "DATA FROM TEST 1" EOL
        WRITE TEXT "--------------------------------------------------------" EOL
        WRITE TEXT dta REAL STD:4 EOL
      )
     )
     (views
      (icon
       (origin 581 533)
       (extent 78 34)
      )
      (detail
       (origin 397 421)
       (extent 457 178)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D3:0 D0:0)
     (connect D0:1 D1:0)
     (connect D1:1 D2:1)
     (connect D1:1 D4:1)
     (connect D0:0 D4:2)
     (connect D4:1 D5:1)
     (connect D0:1 D5:2)
     (connect D4:1 D6:1)
     (connect D5:1 D6:2)
     (connect D4:1 D7:1)
    )
    (ShowOnExecPanel
     (origin 76 210)
     (extent 880 319)
     (panel
      (origin 2 340)
      (extent 876 281)
      (widget 2 detail
       (title on)
       (origin 397 412)
       (extent 387 147)
       (displayMode graphOnly)
       (graphType cartesian)
       (gridType axis)
       (scale 0
        (name "Y name")
        (domainName "X name")
        (pen 9)
        (show 1)
        (range -1 1 3 linear)
       )
       (domain 0 49.00000000000053 4 linear)
       (trace 0 onScale 0
        (name "Trace1")
        (pen 4)
        (lineType 1)
        (pointType 0)
       )
       (stepSize 1)
       (trackingEnabled 1)
      )
     )
    )
   )
   (views
    (icon
     (origin 751 458)
     (extent 78 25)
    )
    (detail
     (origin 86 245)
     (extent 688 450)
     (configuration
      (connect D3:0 D0:0
       (Point 160 341)
       (Point 160 365)
      )
      (connect D0:1 D1:0
       (Point 221 400)
       (Point 340 400)
       (Point 340 415)
      )
      (connect D1:1 D2:1
       (Point 406 430)
       (Point 472 430)
      )
      (connect D1:1 D4:1
       (Point 406 430)
       (Point 420 430)
       (Point 420 460)
       (Point 270 460)
       (Point 270 490)
       (Point 282 490)
      )
      (connect D0:0 D4:2
       (Point 160 434)
       (Point 160 510)
       (Point 282 510)
      )
      (connect D4:1 D5:1
       (Point 397 500)
       (Point 410 500)
       (Point 410 530)
       (Point 260 530)
       (Point 260 560)
       (Point 267 560)
      )
      (connect D0:1 D5:2
       (Point 221 400)
       (Point 240 400)
       (Point 240 580)
       (Point 267 580)
      )
      (connect D4:1 D6:1
       (Point 397 500)
       (Point 410 500)
       (Point 410 530)
       (Point 530 530)
       (Point 530 590)
       (Point 562 590)
      )
      (connect D5:1 D6:2
       (Point 453 570)
       (Point 470 570)
       (Point 470 610)
       (Point 562 610)
      )
      (connect D4:1 D7:1
       (Point 397 500)
       (Point 410 500)
       (Point 410 530)
       (Point 530 530)
       (Point 530 550)
       (Point 578 550)
      )
     )
    )
    (active icon)
   )
  )
  (component 14 "Context"
   (name "Test #2")
   (description 12 4
    Test 2 will check a noisy waveform against a 
    set of pre-determined coordinates.  Here we 
    use a coordinate constant.  Instead, we could
    have read the coordinate points from a file.
    
    The most powerful object in this test is the
    comparator.  Note that it was used to compare
    coordinate points to a waveform, and included 
    the ability to interpolate between points.
    
    Note that the '+' object simply concatenates the
    string to the value.
   )
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "YPlot"
     (name "MASK TEST")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Noisy Wave")
       (lock constraints)
      )
      (input 2
       (type data)
       (name "UpperLimit")
       (lock constraints)
       (optional yes)
      )
      (input 3
       (type data)
       (name "UpperFail")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
      (component tracePin 1)
      (component tracePin 2)
      (component tracePin 3)
      (component graphMode time)
     )
     (views
      (icon
       (extent 110 0)
       (iconImage "display.icon")
      )
      (detail
       (origin 717 207)
       (extent 346 266)
       (displayMode annotGraph)
       (graphType cartesian)
       (gridType grid)
       (scale 0
        (name "Mag")
        (domainName "Time")
        (pen 9)
        (show 1)
        (range -2 2 4 linear)
       )
       (domain 0 0.02 4 linear)
       (trace 0 onScale 0
        (name "Noisy Wave")
        (pen 4)
        (lineType 1)
        (pointType 0)
       )
       (trace 1 onScale 0
        (name "UpperLimit")
        (pen 7)
        (lineType 1)
        (pointType 0)
       )
       (trace 2 onScale 0
        (name "UpperFail")
        (pen 2)
        (lineType 2)
        (pointType 1)
       )
      )
      (active detail)
     )
    )
    (component 1 "Formula"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "a+1")
     )
     (views
      (icon
       (origin 491 138)
       (extent 78 64)
       (iconImage "formula.icon")
      )
      (detail
       (origin 626 100)
       (extent 79 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Meter"
     (name "Test Number")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock name constraints)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
      (component range 0 30)
     )
     (views
      (icon
       (origin 595 158)
       (extent 110 25)
      )
      (detail
       (origin 579 128)
       (extent 183 124)
      )
      (active icon)
     )
    )
    (component 3 "Counter"
     (name "# of Failures")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
      (output 1
       (type data)
       (name "Count")
       (tag "Count")
       (lock name constraints)
      )
     )
     (implementation
      (component clearAtPrerun 0)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (origin 717 508)
       (extent 127 25)
      )
      (detail
       (origin 551 539)
       (extent 129 63)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "Formula"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "((a/b)*100)")
     )
     (views
      (icon
       (origin 731 608)
       (extent 78 64)
       (iconImage "formula.icon")
      )
      (detail
       (origin 679 308)
       (extent 133 104)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "Constant"
     (name "Upper Limit")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Coord
       (name "Upper Limit")
       (numDims 1)
       (size 6)
       (numCoordDims 2)
       (data
        [ (0,0.5) (0.0022,1.2) (0.007200000000000001,1.2) (0.0132,-0.5) (0.0162,-0.5) (0.02,0.5) ]
       )
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Coord
       (numCoordDims 2)
       (datum (0,0))
      )
     )
     (views
      (icon
       (origin 115 498)
       (extent 110 25)
      )
      (detail
       (origin 106 347)
       (extent 249 126)
      )
      (active detail)
     )
    )
    (component 6 "ForRange"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
      (component from 5)
      (component thru 1)
      (component step -1)
     )
     (views
      (icon
       (origin 145 568)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
       (origin 135 537)
       (extent 170 86)
      )
      (active icon)
     )
    )
    (component 7 "ExitContext"
     (interface
      (sequence in)
     )
     (implementation
     )
     (views
      (icon
       (origin 128 658)
       (extent 145 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 8 "Formula"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "\"WAITING...\"+a")
     )
     (views
      (icon
       (origin 291 568)
       (extent 78 64)
       (iconImage "formula.icon")
      )
      (detail
       (origin 245 378)
       (extent 160 104)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 9 "TextDisplay"
     (name "AlphaNumeric")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
      )
      (detail
       (origin 414 612)
       (extent 192 37)
      )
      (active detail)
     )
    )
    (component 10 "Delay"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Done")
       (tag "Done")
       (lock constraints)
      )
     )
     (implementation
      (component delay 0.8)
     )
     (views
      (icon
       (origin 471 668)
       (extent 78 25)
      )
      (detail
       (origin 555 633)
       (extent 130 34)
      )
      (active icon)
     )
    )
    (component 11 "ForCount"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Count")
       (lock name constraints)
      )
     )
     (implementation
      (component count 30)
     )
     (views
      (icon
       (iconImage "loop.icon")
      )
      (detail
       (origin 95 243)
       (extent 170 34)
      )
      (active detail)
     )
    )
    (component 12 "Start"
     (interface
      (sequence out)
     )
     (implementation
     )
     (views
      (icon
       (origin 147 152)
       (extent 67 37)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 13 "RandomNumber"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Rand Val")
       (lock name constraints)
      )
     )
     (implementation
      (component lowerLimit 0.2)
      (component upperLimit 0.23)
     )
     (views
      (icon
       (origin 317 188)
       (extent 127 25)
      )
      (detail
       (origin 169 250)
       (extent 222 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 14 "VNoiseGenerator"
     (name "Noise Generator")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Amplitude")
       (tag "Amplitude")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "noise WF")
       (tag "noiseWF")
       (lock name constraints)
      )
      (buffers in
       (buffer "Amplitude")
      )
     )
     (implementation
      (component amplitude 0.2001999532770134)
      (component numPoints 256)
      (component interval 0.02)
     )
     (views
      (icon
       (origin 425 225)
       (extent 151 31)
      )
      (detail
       (origin 375 225)
       (extent 221 90)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 15 "Comparator"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ref Value")
       (tag "RefValue")
      )
      (input 2
       (type data)
       (name "Test Value")
       (tag "TestValue")
      )
      (output 1
       (type data)
       (name "Passed")
       (tag "Passed")
       (lock name constraints)
       (optional yes)
      )
      (output 2
       (type data)
       (name "Failed")
       (tag "Failed")
       (lock name constraints)
       (optional yes)
      )
      (output 3
       (type data)
       (name "Failures")
       (tag "Failures")
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (attr relation "<")
     )
     (views
      (icon
       (origin 415 403)
       (extent 110 34)
      )
      (detail
       (origin 815 125)
       (extent 251 110)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 16 "Collector"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
      (input 2
       (type trigger)
       (name "XEQ")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (origin 425 478)
       (extent 110 25)
      )
      (detail
       (origin 485 335)
       (extent 60 110)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 17 "ToFile"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "B")
       (optional yes)
      )
     )
     (implementation
      (attr iopath file write "/tmp/mfgdata"
       (readTerm "\n")
       (fs "\n")
       (eol "\n")
       (multiField fullSyntax)
       (arrayFormat block)
      )
      (procedure
        WRITE TEXT "    " QSTR EOL
        WRITE TEXT "FAILING COORDINATES from TEST 2" EOL
        WRITE TEXT "--------------------------------------------------------" EOL
        WRITE TEXT b COORD STD:4 EOL
      )
     )
     (views
      (icon
       (origin 561 473)
       (extent 78 34)
      )
      (detail
       (origin 195 207)
       (extent 320 167)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 18 "Formula"
     (name " + ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "Y")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "X+Y")
     )
     (views
      (icon
       (origin 617 238)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 19 "VFunctionGenerator"
     (name "Function Generator")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component function Sine)
      (component frequency 50)
      (component amplitude 1)
      (component dcOffset 0)
      (component phaseShift 0)
      (component numPoints 256)
      (component interval 0.02)
      (component degRad Deg)
      (component errorOnAlias 1)
     )
     (views
      (icon
       (origin 413 271)
       (extent 174 78)
       (iconImage "virtual.icon")
      )
      (detail
       (origin 239 111)
       (extent 239 198)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 20 "SampleHold"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "InData")
       (tag "InData")
       (lock constraints)
      )
      (input 2
       (type trigger)
       (name "XEQ")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "OutData")
       (tag "OutData")
       (lock constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 877 518)
       (extent 127 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 21 "TextDisplay"
     (name "% Failures")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 835 622)
       (extent 190 37)
      )
      (active detail)
     )
    )
    (configuration
     (connect D18:1 D0:1)
     (connect D5:1 D0:2)
     (connect D15:3 D0:3)
     (connect D11:1 D1:1)
     (connect D1:1 D2:1)
     (connect D15:2 D3:1)
     (connect D20:1 D4:1)
     (connect D1:1 D4:2)
     (connect D17:0 D6:0)
     (connect D6:0 D7:0)
     (connect D6:1 D8:1)
     (connect D8:1 D9:1)
     (connect D9:0 D10:0)
     (connect D12:0 D11:0)
     (connect D11:1 D13:0)
     (connect D13:1 D14:1)
     (connect D5:1 D15:1)
     (connect D18:1 D15:2)
     (connect D15:3 D16:1)
     (connect D11:0 D16:2)
     (connect D16:1 D17:1)
     (connect D14:1 D18:1)
     (connect D19:1 D18:2)
     (connect D3:1 D20:1)
     (connect D11:1 D20:2)
     (connect D4:1 D21:1)
    )
    (ShowOnExecPanel
     (origin 169 123)
     (extent 594 591)
     (panel
      (origin 225 164)
      (extent 590 553)
      (widget 0 detail
       (title off)
       (origin 242 174)
       (extent 554 305)
       (displayMode annotGraph)
       (graphType cartesian)
       (gridType off)
       (scale 0
        (name "Mag")
        (domainName "Time")
        (pen 9)
        (show 1)
        (range -2 2 4 linear)
       )
       (domain 0 0.02 4 linear)
       (trace 0 onScale 0
        (name "Noisy Wave")
        (pen 4)
        (lineType 1)
        (pointType 0)
       )
       (trace 1 onScale 0
        (name "UpperLimit")
        (pen 7)
        (lineType 1)
        (pointType 0)
       )
       (trace 2 onScale 0
        (name "UpperFail")
        (pen 2)
        (lineType 2)
        (pointType 1)
       )
      )
      (widget 2 detail
       (title on)
       (origin 243 522)
       (extent 290 140)
      )
      (widget 3 detail
       (title on)
       (origin 577 522)
       (extent 216 36)
      )
      (widget 21 detail
       (title on)
       (origin 579 614)
       (extent 216 45)
      )
      (widget 9 detail
       (title off)
       (origin 423 670)
       (extent 217 40)
      )
     )
    )
   )
   (views
    (icon
     (origin 752 527)
     (extent 77 27)
    )
    (detail
     (origin 85 122)
     (extent 890 576)
     (configuration
      (connect D18:1 D0:1
       (Point 665 250)
       (Point 714 250)
      )
      (connect D5:1 D0:2
       (Point 357 410)
       (Point 390 410)
       (Point 390 380)
       (Point 690 380)
       (Point 690 340)
       (Point 714 340)
      )
      (connect D15:3 D0:3
       (Point 527 430)
       (Point 714 430)
      )
      (connect D11:1 D1:1
       (Point 267 260)
       (Point 290 260)
       (Point 290 170)
       (Point 488 170)
      )
      (connect D1:1 D2:1
       (Point 571 170)
       (Point 592 170)
      )
      (connect D15:2 D3:1
       (Point 527 420)
       (Point 660 420)
       (Point 660 520)
       (Point 714 520)
      )
      (connect D20:1 D4:1
       (Point 1006 530)
       (Point 1020 530)
       (Point 1020 560)
       (Point 710 560)
       (Point 710 620)
       (Point 728 620)
      )
      (connect D1:1 D4:2
       (Point 571 170)
       (Point 580 170)
       (Point 580 200)
       (Point 690 200)
       (Point 690 330)
       (Point 700 330)
       (Point 700 390)
       (Point 690 390)
       (Point 690 660)
       (Point 728 660)
      )
      (connect D17:0 D6:0
       (Point 600 509)
       (Point 600 530)
       (Point 200 530)
       (Point 200 565)
      )
      (connect D6:0 D7:0
       (Point 200 634)
       (Point 200 655)
      )
      (connect D6:1 D8:1
       (Point 257 600)
       (Point 288 600)
      )
      (connect D8:1 D9:1
       (Point 371 600)
       (Point 390 600)
       (Point 390 630)
       (Point 411 630)
      )
      (connect D9:0 D10:0
       (Point 510 651)
       (Point 510 665)
      )
      (connect D12:0 D11:0
       (Point 180 191)
       (Point 180 210)
      )
      (connect D11:1 D13:0
       (Point 267 260)
       (Point 290 260)
       (Point 290 170)
       (Point 380 170)
       (Point 380 185)
      )
      (connect D13:1 D14:1
       (Point 446 200)
       (Point 460 200)
       (Point 460 220)
       (Point 410 220)
       (Point 410 240)
       (Point 422 240)
      )
      (connect D5:1 D15:1
       (Point 357 410)
       (Point 412 410)
      )
      (connect D18:1 D15:2
       (Point 665 250)
       (Point 680 250)
       (Point 680 370)
       (Point 400 370)
       (Point 400 430)
       (Point 412 430)
      )
      (connect D15:3 D16:1
       (Point 527 430)
       (Point 540 430)
       (Point 540 460)
       (Point 410 460)
       (Point 410 480)
       (Point 422 480)
      )
      (connect D11:0 D16:2
       (Point 180 279)
       (Point 180 290)
       (Point 380 290)
       (Point 380 500)
       (Point 422 500)
      )
      (connect D16:1 D17:1
       (Point 537 490)
       (Point 558 490)
      )
      (connect D14:1 D18:1
       (Point 578 240)
       (Point 614 240)
      )
      (connect D19:1 D18:2
       (Point 589 310)
       (Point 600 310)
       (Point 600 260)
       (Point 614 260)
      )
      (connect D3:1 D20:1
       (Point 846 520)
       (Point 874 520)
      )
      (connect D11:1 D20:2
       (Point 267 260)
       (Point 390 260)
       (Point 390 370)
       (Point 370 370)
       (Point 370 550)
       (Point 860 550)
       (Point 860 540)
       (Point 874 540)
      )
      (connect D4:1 D21:1
       (Point 811 640)
       (Point 832 640)
      )
     )
    )
    (active icon)
   )
  )
  (component 15 "Context"
   (name "Test #3")
   (description 5 4
    This object just loads and runs a complete other
    test.  In this case, the other test is another
    VEE model.  It could just as easily have been 
    an HP BASIC/UX program, or a C program.
    
   )
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "LiteralConstant"
     (name "Program to load")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "Program to load")
       (datum "mfgtest1.ex")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (datum "")
      )
     )
     (views
      (icon
       (extent 145 0)
      )
      (detail
       (origin 161 378)
       (extent 219 25)
      )
      (active detail)
     )
    )
    (component 1 "TextDisplay"
     (name "Wait, loading test:")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (extent 181 0)
      )
      (detail
       (origin 433 372)
       (extent 255 37)
      )
      (active detail)
     )
    )
    (component 2 "ShellEscape"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "prog")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Exit code")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "X")
       (lock constraints)
       (optional yes)
      )
      (output 3
       (type exception)
       (name "Error")
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (attr iopath pipe read "pipe"
       (readTerm "\n")
       (fs " ")
       (eol "\n")
       (multiField fullSyntax)
       (arrayFormat block)
      )
      (attr iopath pipe write "pipe"
       (readTerm "\n")
       (fs " ")
       (eol "\n")
       (multiField fullSyntax)
       (arrayFormat block)
      )
      (procedure
        WRITE TEXT "/usr/lib/veetest/veetest -r "
        WRITE TEXT "/usr/lib/veetest/examples/applications/"
        WRITE TEXT prog," -geometry 600x300+100+100"
        WRITE TEXT " 2>/dev/null" EOL
        WRITE TEXT "[ $? -ne 0 ] && exit 255" EOL
        READ CONTAINER x
      )
      (component shell "none")
      (component command "/bin/ksh -s")
      (component deathWait "Yes")
     )
     (views
      (icon
       (origin 381 398)
       (extent 118 64)
       (iconImage "c.icon")
      )
      (detail
       (origin 184 489)
       (extent 502 183)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 3 "ToFile"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "dta")
       (optional yes)
      )
     )
     (implementation
      (attr iopath file write "/tmp/mfgdata"
       (readTerm "\n")
       (fs "\n")
       (eol "\n")
       (multiField fullSyntax)
       (arrayFormat block)
      )
      (procedure
        WRITE TEXT "    " QSTR EOL
        WRITE TEXT "DATA FROM TEST 3" EOL
        WRITE TEXT "--------------------------------------------------------" EOL
        WRITE TEXT " !!!!!! TEST FAILED (error ",dta,") !!!!!!!!" INT EOL
      )
     )
     (views
      (icon
       (origin 851 623)
       (extent 78 34)
      )
      (detail
       (origin 467 501)
       (extent 457 178)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "TextDisplay"
     (name "The Date")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 812 354)
       (extent 156 192)
      )
      (active detail)
     )
    )
    (component 5 "ToFile"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "dta")
       (optional yes)
      )
     )
     (implementation
      (attr iopath file write "/tmp/mfgdata"
       (readTerm "\n")
       (fs "\n")
       (eol "\n")
       (multiField fullSyntax)
       (arrayFormat block)
      )
      (procedure
        WRITE TEXT "    " QSTR EOL
        WRITE TEXT "DATA FROM TEST 3" EOL
        WRITE TEXT "--------------------------------------------------------" EOL
        WRITE TEXT dta REAL STD:4 EOL
      )
     )
     (views
      (icon
       (origin 851 563)
       (extent 78 34)
      )
      (detail
       (origin 467 461)
       (extent 457 178)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D0:1 D1:1)
     (connect D0:1 D2:1)
     (connect D2:3 D3:1)
     (connect D2:2 D4:1)
     (connect D2:2 D5:1)
    )
    (ShowOnExecPanel
     (origin 295 261)
     (extent 396 300)
     (panel
      (origin 404 459)
      (extent 392 262)
      (widget 1 detail
       (title on)
       (origin 474 579)
       (extent 255 37)
      )
     )
    )
   )
   (views
    (icon
     (origin 751 598)
     (extent 78 25)
    )
    (detail
     (origin 113 321)
     (extent 854 378)
     (configuration
      (connect D0:1 D1:1
       (Point 382 390)
       (Point 430 390)
      )
      (connect D0:1 D2:1
       (Point 382 390)
       (Point 400 390)
       (Point 400 440)
       (Point 120 440)
       (Point 120 580)
       (Point 131 580)
      )
      (connect D2:3 D3:1
       (Point 788 640)
       (Point 848 640)
      )
      (connect D2:2 D4:1
       (Point 788 580)
       (Point 800 580)
       (Point 800 450)
       (Point 809 450)
      )
      (connect D2:2 D5:1
       (Point 788 580)
       (Point 848 580)
      )
     )
    )
    (active icon)
   )
  )
  (component 16 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "RepeatUntilBreak"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 115 258)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 482)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 20 9
         PURPOSE:      To illustrate how a manufacturing test system might be designed using VEE.
         
         USER INPUT REQUIRED: Press Start (or Run) and answer the prompts.
         
         EXPLANATION:  The following simulated tests are available in this example:
         
                       TEST #1:  Takes 50 random points and plots the results as they are taken.
         
                       TEST #2:  Tests 30 waveforms with random noise against an upper limit,
                                 recording the coordinates that failed and percent of failures.
         
                       TEST #3   Determines the distribution of 100 random numbers and plots a
                                 barchart of the results.  A threshold, manually set, determines
                                 the color of each bar for Pass/Fail indication.
         
         
                       REPORT:   At any time, a report of the previously run tests can be shown,
                                 including the OPERATOR, timestamp when test was run, and the
                                 logged output from each test.  The Report is cleared each time
                                 after it is displayed.
        )
       )
       (views
        (icon
         (origin 410 415)
         (extent 78 25)
        )
        (detail
         (origin 25 209)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 61 130)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 45 175)
         (extent 832 463)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:1 D1:0)
     (connect D3:0 D1:1)
     (connect D0:1 D3:0)
    )
   )
   (views
    (icon
     (origin 765 128)
     (extent 110 25)
    )
    (panel
     (origin 302 118)
     (extent 276 85)
     (widget 1 icon
      (title off)
      (origin 383 139)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:1 D1:0
       (Point 227 290)
       (Point 258 290)
       (Point 258 340)
      )
      (connect D3:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D3:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 17 "RepeatUntilBreak"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 55 218)
     (extent 110 64)
     (iconImage "loop.icon")
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 18 "Context"
   (name "Password Accepted")
   (description 4 4
    Bogus box to tell the operator that they 
    entered the correct password.  This object
    does not perform any other function.
    
   )
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "ExitContext"
     (interface
      (sequence in)
     )
     (implementation
     )
     (views
      (icon
       (origin 268 568)
       (extent 145 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TextDisplay"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
      )
      (detail
       (origin 189 426)
       (extent 242 68)
      )
      (active detail)
     )
    )
    (component 2 "Delay"
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (component delay 1.5)
     )
     (views
      (icon
       (origin 191 528)
       (extent 78 25)
      )
      (detail
       (origin 205 563)
       (extent 130 34)
      )
      (active icon)
     )
    )
    (component 3 "LiteralConstant"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "Text")
       (datum "Password Accepted")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (datum "")
      )
     )
     (views
      (icon
       (origin 167 338)
       (extent 46 25)
      )
      (detail
       (origin 340 306)
       (extent 201 28)
      )
      (active icon)
     )
    )
    (configuration
     (connect D2:0 D0:0)
     (connect D3:1 D1:1)
     (connect D1:0 D2:0)
    )
    (ShowOnExecPanel
     (origin 293 205)
     (extent 375 516)
     (panel
      (origin 135 241)
      (extent 371 478)
      (widget 1 detail
       (title off)
       (origin 197 332)
       (extent 251 61)
      )
     )
    )
   )
   (views
    (icon
     (origin 199 318)
     (extent 163 25)
    )
    (detail
     (origin 135 320)
     (extent 350 300)
     (configuration
      (connect D2:0 D0:0
       (Point 230 555)
       (Point 230 570)
       (Point 250 570)
       (Point 250 560)
       (Point 280 560)
       (Point 280 550)
       (Point 340 550)
       (Point 340 565)
      )
      (connect D3:1 D1:1
       (Point 215 350)
       (Point 230 350)
       (Point 230 380)
       (Point 170 380)
       (Point 170 460)
       (Point 186 460)
      )
      (connect D1:0 D2:0
       (Point 310 496)
       (Point 310 520)
       (Point 230 520)
       (Point 230 525)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 19 "Break"
   (interface
    (sequence in)
   )
   (implementation
   )
   (views
    (icon
     (origin 241 358)
     (extent 78 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 20 "Context"
   (name "Check Password")
   (description 11 4
    This an object which will pop-up a dialog box for
    interaction with a user. The input required is the
    prompt and, if needed, a default reply. The con-
    struction is that of a user object inside a user
    object. The internal user object is the actual
    dialog box that will pop-up. This is an unsecured
    model; feel free to make any necessary mod-
    ifications.
    
    (one possible change could be to store the 
    passwords into an encrypted file.)
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "ReplyOut")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Junction"
     (name "JCT")
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "C")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 397 348)
       (extent 46 45)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "IfThenElse"
     (name "Passwords")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else If")
       (lock name constraints)
      )
      (output 3
       (type data)
       (name "Else If")
       (lock name constraints)
      )
      (output 4
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "b==\"Joe\" AND a==\"1234\"")
      (component expr "b==\"Fred\" AND a==\"2345\"")
      (component expr "b==\"Sally\" AND a==\"3456\"")
     )
     (views
      (icon
       (origin 215 353)
       (extent 110 54)
      )
      (detail
       (origin 316 313)
       (extent 248 154)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Formula"
     (name " + ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "Y")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "X+Y")
     )
     (views
      (icon
       (origin 137 168)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "TextDisplay"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (origin 231 168)
       (extent 118 25)
      )
      (detail
       (origin 477 611)
       (extent 286 38)
      )
      (active icon)
     )
    )
    (component 4 "LiteralConstant"
     (name "Prompt")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "Prompt")
       (datum ", Enter your ID number")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (datum "")
      )
     )
     (views
      (icon
       (extent 78 0)
      )
      (detail
       (origin 114 258)
       (extent 252 25)
      )
      (active detail)
     )
    )
    (component 5 "Context"
     (name "Keybd")
     (description 2 6
      Keypad Modified to display asterisks instead 
      of the entered number string.
     )
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "X")
       (lock constraints)
       (optional yes)
      )
      (output 2
       (type exception)
       (name "Error")
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Junction"
       (name "JCT")
       (interface
        (input 1
         (type data)
         (name "A")
         (lock name constraints)
        )
        (input 2
         (type data)
         (name "B")
         (lock name constraints)
        )
        (input 3
         (type data)
         (name "C")
         (optional yes)
        )
        (input 4
         (type data)
         (name "D")
         (optional yes)
        )
        (input 5
         (type data)
         (name "E")
         (optional yes)
        )
        (input 6
         (type data)
         (name "F")
         (optional yes)
        )
        (input 7
         (type data)
         (name "G")
         (optional yes)
        )
        (input 8
         (type data)
         (name "H")
         (optional yes)
        )
        (input 9
         (type data)
         (name "I")
         (optional yes)
        )
        (input 10
         (type data)
         (name "J")
         (optional yes)
        )
        (input 11
         (type data)
         (name "K")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Data")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 537 293)
         (extent 46 114)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "LiteralConstant"
       (name "\"8\"")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Text")
         (lock name constraints)
        )
       )
       (implementation
        (component value Text
         (name "\"8\"")
         (datum "8")
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Text
         (datum "")
        )
       )
       (views
        (icon
         (origin 307 478)
         (extent 46 25)
        )
        (detail
         (origin 290 399)
         (extent 120 23)
        )
        (active icon)
       )
      )
      (component 2 "Confirm"
       (name "Cancel")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 572 492)
         (extent 76 37)
        )
        (detail
         (origin 491 410)
         (extent 68 40)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 3 "LiteralConstant"
       (name "\"1\"")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Text")
         (lock name constraints)
        )
       )
       (implementation
        (component value Text
         (name "\"1\"")
         (datum "1")
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Text
         (datum "")
        )
       )
       (views
        (icon
         (origin 227 248)
         (extent 46 25)
        )
        (detail
         (origin 170 269)
         (extent 120 23)
        )
        (active icon)
       )
      )
      (component 4 "Confirm"
       (name " 2 ")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 266 202)
         (extent 49 37)
        )
        (detail
         (origin 360 180)
         (extent 50 40)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 5 "LiteralConstant"
       (name "\"2\"")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Text")
         (lock name constraints)
        )
       )
       (implementation
        (component value Text
         (name "\"2\"")
         (datum "2")
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Text
         (datum "")
        )
       )
       (views
        (icon
         (origin 307 248)
         (extent 46 25)
        )
        (detail
         (origin 230 389)
         (extent 120 23)
        )
        (active icon)
       )
      )
      (component 6 "Confirm"
       (name " 3 ")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 366 202)
         (extent 49 37)
        )
        (detail
         (origin 390 180)
         (extent 50 40)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 7 "LiteralConstant"
       (name "\"3\"")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Text")
         (lock name constraints)
        )
       )
       (implementation
        (component value Text
         (name "\"3\"")
         (datum "3")
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Text
         (datum "")
        )
       )
       (views
        (icon
         (origin 407 248)
         (extent 46 25)
        )
        (detail
         (origin 200 379)
         (extent 120 23)
        )
        (active icon)
       )
      )
      (component 8 "Confirm"
       (name " 4 ")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 176 322)
         (extent 49 37)
        )
        (detail
         (origin 210 310)
         (extent 50 40)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 9 "Confirm"
       (name " 5 ")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 266 322)
         (extent 49 37)
        )
        (detail
         (origin 350 320)
         (extent 50 40)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 10 "Confirm"
       (name " 6 ")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 366 322)
         (extent 49 37)
        )
        (detail
         (origin 490 320)
         (extent 50 40)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 11 "LiteralConstant"
       (name "\"4\"")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Text")
         (lock name constraints)
        )
       )
       (implementation
        (component value Text
         (name "\"4\"")
         (datum "4")
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Text
         (datum "")
        )
       )
       (views
        (icon
         (origin 217 368)
         (extent 46 25)
        )
        (detail
         (origin 190 309)
         (extent 120 23)
        )
        (active icon)
       )
      )
      (component 12 "LiteralConstant"
       (name "\"5\"")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Text")
         (lock name constraints)
        )
       )
       (implementation
        (component value Text
         (name "\"5\"")
         (datum "5")
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Text
         (datum "")
        )
       )
       (views
        (icon
         (origin 307 368)
         (extent 46 25)
        )
        (detail
         (origin 290 309)
         (extent 120 23)
        )
        (active icon)
       )
      )
      (component 13 "LiteralConstant"
       (name "\"6\"")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Text")
         (lock name constraints)
        )
       )
       (implementation
        (component value Text
         (name "\"6\"")
         (datum "6")
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Text
         (datum "")
        )
       )
       (views
        (icon
         (origin 397 368)
         (extent 46 25)
        )
        (detail
         (origin 390 309)
         (extent 120 23)
        )
        (active icon)
       )
      )
      (component 14 "Confirm"
       (name " 7 ")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 166 432)
         (extent 49 37)
        )
        (detail
         (origin 200 410)
         (extent 50 40)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 15 "LiteralConstant"
       (name "\"7\"")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Text")
         (lock name constraints)
        )
       )
       (implementation
        (component value Text
         (name "\"7\"")
         (datum "7")
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Text
         (datum "")
        )
       )
       (views
        (icon
         (origin 207 478)
         (extent 46 25)
        )
        (detail
         (origin 190 399)
         (extent 120 23)
        )
        (active icon)
       )
      )
      (component 16 "Confirm"
       (name " 8 ")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 266 432)
         (extent 49 37)
        )
        (detail
         (origin 340 420)
         (extent 50 40)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 17 "Confirm"
       (name " 9 ")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 366 432)
         (extent 49 37)
        )
        (detail
         (origin 480 420)
         (extent 50 40)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 18 "LiteralConstant"
       (name "\"9\"")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Text")
         (lock name constraints)
        )
       )
       (implementation
        (component value Text
         (name "\"9\"")
         (datum "9")
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Text
         (datum "")
        )
       )
       (views
        (icon
         (origin 407 478)
         (extent 46 25)
        )
        (detail
         (origin 390 399)
         (extent 120 23)
        )
        (active icon)
       )
      )
      (component 19 "RepeatUntilBreak"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Continuous")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 25 348)
         (extent 110 64)
         (iconImage "loop.icon")
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (component 20 "Confirm"
       (name " 0 ")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 156 532)
         (extent 49 37)
        )
        (detail
         (origin 190 520)
         (extent 50 40)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 21 "Confirm"
       (name " . ")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 266 532)
         (extent 49 37)
        )
        (detail
         (origin 330 530)
         (extent 50 40)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 22 "LiteralConstant"
       (name "\".\"")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Text")
         (lock name constraints)
        )
       )
       (implementation
        (component value Text
         (name "\".\"")
         (datum ".")
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Text
         (datum "")
        )
       )
       (views
        (icon
         (origin 307 578)
         (extent 46 25)
        )
        (detail
         (origin 260 539)
         (extent 120 23)
        )
        (active icon)
       )
      )
      (component 23 "LiteralConstant"
       (name "\"0\"")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Text")
         (lock name constraints)
        )
       )
       (implementation
        (component value Text
         (name "\"0\"")
         (datum "0")
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Text
         (datum "")
        )
       )
       (views
        (icon
         (origin 197 578)
         (extent 46 25)
        )
        (detail
         (origin 190 539)
         (extent 120 23)
        )
        (active icon)
       )
      )
      (component 24 "Confirm"
       (name "CE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 410 532)
         (extent 40 37)
        )
        (detail
         (origin 470 530)
         (extent 50 40)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 25 "Confirm"
       (name " 1 ")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 186 202)
         (extent 49 37)
        )
        (detail
         (origin 200 180)
         (extent 50 40)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 26 "Escape"
       (interface
        (sequence in)
       )
       (implementation
        (component code 0)
        (component message "Done")
       )
       (views
        (icon
        )
        (detail
         (origin 650 559)
         (extent 140 63)
        )
        (active detail)
       )
      )
      (component 27 "Confirm"
       (name "Accept")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 632 172)
         (extent 76 37)
        )
        (detail
         (origin 631 180)
         (extent 68 40)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 28 "ExitContext"
       (interface
        (sequence in)
       )
       (implementation
       )
       (views
        (icon
         (origin 678 218)
         (extent 145 25)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (component 29 "Accumulator"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (tag "InData")
         (requires
          (shape "Scalar")
         )
         (lock name constraints)
        )
        (input 2
         (type control)
         (name "Clear")
         (lock name constraints)
         (optional yes)
        )
        (output 1
         (type data)
         (name "Data")
         (tag "accumData")
         (lock name constraints)
        )
       )
       (implementation
        (component clearAtPrerun 1)
        (component clearAtActivate 1)
       )
       (views
        (icon
        )
        (detail
         (origin 630 303)
         (extent 180 34)
        )
        (active detail)
       )
      )
      (component 30 "Junction"
       (name "JCT")
       (interface
        (input 1
         (type data)
         (name "A")
         (lock name constraints)
        )
        (input 2
         (type data)
         (name "B")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Data")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 837 318)
         (extent 46 25)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (component 31 "Accumulator"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (tag "InData")
         (requires
          (shape "Scalar")
         )
         (lock name constraints)
        )
        (input 2
         (type control)
         (name "Clear")
         (lock name constraints)
         (optional yes)
        )
        (output 1
         (type data)
         (name "Data")
         (tag "accumData")
         (lock name constraints)
        )
       )
       (implementation
        (component clearAtPrerun 1)
        (component clearAtActivate 1)
       )
       (views
        (icon
        )
        (detail
         (origin 630 393)
         (extent 180 34)
        )
        (active detail)
       )
      )
      (component 32 "Next"
       (interface
        (sequence in)
       )
       (implementation
       )
       (views
        (icon
         (origin 697 438)
         (extent 46 25)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (component 33 "LiteralConstant"
       (name "\"*\"")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Text")
         (lock name constraints)
        )
       )
       (implementation
        (component value Text
         (name "\"*\"")
         (datum "*")
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Text
         (datum "")
        )
       )
       (views
        (icon
         (origin 537 428)
         (extent 46 25)
        )
        (detail
         (origin 500 219)
         (extent 120 23)
        )
        (active icon)
       )
      )
      (configuration
       (connect D3:1 D0:1)
       (connect D5:1 D0:2)
       (connect D7:1 D0:3)
       (connect D11:1 D0:4)
       (connect D12:1 D0:5)
       (connect D13:1 D0:6)
       (connect D15:1 D0:7)
       (connect D1:1 D0:8)
       (connect D18:1 D0:9)
       (connect D23:1 D0:10)
       (connect D22:1 D0:11)
       (connect D16:1 D1:0)
       (connect D25:1 D3:0)
       (connect D19:1 D4:0)
       (connect D4:1 D5:0)
       (connect D19:1 D6:0)
       (connect D6:1 D7:0)
       (connect D19:1 D8:0)
       (connect D19:1 D9:0)
       (connect D19:1 D10:0)
       (connect D8:1 D11:0)
       (connect D9:1 D12:0)
       (connect D10:1 D13:0)
       (connect D19:1 D14:0)
       (connect D14:1 D15:0)
       (connect D19:1 D16:0)
       (connect D19:1 D17:0)
       (connect D17:1 D18:0)
       (connect D19:1 D20:0)
       (connect D19:1 D21:0)
       (connect D21:1 D22:0)
       (connect D20:1 D23:0)
       (connect D19:1 D24:0)
       (connect D19:1 D25:0)
       (connect D2:1 D26:0)
       (connect D27:1 D28:0)
       (connect D0:1 D29:1)
       (connect D24:1 D29:2)
       (connect D29:1 D30:1)
       (connect D24:1 D30:2)
       (connect D29:0 D31:0)
       (connect D33:1 D31:1)
       (connect D24:1 D31:2)
       (connect D31:0 D32:0)
       (connect D0:1 D33:0)
       (connect D30:1 O1:1)
      )
     )
     (views
      (icon
       (origin 71 358)
       (extent 78 25)
      )
      (panel
       (origin 404 223)
       (extent 232 355)
       (widget 31 detail
        (title off)
        (origin 422 244)
        (extent 190 39)
       )
       (widget 2 icon
        (title off)
        (origin 426 519)
        (extent 76 37)
       )
       (widget 27 icon
        (title off)
        (origin 538 519)
        (extent 76 37)
       )
       (widget 25 icon
        (title off)
        (origin 422 300)
        (extent 49 37)
       )
       (widget 6 icon
        (title off)
        (origin 562 300)
        (extent 49 37)
       )
       (widget 4 icon
        (title off)
        (origin 490 300)
        (extent 49 37)
       )
       (widget 8 icon
        (title off)
        (origin 421 354)
        (extent 49 37)
       )
       (widget 10 icon
        (title off)
        (origin 561 353)
        (extent 49 37)
       )
       (widget 14 icon
        (title off)
        (origin 422 407)
        (extent 49 37)
       )
       (widget 17 icon
        (title off)
        (origin 561 407)
        (extent 49 37)
       )
       (widget 9 icon
        (title off)
        (origin 490 353)
        (extent 49 37)
       )
       (widget 16 icon
        (title off)
        (origin 491 405)
        (extent 49 37)
       )
       (widget 21 icon
        (title off)
        (origin 561 455)
        (extent 49 37)
       )
       (widget 20 icon
        (title off)
        (origin 491 455)
        (extent 49 37)
       )
       (widget 24 icon
        (title off)
        (origin 423 457)
        (extent 49 35)
       )
      )
      (detail
       (origin 48 147)
       (extent 924 487)
       (configuration
        (connect D3:1 D0:1
         (Point 275 260)
         (Point 290 260)
         (Point 290 290)
         (Point 340 290)
         (Point 340 180)
         (Point 480 180)
         (Point 480 300)
         (Point 534 300)
        )
        (connect D5:1 D0:2
         (Point 355 260)
         (Point 370 260)
         (Point 370 290)
         (Point 450 290)
         (Point 450 310)
         (Point 534 310)
        )
        (connect D7:1 D0:3
         (Point 455 260)
         (Point 470 260)
         (Point 470 320)
         (Point 534 320)
        )
        (connect D11:1 D0:4
         (Point 265 380)
         (Point 280 380)
         (Point 280 390)
         (Point 340 390)
         (Point 340 400)
         (Point 380 400)
         (Point 380 380)
         (Point 430 380)
         (Point 430 360)
         (Point 440 360)
         (Point 440 350)
         (Point 450 350)
         (Point 450 330)
         (Point 534 330)
        )
        (connect D12:1 D0:5
         (Point 355 380)
         (Point 370 380)
         (Point 370 370)
         (Point 360 370)
         (Point 360 360)
         (Point 350 360)
         (Point 350 300)
         (Point 440 300)
         (Point 440 340)
         (Point 534 340)
        )
        (connect D13:1 D0:6
         (Point 445 380)
         (Point 460 380)
         (Point 460 350)
         (Point 534 350)
        )
        (connect D15:1 D0:7
         (Point 255 490)
         (Point 270 490)
         (Point 270 510)
         (Point 300 510)
         (Point 300 520)
         (Point 440 520)
         (Point 440 370)
         (Point 470 370)
         (Point 470 360)
         (Point 534 360)
        )
        (connect D1:1 D0:8
         (Point 355 490)
         (Point 370 490)
         (Point 370 480)
         (Point 360 480)
         (Point 360 470)
         (Point 350 470)
         (Point 350 410)
         (Point 480 410)
         (Point 480 370)
         (Point 534 370)
        )
        (connect D18:1 D0:9
         (Point 455 490)
         (Point 470 490)
         (Point 470 380)
         (Point 534 380)
        )
        (connect D23:1 D0:10
         (Point 245 590)
         (Point 260 590)
         (Point 260 620)
         (Point 500 620)
         (Point 500 390)
         (Point 534 390)
        )
        (connect D22:1 D0:11
         (Point 355 590)
         (Point 490 590)
         (Point 490 400)
         (Point 534 400)
        )
        (connect D16:1 D1:0
         (Point 317 450)
         (Point 330 450)
         (Point 330 475)
        )
        (connect D25:1 D3:0
         (Point 237 220)
         (Point 250 220)
         (Point 250 245)
        )
        (connect D19:1 D4:0
         (Point 137 380)
         (Point 160 380)
         (Point 160 180)
         (Point 290 180)
         (Point 290 199)
        )
        (connect D4:1 D5:0
         (Point 317 220)
         (Point 330 220)
         (Point 330 245)
        )
        (connect D19:1 D6:0
         (Point 137 380)
         (Point 160 380)
         (Point 160 180)
         (Point 290 180)
         (Point 290 170)
         (Point 390 170)
         (Point 390 199)
        )
        (connect D6:1 D7:0
         (Point 417 220)
         (Point 430 220)
         (Point 430 245)
        )
        (connect D19:1 D8:0
         (Point 137 380)
         (Point 160 380)
         (Point 160 300)
         (Point 200 300)
         (Point 200 319)
        )
        (connect D19:1 D9:0
         (Point 137 380)
         (Point 160 380)
         (Point 160 300)
         (Point 290 300)
         (Point 290 319)
        )
        (connect D19:1 D10:0
         (Point 137 380)
         (Point 160 380)
         (Point 160 300)
         (Point 330 300)
         (Point 330 310)
         (Point 390 310)
         (Point 390 319)
        )
        (connect D8:1 D11:0
         (Point 227 340)
         (Point 240 340)
         (Point 240 365)
        )
        (connect D9:1 D12:0
         (Point 317 340)
         (Point 330 340)
         (Point 330 365)
        )
        (connect D10:1 D13:0
         (Point 417 340)
         (Point 430 340)
         (Point 430 350)
         (Point 420 350)
         (Point 420 365)
        )
        (connect D19:1 D14:0
         (Point 137 380)
         (Point 190 380)
         (Point 190 429)
        )
        (connect D14:1 D15:0
         (Point 217 450)
         (Point 230 450)
         (Point 230 475)
        )
        (connect D19:1 D16:0
         (Point 137 380)
         (Point 190 380)
         (Point 190 410)
         (Point 290 410)
         (Point 290 429)
        )
        (connect D19:1 D17:0
         (Point 137 380)
         (Point 190 380)
         (Point 190 410)
         (Point 330 410)
         (Point 330 420)
         (Point 390 420)
         (Point 390 429)
        )
        (connect D17:1 D18:0
         (Point 417 450)
         (Point 430 450)
         (Point 430 475)
        )
        (connect D19:1 D20:0
         (Point 137 380)
         (Point 150 380)
         (Point 150 490)
         (Point 180 490)
         (Point 180 529)
        )
        (connect D19:1 D21:0
         (Point 137 380)
         (Point 150 380)
         (Point 150 490)
         (Point 190 490)
         (Point 190 520)
         (Point 290 520)
         (Point 290 529)
        )
        (connect D21:1 D22:0
         (Point 317 550)
         (Point 330 550)
         (Point 330 575)
        )
        (connect D20:1 D23:0
         (Point 207 550)
         (Point 220 550)
         (Point 220 575)
        )
        (connect D19:1 D24:0
         (Point 137 380)
         (Point 190 380)
         (Point 190 410)
         (Point 330 410)
         (Point 330 420)
         (Point 340 420)
         (Point 340 510)
         (Point 420 510)
         (Point 420 520)
         (Point 430 520)
         (Point 430 529)
        )
        (connect D19:1 D25:0
         (Point 137 380)
         (Point 160 380)
         (Point 160 180)
         (Point 210 180)
         (Point 210 199)
        )
        (connect D2:1 D26:0
         (Point 650 510)
         (Point 720 510)
         (Point 720 526)
        )
        (connect D27:1 D28:0
         (Point 710 190)
         (Point 750 190)
         (Point 750 215)
        )
        (connect D0:1 D29:1
         (Point 585 350)
         (Point 600 350)
         (Point 600 310)
         (Point 627 310)
        )
        (connect D24:1 D29:2
         (Point 452 550)
         (Point 480 550)
         (Point 480 470)
         (Point 620 470)
         (Point 620 330)
         (Point 627 330)
        )
        (connect D29:1 D30:1
         (Point 812 320)
         (Point 834 320)
        )
        (connect D24:1 D30:2
         (Point 452 550)
         (Point 480 550)
         (Point 480 470)
         (Point 660 470)
         (Point 660 480)
         (Point 820 480)
         (Point 820 340)
         (Point 834 340)
        )
        (connect D29:0 D31:0
         (Point 720 339)
         (Point 720 360)
        )
        (connect D33:1 D31:1
         (Point 585 440)
         (Point 600 440)
         (Point 600 400)
         (Point 627 400)
        )
        (connect D24:1 D31:2
         (Point 452 550)
         (Point 480 550)
         (Point 480 470)
         (Point 620 470)
         (Point 620 420)
         (Point 627 420)
        )
        (connect D31:0 D32:0
         (Point 720 429)
         (Point 720 435)
        )
        (connect D0:1 D33:0
         (Point 585 350)
         (Point 600 350)
         (Point 600 390)
         (Point 590 390)
         (Point 590 420)
         (Point 560 420)
         (Point 560 425)
        )
        (connect D30:1 O1:1
         (Point 885 330)
         (Point 900 330)
         (Point 900 270)
         (Point 969 270)
        )
       )
      )
      (active icon)
     )
    )
    (component 6 "ExitProcess"
     (interface
      (sequence in)
     )
     (implementation
      (comp code 0)
     )
     (views
      (icon
       (origin 71 418)
       (extent 78 64)
       (iconImage "stop.icon")
      )
      (detail
       (origin 70 463)
       (extent 120 34)
      )
      (active icon)
     )
    )
    (component 7 "ExitContext"
     (interface
      (sequence in)
     )
     (implementation
     )
     (views
      (icon
       (origin 378 478)
       (extent 145 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 8 "Context"
     (name "Permission Denied")
     (description 6 6
      This is the message box to inform them that
      the password was incorrect.  
      
      NOTE !!!  The HINT box would be removed before
      using this object in an actual situation.
      
     )
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Note"
       (interface
       )
       (implementation
        (component text 4 9
          
            Sorry, please enter
           another ID number, or 
               press CANCEL.
        )
       )
       (views
        (icon
         (iconImage "notepad.icon")
        )
        (detail
         (origin 290 265)
         (extent 180 90)
         (editing enabled)
        )
        (active detail)
       )
      )
      (component 1 "Confirm"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 431 432)
         (extent 58 37)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "Note"
       (name "Login Hint")
       (interface
       )
       (implementation
        (component text 4 9
          
             Joe....1234
             Fred...2345
            Sally...3456
        )
       )
       (views
        (icon
         (origin 625 228)
         (extent 110 64)
         (iconImage "notepad.icon")
        )
        (detail
         (origin 417 316)
         (extent 187 89)
         (editing enabled)
        )
        (active detail)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 284 201)
       (extent 407 518)
       (panel
        (origin 249 150)
        (extent 403 480)
        (widget 1 icon
         (title off)
         (origin 403 329)
         (extent 97 59)
        )
        (widget 2 detail
         (title on)
         (origin 362 478)
         (extent 187 89)
         (editing disabled)
        )
        (widget 0 detail
         (title off)
         (origin 329 194)
         (extent 241 101)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 369 428)
       (extent 163 25)
      )
      (detail
       (origin 275 220)
       (extent 350 300)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D1:2 D0:2)
     (connect D1:3 D0:3)
     (connect D5:1 D1:1)
     (connect I1:1 D1:2)
     (connect I1:1 D2:1)
     (connect D4:1 D2:2)
     (connect D2:1 D3:1)
     (connect D5:2 D6:0)
     (connect D8:0 D7:0)
     (connect D1:4 D8:0)
     (connect D0:1 O1:1)
    )
    (ShowOnExecPanel
     (origin 313 200)
     (extent 353 509)
     (panel
      (origin 71 115)
      (extent 349 471)
      (widget 5 panel
       (title off)
       (origin 141 212)
       (extent 207 332)
       (widget 4 icon
        (title off)
        (origin 222 288)
        (extent 49 37)
       )
       (widget 6 icon
        (title off)
        (origin 278 288)
        (extent 49 37)
       )
       (widget 8 icon
        (title off)
        (origin 165 331)
        (extent 49 37)
       )
       (widget 9 icon
        (title off)
        (origin 222 331)
        (extent 49 37)
       )
       (widget 10 icon
        (title off)
        (origin 277 330)
        (extent 49 37)
       )
       (widget 14 icon
        (title off)
        (origin 165 373)
        (extent 49 37)
       )
       (widget 25 icon
        (title off)
        (origin 166 289)
        (extent 49 37)
       )
       (widget 16 icon
        (title off)
        (origin 222 372)
        (extent 49 37)
       )
       (widget 17 icon
        (title off)
        (origin 276 371)
        (extent 49 37)
       )
       (widget 20 icon
        (title off)
        (origin 221 414)
        (extent 49 37)
       )
       (widget 21 icon
        (title off)
        (origin 276 413)
        (extent 49 37)
       )
       (widget 24 icon
        (title off)
        (origin 165 415)
        (extent 49 35)
       )
       (widget 31 detail
        (title off)
        (origin 168 234)
        (extent 160 42)
       )
       (widget 2 icon
        (title off)
        (origin 248 474)
        (extent 76 37)
       )
       (widget 27 icon
        (title off)
        (origin 165 474)
        (extent 76 37)
       )
      )
      (widget 3 detail
       (title off)
       (origin 78 137)
       (extent 335 46)
      )
     )
    )
   )
   (views
    (icon
     (origin 212 268)
     (extent 136 25)
    )
    (detail
     (origin 43 152)
     (extent 505 377)
     (configuration
      (connect D1:1 D0:1
       (Point 327 360)
       (Point 394 360)
      )
      (connect D1:2 D0:2
       (Point 327 370)
       (Point 394 370)
      )
      (connect D1:3 D0:3
       (Point 327 380)
       (Point 394 380)
      )
      (connect D5:1 D1:1
       (Point 151 360)
       (Point 212 360)
      )
      (connect I1:1 D1:2
       (Point 45 350)
       (Point 60 350)
       (Point 60 338)
       (Point 170 338)
       (Point 170 400)
       (Point 212 400)
      )
      (connect I1:1 D2:1
       (Point 45 350)
       (Point 60 350)
       (Point 60 338)
       (Point 90 338)
       (Point 90 170)
       (Point 134 170)
      )
      (connect D4:1 D2:2
       (Point 368 270)
       (Point 390 270)
       (Point 390 210)
       (Point 120 210)
       (Point 120 190)
       (Point 134 190)
      )
      (connect D2:1 D3:1
       (Point 185 180)
       (Point 228 180)
      )
      (connect D5:2 D6:0
       (Point 151 380)
       (Point 160 380)
       (Point 160 400)
       (Point 110 400)
       (Point 110 415)
      )
      (connect D8:0 D7:0
       (Point 450 455)
       (Point 450 465)
       (Point 450 465)
       (Point 450 475)
      )
      (connect D1:4 D8:0
       (Point 327 390)
       (Point 340 390)
       (Point 340 410)
       (Point 450 410)
       (Point 450 425)
      )
      (connect D0:1 O1:1
       (Point 445 370)
       (Point 460 370)
       (Point 460 350)
       (Point 545 350)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (configuration
   (connect D9:4 D0:0)
   (connect D17:0 D1:0)
   (connect D5:1 D2:0)
   (connect D2:1 D3:1)
   (connect D5:1 D4:1)
   (connect D11:1 D4:2)
   (connect D9:1 D5:1)
   (connect D11:1 D5:2)
   (connect D7:0 D6:0)
   (connect D6:1 D8:1)
   (connect D1:1 D9:0)
   (connect D6:1 D9:1)
   (connect D9:2 D11:1)
   (connect D11:0 D12:0)
   (connect D9:3 D12:1)
   (connect D4:1 D13:0)
   (connect D4:2 D14:0)
   (connect D4:3 D15:0)
   (connect D7:0 D16:0)
   (connect D6:0 D17:0)
   (connect D20:1 D18:0)
   (connect D18:0 D19:0)
   (connect D17:1 D20:0)
   (connect D6:1 D20:1)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 1000 660)
   (widget 16 panel
    (title on)
    (origin 20 114)
    (extent 319 77)
    (widget 1 icon
     (title off)
     (origin 122 127)
     (extent 114 39)
     (format button)
    )
   )
   (widget 10 detail
    (title on)
    (origin 591 109)
    (extent 397 82)
    (editing disabled)
   )
   (widget 7 icon
    (title off)
    (origin 407 356)
    (extent 178 101)
   )
  )
  (detail
   (origin 0 67)
   (extent 1004 664)
   (configuration
    (connect D9:4 D0:0
     (Point 185 520)
     (Point 200 520)
     (Point 200 550)
     (Point 100 550)
     (Point 100 565)
    )
    (connect D17:0 D1:0
     (Point 110 284)
     (Point 110 385)
    )
    (connect D5:1 D2:0
     (Point 401 490)
     (Point 430 490)
     (Point 430 380)
     (Point 510 380)
     (Point 510 393)
    )
    (connect D2:1 D3:1
     (Point 568 410)
     (Point 578 410)
    )
    (connect D5:1 D4:1
     (Point 401 490)
     (Point 420 490)
     (Point 420 510)
     (Point 457 510)
    )
    (connect D11:1 D4:2
     (Point 417 570)
     (Point 457 570)
    )
    (connect D9:1 D5:1
     (Point 185 490)
     (Point 318 490)
    )
    (connect D11:1 D5:2
     (Point 417 570)
     (Point 430 570)
     (Point 430 530)
     (Point 310 530)
     (Point 310 510)
     (Point 318 510)
    )
    (connect D7:0 D6:0
     (Point 110 131)
     (Point 110 165)
    )
    (connect D6:1 D8:1
     (Point 167 180)
     (Point 198 180)
    )
    (connect D1:1 D9:0
     (Point 180 420)
     (Point 200 420)
     (Point 200 470)
     (Point 110 470)
     (Point 110 485)
    )
    (connect D6:1 D9:1
     (Point 167 180)
     (Point 180 180)
     (Point 180 300)
     (Point 20 300)
     (Point 20 510)
     (Point 35 510)
    )
    (connect D9:2 D11:1
     (Point 185 500)
     (Point 210 500)
     (Point 210 570)
     (Point 302 570)
    )
    (connect D11:0 D12:0
     (Point 360 604)
     (Point 360 625)
    )
    (connect D9:3 D12:1
     (Point 185 510)
     (Point 220 510)
     (Point 220 640)
     (Point 285 640)
    )
    (connect D4:1 D13:0
     (Point 662 500)
     (Point 680 500)
     (Point 680 440)
     (Point 790 440)
     (Point 790 455)
    )
    (connect D4:2 D14:0
     (Point 662 540)
     (Point 680 540)
     (Point 680 510)
     (Point 790 510)
     (Point 790 524)
    )
    (connect D4:3 D15:0
     (Point 662 580)
     (Point 790 580)
     (Point 790 595)
    )
    (connect D7:0 D16:0
     (Point 110 131)
     (Point 110 150)
     (Point 160 150)
     (Point 160 80)
     (Point 440 80)
     (Point 440 85)
    )
    (connect D6:0 D17:0
     (Point 110 195)
     (Point 110 215)
    )
    (connect D20:1 D18:0
     (Point 350 280)
     (Point 360 280)
     (Point 360 310)
     (Point 280 310)
     (Point 280 315)
    )
    (connect D18:0 D19:0
     (Point 280 345)
     (Point 280 355)
    )
    (connect D17:1 D20:0
     (Point 167 250)
     (Point 280 250)
     (Point 280 265)
    )
    (connect D6:1 D20:1
     (Point 167 180)
     (Point 180 180)
     (Point 180 280)
     (Point 209 280)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
