#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Wed 01/Jan/1992")
(component 0 "Context"
 (name "Pareto Chart Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 562 539)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 1 "TextDisplay"
   (name "Data")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 46 0)
    )
    (detail
     (origin 401 540)
     (extent 139 300)
    )
    (active detail)
   )
  )
  (component 2 "Context"
   (name "Pareto Chart Display")
   (description 25 4
    Generates and displays a bar chart using the 1-D
    array input data.  The number of bars is fixed
    at 10; the first 9 bars represent the largest
    input values, and the 10th bar represents all
    other inputs.  The "length" of each bar is set
    by the corresponding element value, which should
    be a positive real or int32 number.
    
    The display is pre-autoscaled before plotting,
    using the calculated pareto data values.
    
    The display and data labels, bar color, grid type,
    etc. can be set by clicking the Right Button over
    the display area and selecting the "Traces and
    Scales" entry from the resulting menu.  The gap
    between bars can be set using the "Spacing" box
    in the Detail view.
    
    It may prove useful to Secure the BarChart User
    Object after customizing, since this eliminates
    the Panel/Detail buttons and some menu selections
    that are no longer needed.  Be sure to save the
    unsecured object so you can make changes at a
    later date, however.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Ary")
     (requires
      (shape "Array 1D")
     )
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "ForCount"
     (name "For Count")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Count")
       (tag "Count")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Count")
       (lock name constraints)
      )
      (buffers in
       (buffer "Count")
      )
     )
     (implementation
      (component count 10)
     )
     (views
      (icon
       (origin 505 548)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
       (origin 615 253)
       (extent 170 34)
      )
      (active icon)
     )
    )
    (component 1 "FromArray"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (tag "Ary")
      )
      (output 1
       (type data)
       (name "SubAry")
       (tag "Result")
       (lock constraints)
      )
      (output 2
       (type data)
       (name "Type")
       (tag "Type")
       (lock constraints)
      )
      (output 3
       (type data)
       (name "NumDims")
       (tag "NumDims")
       (lock constraints)
      )
      (output 4
       (type data)
       (name "DimSizes")
       (tag "DimSizes")
       (lock constraints)
      )
      (output 5
       (type data)
       (name "TotSize")
       (tag "TotSize")
       (lock constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary")
     )
     (views
      (icon
       (origin 365 548)
       (extent 110 64)
       (iconImage "unbuild.icon")
      )
      (detail
       (origin 252 110)
       (extent 147 160)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Formula"
     (name "Calculate Bar coords")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "I")
       (optional yes)
      )
      (input 3
       (type data)
       (name "z")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "[coord(I+z/2,A[i]) coord(I+1-z/2,A[i])]")
     )
     (views
      (icon
       (origin 375 293)
       (extent 190 34)
      )
      (detail
       (origin 83 123)
       (extent 385 154)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Constant"
     (name "Spacing")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Spacing")
       (datum 0.2)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 351 338)
       (extent 78 25)
      )
      (detail
       (origin 257 286)
       (extent 147 28)
       (showFormat real)
      )
      (active icon)
     )
    )
    (component 4 "ToString"
     (name "Make Label")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "result")
       (lock name constraints)
      )
     )
     (implementation
      (attr iopath string write "string"
       (readTerm "\n")
       (fs " ")
       (eol "\n")
       (multiField fullSyntax)
       (arrayFormat linear)
      )
      (procedure
        WRITE TEXT "Index: "
        WRITE TEXT a INT FW:4 RJ
        WRITE TEXT " other" EOL
      )
     )
     (views
      (icon
       (origin 325 658)
       (extent 110 25)
      )
      (detail
       (origin 288 450)
       (extent 294 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "YPlot"
     (name "XY Trace")
     (subType "XY_Trace")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ranking")
       (lock constraints)
      )
      (input 2
       (type data)
       (name "Accum %")
       (lock constraints)
       (optional yes)
      )
      (input 3
       (type control)
       (name "Auto Scale")
       (lock name constraints)
       (optional yes)
      )
      (input 4
       (type control)
       (name "Next Curve")
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
      (component tracePin 1)
      (component tracePin 2)
      (component graphMode rectangular)
     )
     (views
      (icon
       (extent 110 0)
       (iconImage "display.icon")
      )
      (detail
       (origin 687 312)
       (extent 327 277)
       (displayMode scrollGraph)
       (graphType cartesian)
       (gridType frame)
       (scale 0
        (name "Y name")
        (domainName "X name")
        (pen 1)
        (show 1)
        (range 0 30 4 linear)
       )
       (scale 1
        (name "%")
        (domainName "X name")
        (pen 1)
        (show 1)
        (range 0 100 4 linear)
       )
       (domain 0 10 4 linear)
       (trace 0 onScale 0
        (name "Ranking")
        (pen 7)
        (lineType 1)
        (pointType 6)
       )
       (trace 1 onScale 1
        (name "Accum %")
        (pen 4)
        (lineType 1)
        (pointType 0)
       )
      )
      (active detail)
     )
    )
    (component 6 "Junction"
     (name "JCT")
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "C")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 617 393)
       (extent 46 34)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "Junction"
     (name "JCT")
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "C")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 617 323)
       (extent 46 34)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 8 "Context"
     (name "PreScale")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "LL")
       (lock constraints)
       (optional yes)
      )
      (output 2
       (type data)
       (name "UR")
       (lock constraints)
       (optional yes)
      )
      (output 3
       (type data)
       (name "LL")
       (lock constraints)
       (optional yes)
      )
      (output 4
       (type data)
       (name "UR")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Formula"
       (name "Upper Right")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "xmax")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "coord(xmax,max(a))")
       )
       (views
        (icon
         (origin 285 248)
         (extent 110 25)
        )
        (detail
         (origin 312 308)
         (extent 196 104)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "FromArray"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Ary")
         (tag "Ary")
        )
        (output 1
         (type data)
         (name "SubAry")
         (tag "Result")
         (lock constraints)
        )
        (output 2
         (type data)
         (name "Type")
         (tag "Type")
         (lock constraints)
        )
        (output 3
         (type data)
         (name "NumDims")
         (tag "NumDims")
         (lock constraints)
        )
        (output 4
         (type data)
         (name "DimSizes")
         (tag "DimSizes")
         (lock constraints)
        )
        (output 5
         (type data)
         (name "TotSize")
         (tag "TotSize")
         (lock constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "Ary")
       )
       (views
        (icon
         (origin 265 298)
         (extent 110 64)
         (iconImage "unbuild.icon")
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "Formula"
       (name "Lower Left")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "coord(0,min([min(a) 0]))")
       )
       (views
        (icon
         (origin 285 198)
         (extent 110 25)
        )
        (detail
         (origin 330 368)
         (extent 250 104)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 3 "Constant"
       (name "(0,0)")
       (subType "Coord")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Coord")
         (lock name constraints)
        )
       )
       (implementation
        (component value Coord
         (name "(0,0)")
         (numCoordDims 2)
         (datum (0,0))
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Coord
         (numCoordDims 2)
         (datum (0,0))
        )
       )
       (views
        (icon
         (origin 431 298)
         (extent 78 25)
        )
        (detail
         (origin 445 144)
         (extent 130 32)
         (showFormat real)
        )
        (active icon)
       )
      )
      (component 4 "Constant"
       (name "(10,100)")
       (subType "Coord")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Coord")
         (lock name constraints)
        )
       )
       (implementation
        (component value Coord
         (name "(10,100)")
         (numCoordDims 2)
         (datum (10,100))
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Coord
         (numCoordDims 2)
         (datum (0,0))
        )
       )
       (views
        (icon
         (origin 395 348)
         (extent 110 25)
        )
        (detail
         (origin 332 364)
         (extent 156 32)
         (showFormat real)
        )
        (active icon)
       )
      )
      (configuration
       (connect D2:0 D0:0)
       (connect I1:1 D0:1)
       (connect D1:5 D0:2)
       (connect I1:1 D1:1)
       (connect I1:1 D2:1)
       (connect D2:1 O1:1)
       (connect D0:1 O2:1)
       (connect D3:1 O3:1)
       (connect D4:1 O4:1)
      )
     )
     (views
      (icon
       (origin 455 378)
       (extent 110 45)
      )
      (detail
       (origin 236 178)
       (extent 288 205)
       (configuration
        (connect D2:0 D0:0
         (Point 340 225)
         (Point 340 245)
        )
        (connect I1:1 D0:1
         (Point 238 290)
         (Point 250 290)
         (Point 250 250)
         (Point 282 250)
        )
        (connect D1:5 D0:2
         (Point 377 350)
         (Point 390 350)
         (Point 390 290)
         (Point 270 290)
         (Point 270 270)
         (Point 282 270)
        )
        (connect I1:1 D1:1
         (Point 238 290)
         (Point 250 290)
         (Point 250 330)
         (Point 262 330)
        )
        (connect I1:1 D2:1
         (Point 238 290)
         (Point 250 290)
         (Point 250 210)
         (Point 282 210)
        )
        (connect D2:1 O1:1
         (Point 397 210)
         (Point 470 210)
         (Point 470 210)
         (Point 521 210)
        )
        (connect D0:1 O2:1
         (Point 397 260)
         (Point 410 260)
         (Point 410 260)
         (Point 521 260)
        )
        (connect D3:1 O3:1
         (Point 511 310)
         (Point 521 310)
        )
        (connect D4:1 O4:1
         (Point 507 360)
         (Point 521 360)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 9 "Do"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Do")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 537 468)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 10 "Gate"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (tag "InData")
      )
      (output 1
       (type data)
       (name "X")
       (tag "OutData")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 457 458)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 11 "Context"
     (name "Build Pareto")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (optional yes)
      )
      (output 1
       (type data)
       (name "result")
       (lock constraints)
       (optional yes)
      )
      (output 2
       (type data)
       (name "Result")
       (lock constraints)
       (optional yes)
      )
      (output 3
       (type data)
       (name "Result")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Formula"
       (name "maxIndex(x)")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked yes)
        (component expr 1 "maxIndex(x)")
       )
       (views
        (icon
         (origin 365 298)
         (extent 110 25)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "ToArray"
       (name "Set Array Value")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
        (input 2
         (type data)
         (name "Datum")
         (tag "Datum")
         (requires
          (shape "Scalar")
         )
         (lock constraints)
        )
        (input 3
         (type data)
         (name "Index 1")
         (tag "Index 1")
         (requires
          (datatype Int32)
          (shape "Scalar")
         )
         (lock constraints)
        )
        (input 4
         (type trigger)
         (name "XEQ")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
       )
       (implementation
        (component numDims 1)
       )
       (views
        (icon
         (origin 528 278)
         (extent 145 64)
         (iconImage "build.icon")
        )
        (detail
         (origin 710 495)
         (extent 140 210)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "Junction"
       (name "JCT")
       (interface
        (input 1
         (type data)
         (name "A")
         (lock name constraints)
        )
        (input 2
         (type data)
         (name "B")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Data")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 697 288)
         (extent 46 25)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (component 3 "Collector"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (tag "Data")
        )
        (input 2
         (type trigger)
         (name "XEQ")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
       )
       (implementation
        (component clearAtPrerun 1)
        (component clearAtActivate 1)
       )
       (views
        (icon
         (origin 535 378)
         (extent 110 25)
        )
        (detail
         (origin 575 575)
         (extent 60 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 4 "Collector"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (tag "Data")
        )
        (input 2
         (type trigger)
         (name "XEQ")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
       )
       (implementation
        (component clearAtPrerun 1)
        (component clearAtActivate 1)
       )
       (views
        (icon
         (origin 535 438)
         (extent 110 25)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (component 5 "Collector"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (tag "Data")
        )
        (input 2
         (type trigger)
         (name "XEQ")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
       )
       (implementation
        (component clearAtPrerun 1)
        (component clearAtActivate 1)
       )
       (views
        (icon
         (origin 535 498)
         (extent 110 25)
        )
        (detail
         (origin 575 575)
         (extent 60 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 6 "Start"
       (interface
        (sequence out)
       )
       (implementation
       )
       (views
        (icon
         (origin 117 162)
         (extent 67 37)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (component 7 "FromArray"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Ary")
         (tag "Ary")
        )
        (output 1
         (type data)
         (name "SubAry")
         (tag "Result")
         (lock constraints)
        )
        (output 2
         (type data)
         (name "Type")
         (tag "Type")
         (lock constraints)
        )
        (output 3
         (type data)
         (name "NumDims")
         (tag "NumDims")
         (lock constraints)
        )
        (output 4
         (type data)
         (name "DimSizes")
         (tag "DimSizes")
         (lock constraints)
        )
        (output 5
         (type data)
         (name "TotSize")
         (tag "TotSize")
         (lock constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "Ary")
       )
       (views
        (icon
         (origin 95 218)
         (extent 110 64)
         (iconImage "unbuild.icon")
        )
        (detail
         (origin 162 400)
         (extent 147 160)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 8 "ForCount"
       (name "For Count")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Count")
         (lock name constraints)
        )
       )
       (implementation
        (component count 9)
       )
       (views
        (icon
         (origin 95 308)
         (extent 110 64)
         (iconImage "loop.icon")
        )
        (detail
         (origin 445 373)
         (extent 170 34)
        )
        (active icon)
       )
      )
      (component 9 "Formula"
       (name "min(x)-1")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "min(a)-1.0")
       )
       (views
        (icon
         (origin 375 228)
         (extent 110 25)
        )
        (detail
         (origin 183 568)
         (extent 124 104)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 10 "Formula"
       (name "stretch")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "B")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "(a<10 ? concat(b,[0 0 0 0 0 0 0 0 0 0]) : b)")
       )
       (views
        (icon
         (origin 241 228)
         (extent 78 25)
        )
        (detail
         (origin 160 288)
         (extent 430 104)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 11 "Formula"
       (name "[a other]")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "B")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "concat(A,B-sum(A))")
       )
       (views
        (icon
         (origin 675 508)
         (extent 110 25)
        )
        (detail
         (origin 500 458)
         (extent 250 104)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 12 "Formula"
       (name "[0% a 100%]")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "concat(concat(0,a),100)")
       )
       (views
        (icon
         (origin 665 438)
         (extent 110 25)
        )
        (detail
         (origin 490 388)
         (extent 250 104)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 13 "Formula"
       (name "sum(x)")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked yes)
        (component expr 1 "sum(x)")
       )
       (views
        (icon
         (origin 121 528)
         (extent 78 25)
        )
        (detail
         (origin 121 650)
         (extent 88 60)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 14 "Formula"
       (name "a[i]")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "i")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "a[i]")
       )
       (views
        (icon
         (origin 127 418)
         (extent 46 25)
        )
        (detail
         (origin 370 538)
         (extent 70 104)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 15 "Formula"
       (name "cum sum")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "sum")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "a+sum")
       )
       (views
        (icon
         (origin 251 423)
         (extent 78 34)
        )
        (detail
         (origin 306 353)
         (extent 79 154)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 16 "Formula"
       (name "percent")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "B")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "A/B*100")
       )
       (views
        (icon
         (origin 391 428)
         (extent 78 25)
        )
        (detail
         (origin 287 388)
         (extent 97 104)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
       (connect D8:1 D0:0)
       (connect D2:1 D0:1)
       (connect D2:1 D1:1)
       (connect D9:1 D1:2)
       (connect D0:1 D1:3)
       (connect D0:0 D1:4)
       (connect D10:1 D2:1)
       (connect D1:1 D2:2)
       (connect D0:1 D3:1)
       (connect D8:0 D3:2)
       (connect D16:1 D4:1)
       (connect D8:0 D4:2)
       (connect D14:1 D5:1)
       (connect D8:0 D5:2)
       (connect D6:0 D7:0)
       (connect I1:1 D7:1)
       (connect D7:0 D8:0)
       (connect D10:1 D9:1)
       (connect D7:5 D10:1)
       (connect I1:1 D10:2)
       (connect D5:1 D11:1)
       (connect D13:1 D11:2)
       (connect D4:1 D12:1)
       (connect D10:1 D13:1)
       (connect D10:1 D14:1)
       (connect D0:1 D14:2)
       (connect D14:1 D15:1)
       (connect D15:1 D15:2)
       (connect D15:1 D16:1)
       (connect D13:1 D16:2)
       (connect D3:1 O1:1)
       (connect D12:1 O2:1)
       (connect D11:1 O3:1)
      )
     )
     (views
      (icon
       (origin 301 438)
       (extent 118 65)
      )
      (detail
       (origin 54 148)
       (extent 782 485)
       (configuration
        (connect D8:1 D0:0
         (Point 207 340)
         (Point 220 340)
         (Point 220 280)
         (Point 420 280)
         (Point 420 295)
        )
        (connect D2:1 D0:1
         (Point 745 300)
         (Point 760 300)
         (Point 760 360)
         (Point 350 360)
         (Point 350 310)
         (Point 362 310)
        )
        (connect D2:1 D1:1
         (Point 745 300)
         (Point 760 300)
         (Point 760 260)
         (Point 510 260)
         (Point 510 290)
         (Point 525 290)
        )
        (connect D9:1 D1:2
         (Point 487 240)
         (Point 500 240)
         (Point 500 300)
         (Point 525 300)
        )
        (connect D0:1 D1:3
         (Point 477 310)
         (Point 525 310)
        )
        (connect D0:0 D1:4
         (Point 420 325)
         (Point 420 340)
         (Point 490 340)
         (Point 490 320)
         (Point 525 320)
        )
        (connect D10:1 D2:1
         (Point 321 240)
         (Point 350 240)
         (Point 350 210)
         (Point 680 210)
         (Point 680 290)
         (Point 694 290)
        )
        (connect D1:1 D2:2
         (Point 675 310)
         (Point 694 310)
        )
        (connect D0:1 D3:1
         (Point 477 310)
         (Point 500 310)
         (Point 500 380)
         (Point 532 380)
        )
        (connect D8:0 D3:2
         (Point 150 374)
         (Point 150 390)
         (Point 260 390)
         (Point 260 400)
         (Point 532 400)
        )
        (connect D16:1 D4:1
         (Point 471 440)
         (Point 532 440)
        )
        (connect D8:0 D4:2
         (Point 150 374)
         (Point 150 390)
         (Point 260 390)
         (Point 260 400)
         (Point 500 400)
         (Point 500 460)
         (Point 532 460)
        )
        (connect D14:1 D5:1
         (Point 175 430)
         (Point 220 430)
         (Point 220 500)
         (Point 532 500)
        )
        (connect D8:0 D5:2
         (Point 150 374)
         (Point 150 390)
         (Point 260 390)
         (Point 260 400)
         (Point 500 400)
         (Point 500 520)
         (Point 532 520)
        )
        (connect D6:0 D7:0
         (Point 150 201)
         (Point 150 215)
        )
        (connect I1:1 D7:1
         (Point 56 400)
         (Point 70 400)
         (Point 70 250)
         (Point 92 250)
        )
        (connect D7:0 D8:0
         (Point 150 284)
         (Point 150 305)
        )
        (connect D10:1 D9:1
         (Point 321 240)
         (Point 372 240)
        )
        (connect D7:5 D10:1
         (Point 207 270)
         (Point 220 270)
         (Point 220 230)
         (Point 238 230)
        )
        (connect I1:1 D10:2
         (Point 56 400)
         (Point 230 400)
         (Point 230 250)
         (Point 238 250)
        )
        (connect D5:1 D11:1
         (Point 647 510)
         (Point 672 510)
        )
        (connect D13:1 D11:2
         (Point 201 540)
         (Point 660 540)
         (Point 660 530)
         (Point 672 530)
        )
        (connect D4:1 D12:1
         (Point 647 450)
         (Point 662 450)
        )
        (connect D10:1 D13:1
         (Point 321 240)
         (Point 340 240)
         (Point 340 270)
         (Point 240 270)
         (Point 240 410)
         (Point 110 410)
         (Point 110 420)
         (Point 100 420)
         (Point 100 540)
         (Point 118 540)
        )
        (connect D10:1 D14:1
         (Point 321 240)
         (Point 340 240)
         (Point 340 270)
         (Point 240 270)
         (Point 240 410)
         (Point 110 410)
         (Point 110 420)
         (Point 124 420)
        )
        (connect D0:1 D14:2
         (Point 477 310)
         (Point 500 310)
         (Point 500 380)
         (Point 250 380)
         (Point 250 420)
         (Point 210 420)
         (Point 210 460)
         (Point 110 460)
         (Point 110 440)
         (Point 124 440)
        )
        (connect D14:1 D15:1
         (Point 175 430)
         (Point 248 430)
        )
        (connect D15:1 D15:2
         (Point 331 440)
         (Point 350 440)
         (Point 350 480)
         (Point 230 480)
         (Point 230 450)
         (Point 248 450)
        )
        (connect D15:1 D16:1
         (Point 331 440)
         (Point 350 440)
         (Point 350 430)
         (Point 388 430)
        )
        (connect D13:1 D16:2
         (Point 201 540)
         (Point 360 540)
         (Point 360 450)
         (Point 388 450)
        )
        (connect D3:1 O1:1
         (Point 647 390)
         (Point 770 390)
         (Point 770 230)
         (Point 833 230)
        )
        (connect D12:1 O2:1
         (Point 777 450)
         (Point 790 450)
         (Point 790 400)
         (Point 833 400)
        )
        (connect D11:1 O3:1
         (Point 787 520)
         (Point 800 520)
         (Point 800 570)
         (Point 833 570)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 12 "TextDisplay"
     (name "Ranking")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (extent 78 0)
      )
      (detail
       (origin 466 656)
       (extent 508 29)
      )
      (active detail)
     )
    )
    (configuration
     (connect D9:0 D0:0)
     (connect D1:5 D0:1)
     (connect D11:3 D1:1)
     (connect D11:3 D2:1)
     (connect D0:1 D2:2)
     (connect D3:1 D2:3)
     (connect D11:1 D4:1)
     (connect D7:1 D5:1)
     (connect D6:1 D5:2)
     (connect D9:1 D5:3)
     (connect D5:0 D5:4)
     (connect D8:3 D6:1)
     (connect D8:4 D6:2)
     (connect D10:1 D6:3)
     (connect D2:1 D7:1)
     (connect D8:1 D7:2)
     (connect D8:2 D7:3)
     (connect D11:3 D8:1)
     (connect D8:0 D9:0)
     (connect D0:1 D10:0)
     (connect D11:2 D10:1)
     (connect I1:1 D11:1)
     (connect D4:1 D12:1)
    )
   )
   (views
    (icon
     (origin 415 318)
     (extent 190 25)
    )
    (panel
     (origin 480 118)
     (extent 561 365)
     (widget 12 detail
      (title off)
      (origin 485 448)
      (extent 510 30)
     )
     (widget 5 detail
      (title off)
      (origin 484 122)
      (extent 553 319)
      (displayMode annotGraph)
      (graphType cartesian)
      (gridType frame)
      (scale 0
       (name "")
       (domainName "")
       (pen 1)
       (show 1)
       (range 0 30 4 linear)
      )
      (scale 1
       (name " %")
       (domainName "")
       (pen 1)
       (show 1)
       (range 0 100 4 linear)
      )
      (domain 0 10 4 linear)
      (trace 0 onScale 0
       (name "Ranking")
       (pen 7)
       (lineType 1)
       (pointType 6)
      )
      (trace 1 onScale 1
       (name "Accum %")
       (pen 4)
       (lineType 1)
       (pointType 0)
      )
     )
    )
    (detail
     (origin 276 282)
     (extent 689 417)
     (configuration
      (connect D9:0 D0:0
       (Point 560 495)
       (Point 560 545)
      )
      (connect D1:5 D0:1
       (Point 477 600)
       (Point 490 600)
       (Point 490 580)
       (Point 502 580)
      )
      (connect D11:3 D1:1
       (Point 421 490)
       (Point 440 490)
       (Point 440 520)
       (Point 350 520)
       (Point 350 580)
       (Point 362 580)
      )
      (connect D11:3 D2:1
       (Point 421 490)
       (Point 440 490)
       (Point 440 390)
       (Point 320 390)
       (Point 320 300)
       (Point 372 300)
      )
      (connect D0:1 D2:2
       (Point 617 580)
       (Point 630 580)
       (Point 630 530)
       (Point 490 530)
       (Point 490 450)
       (Point 480 450)
       (Point 480 440)
       (Point 450 440)
       (Point 450 410)
       (Point 310 410)
       (Point 310 310)
       (Point 372 310)
      )
      (connect D3:1 D2:3
       (Point 431 350)
       (Point 440 350)
       (Point 440 380)
       (Point 330 380)
       (Point 330 320)
       (Point 372 320)
      )
      (connect D11:1 D4:1
       (Point 421 450)
       (Point 430 450)
       (Point 430 420)
       (Point 280 420)
       (Point 280 510)
       (Point 290 510)
       (Point 290 670)
       (Point 322 670)
      )
      (connect D7:1 D5:1
       (Point 665 340)
       (Point 684 340)
      )
      (connect D6:1 D5:2
       (Point 665 410)
       (Point 684 410)
      )
      (connect D9:1 D5:3
       (Point 585 480)
       (Point 684 480)
      )
      (connect D5:0 D5:4
       (Point 850 591)
       (Point 850 600)
       (Point 660 600)
       (Point 660 550)
       (Point 684 550)
      )
      (connect D8:3 D6:1
       (Point 567 400)
       (Point 614 400)
      )
      (connect D8:4 D6:2
       (Point 567 410)
       (Point 614 410)
      )
      (connect D10:1 D6:3
       (Point 505 470)
       (Point 520 470)
       (Point 520 450)
       (Point 580 450)
       (Point 580 420)
       (Point 614 420)
      )
      (connect D2:1 D7:1
       (Point 567 310)
       (Point 580 310)
       (Point 580 330)
       (Point 614 330)
      )
      (connect D8:1 D7:2
       (Point 567 380)
       (Point 590 380)
       (Point 590 340)
       (Point 614 340)
      )
      (connect D8:2 D7:3
       (Point 567 390)
       (Point 580 390)
       (Point 580 350)
       (Point 614 350)
      )
      (connect D11:3 D8:1
       (Point 421 490)
       (Point 440 490)
       (Point 440 400)
       (Point 452 400)
      )
      (connect D8:0 D9:0
       (Point 510 425)
       (Point 510 440)
       (Point 560 440)
       (Point 560 465)
      )
      (connect D0:1 D10:0
       (Point 617 580)
       (Point 630 580)
       (Point 630 530)
       (Point 490 530)
       (Point 490 450)
       (Point 480 450)
       (Point 480 455)
      )
      (connect D11:2 D10:1
       (Point 421 470)
       (Point 454 470)
      )
      (connect I1:1 D11:1
       (Point 278 500)
       (Point 290 500)
       (Point 290 470)
       (Point 298 470)
      )
      (connect D4:1 D12:1
       (Point 437 670)
       (Point 463 670)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 3 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 482)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 23 9
         PURPOSE:     Illustrates use of the ParetoChart library object to view an array of data.
         
         USER INPUT REQUIRED: Press Run to display the Bar Chart.
         
         EXPLANATION: To generate some interesting data to display, an array of 100 random numbers
                      between 0 and 1.0 is analyzed to get the magnitude Distribution in 15 "bins"
                      between 0 and 1.  The resulting array has 15 elements representing the number
                      of numbers in each of the 10 bins.  This array is given to the ParetoChart
                      library object for display.
         
         IMPLEMENTATION:  The ParetoChart library object provides additional usage information from
                      the Show Description choice in the object menu.  Setting colors, etc. is
                      described here, along with a description of the input requirements.  When
                      using the ParetoChart object in your models, you may want to place and size
                      it, then secure the User Object to prevent inadvertent changes.
         
                      Since the BarChart is a User Object, you may want to examine it to see how
                      the chart is generated.  Of special interest is the XYDisplay Traces & Scales
                      setting of Point style to "fill mode" to generate bars quickly.  Additionally,
                      a pseudo-recursive algorithm is used to successively eliminate the largest
                      element of the input array.  A "stretch" formula zero-fills the input array
                      if it is less than 9 elements.  
         
        )
       )
       (views
        (icon
         (origin 410 415)
         (extent 78 25)
        )
        (detail
         (origin 25 209)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 0 41)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 45 175)
         (extent 832 463)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 415 508)
     (extent 110 25)
    )
    (panel
     (origin 41 532)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 143 545)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 4 "Context"
   (name "Generate Data")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Result")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Constant"
     (name "Low Limit")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Low Limit")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 28 236)
       (extent 165 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 1 "Constant"
     (name "High Limit")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "High Limit")
       (datum 1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 23 306)
       (extent 174 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 2 "Constant"
     (name "step")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "step")
       (datum 0.06666666666666667)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 487 708)
       (extent 46 25)
      )
      (detail
       (origin 39 376)
       (extent 122 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 3 "Formula"
     (name "randomize(x,low,high)")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "low")
       (requires
        (shape "Scalar")
       )
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "high")
       (requires
        (shape "Scalar")
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "randomize(x,low,high)")
     )
     (views
      (icon
       (origin 261 203)
       (extent 199 34)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "Formula"
     (name "magDist()")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "From")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "Thru")
       (lock name constraints)
      )
      (input 4
       (type data)
       (name "Step")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "magDist(x,from,thru,step)")
     )
     (views
      (icon
       (origin 265 298)
       (extent 110 45)
      )
      (detail
       (origin 421 305)
       (extent 259 210)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "AllocateArray"
     (name "Alloc Real")
     (subType "Alloc_Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
     )
     (implementation
      (component numDims 1)
      (component dimSizes "100")
      (component type "Real")
      (component initEnum "Init Value")
      (component initialValue
       (name "Init Value")
       (datum 0)
      )
      (component from 1)
      (component thru 10)
     )
     (views
      (icon
       (origin 55 168)
       (extent 110 25)
      )
      (detail
       (origin 525 110)
       (extent 360 120)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D5:1 D3:1)
     (connect D0:1 D3:2)
     (connect D1:1 D3:3)
     (connect D3:1 D4:1)
     (connect D0:1 D4:2)
     (connect D1:1 D4:3)
     (connect D2:1 D4:4)
     (connect D4:1 O1:1)
    )
   )
   (views
    (icon
     (extent 127 0)
    )
    (detail
     (origin 14 148)
     (extent 393 284)
     (configuration
      (connect D5:1 D3:1
       (Point 167 180)
       (Point 220 180)
       (Point 220 210)
       (Point 258 210)
      )
      (connect D0:1 D3:2
       (Point 195 250)
       (Point 220 250)
       (Point 220 220)
       (Point 258 220)
      )
      (connect D1:1 D3:3
       (Point 199 320)
       (Point 240 320)
       (Point 240 230)
       (Point 258 230)
      )
      (connect D3:1 D4:1
       (Point 462 220)
       (Point 470 220)
       (Point 470 260)
       (Point 250 260)
       (Point 250 300)
       (Point 262 300)
      )
      (connect D0:1 D4:2
       (Point 195 250)
       (Point 230 250)
       (Point 230 310)
       (Point 262 310)
      )
      (connect D1:1 D4:3
       (Point 199 320)
       (Point 262 320)
      )
      (connect D2:1 D4:4
       (Point 163 390)
       (Point 220 390)
       (Point 220 330)
       (Point 262 330)
      )
      (connect D4:1 O1:1
       (Point 377 320)
       (Point 405 320)
       (Point 405 300)
       (Point 404 300)
      )
     )
    )
    (active detail)
   )
  )
  (configuration
   (connect D4:1 D1:1)
   (connect D4:1 D2:1)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 851 554)
   (widget 1 detail
    (title on)
    (origin 38 243)
    (extent 167 362)
   )
   (widget 3 panel
    (title on)
    (origin 38 113)
    (extent 327 80)
    (widget 1 icon
     (title off)
     (origin 147 130)
     (extent 114 39)
     (format button)
    )
   )
   (widget 2 panel
    (title on)
    (origin 238 244)
    (extent 580 364)
    (widget 12 detail
     (title off)
     (origin 243 574)
     (extent 510 30)
    )
    (widget 5 detail
     (title off)
     (origin 243 249)
     (extent 572 321)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType frame)
     (scale 0
      (name "")
      (domainName "")
      (pen 1)
      (show 1)
      (range 0 30 4 linear)
     )
     (scale 1
      (name " %")
      (domainName "")
      (pen 1)
      (show 1)
      (range 0 100 4 linear)
     )
     (domain 0 10 4 linear)
     (trace 0 onScale 0
      (name "Ranking")
      (pen 7)
      (lineType 1)
      (pointType 6)
     )
     (trace 1 onScale 1
      (name "Accum %")
      (pen 4)
      (lineType 1)
      (pointType 0)
     )
    )
   )
   (widget 0 detail
    (title on)
    (origin 420 114)
    (extent 397 82)
    (editing disabled)
   )
  )
  (detail
   (origin 0 67)
   (extent 970 628)
   (configuration
    (connect D4:1 D1:1
     (Point 429 300)
     (Point 450 300)
     (Point 450 470)
     (Point 380 470)
     (Point 380 690)
     (Point 398 690)
    )
    (connect D4:1 D2:1
     (Point 429 300)
     (Point 477 300)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
