#! /usr/lib/veetest/veetest -r
(revision "A.00.00")
(date "Tue 02/Apr/1991")
(component 0 "Context"
 (name "Optimize 3 Example")
 (interface
  (sequence in)
  (sequence out)
 )
 (implementation
  (trigMode rad)
  (locked no)
  (component 0 "Do"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Do")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (description 11 5
     In order to get accurate timing, this DO is used
     to guarantee that the timer Start input will be
     "pinged" before the formula box is executed.
     
     If, instead, the Start had just connected to the
     Timer Begin and the Formula box with two lines,
     the actual order of execution of the two would
     not be guaranteed.  This technique should always
     be used when timing events.  There is a small
     delay in the Do, but if both the Timer Begin and
     End are fed by Do's, the delays will cancel.
    )
    (icon
     (origin 357 148)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 1 "ForRange"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component from 0)
    (component thru 990)
    (component step 10)
   )
   (views
    (description 11 5
     Instead of generating the 100 data values between
     0 and 990 with a linear Ramp, we use the ForRange
     to generate them one at a time.
     
     The output of the For Range is fed to the sin() and
     cos(s) objects for each iteration.  The plot also
     receives the sin and cos values once each iteration.
     
     This requires that the sin, cos, and XY plot are
     executed 100 times each, rather than 3 times as
     in the first example.
    )
    (icon
     (iconImage loop.icon)
    )
    (detail
     (origin 295 487)
     (extent 170 86)
    )
    (active detail)
   )
  )
  (component 2 "Do"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Do")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (description 2 5
     See the Show Description on the "Do" objects
     before and after the "Formula" object above.
    )
    (icon
     (origin 357 588)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "XYPlot"
   (name "X vs Y Plot")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "XData")
    )
    (input 2
     (type data)
     (name "YData1")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 0)
    (component tracePin 2)
    (component graphMode rectangular)
   )
   (views
    (description 10 5
     In this case, the X and Y input data consists of
     two 100 element arrays.  The first X,Y point is
     taken from the first element of each array, the
     next X,Y point from the second element of each
     array, etc. 
     
     Note that it is Much faster to plot X,Y pairs
     this way than to send the values a pair at a
     time to the display.
     
    )
    (icon
    )
    (detail
     (origin 699 163)
     (extent 243 234)
     (displayMode graphOnly)
     (graphType cartesian)
     (gridType off)
     (scale 0
      (name "Y scale")
      (domainName "X scale")
      (color 0xa8a8a8)
      (show 1)
      (range -1 1 3 linear)
     )
     (domain -1 1 3 linear)
     (trace 0 onScale 0
      (name "YData1")
      (color 0xff0000)
      (lineType 1)
      (pointType 0)
     )
    )
    (terminals on)
    (active detail)
   )
  )
  (component 4 "XYPlot"
   (name "X vs Y Plot")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "XData")
    )
    (input 2
     (type data)
     (name "YData1")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 0)
    (component tracePin 2)
    (component graphMode rectangular)
   )
   (views
    (description 5 5
     This plot is generated by drawing lines from each
     pair of X,Y data presented to the object.  Note
     that it is much slower to draw each line once
     per execution, rather than all at once as in the
     first case.
    )
    (icon
    )
    (detail
     (origin 699 453)
     (extent 243 234)
     (displayMode graphOnly)
     (graphType cartesian)
     (gridType off)
     (scale 0
      (name "Y scale")
      (domainName "X scale")
      (color 0xa8a8a8)
      (show 1)
      (range -1 1 3 linear)
     )
     (domain -1 1 3 linear)
     (trace 0 onScale 0
      (name "YData1")
      (color 0xff0000)
      (lineType 1)
      (pointType 0)
     )
    )
    (terminals on)
    (active detail)
   )
  )
  (component 5 "Start"
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 347 92)
     (extent 67 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "Formula"
   (name "cos(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "cos(X)")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "cos(x)")
   )
   (views
    (description 3 5
     Calculates cos(x) on each data value passed to
     the object.  This is done for each of the 100
     data points.
    )
    (icon
     (origin 535 617)
     (extent 71 26)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "Do"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Do")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (description 2 5
     See the comments in the "Do" objects before
     and after the "Formula" object above.
    )
    (icon
     (origin 357 398)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "Formula"
   (name "cos(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "cos(X)")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "cos(x)")
   )
   (views
    (description 4 5
     The cos of all elements of the input array are
     calculated in this object (effectively) in 
     parallel.  This is much faster than doing the
     cos function on each discrete data element.
    )
    (icon
     (origin 535 327)
     (extent 71 26)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "Formula"
   (name "sin(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "sin(X)")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "sin(x)")
   )
   (views
    (description 3 5
     Calculates sin(x) on each data value passed to
     the function.  This is done for each of the 100
     data points.
    )
    (icon
     (origin 535 497)
     (extent 71 26)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 10 "Timer"
   (interface
    (sequence out)
    (input 1
     (type data)
     (name "Time1")
    )
    (input 2
     (type data)
     (name "Time2")
    )
    (output 1
     (type data)
     (name "T2 - T1")
     (tag "dTime")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (description 2 5
     See the Show Description on the other timer for
     more info.
    )
    (icon
     (origin 481 418)
     (extent 78 25)
    )
    (detail
     (origin 476 403)
     (extent 129 34)
    )
    (active detail)
   )
  )
  (component 11 "ExitProcess"
   (interface
    (sequence in)
   )
   (implementation
    (comp code 0)
   )
   (views
    (icon
     (origin 341 638)
     (extent 78 64)
     (iconImage stop.icon)
    )
    (detail
     (origin 320 663)
     (extent 120 34)
    )
    (active icon)
   )
  )
  (component 12 "Do"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Do")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (description 11 5
     This "Do" object guarantees that the Timer End
     pin will be "pinged" before continuing on to the 
     remainder of the example.  If, instead, the 
     Formula box had just wired two lines to the Timer
     End and the next Do, it would not be guaranteed
     that the timer End signal would be received before
     the next Do would receive control.
     
     This is a good technique whenever timing is used.
     Note that any small delay in the "Do" object is
     cancelled if both Timer Begin and End use Do's.
    )
    (icon
     (origin 357 358)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "Formula"
   (name "sin(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "sin(X)")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "sin(x)")
   )
   (views
    (description 4 5
     The sin of all elements in the input data are
     calculated within this object.  This is much more
     efficient than calculating sin with each discrete
     data value.
    )
    (icon
     (origin 535 207)
     (extent 71 26)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 14 "AllocateArray"
   (name "Alloc  Array")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Array")
     (tag "Array")
     (lock constraints)
    )
   )
   (implementation
    (component numDims 1)
    (component dimSizes "100")
    (component type "Int32")
    (component initEnum "Lin Ramp")
    (component initialValue
     (name "Init Value")
     (datum 0)
    )
    (component from 0)
    (component thru 990)
   )
   (views
    (description 21 5
     Instead of using a For Range to generate an array
     of 100 numbers between 0 and 990, the Allocate
     Array object can be used.  The Alloc Array object
     can initialize the resulting array using one of
     several methods.  The default is to set all array
     elements to a constant value (default 0).  If you
     click on the "Init Value" button, you can select
     either Linear or Logarithmic Ramp initialization.
     
     In our case, we generate an array of 100 numbers
     starting at 0 and ending at 990, just the same as
     the For Range in the example below.
     
     As an exercise, you could also use the Math
     Generate function for Ramp to produce an array of
     data for this example.  Or, the Formula object
     could use the ramp(numElem,Start,End) expression
     to generate the data.  In any case, the goal is
     to have an array of the numbers instead of using
     an iterative loop to generate them one at a time.
     
    )
    (icon
     (extent 118 0)
    )
    (detail
     (origin 284 229)
     (extent 192 102)
    )
    (active detail)
   )
  )
  (component 15 "Timer"
   (interface
    (sequence out)
    (input 1
     (type data)
     (name "Time1")
    )
    (input 2
     (type data)
     (name "Time2")
    )
    (output 1
     (type data)
     (name "T2 - T1")
     (tag "dTime")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (description 10 5
     The time delay between receiving a "ping" on the
     Begin pin and a "ping" on the End pin is displayed
     by the timer in seconds.
     
     Since both inputs are fed by the "Do" objects, any
     delay in the "Do" is effectively canceled.
     
     See the Show Description for the "Do" objects to
     see why they are needed to guarantee good timing
     accuracy.
    )
    (icon
    )
    (detail
     (origin 475 133)
     (extent 130 34)
    )
    (active detail)
   )
  )
  (component 16 "Note"
   (name "HINTS:")
   (interface
   )
   (implementation
    (component text 7 5
     Most of the objects have
     detailed comments in the
     "Show Description" dialog
     boxes.  Click the right
     mouse button over an object
     to allow you to select this
     menu item.
    )
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 9 262)
     (extent 263 137)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 17 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 6 5
     This example is provided
     as an illustration "as is",
     and Hewlett-Packard
     Company makes no warranty
     of any kind with regard to
     this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 8 471)
     (extent 265 119)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 18 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Note"
       (name "NotePad")
       (interface
       )
       (implementation
        (component text 25 9
         PURPOSE:  To show the efficiency of parallel operations on arrays, in contrast to 
              element-by-element iterative loops.
         
         USER INPUT REQUIRED:  Press RUN and observe the timing differences between the cases.
         
         EXPLANATION:  If data is "bundled" into a 1 dimension array,  the entire array can
              be processed more efficiently.  In this example, the time to generate sin(x) and
              cos(x) one element at a time is much greater than the time to take the sin() and
              cos() of all elements in an array (in parallel).  Plotting data is also much more
              efficient if the data points to be plotted are collected into an array rather than
              sent one by one to the XY display.
         
              The first case generates an array of 100 numbers between 0 and 990.  Since the
              Preferences for Trig is set to "radians", the sin and cos of all numbers in the
              array are generated by assuming that the array values are radians.  (Different
              results are obtained if this is changed; you may want to experiment with the
              Preferences from the "File" menu.)  The output of the sin and cos objects is two
              arrays of 100 values; the plot is generated by drawing lines between each
              successive pair of input points.
         
              The second case uses a For Range to generate the same number series, only one at
              a time.  Again the sin and cos of each number are calculated assuming the value
              is in radians.  The resulting sin/cos values are plotted by drawing a line from the
              previous X,Y point to the new point.
         
        )
       )
       (views
        (description 2 9
         This notepad is displayed as a Show on Execute
         panel to present the information to the reader.
        )
        (icon
         (origin 160 185)
         (extent 78 25)
        )
        (detail
         (origin 36 162)
         (extent 848 437)
         (editing enabled)
        )
        (active icon)
       )
      )
      (component 1 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (description 7 9
         This tiny "thread" begins running when the 
         enclosing UserObject is executed.  When the user
         acknowledges the OK/DONE button, there is nothing
         left to execute, so the thread ends.  Since there
         are not other threads running, the User Object
         is completed and will exit, removing the Show on
         Execute pop-up display.
        )
        (icon
         (origin 171 252)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 55 78)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 detail
         (title off)
         (origin 51 176)
         (extent 816 465)
         (editing disabled)
        )
        (widget 1 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 140)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 415 408)
     (extent 110 25)
    )
    (panel
     (origin 10 124)
     (extent 260 72)
     (widget 1 icon
      (title off)
      (origin 87 138)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D5:0 D0:0)
   (connect D7:0 D1:0)
   (connect D1:0 D2:0)
   (connect D13:1 D3:1)
   (connect D8:1 D3:2)
   (connect D9:1 D4:1)
   (connect D6:1 D4:2)
   (connect D1:1 D6:1)
   (connect D12:0 D7:0)
   (connect D14:1 D8:1)
   (connect D1:1 D9:1)
   (connect D7:1 D10:1)
   (connect D2:1 D10:2)
   (connect D2:0 D11:0)
   (connect D14:0 D12:0)
   (connect D14:1 D13:1)
   (connect D0:0 D14:0)
   (connect D0:1 D15:1)
   (connect D12:1 D15:2)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 980 653)
   (configuration
    (connect D5:0 D0:0
     (Point 380 131)
     (Point 380 145)
    )
    (connect D7:0 D1:0
     (Point 380 425)
     (Point 380 454)
    )
    (connect D1:0 D2:0
     (Point 380 575)
     (Point 380 585)
    )
    (connect D13:1 D3:1
     (Point 608 220)
     (Point 626 220)
    )
    (connect D8:1 D3:2
     (Point 608 340)
     (Point 626 340)
    )
    (connect D9:1 D4:1
     (Point 608 510)
     (Point 626 510)
    )
    (connect D6:1 D4:2
     (Point 608 630)
     (Point 626 630)
    )
    (connect D1:1 D6:1
     (Point 467 530)
     (Point 500 530)
     (Point 500 630)
     (Point 532 630)
    )
    (connect D12:0 D7:0
     (Point 380 385)
     (Point 380 395)
    )
    (connect D14:1 D8:1
     (Point 478 280)
     (Point 520 280)
     (Point 520 340)
     (Point 532 340)
    )
    (connect D1:1 D9:1
     (Point 467 530)
     (Point 500 530)
     (Point 500 510)
     (Point 532 510)
    )
    (connect D7:1 D10:1
     (Point 405 410)
     (Point 473 410)
    )
    (connect D2:1 D10:2
     (Point 405 600)
     (Point 490 600)
     (Point 490 450)
     (Point 460 450)
     (Point 460 430)
     (Point 473 430)
    )
    (connect D2:0 D11:0
     (Point 380 615)
     (Point 380 635)
    )
    (connect D14:0 D12:0
     (Point 380 333)
     (Point 380 355)
    )
    (connect D14:1 D13:1
     (Point 478 280)
     (Point 510 280)
     (Point 510 220)
     (Point 532 220)
    )
    (connect D0:0 D14:0
     (Point 380 175)
     (Point 380 196)
    )
    (connect D0:1 D15:1
     (Point 405 160)
     (Point 430 160)
     (Point 430 140)
     (Point 472 140)
    )
    (connect D12:1 D15:2
     (Point 405 370)
     (Point 420 370)
     (Point 420 350)
     (Point 500 350)
     (Point 500 190)
     (Point 460 190)
     (Point 460 160)
     (Point 472 160)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
