#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Tue 24/Sep/1991")
(component 0 "Context"
 (name "Mag/Phase Display")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "VFunctionGenerator"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Func")
     (lock name constraints)
    )
   )
   (implementation
    (component function Sine)
    (component frequency 1000)
    (component amplitude 1)
    (component dcOffset 0)
    (component phaseShift 0)
    (component numPoints 256)
    (component interval 0.02)
    (component degRad Deg)
    (component errorOnAlias 1)
   )
   (views
    (icon
     (origin 62 155)
     (extent 156 70)
     (iconImage "virtual.icon")
    )
    (detail
     (origin 40 343)
     (extent 220 234)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 1 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 382 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 2 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 482)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 20 9
         PURPOSE:      Illustrates a simple method of displaying the Magnitude and Phase vs.
                       Frequency from a time domain waveform.  Note that this is a User Object
                       and not one of the supplied display objects.
         
         USER INPUT REQUIRED: Press Run to display the Magnitude and Phase of the waveform.
         
         EXPLANATION:  A time domain waveform can be processed by a FFT to give the Frequency
                       domain magitude.  The FFT also produces, as the complex part of the
                       spectrum output, a phase vs. frequence output.  This model shows a simple
                       way to generate and plot both the magnitude and the phase vs. frequency,
                       given a time-domain waveform as input.
         
                       Note use of the library "toDB" object to convert the magnitude to DB for
                       a more useful display.
                       
                       The technique for shifting the X axis of both waveforms during display 
                       relies on adding a right scale to the display.  Each waveform then has
                       a different scaling algorithm, allowing the magnitude to be shifted "up"
                       (scale from 60 to -250) and the phase to be shifted "down" (600 to -200).
         
        )
       )
       (views
        (icon
         (origin 410 415)
         (extent 78 25)
        )
        (detail
         (origin 25 209)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 48 78)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 45 175)
         (extent 832 463)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 315 258)
     (extent 110 25)
    )
    (panel
     (origin 11 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 113 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 3 "Context"
   (name "Mag/Phase Display")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (requires
      (datatype Spectrum)
      (shape "Array 1D")
     )
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Context"
     (name "To dB")
     (description 7 6
      Converts from a linear unit to a dB unit.  Select
      the dB unit by clicking on the dB type field. 
      The unit of the input is assumed to be either
      Volt or Watt depending the dB type selected.
      
      LogMag references to 1, like dBW and dBV, but
      multiplies by 1 rather than 10 or 20.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Mag")
       (optional yes)
      )
      (output 1
       (type data)
       (name "X")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked yes)
      (component 0 "Formula"
       (name "To dB")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Mag")
         (optional yes)
        )
        (input 2
         (type data)
         (name "Ref")
         (optional yes)
        )
        (input 3
         (type data)
         (name "Mult")
         (optional yes)
        )
        (input 4
         (type data)
         (name "type")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "TodB(Mag,Ref[ordinal(type)],Mult[ordinal(type)])")
       )
      )
      (component 1 "EnumConstant"
       (name "dB type")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (lock name constraints)
        )
       )
       (implementation
        (component value Enum
         (name "dB type")
         (values
          ( "dBV" 0)
          ( "dBmV" 1)
          ( "dBuV" 2)
          ( "dBW" 3)
          ( "dBm" 4)
          ( "dBmW" 5)
          ( "dBuW" 6)
          ( "dBpW" 7)
          ( "LogMag" 8)
         )
         (datum "dBm")
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Enum
         (shared yes)
         (datum "dBV")
        )
       )
      )
      (component 2 "Constant"
       (name "Ref")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (lock name constraints)
        )
       )
       (implementation
        (component value Real
         (name "Ref")
         (numDims 1)
         (size 9)
         (data
          [ 1 0.001 1E-06 1 0.001 0.001 1E-06 1E-12 1 ]
         )
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Real
         (datum 0)
        )
       )
      )
      (component 3 "Constant"
       (name "Mult")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (lock name constraints)
        )
       )
       (implementation
        (component value Real
         (name "Mult")
         (numDims 1)
         (size 9)
         (data
          [ 20 20 20 10 10 10 10 10 1 ]
         )
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Real
         (datum 0)
        )
       )
      )
      (configuration
       (connect I1:1 D0:1)
       (connect D2:1 D0:2)
       (connect D3:1 D0:3)
       (connect D1:1 D0:4)
       (connect D0:1 O1:1)
      )
     )
     (views
      (icon
       (origin 846 158)
       (extent 78 25)
      )
      (panel
       (origin 941 204)
       (extent 168 73)
       (widget 1 detail
        (title on)
        (origin 951 247)
        (extent 147 26)
        (format list)
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "ToFunction"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "InArray")
       (tag "InArray")
       (lock constraints)
      )
      (input 2
       (type data)
       (name "Map From 1")
       (tag "Map From 1")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (input 3
       (type data)
       (name "Map To 1")
       (tag "Map To 1")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "OutFunc")
       (tag "OutFunc")
       (lock constraints)
      )
      (buffers in
       (buffer "Map From 1")
       (buffer "Map To 1")
      )
     )
     (implementation
      (component numDims 1)
      (component xMappings "Linear")
      (component mapFroms "0")
      (component mapTos "6450")
     )
     (views
      (icon
       (origin 699 225)
       (extent 112 70)
       (iconImage "build.icon")
      )
      (detail
       (origin 551 253)
       (extent 318 154)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "FromSpectrum"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Spec Data")
       (tag "Spec Data")
       (requires
        (datatype Spectrum)
       )
       (lock constraints)
      )
      (output 1
       (type data)
       (name "Pcx Ary")
       (tag "Pcx Ary")
       (lock constraints)
      )
      (output 2
       (type data)
       (name "Start")
       (tag "Start")
       (lock name constraints)
      )
      (output 3
       (type data)
       (name "Stop")
       (tag "Stop")
       (lock name constraints)
      )
     )
     (implementation
      (component freqMode "Start/Stop Freq")
     )
     (views
      (icon
       (origin 260 224)
       (extent 161 72)
       (iconImage "unbuild.icon")
      )
      (detail
       (origin 552 450)
       (extent 156 100)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "FromPComplex"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "PComplex")
       (requires
        (datatype PComplex)
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Mag")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Phase")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 462 156)
       (extent 156 69)
       (iconImage "unbuild.icon")
      )
      (detail
       (origin 690 585)
       (extent 80 70)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "ToFunction"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "InArray")
       (tag "InArray")
       (lock constraints)
      )
      (input 2
       (type data)
       (name "Map From 1")
       (tag "Map From 1")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (input 3
       (type data)
       (name "Map To 1")
       (tag "Map To 1")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "OutFunc")
       (tag "OutFunc")
       (lock constraints)
      )
      (buffers in
       (buffer "Map From 1")
       (buffer "Map To 1")
      )
     )
     (implementation
      (component numDims 1)
      (component xMappings "Linear")
      (component mapFroms "0")
      (component mapTos "6450")
     )
     (views
      (icon
       (origin 699 135)
       (extent 112 70)
       (iconImage "build.icon")
      )
      (detail
       (origin 541 163)
       (extent 318 154)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "YPlot"
     (name "Magnitude/Phase")
     (subType "XY_Trace")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Magnitude")
       (lock constraints)
      )
      (input 2
       (type data)
       (name "Phase")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
      (component tracePin 1)
      (component tracePin 2)
      (component graphMode rectangular)
     )
     (views
      (icon
       (origin 624 515)
       (extent 145 70)
       (iconImage "display.icon")
      )
      (detail
       (origin 324 368)
       (extent 592 325)
       (displayMode scrollGraph)
       (graphType cartesian)
       (gridType grid)
       (scale 0
        (name "Magnitude")
        (domainName "Frequency")
        (pen 9)
        (show 1)
        (range -250 60 4 linear)
       )
       (scale 1
        (name "Phase")
        (domainName "Frequency")
        (pen 7)
        (show 1)
        (range -200 600 4 linear)
       )
       (domain 0 7000 4 linear)
       (trace 0 onScale 0
        (name "Magnitude")
        (pen 4)
        (lineType 1)
        (pointType 0)
       )
       (trace 1 onScale 1
        (name "Phase")
        (pen 7)
        (lineType 1)
        (pointType 0)
       )
       (marker 0 onTrace 0)
       (marker 1 onTrace 1)
      )
      (active detail)
     )
    )
    (configuration
     (connect D4:1 D0:1)
     (connect D3:2 D1:1)
     (connect D2:2 D1:2)
     (connect D2:3 D1:3)
     (connect I1:1 D2:1)
     (connect D2:1 D3:1)
     (connect D3:1 D4:1)
     (connect D2:2 D4:2)
     (connect D2:3 D4:3)
     (connect D0:1 D5:1)
     (connect D1:1 D5:2)
    )
   )
   (views
    (icon
     (origin 544 405)
     (extent 163 30)
    )
    (panel
     (origin 345 264)
     (extent 550 393)
     (widget 5 detail
      (title off)
      (origin 349 268)
      (extent 544 386)
      (displayMode scrollGraph)
      (graphType cartesian)
      (gridType grid)
      (scale 0
       (name "Magnitude")
       (domainName "Frequency")
       (pen 9)
       (show 1)
       (range -250 60 4 linear)
      )
      (scale 1
       (name "Phase")
       (domainName "Frequency")
       (pen 7)
       (show 1)
       (range -200 600 4 linear)
      )
      (domain 0 7000 4 linear)
      (trace 0 onScale 0
       (name "Magnitude")
       (pen 4)
       (lineType 1)
       (pointType 0)
      )
      (trace 1 onScale 1
       (name "Phase")
       (pen 7)
       (lineType 1)
       (pointType 0)
      )
      (marker 0 onTrace 0)
      (marker 1 onTrace 0)
     )
    )
    (detail
     (origin 234 118)
     (extent 732 584)
     (configuration
      (connect D4:1 D0:1
       (Point 813 170)
       (Point 828 170)
       (Point 828 170)
       (Point 843 170)
      )
      (connect D3:2 D1:1
       (Point 620 210)
       (Point 640 210)
       (Point 640 240)
       (Point 696 240)
      )
      (connect D2:2 D1:2
       (Point 423 260)
       (Point 696 260)
      )
      (connect D2:3 D1:3
       (Point 423 280)
       (Point 696 280)
      )
      (connect I1:1 D2:1
       (Point 236 420)
       (Point 240 420)
       (Point 240 260)
       (Point 257 260)
      )
      (connect D2:1 D3:1
       (Point 423 240)
       (Point 440 240)
       (Point 440 190)
       (Point 459 190)
      )
      (connect D3:1 D4:1
       (Point 620 170)
       (Point 640 170)
       (Point 640 150)
       (Point 696 150)
      )
      (connect D2:2 D4:2
       (Point 423 260)
       (Point 660 260)
       (Point 660 170)
       (Point 696 170)
      )
      (connect D2:3 D4:3
       (Point 423 280)
       (Point 670 280)
       (Point 670 190)
       (Point 696 190)
      )
      (connect D0:1 D5:1
       (Point 926 170)
       (Point 940 170)
       (Point 940 320)
       (Point 310 320)
       (Point 310 450)
       (Point 321 450)
      )
      (connect D1:1 D5:2
       (Point 813 260)
       (Point 830 260)
       (Point 830 310)
       (Point 300 310)
       (Point 300 610)
       (Point 321 610)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D0:1 D3:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 1004 664)
   (configuration
    (connect D0:1 D3:1
     (Point 312 460)
     (Point 327 460)
     (Point 327 460)
     (Point 342 460)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
