#! /usr/lib/veetest/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name "Using Wait For SRQ")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "OnCycle"
   (name "On Cycle")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component cycle 2)
   )
   (views
    (icon
     (origin 235 318)
     (extent 110 64)
     (iconImage loop.icon)
    )
    (detail
     (origin 230 593)
     (extent 160 34)
    )
    (active detail)
   )
  )
  (component 1 "OnCycle"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component cycle 1)
   )
   (views
    (icon
     (origin 55 498)
     (extent 110 64)
     (iconImage loop.icon)
    )
    (detail
     (origin 230 673)
     (extent 160 34)
    )
    (active detail)
   )
  )
  (component 2 "RepeatUntilBreak"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 505 198)
     (extent 110 64)
     (iconImage loop.icon)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "Note"
   (name "Threads #2 & #3")
   (interface
   )
   (implementation
    (component text 7 5
     These threads just 
     count at different 
     rates.  They are here
     to show that other
     threads continue to 
     execute while a Wait
     For SRQ is pending.
    )
   )
   (views
    (icon
     (extent 145 0)
    )
    (detail
     (origin 5 571)
     (extent 210 139)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 4 "Counter"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
    (output 1
     (type data)
     (name "Count")
     (tag "Count")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 411 678)
     (extent 78 25)
    )
    (detail
     (origin 155 513)
     (extent 150 34)
    )
    (active icon)
   )
  )
  (component 5 "Counter"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
    (output 1
     (type data)
     (name "Count")
     (tag "Count")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 411 598)
     (extent 78 25)
    )
    (detail
     (origin 205 533)
     (extent 150 34)
    )
    (active icon)
   )
  )
  (component 6 "TextDisplay"
   (name "Number")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 515 593)
     (extent 111 35)
    )
    (active detail)
   )
  )
  (component 7 "TextDisplay"
   (name "Number")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 515 673)
     (extent 111 35)
    )
    (active detail)
   )
  )
  (component 8 "Note"
   (name "Thread #4")
   (interface
   )
   (implementation
    (component text 2 5
     This thread
     services SRQs.
    )
   )
   (views
    (icon
     (origin 805 358)
     (extent 110 25)
    )
    (detail
     (origin 786 297)
     (extent 148 46)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 9 "Note"
   (name "Thread #1")
   (interface
   )
   (implementation
    (component text 4 5
     This thread simply
     sets up the instruments
     and enables them to
     generate SRQs.
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 11 436)
     (extent 218 88)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 10 "Note"
   (name "Info About")
   (interface
   )
   (implementation
    (component text 62 5
     Overview:
     This model shows how to service interrupts using
     the "Wait For SRQ" object.  
     
     Details:
     This model uses the HP 54504A oscilloscope and the
     HP 3478A voltmeter to generate interrupts.  You
     MUST have these instruments connected to your
     computer to actually run this model. However,
     the techniques illustrated here apply to any
     instruments.
     
     Note that you must properly configure your 
     instruments before running this model using
     "I/O-->Configure I/O" menu selection.
     
     This is how to operate the model:
     
     1. Click on "Run" in the HP VEE title bar. This 
        way, all threads will operate simultaneously
        to illustrate how execution time is shared among
        threads.  You may wish to set
                 "Edit-->Show Exec Flow"
        to more clearly reveal this behavior.
     
     2. Press the SRQ front panel button on the
        HP 3478A or any key on the front panel of the 
        HP 54504A.
     
     This is how the model works:
     
     When you click on "Run", HP VEE starts executing
     each thread.  Thread #1 resets the instruments
     and configures them to generate service requests
     (SRQs).  The HP 3478A will generate an SRQ when
     you press its SRQ front panel button; the HP 54504A
     will generate an SRQ when you press any of its
     front panel buttons.  Threads #2 & #3 continuously
     count at one and two second intervals respectively.
     Thread #4 waits for an SRQ and reports the 
     identity of the requesting device when an SRQ is
     received. 
     
     Note that Threads #2 & #3 continue to count while
     the "Wait For SRQ" is pending.  Once "Wait For SRQ"
     detects an SRQ, the subthread attached to it
     executes to the exclusion of all others; counting
     on Threads #2 & #3 does not resume until the
     SRQ has been serviced.
     
     Note that different steps are required to re-enable
     interrupts for different instruments as shown in
     Thread #4.  The HP 3478A requires only a serial
     poll to clear the RQS bit of the status byte and
     thus re-enable interrupts.  This is typical of 
     older, simpler instruments.  The HP 54504A requires
     the additional step of clearing the event register
     that records front panel key press events.  This
     behavior is typical of more modern, complex 
     instruments.  READ YOUR INSTRUMENT PROGRAMMING
     MANUAL CAREFULLY.
     
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 6 101)
     (extent 488 259)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 11 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 572 109)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 12 "IfThenElse"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "bit(a,6)")
   )
   (views
    (icon
     (origin 721 498)
     (extent 78 25)
    )
    (detail
     (origin 551 455)
     (extent 149 70)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "Context"
   (name "HP 54504 did it")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "LiteralConstant"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "Text")
       (datum "SRQ from HP 54504A")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (datum "")
      )
     )
     (views
      (icon
       (origin 607 518)
       (extent 46 25)
      )
      (detail
       (origin 430 416)
       (extent 201 28)
      )
      (active icon)
     )
    )
    (component 1 "Confirm"
     (name "Press To Continue...")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 669 592)
       (extent 202 37)
      )
      (detail
       (origin 608 460)
       (extent 194 40)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "TextDisplay"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
      )
      (detail
       (origin 675 513)
       (extent 190 35)
      )
      (active detail)
     )
    )
    (configuration
     (connect D2:0 D1:0)
     (connect D0:1 D2:1)
    )
    (ShowOnExecPanel
     (origin 328 225)
     (extent 346 272)
     (panel
      (origin 589 473)
      (extent 342 234)
      (widget 2 detail
       (title off)
       (origin 609 516)
       (extent 305 42)
      )
      (widget 1 icon
       (title off)
       (origin 662 583)
       (extent 202 37)
      )
     )
    )
   )
   (views
    (icon
     (origin 828 628)
     (extent 145 25)
    )
    (detail
     (origin 589 453)
     (extent 322 214)
     (configuration
      (connect D2:0 D1:0
       (Point 770 550)
       (Point 770 559)
       (Point 770 559)
       (Point 770 589)
      )
      (connect D0:1 D2:1
       (Point 655 530)
       (Point 672 530)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 14 "Context"
   (name "Unknown did it")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Confirm"
     (name "Press To Continue...")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 579 592)
       (extent 202 37)
      )
      (detail
       (origin 608 460)
       (extent 194 40)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TextDisplay"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
      )
      (detail
       (origin 585 513)
       (extent 190 35)
      )
      (active detail)
     )
    )
    (component 2 "LiteralConstant"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "Text")
       (datum "SRQ from unknown device")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (datum "")
      )
     )
     (views
      (icon
       (origin 517 518)
       (extent 46 25)
      )
      (detail
       (origin 430 486)
       (extent 201 28)
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:0 D0:0)
     (connect D2:1 D1:1)
    )
    (ShowOnExecPanel
     (panel
      (origin 579 503)
      (extent 342 234)
      (widget 1 detail
       (title off)
       (origin 599 546)
       (extent 305 42)
      )
      (widget 0 icon
       (title off)
       (origin 652 613)
       (extent 202 37)
      )
     )
    )
   )
   (views
    (icon
     (origin 682 628)
     (extent 136 25)
    )
    (detail
     (origin 499 453)
     (extent 322 214)
     (configuration
      (connect D1:0 D0:0
       (Point 680 550)
       (Point 680 559)
       (Point 680 559)
       (Point 680 589)
      )
      (connect D2:1 D1:1
       (Point 565 530)
       (Point 582 530)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 15 "IODevice"
   (name "Clear ESR")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (comp iopath "scope")
    (procedure
      WRITE TEXT "*ESR?" EOL
    )
   )
   (views
    (icon
     (origin 845 538)
     (extent 110 64)
     (iconImage io.icon)
    )
    (detail
     (origin 316 458)
     (extent 308 105)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 16 "Context"
   (name "HP 3478 did it")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Confirm"
     (name "Press To Continue...")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 729 402)
       (extent 202 37)
      )
      (detail
       (origin 608 460)
       (extent 194 40)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TextDisplay"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
      )
      (detail
       (origin 735 323)
       (extent 190 35)
      )
      (active detail)
     )
    )
    (component 2 "LiteralConstant"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "Text")
       (datum "SRQ from HP 3478A")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (datum "")
      )
     )
     (views
      (icon
       (origin 667 328)
       (extent 46 25)
      )
      (detail
       (origin 280 306)
       (extent 201 28)
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:0 D0:0)
     (connect D2:1 D1:1)
    )
    (ShowOnExecPanel
     (origin 328 225)
     (extent 346 272)
     (panel
      (origin 279 243)
      (extent 342 234)
      (widget 1 detail
       (title off)
       (origin 299 286)
       (extent 305 42)
      )
      (widget 0 icon
       (title off)
       (origin 352 353)
       (extent 202 37)
      )
     )
    )
   )
   (views
    (icon
     (origin 832 458)
     (extent 136 25)
    )
    (detail
     (origin 589 263)
     (extent 322 214)
     (configuration
      (connect D1:0 D0:0
       (Point 830 360)
       (Point 830 369)
       (Point 830 369)
       (Point 830 399)
      )
      (connect D2:1 D1:1
       (Point 715 340)
       (Point 723 340)
       (Point 723 340)
       (Point 732 340)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 17 "IfThenElse"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "bit(a,6)")
   )
   (views
    (icon
     (origin 761 388)
     (extent 78 25)
    )
    (detail
     (origin 541 345)
     (extent 149 70)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 18 "SerialPoll"
   (name "SPOLL( scope )")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "status")
     (lock name constraints)
    )
   )
   (implementation
    (comp iopath "scope")
   )
   (views
    (icon
     (origin 572 478)
     (extent 136 64)
     (iconImage io.icon)
    )
    (detail
     (origin 503 490)
     (extent 234 40)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 19 "SerialPoll"
   (name "SPOLL( dvm )")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "status")
     (lock name constraints)
    )
   )
   (implementation
    (comp iopath "dvm")
   )
   (views
    (icon
     (origin 581 368)
     (extent 118 64)
     (iconImage io.icon)
    )
    (detail
     (origin 565 387)
     (extent 110 26)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 20 "WaitSRQ"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "SRQ")
     (lock name constraints)
    )
   )
   (implementation
    (component channel 7)
   )
   (views
    (icon
     (origin 571 268)
     (extent 118 64)
     (iconImage io.icon)
    )
    (detail
     (origin 470 280)
     (extent 311 40)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 21 "IODevice"
   (name "dvm (hp3478a @ HP-IB 0)")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (comp iopath "dvm")
    (procedure
      EXECUTE CLEAR
      WRITE TEXT "M20" EOL
    )
   )
   (views
    (icon
     (origin 255 458)
     (extent 251 65)
     (iconImage io.icon)
    )
    (detail
     (origin 226 438)
     (extent 308 105)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 22 "IODevice"
   (name "scope (hp54504a @ HP-IB 0)")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (comp iopath "scope")
    (procedure
      WRITE TEXT "*RST" EOL
      WRITE TEXT "*CLS;*ESE 64;*SRE 32" EOL
      EXECUTE LOCAL
    )
   )
   (views
    (icon
     (origin 258 378)
     (extent 244 64)
     (iconImage io.icon)
    )
    (detail
     (origin 226 358)
     (extent 308 105)
    )
    (terminals on)
    (active icon)
   )
  )
  (configuration
   (connect D1:1 D4:1)
   (connect D0:1 D5:1)
   (connect D5:1 D6:1)
   (connect D4:1 D7:1)
   (connect D18:1 D12:1)
   (connect D15:0 D13:0)
   (connect D12:2 D14:0)
   (connect D12:1 D15:0)
   (connect D17:1 D16:0)
   (connect D19:1 D17:1)
   (connect D17:2 D18:0)
   (connect D20:1 D19:0)
   (connect D2:1 D20:0)
   (connect D22:0 D21:0)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 980 653)
   (configuration
    (connect D1:1 D4:1
     (Point 392 690)
     (Point 408 690)
    )
    (connect D0:1 D5:1
     (Point 392 610)
     (Point 408 610)
    )
    (connect D5:1 D6:1
     (Point 491 610)
     (Point 512 610)
    )
    (connect D4:1 D7:1
     (Point 491 690)
     (Point 512 690)
    )
    (connect D18:1 D12:1
     (Point 710 510)
     (Point 714 510)
     (Point 714 510)
     (Point 718 510)
    )
    (connect D15:0 D13:0
     (Point 900 604)
     (Point 900 625)
    )
    (connect D12:2 D14:0
     (Point 801 520)
     (Point 810 520)
     (Point 810 540)
     (Point 750 540)
     (Point 750 625)
    )
    (connect D12:1 D15:0
     (Point 801 500)
     (Point 900 500)
     (Point 900 535)
    )
    (connect D17:1 D16:0
     (Point 841 390)
     (Point 900 390)
     (Point 900 455)
    )
    (connect D19:1 D17:1
     (Point 701 400)
     (Point 752 400)
     (Point 752 400)
     (Point 758 400)
    )
    (connect D17:2 D18:0
     (Point 841 410)
     (Point 850 410)
     (Point 850 440)
     (Point 640 440)
     (Point 640 475)
    )
    (connect D20:1 D19:0
     (Point 691 300)
     (Point 710 300)
     (Point 710 340)
     (Point 640 340)
     (Point 640 365)
    )
    (connect D2:1 D20:0
     (Point 617 230)
     (Point 630 230)
     (Point 630 265)
    )
    (connect D22:0 D21:0
     (Point 380 444)
     (Point 380 449)
     (Point 380 449)
     (Point 380 455)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
