#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Sun 05/Jan/1992")
(component 0 "Context"
 (name "String Function Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "LiteralConstant"
   (name "String")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "String")
     (datum "supercalifragalistic")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 10 266)
     (extent 201 28)
    )
    (active detail)
   )
  )
  (component 1 "Note"
   (name "To Operate:")
   (interface
   )
   (implementation
    (component text 3 5
     Enter some String data
     and other parameters,
     then press RUN.
    )
   )
   (views
    (icon
     (extent 110 0)
     (iconImage "notepad.icon")
    )
    (detail
     (origin 350 121)
     (extent 221 79)
     (editing enabled)
    )
    (active detail)
   )
  )
  (component 2 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 592 118)
     (extent 396 84)
     (editing enabled)
    )
    (active detail)
   )
  )
  (component 3 "LiteralConstant"
   (name "Reg. Expr.")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Reg. Expr.")
     (datum ".*\\(li.*li\\)")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 10 396)
     (extent 201 28)
    )
    (active detail)
   )
  )
  (component 4 "ShellEscape"
   (name "match(string,regexp)")
   (description 18 4
    Examines "string" for the first match with the
    Basic Regular Expression (see regexp(5)).  Since
    all patterns are anchored to the beginning of the
    string, ^ is not a r.e. metachar.   Because of 
    this anchoring, regular expression must include
    all characters beginning with the first; matching
    only chars in the middle of the string is not
    directly supported.
    
    Normally, match() returns the number of characters
    that are matched by the regular expression.  An
    alternative is to return the (sub)set of chars
    from the match by using the \( and \) metachars.
    If such a regular expression matches the string,
    the characters within the \(..\) will be returned
    instead of the match count.  If no match occurs,
    0 will still be returned.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "string")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (optional yes)
    )
    (input 2
     (type data)
     (name "regexp")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (optional yes)
    )
    (output 1
     (type data)
     (name "Exit code")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath pipe read "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath pipe write "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "expr \'",string,"\' : \'",regexp,"\'" EOL
      READ TEXT x TOKEN EXCLUDE:"\n" COUNT:1
    )
    (component shell "none")
    (component command "/bin/sh -s")
    (component deathWait "Yes")
   )
   (views
    (icon
     (origin 265 323)
     (extent 190 34)
    )
    (detail
     (origin 327 274)
     (extent 496 132)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 5 "TextDisplay"
   (name "Error Code")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 762 525)
     (extent 176 31)
    )
    (active detail)
   )
  )
  (component 6 "TextDisplay"
   (name "Match data")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 455 523)
     (extent 251 34)
    )
    (active detail)
   )
  )
  (component 7 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Note"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 19 9
         PURPOSE:     Provides a string extraction object using HP-UX "expr" command.
         
         USER INPUT REQUIRED:  Adjust the "string", if desired, then press RUN.
         
         EXPLANATION: Using the HP-UX escape object to run the "expr" command provides a way to
                   implement an unusual string function needed to parse text data using a
                   regular expression.  Because expr is rather good about always sending 
                   something to stdout, the extra tests to examine the expr exit code is
                   not usually needed before the READ TOKEN input transaction.  
         
                   Each object has a Show Description that explains the usage and limitations of
                   the implementation.  The man pages for "expr" may be of additional use to
                   determine the behavior of these objects for special cases.  
         
                   NOTE:  The READ TOKEN EXCLUDE: "\n" operation is used to allow a nil string
                   to be returned if expr outputs only a "\n" to stdout.  The STRING format would
                   have skipped over the newline and hung waiting for non-whitespace output!
         
         
        )
       )
       (views
        (icon
         (origin 160 185)
         (extent 78 25)
        )
        (detail
         (origin 36 162)
         (extent 848 437)
         (editing enabled)
        )
        (active icon)
       )
      )
      (component 1 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 171 252)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 0 29)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 1 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
        (widget 0 detail
         (title off)
         (origin 49 174)
         (extent 827 463)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 140)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 175 368)
     (extent 110 25)
    )
    (panel
     (origin 11 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 113 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D0:1 D4:1)
   (connect D3:1 D4:2)
   (connect D4:1 D5:1)
   (connect D4:2 D6:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 1004 664)
   (configuration
    (connect D0:1 D4:1
     (Point 213 280)
     (Point 230 280)
     (Point 230 310)
     (Point 254 310)
    )
    (connect D3:1 D4:2
     (Point 213 410)
     (Point 230 410)
     (Point 230 370)
     (Point 254 370)
    )
    (connect D4:1 D5:1
     (Point 925 310)
     (Point 950 310)
     (Point 950 440)
     (Point 740 440)
     (Point 740 540)
     (Point 759 540)
    )
    (connect D4:2 D6:1
     (Point 925 370)
     (Point 940 370)
     (Point 940 430)
     (Point 430 430)
     (Point 430 540)
     (Point 452 540)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
