#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Tue 17/Sep/1991")
(component 0 "Context"
 (name "HP VEE-Test: 3852A DAC Example")
 (interface
  (sequence in)
  (sequence out)
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Break"
   (interface
    (sequence in)
   )
   (implementation
   )
   (views
    (icon
     (origin 291 218)
     (extent 78 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 1 "Constant"
   (name "Block Size")
   (subType "Integer")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Int32")
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Block Size")
     (datum 10)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (origin 35 188)
     (extent 110 25)
    )
    (detail
     (origin 16 211)
     (extent 148 39)
     (showFormat int)
    )
    (active detail)
   )
  )
  (component 2 "RepeatUntilBreak"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 35 98)
     (extent 110 64)
     (iconImage "loop.icon")
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 582 119)
     (extent 397 82)
     (editing enabled)
    )
    (active detail)
   )
  )
  (component 4 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 345 330)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 181 323)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 61 182)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "Explanation")
       (interface
       )
       (implementation
        (component text 25 9
         This example shows the unpacking and display of data acquired from the 44702A/B voltmeter 
         within the 3852A after the data has been acquired and output to disc. The acquisition could 
         have been done by HP VEE-Test ( see example gpio1.ex this directory ), or by an existing 
         HP Basic program. The data acquired is a sinusoidal waveform sampled at 100kHz samples/second
         via the GPIO interface, therefore the data is in a raw or packed format, each reading contained
         in 16 bits.
          
         The Until Break, From File, and Break objects provide the continuous means to read the packed
         data from the file, 100kHzdata. The Constant object titled "Block Size" inputs the number of
         readings to be read from the file, unpacked, and displayed. The unpacking of the readings is 
         done by a separate process represented by a "C" program titled unpack.c.The HP-UX Escape object
         starts up the process, writes the packed readings to the process and reads the unpacked
         readings back from the process. The unpacked readings are then displayed on the XY Display 
         object titled "Readings from HP 3852A". Note that the transactions in the From File object and
         the HP-UX Escape object deal with the packed readings by using the binary Int16 VEE datatype.
         Since speed and efficiency are not of primary importance for this model (unlike the 
         acquisition model in the examples "gpio1.ex" and "gpio2.ex"), the overhead of having the 
         Int16 datatype converted to Int32 and then back for the short trip between the two objects is 
         negligeble.
         
         An obvious addition to this model would be a To File object to output the unpacked readings to
         a file.
         
         For more information concerning this model please look at Show Description on th HP-UX Escape, 
         From File, and To String  objects.
        )
       )
       (views
        (icon
         (origin 395 468)
         (extent 110 25)
        )
        (detail
         (origin 21 230)
         (extent 898 361)
         (editing enabled)
        )
        (active detail)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 79 87)
       (extent 926 523)
       (panel
        (origin 19 188)
        (extent 922 485)
        (widget 0 icon
         (title off)
         (origin 453 603)
         (extent 58 37)
        )
        (widget 1 detail
         (title on)
         (origin 50 238)
         (extent 883 351)
         (editing enabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 372 418)
       (extent 217 25)
      )
      (detail
       (origin 12 159)
       (extent 916 522)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D0:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 435 408)
     (extent 110 25)
    )
    (panel
     (origin 609 249)
     (extent 342 83)
     (widget 1 icon
      (title off)
      (origin 711 262)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 2 110)
     (extent 956 601)
     (configuration
      (connect D1:1 D0:1
       (Point 297 342)
       (Point 342 342)
      )
      (connect D0:0 D1:1
       (Point 368 357)
       (Point 368 380)
       (Point 160 380)
       (Point 160 342)
       (Point 178 342)
      )
      (connect D0:1 D2:0
       (Point 393 332)
       (Point 400 332)
       (Point 400 140)
       (Point 480 140)
       (Point 480 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 5 "YPlot"
   (name "Readings from HP 3852A ")
   (subType "Strip")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Trace1")
     (lock constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 1)
    (component graphMode strip)
   )
   (views
    (icon
     (extent 217 0)
     (iconImage "display.icon")
    )
    (detail
     (origin 73 401)
     (extent 855 319)
     (displayMode scrollGraph)
     (graphType cartesian)
     (gridType axis)
     (scale 0
      (name "DC Volts")
      (domainName "Readings")
      (pen 9)
      (show 1)
      (range -6 6 4 linear)
     )
     (domain 0 1000 4 linear)
     (trace 0 onScale 0
      (name "Trace1")
      (pen 4)
      (lineType 1)
      (pointType 0)
     )
     (stepSize 1)
     (trackingEnabled 1)
    )
    (active detail)
   )
  )
  (component 6 "FromFile"
   (description 14 4
    This object reads the data from the file 
    containing the readings acquired from the 3852A.
    Since each reading is represented in a packed 
    format of 16 bits the Int16 datatype is chosen 
    in the transaction. Since the Int16 datatype is
    supported only for I/O the packed readings are
    promoted to Int32 upon exiting the object's data
    output pin. The packed readings are demoted to
    Int16 within the HP-UX Escape for output to the
    'C' process which does the unpacking. The overhead
    of the promotion and demotion, while small, is not
    critical here as it was in the "gpio1.ex" example.
    
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "cnt")
     (optional yes)
    )
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "EOF")
     (tag "EOF")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath file read "/usr/lib/veetest/examples/3852A/100kHzdata"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      READ BINARY x INT16 COUNT:cnt
    )
   )
   (views
    (icon
     (origin 205 178)
     (extent 110 25)
    )
    (detail
     (origin 88 114)
     (extent 324 153)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "ToString"
   (description 12 4
    This object builds the command string used by the 
    HP-UX Escape object to invoke the program 
    "unpack.exe" used to unpack the readings from the 
    voltmeter in the 3852A. The program accepts as a 
    command line argument the number of readings to 
    unpack. The string "unpack.exe" is concatenated 
    with the number from the Constant object titled 
    "Block Size". Needless to say, the conversion of 
    the number from binary to ASCII, as with most of 
    the datatypes in HP VEE, is completely 
    transparent.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "cnt")
     (optional yes)
    )
    (output 1
     (type data)
     (name "result")
     (lock name constraints)
    )
   )
   (implementation
    (attr iopath string write "string"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "/usr/lib/veetest/examples/3852A/unpack.exe ",cnt EOL
    )
   )
   (views
    (icon
     (origin 215 258)
     (extent 110 25)
    )
    (detail
     (origin 42 215)
     (extent 607 110)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "ShellEscape"
   (description 27 4
    The UP-UX Escape object manages the executable 
    "unpack.exe", the source for which is in the file 
    "unpack.c".This program unpacks a number of packed 
    16 bit 44702A/B readings and returns them as 64 
    bit reals. The number of readings to be unpacked
    is input to the program as a command line 
    argument. The HP-UX Escape writes the packed data
    to the process via the process's stdin pipe and
    reads the unpacked data from it's stdout pipe.
    Since the program is written to run continuously,
    reading and writing data from and to the HP-UX
    Escape, the Wait for child exit choice on the 
    object is set to "No". For more information on the
    HP-UX Escape please see the HP VEE reference guide
    and the examples "hpux1.ex" through "hpux3.ex".
    
    An important point is that the default size of 
    HP-UX pipes is 8192 bytes. If any more data than 
    this is written to the pipe it will fill up and 
    block causing HP VEE to hang. The block size value
    therefore cannot exceed 4096. It is possible to
    increase the allowed size of pipes by 
    reconfiguring the HP-UX kernel.
    
    
    
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "rawIn")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Command")
     (tag "Command")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (input 3
     (type data)
     (name "cnt")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Exit code")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "dataOut")
     (lock constraints)
     (optional yes)
    )
    (buffers in
     (buffer "Command")
    )
   )
   (implementation
    (attr iopath pipe read "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath pipe write "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE BINARY rawIn INT16
      READ BINARY dataOut REAL COUNT:cnt
    )
    (component shell "none")
    (component command "/usr/lib/veetest/examples/3852A/unpack.exe 10")
    (component deathWait "No")
   )
   (views
    (icon
     (origin 421 198)
     (extent 118 64)
     (iconImage "c.icon")
    )
    (detail
     (origin 278 141)
     (extent 585 159)
    )
    (terminals on)
    (active icon)
   )
  )
  (configuration
   (connect D6:2 D0:0)
   (connect D8:2 D5:1)
   (connect D2:1 D6:0)
   (connect D1:1 D6:1)
   (connect D1:1 D7:1)
   (connect D6:1 D8:1)
   (connect D7:1 D8:2)
   (connect D1:1 D8:3)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 1248 902)
   (configuration
    (connect D6:2 D0:0
     (Point 317 200)
     (Point 330 200)
     (Point 330 215)
    )
    (connect D8:2 D5:1
     (Point 541 250)
     (Point 560 250)
     (Point 560 310)
     (Point 50 310)
     (Point 50 560)
     (Point 70 560)
    )
    (connect D2:1 D6:0
     (Point 147 130)
     (Point 260 130)
     (Point 260 175)
    )
    (connect D1:1 D6:1
     (Point 166 230)
     (Point 190 230)
     (Point 190 190)
     (Point 202 190)
    )
    (connect D1:1 D7:1
     (Point 166 230)
     (Point 190 230)
     (Point 190 270)
     (Point 212 270)
    )
    (connect D6:1 D8:1
     (Point 317 180)
     (Point 390 180)
     (Point 390 210)
     (Point 418 210)
    )
    (connect D7:1 D8:2
     (Point 327 270)
     (Point 390 270)
     (Point 390 230)
     (Point 418 230)
    )
    (connect D1:1 D8:3
     (Point 166 230)
     (Point 190 230)
     (Point 190 270)
     (Point 200 270)
     (Point 200 300)
     (Point 400 300)
     (Point 400 250)
     (Point 418 250)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
