#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Tue 17/Sep/1991")
(component 0 "Context"
 (name "String Functions Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "LiteralConstant"
   (name "String")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "String")
     (datum "supercalifragalistic")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 10 266)
     (extent 201 28)
    )
    (active detail)
   )
  )
  (component 1 "Constant"
   (name "Start Pos.")
   (subType "Integer")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Int32")
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Start Pos.")
     (datum 2)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 11 345)
     (extent 199 30)
     (showFormat int)
    )
    (active detail)
   )
  )
  (component 2 "Constant"
   (name "Num Char")
   (subType "Integer")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Int32")
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Num Char")
     (datum 6)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 11 424)
     (extent 198 33)
     (showFormat int)
    )
    (active detail)
   )
  )
  (component 3 "TextDisplay"
   (name "Error Code")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 796 365)
     (extent 168 30)
    )
    (active detail)
   )
  )
  (component 4 "LiteralConstant"
   (name "Char(s)")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Char(s)")
     (datum "e")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 10 516)
     (extent 201 28)
    )
    (active detail)
   )
  )
  (component 5 "TextDisplay"
   (name "Index of char")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 127 0)
    )
    (detail
     (origin 541 492)
     (extent 219 37)
    )
    (active detail)
   )
  )
  (component 6 "TextDisplay"
   (name "Error Code")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 799 495)
     (extent 183 31)
    )
    (active detail)
   )
  )
  (component 7 "LiteralConstant"
   (name "Reg. Expr.")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Reg. Expr.")
     (datum ".*\\(li.*li\\)")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 10 616)
     (extent 201 28)
    )
    (active detail)
   )
  )
  (component 8 "TextDisplay"
   (name "Match data")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 525 613)
     (extent 251 34)
    )
    (active detail)
   )
  )
  (component 9 "TextDisplay"
   (name "Error Code")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 812 605)
     (extent 176 31)
    )
    (active detail)
   )
  )
  (component 10 "TextDisplay"
   (name "Extracted String")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 154 0)
    )
    (detail
     (origin 539 371)
     (extent 222 38)
    )
    (active detail)
   )
  )
  (component 11 "TextDisplay"
   (name "Number of Chars")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 145 0)
    )
    (detail
     (origin 541 252)
     (extent 219 37)
    )
    (active detail)
   )
  )
  (component 12 "ShellEscape"
   (name "length(string)")
   (description 8 4
    Length(string) determines the number of chars
    in the passed string.  If the string is null,
    the returned length is 0.
    
    Note that this function is not the same as the
    Access Array --> Get Values "Total Size", since
    the entire string is considered an array element,
    thus Total Size is always 1.)
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "string")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (optional yes)
    )
    (output 1
     (type data)
     (name "Exit code")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "length")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath pipe read "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath pipe write "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "expr length \'",string,"\'" EOL
      READ TEXT length TOKEN EXCLUDE:"\n" COUNT:1
    )
    (component shell "none")
    (component command "/bin/sh -s")
    (component deathWait "Yes")
   )
   (views
    (icon
     (origin 292 263)
     (extent 136 34)
    )
    (detail
     (origin 127 216)
     (extent 437 129)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "ShellEscape"
   (name "substr(string,start,num)")
   (description 14 4
    Extracts the substring beginning at the "start"
    character of the given "string", returning at
    most "num" characters.  The first character of
    a string is position 1.
    
    If a start value less than 1 is given, 1 is
    assumed.  If the number of characters to extract
    is greater than the string length, only chars up
    to the end of string are returned.  If num is 0,
    no characters are returned, and an Error of 1 s
    returned.  If a null string is supplied, an Error
    of 1 is returned, along with a null extracted
    string.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "string")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (optional yes)
    )
    (input 2
     (type data)
     (name "start")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (optional yes)
    )
    (input 3
     (type data)
     (name "num")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (optional yes)
    )
    (output 1
     (type data)
     (name "Exit code")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath pipe read "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath pipe write "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "expr substr \'",string,"\' ",start," ",num EOL
      READ TEXT x TOKEN EXCLUDE:"\n" COUNT:1
    )
    (component shell "none")
    (component command "/bin/sh -s")
    (component deathWait "Yes")
   )
   (views
    (icon
     (origin 267 343)
     (extent 226 34)
    )
    (detail
     (origin 80 293)
     (extent 570 135)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 14 "ShellEscape"
   (name "index(string,char-set)")
   (description 5 4
    Returns the first character position in "string"
    in which any one of the characters in the char-
    set is found.  If none of the characters is found
    in the string or if the string is null, an error
    code of 1 is returned.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "string")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (optional yes)
    )
    (input 2
     (type data)
     (name "chars")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (optional yes)
    )
    (output 1
     (type data)
     (name "Exit code")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath pipe read "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath pipe write "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "expr index \'",string,"\' \'",chars,"\'" EOL
      READ TEXT x TOKEN EXCLUDE:"\n" COUNT:1
    )
    (component shell "none")
    (component command "/bin/sh -s")
    (component deathWait "Yes")
   )
   (views
    (icon
     (origin 266 483)
     (extent 208 34)
    )
    (detail
     (origin 155 450)
     (extent 561 140)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 15 "ShellEscape"
   (name "match(string,regexp)")
   (description 18 4
    Examines "string" for the first match with the
    Basic Regular Expression (see regexp(5)).  Since
    all patterns are anchored to the beginning of the
    string, ^ is not a r.e. metachar.   Because of 
    this anchoring, regular expression must include
    all characters beginning with the first; matching
    only chars in the middle of the string is not
    directly supported.
    
    Normally, match() returns the number of characters
    that are matched by the regular expression.  An
    alternative is to return the (sub)set of chars
    from the match by using the \( and \) metachars.
    If such a regular expression matches the string,
    the characters within the \(..\) will be returned
    instead of the match count.  If no match occurs,
    0 will still be returned.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "string")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (optional yes)
    )
    (input 2
     (type data)
     (name "regexp")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (optional yes)
    )
    (output 1
     (type data)
     (name "Exit code")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath pipe read "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath pipe write "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "expr \'",string,"\' : \'",regexp,"\'" EOL
      READ TEXT x TOKEN EXCLUDE:"\n" COUNT:1
    )
    (component shell "none")
    (component command "/bin/sh -s")
    (component deathWait "Yes")
   )
   (views
    (icon
     (origin 275 583)
     (extent 190 34)
    )
    (detail
     (origin 207 514)
     (extent 496 132)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 16 "Note"
   (name "To Operate:")
   (interface
   )
   (implementation
    (component text 3 5
     Enter some String data
     and other parameters,
     then press RUN.
    )
   )
   (views
    (icon
     (extent 110 0)
     (iconImage "notepad.icon")
    )
    (detail
     (origin 350 121)
     (extent 221 79)
     (editing enabled)
    )
    (active detail)
   )
  )
  (component 17 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Note"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 27 9
         PURPOSE:     Provide string manipulation objects using HP-UX "expr" command.
         
         USER INPUT REQUIRED:  Adjust the "string" and other parameters, then press RUN.
         
         EXPLANATION: Using the HP-UX escape object to run the "expr" command provides a way to
                   implement some of the string functions needed to parse text data.  Because
                   expr is rather good about always sending thing to stdout, the extra tests to
                   examine the expr exit code is not needed before the READ TOKEN input 
                   transaction.  Four string function User Objects are illustrated here:
         
                        SUBSTR (string, start, num)
         
                        INDEX (string, char-set)
         
                        LENGTH (string)
         
                        MATCH (string, regexp)
         
                   Each object has a Show Description that explains the usage and limitations of
                   the implementation.  The man pages for "expr" may be of additional use to
                   determine the behavior of these objects for special cases.  
         
                   NOTE:  The READ TOKEN EXCLUDE: "\n" operation is used to allow a nil string
                   to be returned if expr outputs only a "\n" to stdout.  The STRING format would
                   have skipped over the newline and hung waiting for non-whitespace output!
         
         
        )
       )
       (views
        (icon
         (origin 160 185)
         (extent 78 25)
        )
        (detail
         (origin 36 162)
         (extent 848 437)
         (editing enabled)
        )
        (active icon)
       )
      )
      (component 1 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 171 252)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 0 29)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 1 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
        (widget 0 detail
         (title off)
         (origin 49 174)
         (extent 827 463)
         (editing enabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 140)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 175 368)
     (extent 110 25)
    )
    (panel
     (origin 11 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 113 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 18 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 592 118)
     (extent 396 84)
     (editing enabled)
    )
    (active detail)
   )
  )
  (configuration
   (connect D13:1 D3:1)
   (connect D14:2 D5:1)
   (connect D14:1 D6:1)
   (connect D15:2 D8:1)
   (connect D15:1 D9:1)
   (connect D13:2 D10:1)
   (connect D12:2 D11:1)
   (connect D0:1 D12:1)
   (connect D0:1 D13:1)
   (connect D1:1 D13:2)
   (connect D2:1 D13:3)
   (connect D0:1 D14:1)
   (connect D4:1 D14:2)
   (connect D0:1 D15:1)
   (connect D7:1 D15:2)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 1004 664)
   (configuration
    (connect D13:1 D3:1
     (Point 495 350)
     (Point 510 350)
     (Point 510 320)
     (Point 770 320)
     (Point 770 380)
     (Point 793 380)
    )
    (connect D14:2 D5:1
     (Point 476 510)
     (Point 538 510)
    )
    (connect D14:1 D6:1
     (Point 476 490)
     (Point 490 490)
     (Point 490 440)
     (Point 780 440)
     (Point 780 510)
     (Point 796 510)
    )
    (connect D15:2 D8:1
     (Point 467 610)
     (Point 480 610)
     (Point 480 630)
     (Point 522 630)
    )
    (connect D15:1 D9:1
     (Point 467 590)
     (Point 480 590)
     (Point 480 560)
     (Point 790 560)
     (Point 790 620)
     (Point 809 620)
    )
    (connect D13:2 D10:1
     (Point 495 370)
     (Point 510 370)
     (Point 510 390)
     (Point 536 390)
    )
    (connect D12:2 D11:1
     (Point 430 290)
     (Point 450 290)
     (Point 450 270)
     (Point 538 270)
    )
    (connect D0:1 D12:1
     (Point 213 280)
     (Point 289 280)
    )
    (connect D0:1 D13:1
     (Point 213 280)
     (Point 230 280)
     (Point 230 350)
     (Point 264 350)
    )
    (connect D1:1 D13:2
     (Point 212 360)
     (Point 264 360)
    )
    (connect D2:1 D13:3
     (Point 211 440)
     (Point 230 440)
     (Point 230 370)
     (Point 264 370)
    )
    (connect D0:1 D14:1
     (Point 213 280)
     (Point 230 280)
     (Point 230 350)
     (Point 240 350)
     (Point 240 490)
     (Point 263 490)
    )
    (connect D4:1 D14:2
     (Point 213 530)
     (Point 230 530)
     (Point 230 510)
     (Point 263 510)
    )
    (connect D0:1 D15:1
     (Point 213 280)
     (Point 230 280)
     (Point 230 350)
     (Point 240 350)
     (Point 240 590)
     (Point 272 590)
    )
    (connect D7:1 D15:2
     (Point 213 630)
     (Point 230 630)
     (Point 230 610)
     (Point 272 610)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
