/*
 * A simple c program, invoked from a VEE HP-UX escape object, to read "n"
 * real numbers (binary 8 bytes) from stdin, sort them, and write the
 * sorted array back to stdout.  The HP-UX escape transactions must be:
 *    "WRITE BINARY size INT32"
 *    "WRITE BINARY array REAL COUNT:size"
 *    "READ BINARY sorted COUNT:size"
 * where "size" is an INT32 input variable with the array size.
 *
 * NOTE: Because stdin/stdout are pipes, unbuffered or raw file reads will
 * return prematurely with partial data from the pipe buffers.  Using fread/
 * fwrite with buffering is needed to mask this.
 */

#include <stdio.h>		/* fread/fwrite/perror live here */
#include <stdlib.h>		/* qsort defs live here */
#include <malloc.h>


int compare (x,y)		/* the qsort algorithm needs a comparison */
    double *x,*y;
{
    if ( *x < *y)
        return -1;
    else if (*x > *y)
        return 1;
    return 0;
}


main()
{
    int num;			/* number of 8-byte reals to read */
    char *array;		/* where to read the data into */

    /* Read an int32 from stdin with the number of 8-byte reals to follow */

    if ( fread( (char *) &num, sizeof(num), (size_t) 1, stdin ) <= 0 ) {
        perror( "Error reading number of reals in input array." );
        return 1;
    }

    if ( ( array = malloc( sizeof(double) * num )) == NULL ) {
        perror( "Error during malloc for input data." );
        return 1;
    }

    /* Read the specified 8-byte reals from stdin */

    if ( fread( array, sizeof(double), (size_t) num, stdin ) <= 0 ) {
        perror( "Error reading Array to be sorted." );
        return 1 ;
    }

    /* Sort the array of reals using the qsort library routine */

    qsort( (void *)array, (size_t) num, sizeof(double), compare); 


    /* Write the sorted array back to the caller on stdout */

    if ( fwrite( array, sizeof(double), (size_t) num, stdout) <= 0 ) {
        perror( "Error writing Array after sorting." );
        return 1;
    }

    return 0; 
}
