#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Tue 17/Sep/1991")
(component 0 "Context"
 (name "Stacked Bar Chart Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Context"
   (name "Stacked Bars")
   (description 34 4
    Generates and displays a Stacked-Bar chart from
    the two 1-D arrays of input data.  The number
    of bars is equal to the number of array elements
    (arrays must be same size), and the "length" of
    each bar is set by the corresponding element data,
    which may be a positive or negative real or int32
    number.  Trace 2 bars are drawn using the "top"
    of each Trace 1 bar, causing overwriting if one
    of the bars is negative length.
    
    The display is autoscaled after plotting the bars
    using the maximum and minumum array data values
    and the number of bars.
    
    Display and trace labels, bar color, grid type,
    etc. can be set by clicking the Right Button on
    the display area and selecting the "Traces and
    Scales" entry from the resulting menu.  The gap
    between bars can be set using the "Spacing" box
    in the Bar Chart Detail view.
    
    If the bars appear to have black vertical lines,
    the number of fill strokes can be increased, at
    the expense of drawing speed, by reducing the
    "Density" value found in the Detail view of the
    FillBarMux object.
    
    It may prove useful to Secure the BarChart User
    Object after customizing, since this eliminates
    the Panel/Detail buttons and some menu selections
    that are no longer needed.  Be sure to save the
    unsecured object so you can make changes at a
    later date, however. 
     
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Ary")
     (optional yes)
    )
    (input 2
     (type data)
     (name "LowData")
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Context"
     (name "BarFill")
     (description 13 6
      Generates the serpentine fill pattern used to
      produce a bar.  The array of coord output 
      represents the line segment end points needed to
      fill the bar. 
      
      An empirical algorithm is used to determine how
      close the lines should be, based on the width of
      the bar.  For extremely high resolution displays
      or output devices, this may not be close enough,
      and the algorithm may need adjustment to give 
      good looking bars.  (Modify the NumPts object).
      
      
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X-Start")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (optional yes)
      )
      (input 2
       (type data)
       (name "X-End")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (optional yes)
      )
      (input 3
       (type data)
       (name "Y-Max")
       (optional yes)
      )
      (input 4
       (type data)
       (name "Y-Min")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Trace1")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Formula"
       (name "Generate Y values")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "B")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "concat(transpose([b a a b]),b[0])")
       )
       (views
        (icon
         (origin 469 328)
         (extent 163 25)
        )
        (detail
         (origin 275 563)
         (extent 340 154)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "ToCoordinate"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X Data")
         (tag "X")
         (requires
          (datatype Real)
         )
         (lock constraints)
        )
        (input 2
         (type data)
         (name "Y Data")
         (tag "Y")
         (requires
          (datatype Real)
         )
         (lock constraints)
        )
        (output 1
         (type data)
         (name "Coord")
         (tag "Coord")
         (lock constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 525 258)
         (extent 110 25)
        )
        (detail
         (origin 510 175)
         (extent 50 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "Constant"
       (name "Density")
       (subType "Real")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Real")
         (lock name constraints)
        )
       )
       (implementation
        (component value Real
         (name "Density")
         (datum 0.03)
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Real
         (datum 0)
        )
       )
       (views
        (icon
         (extent 78 0)
        )
        (detail
         (origin 191 243)
         (extent 138 34)
         (showFormat real)
        )
        (active detail)
       )
      )
      (component 3 "Formula"
       (name "Duplicate each X element")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "B")
         (optional yes)
        )
        (input 3
         (type data)
         (name "n")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "concat(transpose([ramp(2*n,a,b) ramp(2*n,a,b)]),b)")
       )
       (views
        (icon
         (origin 397 173)
         (extent 226 34)
        )
        (detail
         (origin 93 353)
         (extent 484 154)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 4 "AllocateArray"
       (name "Alloc Real")
       (subType "Alloc_Real")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Init Value")
         (tag "Init Value")
         (requires
          (datatype Real)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (input 2
         (type data)
         (name "Dim Size 1")
         (tag "Dim Size 1")
         (requires
          (datatype Int32)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
        (buffers in
         (buffer "Init Value")
         (buffer "Dim Size 1")
        )
       )
       (implementation
        (component numDims 1)
        (component dimSizes "26")
        (component type "Real")
        (component initEnum "Init Value")
        (component initialValue
         (name "Init Value")
         (datum 6)
        )
        (component from 1)
        (component thru 10)
       )
       (views
        (icon
         (origin 335 298)
         (extent 110 25)
        )
        (detail
         (origin 46 305)
         (extent 229 111)
        )
        (active icon)
       )
      )
      (component 5 "AllocateArray"
       (name "Alloc Real")
       (subType "Alloc_Real")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Init Value")
         (tag "Init Value")
         (requires
          (datatype Real)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (input 2
         (type data)
         (name "Dim Size 1")
         (tag "Dim Size 1")
         (requires
          (datatype Int32)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
        (buffers in
         (buffer "Init Value")
         (buffer "Dim Size 1")
        )
       )
       (implementation
        (component numDims 1)
        (component dimSizes "26")
        (component type "Real")
        (component initEnum "Init Value")
        (component initialValue
         (name "Init Value")
         (datum 0)
        )
        (component from 1)
        (component thru 10)
       )
       (views
        (icon
         (origin 335 338)
         (extent 110 25)
        )
        (detail
         (origin 286 525)
         (extent 229 111)
        )
        (active icon)
       )
      )
      (component 6 "Formula"
       (name " + ")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (lock name constraints)
        )
        (input 2
         (type data)
         (name "Y")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked yes)
        (component expr 1 "X+Y")
       )
       (views
        (icon
         (origin 187 288)
         (extent 46 25)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (component 7 "Formula"
       (name "NumPts")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "B")
         (optional yes)
        )
        (input 3
         (type data)
         (name "Density")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "intPart((b-a)/Density)")
       )
       (views
        (icon
         (origin 391 233)
         (extent 78 34)
        )
        (detail
         (origin 356 200)
         (extent 219 120)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
       (connect D4:1 D0:1)
       (connect D5:1 D0:2)
       (connect D3:1 D1:1)
       (connect D0:1 D1:2)
       (connect I1:1 D3:1)
       (connect I2:1 D3:2)
       (connect D7:1 D3:3)
       (connect D6:1 D4:1)
       (connect D7:1 D4:2)
       (connect I4:1 D5:1)
       (connect D7:1 D5:2)
       (connect I3:1 D6:1)
       (connect I4:1 D6:2)
       (connect I1:1 D7:1)
       (connect I2:1 D7:2)
       (connect D2:1 D7:3)
       (connect D1:1 O1:1)
      )
     )
     (views
      (icon
       (origin 531 230)
       (extent 78 61)
      )
      (panel
       (origin 330 179)
       (extent 171 183)
       (widget 2 detail
        (title on)
        (origin 350 227)
        (extent 120 32)
        (showFormat real)
       )
      )
      (detail
       (origin 120 145)
       (extent 571 230)
       (configuration
        (connect D4:1 D0:1
         (Point 447 310)
         (Point 460 310)
         (Point 460 330)
         (Point 466 330)
        )
        (connect D5:1 D0:2
         (Point 447 350)
         (Point 466 350)
        )
        (connect D3:1 D1:1
         (Point 625 190)
         (Point 640 190)
         (Point 640 230)
         (Point 510 230)
         (Point 510 260)
         (Point 522 260)
        )
        (connect D0:1 D1:2
         (Point 634 340)
         (Point 650 340)
         (Point 650 310)
         (Point 510 310)
         (Point 510 280)
         (Point 522 280)
        )
        (connect I1:1 D3:1
         (Point 122 180)
         (Point 394 180)
        )
        (connect I2:1 D3:2
         (Point 122 240)
         (Point 130 240)
         (Point 130 190)
         (Point 394 190)
        )
        (connect D7:1 D3:3
         (Point 471 250)
         (Point 480 250)
         (Point 480 220)
         (Point 380 220)
         (Point 380 200)
         (Point 394 200)
        )
        (connect D6:1 D4:1
         (Point 235 300)
         (Point 332 300)
        )
        (connect D7:1 D4:2
         (Point 471 250)
         (Point 490 250)
         (Point 490 290)
         (Point 340 290)
         (Point 340 310)
         (Point 320 310)
         (Point 320 320)
         (Point 332 320)
        )
        (connect I4:1 D5:1
         (Point 122 360)
         (Point 130 360)
         (Point 130 340)
         (Point 332 340)
        )
        (connect D7:1 D5:2
         (Point 471 250)
         (Point 490 250)
         (Point 490 290)
         (Point 340 290)
         (Point 340 310)
         (Point 320 310)
         (Point 320 360)
         (Point 332 360)
        )
        (connect I3:1 D6:1
         (Point 122 300)
         (Point 130 300)
         (Point 130 290)
         (Point 184 290)
        )
        (connect I4:1 D6:2
         (Point 122 360)
         (Point 130 360)
         (Point 130 310)
         (Point 184 310)
        )
        (connect I1:1 D7:1
         (Point 122 180)
         (Point 360 180)
         (Point 360 240)
         (Point 388 240)
        )
        (connect I2:1 D7:2
         (Point 122 240)
         (Point 130 240)
         (Point 130 190)
         (Point 350 190)
         (Point 350 250)
         (Point 388 250)
        )
        (connect D2:1 D7:3
         (Point 331 260)
         (Point 388 260)
        )
        (connect D1:1 O1:1
         (Point 637 270)
         (Point 688 270)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "YPlot"
     (name "XY Trace")
     (subType "XY_Trace")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Trace1")
       (lock constraints)
      )
      (input 2
       (type data)
       (name "Trace2")
       (lock constraints)
       (optional yes)
      )
      (input 3
       (type control)
       (name "Auto Scale")
       (lock name constraints)
       (optional yes)
      )
      (input 4
       (type control)
       (name "Next Curve")
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
      (component tracePin 1)
      (component tracePin 2)
      (component graphMode rectangular)
     )
     (views
      (icon
       (iconImage "display.icon")
      )
      (detail
       (origin 642 171)
       (extent 317 278)
       (displayMode scrollGraph)
       (graphType cartesian)
       (gridType frame)
       (scale 0
        (name "Y name")
        (domainName "X name")
        (pen 9)
        (show 1)
        (range 0 30 4 linear)
       )
       (domain 0 10 4 linear)
       (trace 0 onScale 0
        (name "Trace1")
        (pen 7)
        (lineType 1)
        (pointType 0)
       )
       (trace 1 onScale 0
        (name "Trace2")
        (pen 4)
        (lineType 1)
        (pointType 0)
       )
      )
      (active detail)
     )
    )
    (component 2 "Context"
     (name "BarFill")
     (description 13 6
      Generates the serpentine fill pattern used to
      produce a bar.  The array of coord output 
      represents the line segment end points needed to
      fill the bar. 
      
      An empirical algorithm is used to determine how
      close the lines should be, based on the width of
      the bar.  For extremely high resolution displays
      or output devices, this may not be close enough,
      and the algorithm may need adjustment to give 
      good looking bars.  (Modify the NumPts object).
      
      
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X-Start")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (optional yes)
      )
      (input 2
       (type data)
       (name "X-End")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (optional yes)
      )
      (input 3
       (type data)
       (name "Y-Max")
       (optional yes)
      )
      (input 4
       (type data)
       (name "Y-Min")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Trace1")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Formula"
       (name "Generate Y values")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "B")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "concat(transpose([b a a b]),b[0])")
       )
       (views
        (icon
         (origin 469 328)
         (extent 163 25)
        )
        (detail
         (origin 275 563)
         (extent 340 154)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "ToCoordinate"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X Data")
         (tag "X")
         (requires
          (datatype Real)
         )
         (lock constraints)
        )
        (input 2
         (type data)
         (name "Y Data")
         (tag "Y")
         (requires
          (datatype Real)
         )
         (lock constraints)
        )
        (output 1
         (type data)
         (name "Coord")
         (tag "Coord")
         (lock constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 525 258)
         (extent 110 25)
        )
        (detail
         (origin 510 175)
         (extent 50 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "Constant"
       (name "Density")
       (subType "Real")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Real")
         (lock name constraints)
        )
       )
       (implementation
        (component value Real
         (name "Density")
         (datum 0.03)
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Real
         (datum 0)
        )
       )
       (views
        (icon
         (extent 78 0)
        )
        (detail
         (origin 191 243)
         (extent 138 34)
         (showFormat real)
        )
        (active detail)
       )
      )
      (component 3 "Formula"
       (name "Duplicate each X element")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "B")
         (optional yes)
        )
        (input 3
         (type data)
         (name "n")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "concat(transpose([ramp(2*n,a,b) ramp(2*n,a,b)]),b)")
       )
       (views
        (icon
         (origin 397 173)
         (extent 226 34)
        )
        (detail
         (origin 93 353)
         (extent 484 154)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 4 "AllocateArray"
       (name "Alloc Real")
       (subType "Alloc_Real")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Init Value")
         (tag "Init Value")
         (requires
          (datatype Real)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (input 2
         (type data)
         (name "Dim Size 1")
         (tag "Dim Size 1")
         (requires
          (datatype Int32)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
        (buffers in
         (buffer "Init Value")
         (buffer "Dim Size 1")
        )
       )
       (implementation
        (component numDims 1)
        (component dimSizes "26")
        (component type "Real")
        (component initEnum "Init Value")
        (component initialValue
         (name "Init Value")
         (datum 19)
        )
        (component from 1)
        (component thru 10)
       )
       (views
        (icon
         (origin 335 298)
         (extent 110 25)
        )
        (detail
         (origin 46 305)
         (extent 229 111)
        )
        (active icon)
       )
      )
      (component 5 "AllocateArray"
       (name "Alloc Real")
       (subType "Alloc_Real")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Init Value")
         (tag "Init Value")
         (requires
          (datatype Real)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (input 2
         (type data)
         (name "Dim Size 1")
         (tag "Dim Size 1")
         (requires
          (datatype Int32)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
        (buffers in
         (buffer "Init Value")
         (buffer "Dim Size 1")
        )
       )
       (implementation
        (component numDims 1)
        (component dimSizes "26")
        (component type "Real")
        (component initEnum "Init Value")
        (component initialValue
         (name "Init Value")
         (datum 6)
        )
        (component from 1)
        (component thru 10)
       )
       (views
        (icon
         (origin 335 338)
         (extent 110 25)
        )
        (detail
         (origin 286 525)
         (extent 229 111)
        )
        (active icon)
       )
      )
      (component 6 "Formula"
       (name " + ")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (lock name constraints)
        )
        (input 2
         (type data)
         (name "Y")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked yes)
        (component expr 1 "X+Y")
       )
       (views
        (icon
         (origin 187 288)
         (extent 46 25)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (component 7 "Formula"
       (name "NumPts")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "B")
         (optional yes)
        )
        (input 3
         (type data)
         (name "Density")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "intPart((b-a)/Density)")
       )
       (views
        (icon
         (origin 391 233)
         (extent 78 34)
        )
        (detail
         (origin 356 200)
         (extent 219 120)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
       (connect D4:1 D0:1)
       (connect D5:1 D0:2)
       (connect D3:1 D1:1)
       (connect D0:1 D1:2)
       (connect I1:1 D3:1)
       (connect I2:1 D3:2)
       (connect D7:1 D3:3)
       (connect D6:1 D4:1)
       (connect D7:1 D4:2)
       (connect I4:1 D5:1)
       (connect D7:1 D5:2)
       (connect I3:1 D6:1)
       (connect I4:1 D6:2)
       (connect I1:1 D7:1)
       (connect I2:1 D7:2)
       (connect D2:1 D7:3)
       (connect D1:1 O1:1)
      )
     )
     (views
      (icon
       (origin 531 150)
       (extent 78 61)
      )
      (panel
       (origin 330 179)
       (extent 171 183)
       (widget 2 detail
        (title on)
        (origin 350 227)
        (extent 120 32)
        (showFormat real)
       )
      )
      (detail
       (origin 120 145)
       (extent 571 230)
       (configuration
        (connect D4:1 D0:1
         (Point 447 310)
         (Point 460 310)
         (Point 460 330)
         (Point 466 330)
        )
        (connect D5:1 D0:2
         (Point 447 350)
         (Point 466 350)
        )
        (connect D3:1 D1:1
         (Point 625 190)
         (Point 640 190)
         (Point 640 230)
         (Point 510 230)
         (Point 510 260)
         (Point 522 260)
        )
        (connect D0:1 D1:2
         (Point 634 340)
         (Point 650 340)
         (Point 650 310)
         (Point 510 310)
         (Point 510 280)
         (Point 522 280)
        )
        (connect I1:1 D3:1
         (Point 122 180)
         (Point 394 180)
        )
        (connect I2:1 D3:2
         (Point 122 240)
         (Point 130 240)
         (Point 130 190)
         (Point 394 190)
        )
        (connect D7:1 D3:3
         (Point 471 250)
         (Point 480 250)
         (Point 480 220)
         (Point 380 220)
         (Point 380 200)
         (Point 394 200)
        )
        (connect D6:1 D4:1
         (Point 235 300)
         (Point 332 300)
        )
        (connect D7:1 D4:2
         (Point 471 250)
         (Point 490 250)
         (Point 490 290)
         (Point 340 290)
         (Point 340 310)
         (Point 320 310)
         (Point 320 320)
         (Point 332 320)
        )
        (connect I4:1 D5:1
         (Point 122 360)
         (Point 130 360)
         (Point 130 340)
         (Point 332 340)
        )
        (connect D7:1 D5:2
         (Point 471 250)
         (Point 490 250)
         (Point 490 290)
         (Point 340 290)
         (Point 340 310)
         (Point 320 310)
         (Point 320 360)
         (Point 332 360)
        )
        (connect I3:1 D6:1
         (Point 122 300)
         (Point 130 300)
         (Point 130 290)
         (Point 184 290)
        )
        (connect I4:1 D6:2
         (Point 122 360)
         (Point 130 360)
         (Point 130 310)
         (Point 184 310)
        )
        (connect I1:1 D7:1
         (Point 122 180)
         (Point 360 180)
         (Point 360 240)
         (Point 388 240)
        )
        (connect I2:1 D7:2
         (Point 122 240)
         (Point 130 240)
         (Point 130 190)
         (Point 350 190)
         (Point 350 250)
         (Point 388 250)
        )
        (connect D2:1 D7:3
         (Point 331 260)
         (Point 388 260)
        )
        (connect D1:1 O1:1
         (Point 637 270)
         (Point 688 270)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Constant"
     (name "Spacing")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Spacing")
       (datum 0.2)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 78 0)
      )
      (detail
       (origin 397 346)
       (extent 147 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 4 "ForCount"
     (name "For Count")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Count")
       (tag "Count")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Count")
       (lock name constraints)
      )
      (buffers in
       (buffer "Count")
      )
     )
     (implementation
      (component count 10)
     )
     (views
      (icon
       (origin 475 408)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
       (origin 615 253)
       (extent 170 34)
      )
      (active icon)
     )
    )
    (component 5 "FromArray"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (tag "Ary")
      )
      (output 1
       (type data)
       (name "SubAry")
       (tag "Result")
       (lock constraints)
      )
      (output 2
       (type data)
       (name "Type")
       (tag "Type")
       (lock constraints)
      )
      (output 3
       (type data)
       (name "NumDims")
       (tag "NumDims")
       (lock constraints)
      )
      (output 4
       (type data)
       (name "DimSizes")
       (tag "DimSizes")
       (lock constraints)
      )
      (output 5
       (type data)
       (name "TotSize")
       (tag "TotSize")
       (lock constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary")
     )
     (views
      (icon
       (origin 345 388)
       (extent 110 64)
       (iconImage "unbuild.icon")
      )
      (detail
       (origin 252 110)
       (extent 147 160)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 6 "Context"
     (name "StackBarSize")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "HiData")
       (optional yes)
      )
      (input 2
       (type data)
       (name "LowData")
       (optional yes)
      )
      (input 3
       (type data)
       (name "BarNo")
       (optional yes)
      )
      (input 4
       (type data)
       (name "Gap")
       (optional yes)
      )
      (output 1
       (type data)
       (name "X-Start")
       (lock constraints)
       (optional yes)
      )
      (output 2
       (type data)
       (name "X-Stop")
       (lock constraints)
       (optional yes)
      )
      (output 3
       (type data)
       (name "Y-Max")
       (lock constraints)
       (optional yes)
      )
      (output 4
       (type data)
       (name "Y-Min")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Formula"
       (name "y[i]")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "y")
         (optional yes)
        )
        (input 2
         (type data)
         (name "i")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "y[i]")
       )
       (views
        (icon
         (origin 167 283)
         (extent 46 34)
        )
        (detail
         (origin 200 461)
         (extent 90 78)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Formula"
       (name "y[i]")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "y")
         (optional yes)
        )
        (input 2
         (type data)
         (name "i")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "y[i]")
       )
       (views
        (icon
         (origin 167 373)
         (extent 46 34)
        )
        (detail
         (origin 200 461)
         (extent 90 78)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "Formula"
       (name "From")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (optional yes)
        )
        (input 2
         (type data)
         (name "Inc")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "X+Inc/2")
       )
       (views
        (icon
         (origin 377 253)
         (extent 46 34)
        )
        (detail
         (origin 287 280)
         (extent 97 101)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 3 "Formula"
       (name "To")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (optional yes)
        )
        (input 2
         (type data)
         (name "Inc")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "X+1-Inc/2")
       )
       (views
        (icon
         (origin 377 313)
         (extent 46 34)
        )
        (detail
         (origin 278 351)
         (extent 115 78)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
       (connect I1:1 D0:1)
       (connect I3:1 D0:2)
       (connect I2:1 D1:1)
       (connect I3:1 D1:2)
       (connect I3:1 D2:1)
       (connect I4:1 D2:2)
       (connect I3:1 D3:1)
       (connect I4:1 D3:2)
       (connect D2:1 O1:1)
       (connect D3:1 O2:1)
       (connect D0:1 O3:1)
       (connect D1:1 O4:1)
      )
     )
     (views
      (icon
       (origin 391 158)
       (extent 118 45)
      )
      (detail
       (origin 86 230)
       (extent 369 261)
       (configuration
        (connect I1:1 D0:1
         (Point 88 260)
         (Point 100 260)
         (Point 100 290)
         (Point 164 290)
        )
        (connect I3:1 D0:2
         (Point 88 400)
         (Point 120 400)
         (Point 120 310)
         (Point 164 310)
        )
        (connect I2:1 D1:1
         (Point 88 330)
         (Point 100 330)
         (Point 100 380)
         (Point 164 380)
        )
        (connect I3:1 D1:2
         (Point 88 400)
         (Point 164 400)
        )
        (connect I3:1 D2:1
         (Point 88 400)
         (Point 120 400)
         (Point 120 340)
         (Point 230 340)
         (Point 230 320)
         (Point 340 320)
         (Point 340 260)
         (Point 374 260)
        )
        (connect I4:1 D2:2
         (Point 88 470)
         (Point 100 470)
         (Point 100 460)
         (Point 250 460)
         (Point 250 340)
         (Point 350 340)
         (Point 350 280)
         (Point 374 280)
        )
        (connect I3:1 D3:1
         (Point 88 400)
         (Point 120 400)
         (Point 120 340)
         (Point 230 340)
         (Point 230 320)
         (Point 374 320)
        )
        (connect I4:1 D3:2
         (Point 88 470)
         (Point 100 470)
         (Point 100 460)
         (Point 250 460)
         (Point 250 340)
         (Point 374 340)
        )
        (connect D2:1 O1:1
         (Point 425 270)
         (Point 440 270)
         (Point 440 260)
         (Point 452 260)
        )
        (connect D3:1 O2:1
         (Point 425 330)
         (Point 452 330)
        )
        (connect D0:1 O3:1
         (Point 215 300)
         (Point 240 300)
         (Point 240 400)
         (Point 452 400)
        )
        (connect D1:1 O4:1
         (Point 215 390)
         (Point 230 390)
         (Point 230 470)
         (Point 452 470)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "Context"
     (name "BarSize")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Array")
       (optional yes)
      )
      (input 2
       (type data)
       (name "BarNo")
       (optional yes)
      )
      (input 3
       (type data)
       (name "Gap")
       (optional yes)
      )
      (output 1
       (type data)
       (name "X-Start")
       (lock constraints)
       (optional yes)
      )
      (output 2
       (type data)
       (name "X-Stop")
       (lock constraints)
       (optional yes)
      )
      (output 3
       (type data)
       (name "Y-Max")
       (lock constraints)
       (optional yes)
      )
      (output 4
       (type data)
       (name "Y-Min")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Formula"
       (name "y[i]")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "y")
         (optional yes)
        )
        (input 2
         (type data)
         (name "i")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "y[i]")
       )
       (views
        (icon
         (origin 297 393)
         (extent 46 34)
        )
        (detail
         (origin 200 461)
         (extent 90 78)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Constant"
       (name "0")
       (subType "Real")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Real")
         (lock name constraints)
        )
       )
       (implementation
        (component value Real
         (name "0")
         (datum 0)
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Real
         (datum 0)
        )
       )
       (views
        (icon
         (origin 297 448)
         (extent 46 25)
        )
        (detail
         (origin 279 446)
         (extent 122 28)
         (showFormat real)
        )
        (active icon)
       )
      )
      (component 2 "Formula"
       (name "From")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (optional yes)
        )
        (input 2
         (type data)
         (name "Inc")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "X+Inc/2")
       )
       (views
        (icon
         (origin 307 273)
         (extent 46 34)
        )
        (detail
         (origin 137 150)
         (extent 97 101)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 3 "Formula"
       (name "To")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (optional yes)
        )
        (input 2
         (type data)
         (name "Inc")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "X+1-Inc/2")
       )
       (views
        (icon
         (origin 307 333)
         (extent 46 34)
        )
        (detail
         (origin 128 221)
         (extent 115 78)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
       (connect I1:1 D0:1)
       (connect I2:1 D0:2)
       (connect I2:1 D2:1)
       (connect I3:1 D2:2)
       (connect I2:1 D3:1)
       (connect I3:1 D3:2)
       (connect D2:1 O1:1)
       (connect D3:1 O2:1)
       (connect D0:1 O3:1)
       (connect D1:1 O4:1)
      )
     )
     (views
      (icon
       (origin 421 238)
       (extent 78 45)
      )
      (detail
       (origin 223 257)
       (extent 194 226)
       (configuration
        (connect I1:1 D0:1
         (Point 225 300)
         (Point 260 300)
         (Point 260 400)
         (Point 294 400)
        )
        (connect I2:1 D0:2
         (Point 225 380)
         (Point 240 380)
         (Point 240 420)
         (Point 294 420)
        )
        (connect I2:1 D2:1
         (Point 225 380)
         (Point 250 380)
         (Point 250 340)
         (Point 270 340)
         (Point 270 280)
         (Point 304 280)
        )
        (connect I3:1 D2:2
         (Point 225 460)
         (Point 270 460)
         (Point 270 360)
         (Point 280 360)
         (Point 280 300)
         (Point 304 300)
        )
        (connect I2:1 D3:1
         (Point 225 380)
         (Point 250 380)
         (Point 250 340)
         (Point 304 340)
        )
        (connect I3:1 D3:2
         (Point 225 460)
         (Point 270 460)
         (Point 270 360)
         (Point 304 360)
        )
        (connect D2:1 O1:1
         (Point 355 290)
         (Point 414 290)
        )
        (connect D3:1 O2:1
         (Point 355 350)
         (Point 414 350)
        )
        (connect D0:1 O3:1
         (Point 345 410)
         (Point 414 410)
        )
        (connect D1:1 O4:1
         (Point 345 460)
         (Point 360 460)
         (Point 360 470)
         (Point 414 470)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D7:1 D0:1)
     (connect D7:2 D0:2)
     (connect D7:3 D0:3)
     (connect D7:4 D0:4)
     (connect D2:1 D1:1)
     (connect D0:1 D1:2)
     (connect D4:0 D1:3)
     (connect D1:0 D1:4)
     (connect D6:1 D2:1)
     (connect D6:2 D2:2)
     (connect D6:3 D2:3)
     (connect D6:4 D2:4)
     (connect D5:5 D4:1)
     (connect I2:1 D5:1)
     (connect I1:1 D6:1)
     (connect I2:1 D6:2)
     (connect D4:1 D6:3)
     (connect D3:1 D6:4)
     (connect I2:1 D7:1)
     (connect D4:1 D7:2)
     (connect D3:1 D7:3)
    )
   )
   (views
    (icon
     (origin 491 608)
     (extent 118 25)
    )
    (panel
     (origin 419 275)
     (extent 423 291)
     (widget 1 detail
      (title off)
      (origin 423 281)
      (extent 415 281)
      (displayMode annotGraph)
      (graphType cartesian)
      (gridType frame)
      (scale 0
       (name "Y name")
       (domainName "X name")
       (pen 1)
       (show 1)
       (range 0 30 4 linear)
      )
      (domain 0 10 4 linear)
      (trace 0 onScale 0
       (name "Trace1")
       (pen 7)
       (lineType 1)
       (pointType 0)
      )
      (trace 1 onScale 0
       (name "Trace2")
       (pen 4)
       (lineType 1)
       (pointType 0)
      )
     )
    )
    (detail
     (origin 276 143)
     (extent 689 355)
     (configuration
      (connect D7:1 D0:1
       (Point 501 240)
       (Point 528 240)
      )
      (connect D7:2 D0:2
       (Point 501 250)
       (Point 528 250)
      )
      (connect D7:3 D0:3
       (Point 501 260)
       (Point 528 260)
      )
      (connect D7:4 D0:4
       (Point 501 270)
       (Point 528 270)
      )
      (connect D2:1 D1:1
       (Point 611 180)
       (Point 620 180)
       (Point 620 200)
       (Point 639 200)
      )
      (connect D0:1 D1:2
       (Point 611 260)
       (Point 620 260)
       (Point 620 270)
       (Point 639 270)
      )
      (connect D4:0 D1:3
       (Point 530 474)
       (Point 530 490)
       (Point 600 490)
       (Point 600 340)
       (Point 639 340)
      )
      (connect D1:0 D1:4
       (Point 800 451)
       (Point 800 470)
       (Point 620 470)
       (Point 620 410)
       (Point 639 410)
      )
      (connect D6:1 D2:1
       (Point 511 160)
       (Point 528 160)
      )
      (connect D6:2 D2:2
       (Point 511 170)
       (Point 528 170)
      )
      (connect D6:3 D2:3
       (Point 511 180)
       (Point 528 180)
      )
      (connect D6:4 D2:4
       (Point 511 190)
       (Point 528 190)
      )
      (connect D5:5 D4:1
       (Point 457 440)
       (Point 472 440)
      )
      (connect I2:1 D5:1
       (Point 278 430)
       (Point 290 430)
       (Point 290 420)
       (Point 342 420)
      )
      (connect I1:1 D6:1
       (Point 278 230)
       (Point 290 230)
       (Point 290 160)
       (Point 388 160)
      )
      (connect I2:1 D6:2
       (Point 278 430)
       (Point 290 430)
       (Point 290 420)
       (Point 330 420)
       (Point 330 250)
       (Point 360 250)
       (Point 360 170)
       (Point 388 170)
      )
      (connect D4:1 D6:3
       (Point 587 440)
       (Point 610 440)
       (Point 610 500)
       (Point 520 500)
       (Point 520 490)
       (Point 330 490)
       (Point 330 430)
       (Point 350 430)
       (Point 350 410)
       (Point 340 410)
       (Point 340 260)
       (Point 350 260)
       (Point 350 180)
       (Point 388 180)
      )
      (connect D3:1 D6:4
       (Point 546 360)
       (Point 570 360)
       (Point 570 300)
       (Point 410 300)
       (Point 410 270)
       (Point 370 270)
       (Point 370 190)
       (Point 388 190)
      )
      (connect I2:1 D7:1
       (Point 278 430)
       (Point 290 430)
       (Point 290 420)
       (Point 330 420)
       (Point 330 250)
       (Point 418 250)
      )
      (connect D4:1 D7:2
       (Point 587 440)
       (Point 610 440)
       (Point 610 500)
       (Point 520 500)
       (Point 520 490)
       (Point 330 490)
       (Point 330 430)
       (Point 350 430)
       (Point 350 410)
       (Point 340 410)
       (Point 340 260)
       (Point 418 260)
      )
      (connect D3:1 D7:3
       (Point 546 360)
       (Point 570 360)
       (Point 570 300)
       (Point 410 300)
       (Point 410 270)
       (Point 418 270)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 1 "TextDisplay"
   (name "Upper")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 866 150)
     (extent 129 240)
    )
    (active detail)
   )
  )
  (component 2 "TextDisplay"
   (name "Lower")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 866 480)
     (extent 129 240)
    )
    (active detail)
   )
  )
  (component 3 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 392 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 4 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 482)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 22 9
         PURPOSE:     Illustrates use of the Stacked Bar Chart library object to display two arrays
                      of data simultaneously.
         
         USER INPUT REQUIRED: Press Run to display the Bar Chart.
         
         EXPLANATION: To generate some interesting data to display, two array of 100 random numbers
                      between 0 and 1.0 are analyzed to get the magnitude Distribution in 10 "bins"
                      between 0 and 1.  The resulting arrays each have 10 elements representing the
                      number of numbers in each of the 10 bins.  The arrays are given to the 
                      StakBarChart library object to generate the display.
         
         IMPLEMENTATION: The StakBarChart library object provides additional usage information from
                      the Show Description choice in the object menu.  Setting colors, etc. is
                      described here, along with a description of the input requirements.  When
                      using the BarChart object in your models, you may want to place and size it,
                      then secure the User Object to prevent inadvertent changes.
         
                      Since the BarChart is a User Object, you may want to examine it to see how
                      the barchart is generated.  Some advanced techniques are used to generate
                      the serpentine fill pattern using parallel array operations to obtain the
                      needed speed.  
         
        )
       )
       (views
        (icon
         (origin 410 415)
         (extent 78 25)
        )
        (detail
         (origin 25 209)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 0 43)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 46 175)
         (extent 832 463)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 415 408)
     (extent 110 25)
    )
    (panel
     (origin 21 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 123 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 5 "Context"
   (name "Generate Data")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Result")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Context"
     (name "100 random #s")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Array")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Collector"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (tag "Data")
        )
        (input 2
         (type trigger)
         (name "XEQ")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
       )
       (implementation
        (component clearAtPrerun 1)
        (component clearAtActivate 1)
       )
       (views
        (icon
         (origin 280 248)
         (extent 110 25)
        )
        (detail
         (origin 265 455)
         (extent 60 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "RandomNumber"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Rand Val")
         (lock name constraints)
        )
       )
       (implementation
        (component lowerLimit 0)
        (component upperLimit 1)
       )
       (views
        (icon
         (origin 107 258)
         (extent 127 25)
        )
        (detail
         (origin 109 410)
         (extent 222 60)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "ForCount"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Count")
         (lock name constraints)
        )
       )
       (implementation
        (component count 100)
       )
       (views
        (icon
         (origin 90 168)
         (extent 110 64)
         (iconImage "loop.icon")
        )
        (detail
         (origin 60 183)
         (extent 170 34)
        )
        (active detail)
       )
      )
      (configuration
       (connect D1:1 D0:1)
       (connect D2:0 D0:2)
       (connect D2:1 D1:0)
       (connect D0:1 O1:1)
      )
     )
     (views
      (icon
       (origin 27 278)
       (extent 127 25)
      )
      (detail
       (origin 31 130)
       (extent 388 200)
       (configuration
        (connect D1:1 D0:1
         (Point 236 270)
         (Point 250 270)
         (Point 250 250)
         (Point 277 250)
        )
        (connect D2:0 D0:2
         (Point 145 219)
         (Point 145 240)
         (Point 85 240)
         (Point 85 300)
         (Point 255 300)
         (Point 255 270)
         (Point 277 270)
        )
        (connect D2:1 D1:0
         (Point 232 200)
         (Point 250 200)
         (Point 250 240)
         (Point 170 240)
         (Point 170 255)
        )
        (connect D0:1 O1:1
         (Point 392 260)
         (Point 416 240)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Context"
     (name "100 random #s")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Array")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Collector"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (tag "Data")
        )
        (input 2
         (type trigger)
         (name "XEQ")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
       )
       (implementation
        (component clearAtPrerun 1)
        (component clearAtActivate 1)
       )
       (views
        (icon
         (origin 280 248)
         (extent 110 25)
        )
        (detail
         (origin 265 455)
         (extent 60 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "RandomNumber"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Rand Val")
         (lock name constraints)
        )
       )
       (implementation
        (component lowerLimit 0)
        (component upperLimit 1)
       )
       (views
        (icon
         (origin 107 258)
         (extent 127 25)
        )
        (detail
         (origin 109 410)
         (extent 222 60)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "ForCount"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Count")
         (lock name constraints)
        )
       )
       (implementation
        (component count 100)
       )
       (views
        (icon
         (origin 90 168)
         (extent 110 64)
         (iconImage "loop.icon")
        )
        (detail
         (origin 60 183)
         (extent 170 34)
        )
        (active detail)
       )
      )
      (configuration
       (connect D1:1 D0:1)
       (connect D2:0 D0:2)
       (connect D2:1 D1:0)
       (connect D0:1 O1:1)
      )
     )
     (views
      (icon
       (origin 7 388)
       (extent 127 25)
      )
      (detail
       (origin 31 130)
       (extent 388 200)
       (configuration
        (connect D1:1 D0:1
         (Point 236 270)
         (Point 250 270)
         (Point 250 250)
         (Point 277 250)
        )
        (connect D2:0 D0:2
         (Point 145 219)
         (Point 145 240)
         (Point 85 240)
         (Point 85 300)
         (Point 255 300)
         (Point 255 270)
         (Point 277 270)
        )
        (connect D2:1 D1:0
         (Point 232 200)
         (Point 250 200)
         (Point 250 240)
         (Point 170 240)
         (Point 170 255)
        )
        (connect D0:1 O1:1
         (Point 392 260)
         (Point 416 240)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Formula"
     (name "magDist()")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "From")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "Thru")
       (lock name constraints)
      )
      (input 4
       (type data)
       (name "Step")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "magDist(x,from,thru,step)")
     )
     (views
      (icon
       (origin 205 348)
       (extent 110 45)
      )
      (detail
       (origin 421 305)
       (extent 259 210)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Formula"
     (name "magDist()")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "From")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "Thru")
       (lock name constraints)
      )
      (input 4
       (type data)
       (name "Step")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "magDist(x,from,thru,step)")
     )
     (views
      (icon
       (origin 205 448)
       (extent 110 45)
      )
      (detail
       (origin 421 305)
       (extent 259 210)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "Constant"
     (name "Low Lim")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Low Lim")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 78 0)
      )
      (detail
       (origin 5 347)
       (extent 130 27)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 5 "Constant"
     (name "High Lim")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "High Lim")
       (datum 1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 2 456)
       (extent 137 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 6 "Constant"
     (name "step")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "step")
       (datum 0.1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 487 708)
       (extent 46 25)
      )
      (detail
       (origin 9 526)
       (extent 122 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (configuration
     (connect D0:1 D2:1)
     (connect D4:1 D2:2)
     (connect D5:1 D2:3)
     (connect D6:1 D2:4)
     (connect D1:1 D3:1)
     (connect D4:1 D3:2)
     (connect D5:1 D3:3)
     (connect D6:1 D3:4)
     (connect D2:1 O1:1)
     (connect D3:1 O2:1)
    )
   )
   (views
    (icon
     (origin 127 348)
     (extent 127 25)
    )
    (detail
     (origin 14 263)
     (extent 332 294)
     (configuration
      (connect D0:1 D2:1
       (Point 156 290)
       (Point 170 290)
       (Point 170 350)
       (Point 202 350)
      )
      (connect D4:1 D2:2
       (Point 137 360)
       (Point 202 360)
      )
      (connect D5:1 D2:3
       (Point 141 470)
       (Point 170 470)
       (Point 170 370)
       (Point 202 370)
      )
      (connect D6:1 D2:4
       (Point 133 540)
       (Point 160 540)
       (Point 160 490)
       (Point 210 490)
       (Point 210 430)
       (Point 190 430)
       (Point 190 380)
       (Point 202 380)
      )
      (connect D1:1 D3:1
       (Point 136 400)
       (Point 160 400)
       (Point 160 450)
       (Point 202 450)
      )
      (connect D4:1 D3:2
       (Point 137 360)
       (Point 180 360)
       (Point 180 460)
       (Point 202 460)
      )
      (connect D5:1 D3:3
       (Point 141 470)
       (Point 202 470)
      )
      (connect D6:1 D3:4
       (Point 133 540)
       (Point 160 540)
       (Point 160 480)
       (Point 202 480)
      )
      (connect D2:1 O1:1
       (Point 317 370)
       (Point 329 370)
       (Point 329 340)
       (Point 343 340)
      )
      (connect D3:1 O2:1
       (Point 317 470)
       (Point 329 470)
       (Point 329 500)
       (Point 343 500)
      )
     )
    )
    (active detail)
   )
  )
  (configuration
   (connect D5:1 D0:1)
   (connect D5:2 D0:2)
   (connect D5:1 D1:1)
   (connect D5:2 D2:1)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 850 558)
   (widget 0 panel
    (title on)
    (origin 353 267)
    (extent 465 318)
    (widget 1 detail
     (title off)
     (origin 357 273)
     (extent 457 309)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType frame)
     (scale 0
      (name "Y name")
      (domainName "X name")
      (pen 1)
      (show 1)
      (range 0 30 4 linear)
     )
     (domain 0 10 4 linear)
     (trace 0 onScale 0
      (name "Trace1")
      (pen 7)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "Trace2")
      (pen 4)
      (lineType 1)
      (pointType 0)
     )
    )
   )
   (widget 3 detail
    (title on)
    (origin 416 118)
    (extent 397 82)
    (editing disabled)
   )
   (widget 4 panel
    (title on)
    (origin 29 118)
    (extent 319 77)
    (widget 1 icon
     (title off)
     (origin 131 131)
     (extent 114 39)
     (format button)
    )
   )
   (widget 1 detail
    (title on)
    (origin 30 268)
    (extent 137 315)
   )
   (widget 2 detail
    (title on)
    (origin 186 268)
    (extent 142 315)
   )
  )
  (detail
   (origin 0 67)
   (extent 935 615)
   (configuration
    (connect D5:1 D0:1
     (Point 368 340)
     (Point 390 340)
     (Point 390 350)
     (Point 416 350)
    )
    (connect D5:2 D0:2
     (Point 368 500)
     (Point 390 500)
     (Point 390 490)
     (Point 416 490)
    )
    (connect D5:1 D1:1
     (Point 368 340)
     (Point 400 340)
     (Point 400 220)
     (Point 850 220)
     (Point 850 270)
     (Point 863 270)
    )
    (connect D5:2 D2:1
     (Point 368 500)
     (Point 400 500)
     (Point 400 600)
     (Point 863 600)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
