#! /usr/lib/veetest/veetest -r
(revision "A.00.00")
(date "Tue 02/Apr/1991")
(component 0 "Context"
 (name "HP-UX Escape 3 Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Formula"
   (name "YesNo")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "(a ? \"Yes\" : \"No\")")
   )
   (views
    (description 11 5
     We use the formula box and the ?: syntax from C
     to construct a quick if test to output one of
     two text strings.  The (e1 ? e2 : e3) syntax
     evaluates the first expression, and if it is true
     (non-zero), evaluates e2; if false, evaluate e3
     instead.  Thus, we can write the formula:
     
        (a ? "No" : "Yes")
     
     to return "Yes" when the input is 0 and "No" when
     the input is 1.
    )
    (icon
     (origin 231 568)
     (extent 78 25)
    )
    (detail
     (origin 397 480)
     (extent 196 60)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 1 "ShellEscape"
   (name "Get Environment Variable")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "var")
     (tag "var")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Exit code")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "value")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath pipe read "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath pipe write "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "echo $",var EOL
      READ TEXT value TOKEN EXCLUDE:"\n" COUNT:1
      WRITE TEXT "[ \"$",var,"\" ] || exit 1" EOL
    )
    (component shell "none")
    (component command "/bin/ksh -s")
    (component deathWait "Yes")
   )
   (views
    (description 49 5
     Use this device to retrieve the contents of an
     exported shell variable.  Input is a text string
     with the name of the variable to examine, such as
     "HOME".  Output value is a text string with the
     contents of the variable; an empty (nil) string is
     returned if the variable is defined but has no
     value.  The Exit Code is 0 if the named variable
     is defined, and 1 if not defined.
     
     HOW IT WORKS:
     
     The HP-UX escape device is used to run a copy of
     /bin/ksh, using the -s option to indicate shell
     commands should be read from stdin rather than a
     script file.  The WRITE TEXT transactions in the
     escape are sent to the stdin of ksh, where they
     are interpreted as if read from a file.  The READ
     TEXT transaction obtains data from the stdout of
     the ksh.  The stderr of the ksh is not captured
     and any error messages will be written to stderr.
     
     The WRITE TEXT "echo $",var EOL transaction asks
     the shell to echo the contents of the environment
     variable constructed by prepending a $ to the text
     name supplied by the user on the var input.  The
     shell responds with the contents of the string,
     if any, followed by a newline.  (The newline from
     the echo is important, since it marks the end of
     the echoed string.)
     
     The READ TEXT into the value output pin uses the
     TOKEN read mode to construct the output token from
     all characters EXCLUDING the "\n" newline.  A text
     string read mode, since it expects at least one
     non-white-space character, would never be complete
     if the variable had a nil value.  The TOKEN read
     uses all characters up to the \n, allowing a nil
     output to properly be read.  Note:  the next char
     to be read would be the \n, so a READ TEXT null
     CHAR would be needed to position the read pointer
     at the start of the next input line.
     
     The final WRITE TEXT transaction is used to run a
     ksh test "[ "$var" ]" to see if the variable was
     defined.  If not, the ksh exits with 1 as the Exit
     code.  Note the use of the \" (quoted ") to imbed
     the quotes around the $var in the test.
     
     
    )
    (icon
     (origin 127 228)
     (extent 226 25)
    )
    (detail
     (origin 198 216)
     (extent 465 209)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "ShellEscape"
   (name "Do we have mail?")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "fname")
     (tag "fname")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Exit code")
     (lock name constraints)
    )
   )
   (implementation
    (attr iopath pipe read "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath pipe write "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "if [ -s ",fname," ] ; then" EOL
      WRITE TEXT "   line <",fname," | \\" EOL
      WRITE TEXT "   fgrep Forward >/dev/null "
      WRITE TEXT "   || exit 1" EOL
      WRITE TEXT "fi" EOL
      WRITE TEXT "exit 0" EOL
    )
    (component shell "none")
    (component command "/bin/ksh -s")
    (component deathWait "Yes")
   )
   (views
    (description 12 5
     We need to verify the file passed to us actually
     exists, and if so, does it have any data in it.
     If length is nonzero, see if the first line begins
     with "Forward".
     
     Exit like a shell program where 0 means success,
     non-zero means failure.
     
     Note the double \\ used to generate a command line
     continuation char "\".   Also note that the fgrep
     line has disabled the EOL rather than use \\.
     
    )
    (icon
     (origin 483 218)
     (extent 154 25)
    )
    (detail
     (origin 271 318)
     (extent 479 184)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 3 "ExitProcess"
   (interface
    (sequence in)
   )
   (implementation
    (comp code 0)
   )
   (views
    (icon
     (origin 577 238)
     (extent 46 25)
    )
    (detail
     (origin 490 333)
     (extent 120 34)
    )
    (active icon)
   )
  )
  (component 4 "IfThenElse"
   (name "If NULL")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "a!=0")
   )
   (views
    (description 6 5
     We need to verify that the user has an exported
     MAIL variable that points to the mail spool file.
     If the getenv (a user object in the lib dir)
     returns 0 as an exit code, then $MAIL exists.  If
     it returns 1, then the $MAIL variable could not
     be found by Vee, and the program stops.
    )
    (icon
     (origin 421 218)
     (extent 78 25)
    )
    (detail
     (origin 423 165)
     (extent 64 70)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "TextDisplay"
   (name "You Have Mail")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 127 0)
    )
    (detail
     (origin 470 563)
     (extent 201 35)
    )
    (active detail)
   )
  )
  (component 6 "Note"
   (name "To Operate:")
   (interface
   )
   (implementation
    (component text 2 5
     Press RUN to see
      if you have mail.
    )
   )
   (views
    (icon
     (origin 125 228)
     (extent 110 64)
     (iconImage notepad.icon)
    )
    (detail
     (origin 351 128)
     (extent 178 65)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 7 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 552 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 8 "Note"
   (name "HINT:")
   (interface
   )
   (implementation
    (component text 6 5
     Most objects
     have a Show
     Description
     entry obtained
     from their
     Object menus.
    )
   )
   (views
    (icon
     (extent 78 0)
     (iconImage notepad.icon)
    )
    (detail
     (origin 17 337)
     (extent 147 126)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 9 "LiteralConstant"
   (name "\"MAIL\"")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "\"MAIL\"")
     (datum "MAIL")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (description 5 5
     This Data Constant Text is used to supply the
     desired environment variable to getenv.  Because
     getenv uses a shell to access the variable, it
     prepends a $ to the variable.  You should not
     add a $ to the text variable.
    )
    (icon
     (origin 21 228)
     (extent 78 25)
    )
    (detail
     (origin 11 224)
     (extent 138 33)
    )
    (active icon)
   )
  )
  (component 10 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Note"
       (name "NotePad")
       (interface
       )
       (implementation
        (component text 25 9
         PURPOSE:    A more complete example using HP-UX escape device with a dynamically 
                     constructed shell script using the WRITE transactions.
         
         USER INPUT REQUIRED:  Press RUN to see if you have any mail waiting in your mailbox.
                     Most devices have further information in their Show Description selections.
         
         EXPLANATION:  As illustrated in the "Get Environment" example, the HPUX escape device
                     can construct a shell script using the WRITE transactions, including the
                     ability to intersperse externally supplied text strings into the script.
         
                     In this example, the Get Environment device supplies the MAIL directory
                     as set by your login shell and exported to each child shell or process.
                     If the variable is not set, an Escape device is used to generate an error
                     message to the user, and the example terminates.
         
                     If the MAIL variable exists, a second HP-UX escape is used to examine the
                     size of the file and, if non-zero, examine the file's first line.  If the
                     MAIL file begins with "Forward", then there will be no mail in the file.
         
                     Note how the "fname" input terminal is used to construct the various commands
                     to the shell.  Also note the use of a double \\ to generate a single \ as
                     the "continue command on the "line" transaction.   An alternative to the \\
                     is shown on the third transaction (the fgrep) by setting EOL OFF when the
                     transaction is build.  Both have similar effects.
         
        )
       )
       (views
        (description 2 9
         This notepad is displayed as a Show on Execute
         panel to present the information to the reader.
        )
        (icon
         (origin 160 205)
         (extent 78 25)
        )
        (detail
         (origin 36 162)
         (extent 848 437)
         (editing enabled)
        )
        (active icon)
       )
      )
      (component 1 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (description 7 9
         This tiny "thread" begins running when the 
         enclosing UserObject is executed.  When the user
         acknowledges the OK/DONE button, there is nothing
         left to execute, so the thread ends.  Since there
         are not other threads running, the User Object
         is completed and will exit, removing the Show on
         Execute pop-up display.
        )
        (icon
         (origin 171 272)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 55 78)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 detail
         (title off)
         (origin 51 176)
         (extent 816 465)
         (editing disabled)
        )
        (widget 1 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 175 368)
     (extent 110 25)
    )
    (panel
     (origin 11 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 113 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D2:1 D0:1)
   (connect D9:1 D1:1)
   (connect D4:2 D2:0)
   (connect D1:2 D2:1)
   (connect D4:1 D3:0)
   (connect D1:1 D4:1)
   (connect D0:1 D5:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 990 634)
   (configuration
    (connect D2:1 D0:1
     (Point 852 410)
     (Point 870 410)
     (Point 870 620)
     (Point 210 620)
     (Point 210 580)
     (Point 228 580)
    )
    (connect D9:1 D1:1
     (Point 101 240)
     (Point 124 240)
    )
    (connect D4:2 D2:0
     (Point 501 240)
     (Point 530 240)
     (Point 530 285)
    )
    (connect D1:2 D2:1
     (Point 355 250)
     (Point 370 250)
     (Point 370 270)
     (Point 190 270)
     (Point 190 410)
     (Point 208 410)
    )
    (connect D4:1 D3:0
     (Point 501 220)
     (Point 600 220)
     (Point 600 235)
    )
    (connect D1:1 D4:1
     (Point 355 230)
     (Point 418 230)
    )
    (connect D0:1 D5:1
     (Point 311 580)
     (Point 467 580)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
