#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Tue 17/Sep/1991")
(component 0 "Context"
 (name "Ordinal of an ASCII character")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "TextDisplay"
   (name "ASCII (hex)")
   (description 7 4
    A return of 0 means the variable was found.  If
    it has a value, that text is returned in the value
    output pin.  If it is defined without a value,
    the output is a nil container.
    
    If the requested variable can not be located, the
    Error Code exit value is 1.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 730 483)
     (extent 201 35)
     (formatter
      (realFormat standard)
      (realSigDigits 4)
      (realRadixSpec 4)
      (integerBase hexadecimal)
     )
    )
    (active detail)
   )
  )
  (component 1 "TextDisplay"
   (name "ASCII (decimal)")
   (description 7 4
    A return of 0 means the variable was found.  If
    it has a value, that text is returned in the value
    output pin.  If it is defined without a value,
    the output is a nil container.
    
    If the requested variable can not be located, the
    Error Code exit value is 1.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 145 0)
    )
    (detail
     (origin 731 573)
     (extent 219 35)
     (formatter
      (realFormat standard)
      (realSigDigits 4)
      (realRadixSpec 4)
      (integerBase decimal)
     )
    )
    (active detail)
   )
  )
  (component 2 "Context"
   (name "ascii(char)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "CHAR")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (optional yes)
    )
    (output 1
     (type data)
     (name "ERROR")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "ASCII")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "EnumConstant"
     (name "ASCII")
     (description 8 6
      This gigantic ENUM has one entry for each of the
      ascii characters, starting with "space".  By
      supplying an unknown character as the Default
      Value, the Enum outputs both the character and
      the ordinal of the character in the Enum list.
      
      We can extract the ordinal to obtain a number that
      represents the character.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Default Value")
       (requires
        (datatype Text)
        (shape "Scalar")
       )
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Enum")
       (lock name constraints)
      )
     )
     (implementation
      (component value Enum
       (name "ASCII")
       (values
        ( " " 0)
        ( "!" 1)
        ( "\"" 2)
        ( "#" 3)
        ( "$" 4)
        ( "%" 5)
        ( "&" 6)
        ( "\'" 7)
        ( "(" 8)
        ( ")" 9)
        ( "*" 10)
        ( "+" 11)
        ( "," 12)
        ( "-" 13)
        ( "." 14)
        ( "/" 15)
        ( "0" 16)
        ( "1" 17)
        ( "2" 18)
        ( "3" 19)
        ( "4" 20)
        ( "5" 21)
        ( "6" 22)
        ( "7" 23)
        ( "8" 24)
        ( "9" 25)
        ( ":" 26)
        ( ";" 27)
        ( "<" 28)
        ( "=" 29)
        ( ">" 30)
        ( "?" 31)
        ( "@" 32)
        ( "A" 33)
        ( "B" 34)
        ( "C" 35)
        ( "D" 36)
        ( "E" 37)
        ( "F" 38)
        ( "G" 39)
        ( "H" 40)
        ( "I" 41)
        ( "J" 42)
        ( "K" 43)
        ( "L" 44)
        ( "M" 45)
        ( "N" 46)
        ( "O" 47)
        ( "P" 48)
        ( "Q" 49)
        ( "R" 50)
        ( "S" 51)
        ( "T" 52)
        ( "U" 53)
        ( "V" 54)
        ( "W" 55)
        ( "X" 56)
        ( "Y" 57)
        ( "Z" 58)
        ( "[" 59)
        ( "\\" 60)
        ( "]" 61)
        ( "^" 62)
        ( "_" 63)
        ( "`" 64)
        ( "a" 65)
        ( "b" 66)
        ( "c" 67)
        ( "d" 68)
        ( "e" 69)
        ( "f" 70)
        ( "g" 71)
        ( "h" 72)
        ( "i" 73)
        ( "j" 74)
        ( "k" 75)
        ( "l" 76)
        ( "m" 77)
        ( "n" 78)
        ( "o" 79)
        ( "p" 80)
        ( "q" 81)
        ( "r" 82)
        ( "s" 83)
        ( "t" 84)
        ( "u" 85)
        ( "v" 86)
        ( "w" 87)
        ( "x" 88)
        ( "y" 89)
        ( "z" 90)
        ( "{" 91)
        ( "|" 92)
        ( "}" 93)
        ( "~" 94)
       )
       (datum "A")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Enum
       (shared yes)
       (datum " ")
      )
     )
     (views
      (icon
       (origin 261 458)
       (extent 78 25)
      )
      (detail
       (origin 205 427)
       (extent 130 2106)
       (format buttons)
      )
      (active icon)
     )
    )
    (component 1 "Formula"
     (name "ordinal(x)")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "ordinal(x)")
     )
     (views
      (icon
       (origin 365 458)
       (extent 110 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Formula"
     (name "+32")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "asInt32(A+32)")
     )
     (views
      (icon
       (origin 497 458)
       (extent 46 25)
      )
      (detail
       (origin 420 410)
       (extent 151 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "IfThenElse"
     (name "Printable?")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a<\" \" OR a>\"~\"")
     )
     (views
      (icon
       (origin 125 398)
       (extent 110 25)
      )
      (detail
       (origin 178 455)
       (extent 154 70)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "Gate"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (tag "InData")
      )
      (output 1
       (type data)
       (name "X")
       (tag "OutData")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 157 458)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D4:0 D0:0)
     (connect D4:1 D0:1)
     (connect D0:1 D1:1)
     (connect D1:1 D2:1)
     (connect I1:1 D3:1)
     (connect D3:2 D4:0)
     (connect I1:1 D4:1)
     (connect D3:1 O1:1)
     (connect D2:1 O2:1)
    )
   )
   (views
    (icon
     (origin 177 418)
     (extent 110 25)
    )
    (detail
     (origin 98 387)
     (extent 495 126)
     (configuration
      (connect D4:0 D0:0
       (Point 180 485)
       (Point 180 500)
       (Point 270 500)
       (Point 270 440)
       (Point 300 440)
       (Point 300 455)
      )
      (connect D4:1 D0:1
       (Point 205 470)
       (Point 258 470)
      )
      (connect D0:1 D1:1
       (Point 341 470)
       (Point 362 470)
      )
      (connect D1:1 D2:1
       (Point 477 470)
       (Point 494 470)
      )
      (connect I1:1 D3:1
       (Point 100 460)
       (Point 110 460)
       (Point 110 410)
       (Point 122 410)
      )
      (connect D3:2 D4:0
       (Point 237 420)
       (Point 250 420)
       (Point 250 440)
       (Point 180 440)
       (Point 180 455)
      )
      (connect I1:1 D4:1
       (Point 100 460)
       (Point 110 460)
       (Point 110 470)
       (Point 154 470)
      )
      (connect D3:1 O1:1
       (Point 237 400)
       (Point 413 400)
       (Point 413 420)
       (Point 590 420)
      )
      (connect D2:1 O2:1
       (Point 545 470)
       (Point 560 470)
       (Point 560 500)
       (Point 590 500)
      )
     )
    )
    (terminals on)
    (active detail)
   )
  )
  (component 3 "TextDisplay"
   (name "ERROR")
   (description 7 4
    A return of 0 means the variable was found.  If
    it has a value, that text is returned in the value
    output pin.  If it is defined without a value,
    the output is a nil container.
    
    If the requested variable can not be located, the
    Error Code exit value is 1.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 730 403)
     (extent 201 35)
    )
    (active detail)
   )
  )
  (component 4 "Context"
   (name "char(ascii)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "N")
     (optional yes)
    )
    (output 1
     (type data)
     (name "CHAR")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "N")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "(32<=N AND N<128)*N")
     )
     (views
      (icon
      )
      (detail
       (origin 71 713)
       (extent 199 55)
      )
      (active detail)
     )
    )
    (component 1 "LiteralConstant"
     (name "char[n]")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "char[n]")
       (numDims 1)
       (size 95)
       (data
        [ " " "!" "\"" "#" "$" "%" "&" "\'" "(" ")" "*" "+" "," "-" "." "/" "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" ":" ";" "<" "=" ">" "?" "@" "A" "B" "C" "D" "E" "F" "G" "H" "I" "J" "K" "L" "M" "N" "O" "P" "Q" "R" "S" "T" "U" "V" "W" "X" "Y" "Z" "[" "\\" "]" "^" "_" "`" "a" "b" "c" "d" "e" "f" "g" "h" "i" "j" "k" "l" "m" "n" "o" "p" "q" "r" "s" "t" "u" "v" "w" "x" "y" "z" "{" "|" "}" "~" ]
       )
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (datum "")
      )
     )
     (views
      (icon
       (origin 171 628)
       (extent 78 25)
      )
      (detail
       (origin 200 588)
       (extent 201 64)
      )
      (active icon)
     )
    )
    (component 2 "Formula"
     (name "toChar")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "CHAR")
       (optional yes)
      )
      (input 2
       (type data)
       (name "N")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "CHAR[(N-32) MOD 128]")
     )
     (views
      (icon
       (extent 78 0)
       (iconImage "formula.icon")
      )
      (detail
       (origin 343 650)
       (extent 214 80)
      )
      (terminals on)
      (active detail)
     )
    )
    (configuration
     (connect I1:1 D0:1)
     (connect D1:1 D2:1)
     (connect D0:1 D2:2)
     (connect D2:1 O1:1)
     (connect D0:2 O2:1)
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 45 612)
     (extent 610 176)
     (configuration
      (connect I1:1 D0:1
       (Point 47 710)
       (Point 60 710)
       (Point 60 740)
       (Point 68 740)
      )
      (connect D1:1 D2:1
       (Point 251 640)
       (Point 270 640)
       (Point 270 670)
       (Point 290 670)
      )
      (connect D0:1 D2:2
       (Point 272 720)
       (Point 280 720)
       (Point 280 710)
       (Point 290 710)
      )
      (connect D2:1 O1:1
       (Point 629 690)
       (Point 640 690)
       (Point 640 660)
       (Point 652 660)
      )
      (connect D0:2 O2:1
       (Point 272 760)
       (Point 652 760)
      )
     )
    )
    (active detail)
   )
  )
  (component 5 "TextDisplay"
   (name "CHAR(ASCII)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 735 652)
     (extent 190 37)
    )
    (active detail)
   )
  )
  (component 6 "TextDisplay"
   (name "ERROR")
   (description 7 4
    A return of 0 means the variable was found.  If
    it has a value, that text is returned in the value
    output pin.  If it is defined without a value,
    the output is a nil container.
    
    If the requested variable can not be located, the
    Error Code exit value is 1.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 740 743)
     (extent 201 35)
    )
    (active detail)
   )
  )
  (component 7 "LiteralConstant"
   (name "Enter ASCII char")
   (description 7 4
    Enter one of your environment variables here,
    or perhaps try one that doesn't exist.
    
    This is one way your programs can examine some
    environment variables and make program decisions
    based on their value.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Enter ASCII char")
     (datum "A")
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (extent 154 0)
    )
    (detail
     (origin 56 279)
     (extent 228 23)
    )
    (active detail)
   )
  )
  (component 8 "Note"
   (name "TO RUN:")
   (interface
   )
   (implementation
    (component text 4 5
          Enter one character                  |   If the Error Code
     <--  from the ASCII char                  |   returns 1, then the
          set and hit Return.                  |   variable could not
                                               v   be found.  
    )
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 349 250)
     (extent 602 81)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 9 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Note"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 38 9
         PURPOSE:       Illustrate a way to convert a character to it's ascii code and to convert
                        an ascii code back to a character.
         
         USER INPUT REQUIRED: Enter one printable character in the box and press return.  The
                        corresponding ASCII value is displayed in hex and as a decimal number.
                        Observe that the ASCII value is also reconverted back to the original
                        character.
         
         EXPLANATION:   Computers internally represent the ascii character set as integers
                        from 0 to 127.  Occasionally, it is necessary to determine what integer
                        a particular character represents.  This examples shows one technique
                        for obtaining the ascii value of a character.
                        
         IMPLEMENTATION:  A character is supplied to the ascii User Object, where it is first
                        tested to insure that it is one of the printable characters (space,
                        punctuation, etc.)  If so, then the character is "gated" to the Default
                        Value input of an enormous Enum relabelled "ASCII".
         
                        The ASCII Enum has one entry for each printable ascii character in the
                        order that the characters appear in the ascii code.  When a character
                        is gated to the Default Value, the Enum locates the matching character
                        and outputs both the character and the ordinal (offset) of that character
                        in the Enum list.  The "ordinal" object extracts just the integer offset
                        so that we now have a number representing the character.  Because we did
                        not have unprintable chars in the Enum, an offset of 32 is added to the
                        ordinal number to convert it to the ascii code.
         
                        Converting the ASCII code back to a character is accomplished in the
                        "code" User object.  The supplied integer is first value-checked to
                        insure it represents a printable ascii character.   A pre-defined 1D
                        array of text provides a printable "char" for each element in the 
                        array arranged in the order of the ascii code.  By subtracting 32 from
                        the supplied character, the corresponding character is generated by
                        accessing the appropriate element of the char array.
         
         
         
                        
        )
       )
       (views
        (icon
         (origin 160 185)
         (extent 78 25)
        )
        (detail
         (origin 36 162)
         (extent 848 437)
         (editing enabled)
        )
        (active icon)
       )
      )
      (component 1 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 171 252)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 55 78)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 1 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
        (widget 0 detail
         (title off)
         (origin 51 176)
         (extent 826 466)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 140)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 145 58)
     (extent 110 25)
    )
    (panel
     (origin 32 119)
     (extent 317 82)
     (widget 1 icon
      (title off)
      (origin 134 132)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 10 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 392 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (configuration
   (connect D2:2 D0:1)
   (connect D2:2 D1:1)
   (connect D7:1 D2:1)
   (connect D2:1 D3:1)
   (connect D2:2 D4:1)
   (connect D4:1 D5:1)
   (connect D4:2 D6:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 1004 664)
   (configuration
    (connect D2:2 D0:1
     (Point 675 500)
     (Point 727 500)
    )
    (connect D2:2 D1:1
     (Point 675 500)
     (Point 700 500)
     (Point 700 590)
     (Point 728 590)
    )
    (connect D7:1 D2:1
     (Point 286 290)
     (Point 310 290)
     (Point 310 320)
     (Point 30 320)
     (Point 30 460)
     (Point 45 460)
    )
    (connect D2:1 D3:1
     (Point 675 420)
     (Point 727 420)
    )
    (connect D2:2 D4:1
     (Point 675 500)
     (Point 700 500)
     (Point 700 560)
     (Point 30 560)
     (Point 30 710)
     (Point 42 710)
    )
    (connect D4:1 D5:1
     (Point 677 660)
     (Point 700 660)
     (Point 700 670)
     (Point 732 670)
    )
    (connect D4:2 D6:1
     (Point 677 760)
     (Point 737 760)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
