#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Sun 22/Sep/1991")
(component 0 "Context"
 (name " Convection Coefficient Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "LiteralConstant"
   (name "Tran")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Tran")
     (datum "Flow is in Transition Range")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (origin 837 428)
     (extent 46 25)
    )
    (detail
     (origin 700 286)
     (extent 201 28)
    )
    (active icon)
   )
  )
  (component 1 "Junction"
   (name "JCT")
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
    )
    (input 3
     (type data)
     (name "C")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 677 733)
     (extent 46 34)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "LiteralConstant"
   (name "Out")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Out")
     (datum "Data is outside Bounds")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (origin 757 548)
     (extent 46 25)
    )
    (detail
     (origin 590 446)
     (extent 201 28)
    )
    (active icon)
   )
  )
  (component 3 "Junction"
   (name "JCT")
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
    )
    (input 3
     (type data)
     (name "C")
     (optional yes)
    )
    (input 4
     (type data)
     (name "D")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 924 523)
     (extent 53 54)
    )
    (detail
     (origin 875 246)
     (extent 40 210)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "LiteralConstant"
   (name "Lam")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Lam")
     (datum "Flow is in Laminar Range")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (origin 857 368)
     (extent 46 25)
    )
    (detail
     (origin 730 167)
     (extent 201 28)
    )
    (active icon)
   )
  )
  (component 5 "TextDisplay"
   (name "Flow Range")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 699 649)
     (extent 342 40)
    )
    (active detail)
   )
  )
  (component 6 "LiteralConstant"
   (name "Turb")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Turb")
     (datum "Flow is in Turbulent Region")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (origin 827 508)
     (extent 46 25)
    )
    (detail
     (origin 630 366)
     (extent 201 28)
    )
    (active icon)
   )
  )
  (component 7 "IfThenElse"
   (description 7 4
    This "Flow -> If/Then" object provides the final
    filter for determining further action based on
    the upstream "Enum" value, and is used when one
    of the last two selections is chosen.  It will
    determine the surface flow condition based on
    the Temperature and Length of the surface over
    which the flow occurs.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "R")
     (optional yes)
    )
    (input 2
     (type data)
     (name "C")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else If")
     (lock name constraints)
    )
    (output 3
     (type data)
     (name "Else If")
     (lock name constraints)
    )
    (output 4
     (type data)
     (name "Else If")
     (lock name constraints)
    )
    (output 5
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "ordinal(C)==3 AND .3<=R AND R<30000")
    (component expr "ordinal(C)==2 AND .1<R AND R<=19")
    (component expr "ordinal(C)==2 AND 19<R AND R<=21")
    (component expr "ordinal(C)==2 AND 21<R AND R<30000")
   )
   (views
    (icon
     (origin 557 403)
     (extent 86 54)
    )
    (detail
     (origin 311 237)
     (extent 338 147)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "IfThenElse"
   (description 8 4
    This "Flow -> If/Then" object provides the final
    filter for determining further action based on
    the upstream "Enum" value, and is used when one
    of the first two selections is chosen.  It will
    determine the surface flow condition based on
    the Temperature and Length of the surface over
    which the flow occurs.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "R")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else If")
     (lock name constraints)
    )
    (output 3
     (type data)
     (name "Else If")
     (lock name constraints)
    )
    (output 4
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr ".01<=R AND R<=990")
    (component expr "990<R AND R<=1010")
    (component expr "1010<R AND R<1000000")
   )
   (views
    (icon
     (origin 557 338)
     (extent 86 45)
    )
    (detail
     (origin 389 136)
     (extent 223 128)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "EnumConstant"
   (name "Surface Type")
   (description 12 4
    This is a "Data -> Enum" object, which has the 
    "Format -> Buttons" option from the object menu
    enabled.  This provides a quick graphical method
    of selecting values for defined, often used items
    from a list, rather than having to know and enter
    specific values.  Since the entries listed in
    this object are descriptive text, some means of
    correlating to actual values must be provided.
    This example does this by a downstream "If/Then"
    check of the "Enum" selection's ordinal value.
    Check "Show Description" for these "If/Then"
    objects and also "Help" for "Enum".
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Enum
     (name "Surface Type")
     (values
      ( "Vert. Plate" 0)
      ( "H/V Pipes" 1)
      ( "Horz. Plate up" 2)
      ( "Horz. Plate down" 3)
     )
     (datum "H/V Pipes")
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Enum
     (shared yes)
     (datum "Vert. Plate")
    )
   )
   (views
    (icon
     (extent 118 0)
    )
    (detail
     (origin 278 249)
     (extent 184 103)
     (format buttons)
    )
    (active detail)
   )
  )
  (component 10 "IfThenElse"
   (description 6 4
    This "Flow -> If/Then" object is a first pass
    "filter" for the upstream enum values, to switch
    between one of the following "If/Then" objects
    which provides final resolution for the action
    to be taken based on the enum value.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "ordinal(A)<2")
   )
   (views
    (icon
     (origin 491 288)
     (extent 78 25)
    )
    (detail
     (origin 347 205)
     (extent 136 70)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "TextDisplay"
   (name "(T*(L^3)) Range")
   (description 1 4
    This is a "Display -> AlphaNumeric" object.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 387 466)
     (extent 146 28)
    )
    (detail
     (origin 368 165)
     (extent 224 33)
     (formatter
      (realFormat standard)
      (realSigDigits 4)
      (realRadixSpec 4)
      (integerBase decimal)
     )
    )
    (active icon)
   )
  )
  (component 12 "Junction"
   (name "JCT")
   (description 8 4
    This is a "Flow -> Junction" object.  It is
    somewhat different than other objects, in that
    it only needs one input value on any one of its
    input pins, in order to be able to supply an
    output.  That is in fact its function, to pass on
    the single value input that it has available when
    it becomes activated.
     
   )
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
    )
    (input 3
     (type data)
     (name "C")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 717 333)
     (extent 46 34)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "Junction"
   (name "JCT")
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 717 398)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 14 "Junction"
   (name "JCT")
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 717 448)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 15 "Junction"
   (name "JCT")
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 717 488)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 16 "Formula"
   (name "LFormula")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "L")
     (optional yes)
    )
    (input 2
     (type data)
     (name "T")
     (optional yes)
    )
    (input 3
     (type data)
     (name "Cy")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "(Cy*(T/L)^.25)")
   )
   (views
    (icon
     (origin 485 573)
     (extent 110 35)
    )
    (detail
     (origin 407 402)
     (extent 196 156)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 17 "Formula"
   (name "LTFormula")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "L")
     (optional yes)
    )
    (input 2
     (type data)
     (name "T")
     (optional yes)
    )
    (input 3
     (type data)
     (name "Cx")
     (optional yes)
    )
    (input 4
     (type data)
     (name "Cy")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "((Cx*(T/L)^.25)+(Cy*(T)^(1/3)))/2")
   )
   (views
    (icon
     (origin 483 646)
     (extent 115 49)
    )
    (detail
     (origin 282 529)
     (extent 337 204)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 18 "TextDisplay"
   (name "Convection Coef. h")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 172 0)
    )
    (detail
     (origin 754 733)
     (extent 273 35)
     (formatter
      (realFormat standard)
      (realSigDigits 4)
      (realRadixSpec 4)
      (integerBase decimal)
     )
    )
    (active detail)
   )
  )
  (component 19 "Formula"
   (name "L^3*T")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "L")
     (optional yes)
    )
    (input 2
     (type data)
     (name "T")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "L^3*T")
   )
   (views
    (icon
     (origin 381 398)
     (extent 78 25)
    )
    (detail
     (origin 286 225)
     (extent 79 110)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 20 "Formula"
   (name " + ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X+Y")
   )
   (views
    (icon
     (origin 287 518)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 21 "Junction"
   (name "JCT")
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 27 448)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 22 "Start"
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin -53 402)
     (extent 67 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 23 "FromArray"
   (name "Get Coef.")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "C")
     (tag "Ary")
    )
    (input 2
     (type data)
     (name "Ary")
     (optional yes)
    )
    (output 1
     (type data)
     (name "SubAry")
     (tag "Result")
     (lock constraints)
    )
    (output 2
     (type data)
     (name "Type")
     (tag "Type")
     (lock constraints)
    )
    (output 3
     (type data)
     (name "NumDims")
     (tag "NumDims")
     (lock constraints)
    )
    (output 4
     (type data)
     (name "DimSizes")
     (tag "DimSizes")
     (lock constraints)
    )
    (output 5
     (type data)
     (name "TotSize")
     (tag "TotSize")
     (lock constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "Ary[ordinal(C)]")
   )
   (views
    (icon
     (origin 285 563)
     (extent 110 54)
    )
    (detail
     (origin 131 490)
     (extent 169 160)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 24 "Formula"
   (name "TFormula")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "T")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Cy")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "(Cy*(T)^(1/3))")
   )
   (views
    (icon
     (origin 485 718)
     (extent 110 25)
    )
    (detail
     (origin 463 622)
     (extent 154 119)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 25 "Constant"
   (name "Coef L,T")
   (description 8 4
    This "Data -> Constant -> Coord" object contains
    a coordinate array of constants, one set of which
    is selected based on the "Surface Type" enum
    ordinal value.  Using a coordinate pair provides
    an easy way of associating the laminar and
    turbulent flow coefficients for each type of
    surface that may be chosen.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Coord
     (name "Coef L,T")
     (numDims 1)
     (size 4)
     (numCoordDims 2)
     (data
      [ (0.29,0.21) (0.25,0.18) (0.27,0.22) (0.12,0) ]
     )
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Coord
     (numCoordDims 2)
     (datum (0,0))
    )
   )
   (views
    (icon
     (origin 285 628)
     (extent 110 25)
    )
    (detail
     (origin 253 795)
     (extent 214 90)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 26 "FromCoordinate"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Coord Data")
     (requires
      (datatype Coord)
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "X Data")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Y Data")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 277 658)
     (extent 127 25)
    )
    (detail
     (origin 380 535)
     (extent 23 70)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 27 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 273 361)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 297 353)
       (extent 16 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 407 368)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About this Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "OK")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 520 501)
         (extent 61 39)
        )
        (detail
         (origin 436 473)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (interface
       )
       (implementation
        (component text 49 9
         PURPOSE:     Demonstrate the use of HP VEE with a Natural Convection Heat Transfer
                      Model that will calculate the heat transfer coefficient, "h", for
                      several body or surface types.
         
         USER INPUT REQUIRED: None to run example as set up.  To use other values, note that
                      three data inputs are required: length (or diameter) of surface, surface
                      to ambient temperature differential, and surface "type" under
                      consideration.  By moving slider handles or entering data by clicking
                      on the entry fields (below slider title), you may enter length and
                      temperature.  Coarse (tens) and fine (ones) sliders are used to provide
                      better resolution for "Temp. Delta".  Clicking on a button next to one
                      of the enumerated "Surface Types" easily defines the surface type. 
                      Finally, click "Run" (on the right side of the title bar) to calculate
                      the result (that is, the heat transfer coefficient) based on the input
                      values. 
         
         EXPLANATION: This model is based on a simplified formula with constants and valid
                      ranges that yield conservative design values.  Valid ranges are based on
                      the "Surface Type" and the value of "Surface/Ambient Temperature Delta"
                      multiplied by the surface "Length" (or diameter) cubed.  The range value
                      is displayed just for reference, since the textual display indicating
                      flow type (laminar, transitional, or turbulent) is of primary interest.
         
                      Simplified constants which are appropriate for laminar and turbulent
                      flow conditions for each surface type are contained in one "Data ->
                      Constant -> Coord" object as a set of paired values.  One pair is chosen
                      for calculation requirements based on the "Surface Type" selection
                      mentioned above.  This "Enum" selection also affects determination of
                      surface flow conditions.
         
                      Click  "Detail" (on the left side of the title bar) to review specific
                      construction details of this model and to better appreciate the display
                      organization benefits of HP VEE's panel view.  Most of the objects are
                      iconized to save space, but may be opened by double-clicking on the
                      icons.  From the object menu, select "Help" and (for some objects) "Show
                      Description" for more information on each object.  For example, "Show
                      Description" for the "Surface Type" object provides some details about
                      how enumerated selections require further processing.  In this example,
                      control over which coefficients, ranges, and flow indicator outputs are
                      used is dependent on proper processing (or "parsing") of the enumerated
                      values. 
         
                      It may also be interesting to explore the "Info About" object, which in
                      the detail view is a panel, built from a "Device -> UserObject" and
                      produces this display upon its activation.  It has its own "Detail"
                      button, which may be used to investigate its own construction details,
                      such as the fact that it contains yet another panel.  These are actually
                      nested "UserObjects" effectively functioning as independent "sub-models".
         
        )
       )
       (views
        (icon
         (origin 541 538)
         (extent 78 25)
        )
        (detail
         (origin 126 231)
         (extent 848 437)
         (editing disabled)
        )
        (active detail)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 22 106)
       (extent 833 588)
       (panel
        (origin 96 165)
        (extent 829 550)
        (widget 0 icon
         (title off)
         (origin 487 672)
         (extent 52 36)
        )
        (widget 1 detail
         (title off)
         (origin 109 176)
         (extent 808 479)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 402 428)
       (extent 217 25)
      )
      (detail
       (origin 117 170)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D2:0 D0:1)
     (connect D0:1 D1:1)
     (connect D1:1 D2:0)
    )
   )
   (views
    (icon
     (origin 705 648)
     (extent 110 25)
    )
    (panel
     (origin 46 111)
     (extent 288 79)
     (widget 0 icon
      (title off)
      (origin 136 130)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 82 115)
     (extent 857 590)
     (configuration
      (connect D2:0 D0:1
       (Point 510 455)
       (Point 510 470)
       (Point 250 470)
       (Point 250 380)
       (Point 270 380)
      )
      (connect D0:1 D1:1
       (Point 389 380)
       (Point 404 380)
      )
      (connect D1:1 D2:0
       (Point 455 370)
       (Point 510 370)
       (Point 510 425)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 28 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 5 5
     This example is provided as an
     illustration "as is", and Hewlett-
     Packard Company makes no warranty
     of any kind with regard to this
     example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 494 112)
     (extent 333 97)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 29 "Note"
   (name "To Operate")
   (interface
   )
   (implementation
    (component text 5 5
     Click "Run" to see example
     calculation results. Click
     "Info About" for details.
     Adjust sliders and Surface
     Type and rerun the example.
    )
   )
   (views
    (icon
     (origin 355 108)
     (extent 110 64)
     (iconImage "/usr/lib/veetest/bitmaps/notepad.icon")
    )
    (detail
     (origin 657 231)
     (extent 266 99)
     (editing enabled)
    )
    (active icon)
   )
  )
  (component 30 "Slider"
   (name "Length or Dia.")
   (description 9 4
    This "Data -> Real Slider" object is one of
    several input devices that has the advantage of
    providing either a direct value entry (click on
    the entry field), or a slider bar which may be
    moved to change the value.  This also provides a
    rough graphical concept of the value, much the
    same as a bar chart gives a quick overall 
    impression of values.
     
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Length or Dia.")
     (values range 0 6)
     (datum 1.25)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
    (component detents 0.25)
   )
   (views
    (icon
     (origin 47 268)
     (extent 136 25)
    )
    (detail
     (origin 25 235)
     (extent 210 191)
    )
    (active detail)
   )
  )
  (component 31 "Slider"
   (name "Delta Temp ")
   (description 7 4
    This a "Data -> Real Slider" object.
    In this case it is being used for a coarse
    setting of the Temperature Delta value.
    
    For more information, see "Show Description" for
    the fine "Temp. Delta" slider, and especially the
    "Lgth. or Dia." slider object.
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Delta Temp ")
     (values range 0 1000)
     (datum 510)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
    (component detents 10)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 39 504)
     (extent 183 173)
    )
    (active detail)
   )
  )
  (component 32 "Slider"
   (name "Delta Temp (Fine)")
   (description 7 4
    This is a "Data -> Real Slider" object.
    In this case it is being used for setting a finer
    resolution Temperature Delta value.
    
    For more information, see "Show Description" for
    the coarse "Temp. Delta" slider, and especially
    the "Lgth. or Dia." slider object.
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Delta Temp (Fine)")
     (values range 0 9)
     (datum 4)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
    (component detents 1)
   )
   (views
    (icon
     (origin 85 538)
     (extent 163 25)
    )
    (detail
     (origin 38 732)
     (extent 184 137)
    )
    (active detail)
   )
  )
  (configuration
   (connect D13:1 D0:0)
   (connect D16:1 D1:1)
   (connect D17:1 D1:2)
   (connect D24:1 D1:3)
   (connect D15:1 D2:0)
   (connect D4:1 D3:1)
   (connect D0:1 D3:2)
   (connect D6:1 D3:3)
   (connect D2:1 D3:4)
   (connect D12:1 D4:0)
   (connect D3:1 D5:1)
   (connect D14:1 D6:0)
   (connect D10:2 D7:0)
   (connect D19:1 D7:1)
   (connect D9:1 D7:2)
   (connect D10:1 D8:0)
   (connect D19:1 D8:1)
   (connect D9:1 D10:1)
   (connect D19:1 D11:1)
   (connect D8:1 D12:1)
   (connect D7:1 D12:2)
   (connect D7:2 D12:3)
   (connect D8:2 D13:1)
   (connect D7:3 D13:2)
   (connect D8:3 D14:1)
   (connect D7:4 D14:2)
   (connect D8:4 D15:1)
   (connect D7:5 D15:2)
   (connect D12:1 D16:0)
   (connect D30:1 D16:1)
   (connect D20:1 D16:2)
   (connect D26:1 D16:3)
   (connect D13:1 D17:0)
   (connect D30:1 D17:1)
   (connect D20:1 D17:2)
   (connect D26:1 D17:3)
   (connect D26:2 D17:4)
   (connect D1:1 D18:1)
   (connect D30:1 D19:1)
   (connect D20:1 D19:2)
   (connect D31:1 D20:1)
   (connect D32:1 D20:2)
   (connect D22:0 D21:1)
   (connect D32:0 D21:2)
   (connect D9:1 D23:1)
   (connect D25:1 D23:2)
   (connect D14:1 D24:0)
   (connect D20:1 D24:1)
   (connect D26:2 D24:2)
   (connect D23:1 D26:1)
   (connect D21:1 D31:0)
   (connect D31:0 D32:0)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 910 653)
   (widget 5 detail
    (title on)
    (origin 299 588)
    (extent 313 40)
   )
   (widget 11 detail
    (title on)
    (origin 46 589)
    (extent 221 40)
    (formatter
     (realFormat standard)
     (realSigDigits 4)
     (realRadixSpec 4)
     (integerBase decimal)
    )
   )
   (widget 18 detail
    (title on)
    (origin 645 588)
    (extent 218 40)
    (formatter
     (realFormat standard)
     (realSigDigits 4)
     (realRadixSpec 4)
     (integerBase decimal)
    )
   )
   (widget 31 detail
    (title on)
    (origin 232 283)
    (extent 201 237)
   )
   (widget 9 detail
    (title on)
    (origin 673 283)
    (extent 212 234)
    (format buttons)
   )
   (widget 28 detail
    (title on)
    (origin 549 109)
    (extent 337 95)
    (editing enabled)
   )
   (widget 29 detail
    (title on)
    (origin 276 110)
    (extent 257 95)
    (editing disabled)
   )
   (widget 27 panel
    (title on)
    (origin 22 112)
    (extent 238 94)
    (widget 0 icon
     (title off)
     (origin 84 130)
     (extent 114 39)
     (format button)
    )
   )
   (widget 30 detail
    (title on)
    (origin 22 283)
    (extent 194 238)
   )
   (widget 32 detail
    (title on)
    (origin 453 283)
    (extent 201 236)
   )
  )
  (detail
   (origin 0 67)
   (extent 979 648)
   (configuration
    (connect D13:1 D0:0
     (Point 765 410)
     (Point 860 410)
     (Point 860 425)
    )
    (connect D16:1 D1:1
     (Point 597 590)
     (Point 630 590)
     (Point 630 740)
     (Point 674 740)
    )
    (connect D17:1 D1:2
     (Point 600 670)
     (Point 620 670)
     (Point 620 750)
     (Point 674 750)
    )
    (connect D24:1 D1:3
     (Point 597 730)
     (Point 610 730)
     (Point 610 760)
     (Point 674 760)
    )
    (connect D15:1 D2:0
     (Point 765 500)
     (Point 780 500)
     (Point 780 545)
    )
    (connect D4:1 D3:1
     (Point 905 380)
     (Point 920 380)
     (Point 920 410)
     (Point 910 410)
     (Point 910 530)
     (Point 921 530)
    )
    (connect D0:1 D3:2
     (Point 885 440)
     (Point 900 440)
     (Point 900 540)
     (Point 921 540)
    )
    (connect D6:1 D3:3
     (Point 875 520)
     (Point 890 520)
     (Point 890 550)
     (Point 921 550)
    )
    (connect D2:1 D3:4
     (Point 805 560)
     (Point 921 560)
    )
    (connect D12:1 D4:0
     (Point 765 350)
     (Point 880 350)
     (Point 880 365)
    )
    (connect D3:1 D5:1
     (Point 979 550)
     (Point 990 550)
     (Point 990 600)
     (Point 680 600)
     (Point 680 669)
     (Point 696 669)
    )
    (connect D14:1 D6:0
     (Point 765 460)
     (Point 780 460)
     (Point 780 470)
     (Point 850 470)
     (Point 850 505)
    )
    (connect D10:2 D7:0
     (Point 571 310)
     (Point 580 310)
     (Point 580 320)
     (Point 540 320)
     (Point 540 390)
     (Point 600 390)
     (Point 600 400)
    )
    (connect D19:1 D7:1
     (Point 461 410)
     (Point 554 410)
    )
    (connect D9:1 D7:2
     (Point 464 300)
     (Point 480 300)
     (Point 480 330)
     (Point 490 330)
     (Point 490 450)
     (Point 554 450)
    )
    (connect D10:1 D8:0
     (Point 571 290)
     (Point 600 290)
     (Point 600 335)
    )
    (connect D19:1 D8:1
     (Point 461 410)
     (Point 520 410)
     (Point 520 360)
     (Point 554 360)
    )
    (connect D9:1 D10:1
     (Point 464 300)
     (Point 488 300)
    )
    (connect D19:1 D11:1
     (Point 461 410)
     (Point 480 410)
     (Point 480 440)
     (Point 370 440)
     (Point 370 480)
     (Point 384 480)
    )
    (connect D8:1 D12:1
     (Point 645 340)
     (Point 714 340)
    )
    (connect D7:1 D12:2
     (Point 645 410)
     (Point 680 410)
     (Point 680 350)
     (Point 714 350)
    )
    (connect D7:2 D12:3
     (Point 645 420)
     (Point 660 420)
     (Point 660 410)
     (Point 670 410)
     (Point 670 360)
     (Point 714 360)
    )
    (connect D8:2 D13:1
     (Point 645 350)
     (Point 660 350)
     (Point 660 400)
     (Point 714 400)
    )
    (connect D7:3 D13:2
     (Point 645 430)
     (Point 660 430)
     (Point 660 420)
     (Point 714 420)
    )
    (connect D8:3 D14:1
     (Point 645 360)
     (Point 660 360)
     (Point 660 370)
     (Point 690 370)
     (Point 690 390)
     (Point 720 390)
     (Point 720 430)
     (Point 700 430)
     (Point 700 450)
     (Point 714 450)
    )
    (connect D7:4 D14:2
     (Point 645 440)
     (Point 660 440)
     (Point 660 470)
     (Point 714 470)
    )
    (connect D8:4 D15:1
     (Point 645 370)
     (Point 660 370)
     (Point 660 380)
     (Point 650 380)
     (Point 650 390)
     (Point 640 390)
     (Point 640 490)
     (Point 714 490)
    )
    (connect D7:5 D15:2
     (Point 645 450)
     (Point 670 450)
     (Point 670 510)
     (Point 714 510)
    )
    (connect D12:1 D16:0
     (Point 765 350)
     (Point 790 350)
     (Point 790 530)
     (Point 540 530)
     (Point 540 570)
    )
    (connect D30:1 D16:1
     (Point 237 330)
     (Point 260 330)
     (Point 260 400)
     (Point 360 400)
     (Point 360 510)
     (Point 430 510)
     (Point 430 580)
     (Point 482 580)
    )
    (connect D20:1 D16:2
     (Point 335 530)
     (Point 420 530)
     (Point 420 590)
     (Point 482 590)
    )
    (connect D26:1 D16:3
     (Point 406 660)
     (Point 430 660)
     (Point 430 600)
     (Point 482 600)
    )
    (connect D13:1 D17:0
     (Point 765 410)
     (Point 800 410)
     (Point 800 590)
     (Point 670 590)
     (Point 670 630)
     (Point 540 630)
     (Point 540 643)
    )
    (connect D30:1 D17:1
     (Point 237 330)
     (Point 260 330)
     (Point 260 400)
     (Point 360 400)
     (Point 360 510)
     (Point 430 510)
     (Point 430 580)
     (Point 460 580)
     (Point 460 650)
     (Point 480 650)
    )
    (connect D20:1 D17:2
     (Point 335 530)
     (Point 420 530)
     (Point 420 590)
     (Point 450 590)
     (Point 450 660)
     (Point 480 660)
    )
    (connect D26:1 D17:3
     (Point 406 660)
     (Point 420 660)
     (Point 420 670)
     (Point 480 670)
    )
    (connect D26:2 D17:4
     (Point 406 680)
     (Point 480 680)
    )
    (connect D1:1 D18:1
     (Point 725 750)
     (Point 751 750)
    )
    (connect D30:1 D19:1
     (Point 237 330)
     (Point 260 330)
     (Point 260 400)
     (Point 378 400)
    )
    (connect D20:1 D19:2
     (Point 335 530)
     (Point 350 530)
     (Point 350 420)
     (Point 378 420)
    )
    (connect D31:1 D20:1
     (Point 224 590)
     (Point 240 590)
     (Point 240 520)
     (Point 284 520)
    )
    (connect D32:1 D20:2
     (Point 224 800)
     (Point 230 800)
     (Point 230 600)
     (Point 250 600)
     (Point 250 540)
     (Point 284 540)
    )
    (connect D22:0 D21:1
     (Point -20 441)
     (Point -20 450)
     (Point 24 450)
    )
    (connect D32:0 D21:2
     (Point 130 871)
     (Point 130 890)
     (Point 10 890)
     (Point 10 470)
     (Point 24 470)
    )
    (connect D9:1 D23:1
     (Point 464 300)
     (Point 480 300)
     (Point 480 330)
     (Point 490 330)
     (Point 490 380)
     (Point 290 380)
     (Point 290 550)
     (Point 270 550)
     (Point 270 570)
     (Point 282 570)
    )
    (connect D25:1 D23:2
     (Point 469 840)
     (Point 490 840)
     (Point 490 750)
     (Point 440 750)
     (Point 440 730)
     (Point 240 730)
     (Point 240 610)
     (Point 282 610)
    )
    (connect D14:1 D24:0
     (Point 765 460)
     (Point 780 460)
     (Point 780 490)
     (Point 760 490)
     (Point 760 540)
     (Point 660 540)
     (Point 660 710)
     (Point 540 710)
     (Point 540 715)
    )
    (connect D20:1 D24:1
     (Point 335 530)
     (Point 420 530)
     (Point 420 590)
     (Point 450 590)
     (Point 450 660)
     (Point 460 660)
     (Point 460 720)
     (Point 482 720)
    )
    (connect D26:2 D24:2
     (Point 406 680)
     (Point 450 680)
     (Point 450 740)
     (Point 482 740)
    )
    (connect D23:1 D26:1
     (Point 397 570)
     (Point 410 570)
     (Point 410 640)
     (Point 260 640)
     (Point 260 670)
     (Point 274 670)
    )
    (connect D21:1 D31:0
     (Point 75 460)
     (Point 90 460)
     (Point 90 450)
     (Point 130 450)
     (Point 130 471)
    )
    (connect D31:0 D32:0
     (Point 130 679)
     (Point 130 699)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
