#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Mon 23/Sep/1991")
(component 0 "Context"
 (name "Digital Filter Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "YPlot"
   (name "Elliptical Filter")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "original")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "filtered")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 1)
    (component tracePin 2)
    (component graphMode freqmag)
   )
   (views
    (icon
     (extent 163 0)
     (iconImage "display.icon")
    )
    (detail
     (origin 548 258)
     (extent 445 365)
     (displayMode scrollGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Mag")
      (domainName "Freq")
      (pen 9)
      (show 1)
      (range 0 180 4 linear)
     )
     (domain 0 7000 4 linear)
     (trace 0 onScale 0
      (name "original")
      (pen 4)
      (lineType 1)
      (pointType 5)
     )
     (trace 1 onScale 0
      (name "filtered")
      (pen 7)
      (lineType 1)
      (pointType 5)
     )
    )
    (active detail)
   )
  )
  (component 1 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 552 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 2 "Formula"
   (name " + ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X+Y")
   )
   (views
    (icon
     (origin 427 398)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "ToWaveform"
   (name "Build Waveform")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Array")
     (tag "Array")
     (requires
      (datatype Real)
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Wf")
     (tag "Wf")
     (lock name constraints)
    )
   )
   (implementation
    (component interval 0.02)
   )
   (views
    (icon
     (origin 392 498)
     (extent 136 64)
     (iconImage "build.icon")
    )
    (detail
     (origin 918 253)
     (extent 212 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "Formula"
   (name "poles")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "z1")
     (optional yes)
    )
    (input 2
     (type data)
     (name "z2")
     (optional yes)
    )
    (input 3
     (type data)
     (name "z3")
     (optional yes)
    )
    (input 4
     (type data)
     (name "a")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "a[1]*z1+a[2]*z2+a[3]*z3")
   )
   (views
    (icon
     (origin 281 388)
     (extent 78 64)
     (iconImage "/usr/lib/veetest/bitmaps/formula.icon")
    )
    (detail
     (origin 225 528)
     (extent 241 204)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "Start"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 46 99)
     (extent 109 82)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "ExitProcess"
   (interface
    (sequence in)
   )
   (implementation
    (comp code 0)
   )
   (views
    (icon
     (origin 731 658)
     (extent 78 64)
     (iconImage "stop.icon")
    )
    (detail
     (origin 710 683)
     (extent 120 34)
    )
    (active icon)
   )
  )
  (component 7 "ShiftRegister"
   (name "Shift Register")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
    (output 1
     (type data)
     (name "Current")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "1 Prev")
     (lock name constraints)
     (optional yes)
    )
    (output 3
     (type data)
     (name "2 Prev")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 35 387)
     (extent 150 46)
    )
    (detail
     (origin 195 590)
     (extent 110 100)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "Constant"
   (name "a[k]")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "a[k]")
     (numDims 1)
     (size 4)
     (data
      [ 0 2.1291 -1.7834 0.5435 ]
     )
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 67 518)
     (extent 46 25)
    )
    (detail
     (origin 27 476)
     (extent 167 88)
    )
    (active detail)
   )
  )
  (component 9 "Constant"
   (name "b[k]")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "b[k]")
     (numDims 1)
     (size 4)
     (data
      [ 0.05634 -0.0009352400000000001 -0.0009352400000000001 0.05634 ]
     )
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 77 618)
     (extent 46 25)
    )
    (detail
     (origin 27 609)
     (extent 166 82)
    )
    (active detail)
   )
  )
  (component 10 "Formula"
   (name "zeros")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "x")
     (optional yes)
    )
    (input 2
     (type data)
     (name "z1")
     (optional yes)
    )
    (input 3
     (type data)
     (name "z2")
     (optional yes)
    )
    (input 4
     (type data)
     (name "z3")
     (optional yes)
    )
    (input 5
     (type data)
     (name "b")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "b[0]*x+b[1]*z1+b[2]*z2+b[3]*z3")
   )
   (views
    (icon
     (origin 281 598)
     (extent 78 64)
     (iconImage "/usr/lib/veetest/bitmaps/formula.icon")
    )
    (detail
     (origin 423 473)
     (extent 304 254)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "SlidingWindow"
   (name "Collector")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (tag "Data")
     (requires
      (shape "Scalar")
     )
     (lock constraints)
    )
    (output 1
     (type data)
     (name "Array")
     (tag "Array")
     (lock constraints)
    )
   )
   (implementation
    (component vecSize 256)
    (component triggerSize 256)
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 385 618)
     (extent 110 25)
    )
    (detail
     (origin 301 579)
     (extent 248 63)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 12 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 325 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 161 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "RepeatUntilBreak"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 55 208)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Context"
     (name "Info About...")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 420 669)
         (extent 58 37)
        )
        (detail
         (origin 466 633)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "Overview of Example")
       (interface
       )
       (implementation
        (component text 45 9
         PURPOSE:      To illustrate:  1) Unbuilding and building time domain waveforms,
                       2) Construction of a 3rd order elliptical digital filter, and
                       3) Automatic conversion from the time domain to the frequency domain.
         
         USER INPUT REQUIRED: None.  Click on "Start" or "Run" to run the model.
         
         EXPLANATION:  A digital filter operates iteratively on a sequence of numbers.  The 
                       For Count object, Formula object titled "x(n)", and Unbuild Waveform
                       object convert the output of the "Function Generator" (titled "200Hz
                       Square Wave") to such a sequence.  The "+" is given one number after
                       another.
         
                       The output of the filter, which appears on the output of the Formula
                       object titled "zeros", is also a sequence of numbers.  The Sliding
                       Collector converts the individual numbers into an array and the Build
                       Waveform makes the array into a time domain waveform similar to the
                       output of the Function Generator.
         
                       The digital filter is constructed with the Shift Register, Formulas
                       ("poles" and "zeros"), Addition and Constant objects ("a[k]" and "b[k]").
                       This filter implements an arbitrary 3rd order digital filter of the form:
         
                                        -1     -2     -3
                                 b0+b1*z  +b2*z  +b3*z
                        H(z) = -------------------------
                                        -1     -2    -3
                                 1-(a1*z  +a2*z +a3*z  )
         
                       The filter is implemented using direct form II. The coefficients of a
                       3rd order elliptical filter were obtained from the book "Digital Signal
                       Processing" by Alan V. Oppenheim and Ronald W.  Schafer, page 226.
         
                       The result of the filtering operation can be seen in the display labeled
                       "Elliptical Filter".  While the inputs are time domain waveforms, the
                       display is done in the frequency domain.  The display automatically
                       performs an FFT on the input to change domains.
         
                       Try changing the parameters of the square wave. If you know the
                       coefficients for another of 3rd order or less filter, try changing "a[k]"
                       and "b[k]".  Try changing the display to log or turn on markers.
         
                       The order of the filter can be easily increased by adding outputs to the
                       Shift Register, increasing the size of "a[k]" and "b[k]", and editing
                       the formulas in the "poles" and "zeros" Formula objects. 
         
        )
       )
       (views
        (icon
         (origin 350 608)
         (extent 181 25)
        )
        (detail
         (origin 116 608)
         (extent 469 285)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 86 135)
       (extent 849 571)
       (panel
        (origin 28 164)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 427 649)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 34 173)
         (extent 835 461)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 387 418)
       (extent 127 25)
      )
      (detail
       (origin 265 560)
       (extent 351 200)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:1 D1:0)
     (connect D3:0 D1:1)
     (connect D0:1 D3:0)
    )
   )
   (views
    (icon
     (origin 435 388)
     (extent 110 25)
    )
    (panel
     (origin 211 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 313 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 277 362)
       (Point 322 362)
      )
      (connect D2:1 D1:0
       (Point 167 240)
       (Point 218 240)
       (Point 218 340)
      )
      (connect D3:0 D1:1
       (Point 450 445)
       (Point 450 460)
       (Point 140 460)
       (Point 140 362)
       (Point 158 362)
      )
      (connect D0:1 D3:0
       (Point 373 352)
       (Point 450 352)
       (Point 450 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 13 "ForCount"
   (name "256 pts")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component count 256)
   )
   (views
    (icon
     (origin 61 198)
     (extent 78 64)
     (iconImage "/usr/lib/veetest/bitmaps/loop.icon")
    )
    (detail
     (origin 88 323)
     (extent 165 34)
    )
    (active icon)
   )
  )
  (component 14 "FromWaveform"
   (name "UnBuild Waveform")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Wf Data")
     (requires
      (datatype Waveform)
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Real Ary")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Interval")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 223 308)
     (extent 154 25)
    )
    (detail
     (origin 305 505)
     (extent 80 70)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 15 "Counter"
   (name "Counter")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
    (output 1
     (type data)
     (name "Count")
     (tag "Count")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 171 308)
     (extent 78 25)
    )
    (detail
     (origin 185 253)
     (extent 150 34)
    )
    (active detail)
   )
  )
  (component 16 "Formula"
   (name "x(n)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "b[a]")
   )
   (views
    (icon
     (origin 417 268)
     (extent 46 25)
    )
    (detail
     (origin 467 408)
     (extent 79 104)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 17 "VFunctionGenerator"
   (name "200Hz Square Wave")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component function Square)
    (component frequency 200)
    (component amplitude 1)
    (component dcOffset 0)
    (component phaseShift 0)
    (component numPoints 256)
    (component interval 0.02)
    (component degRad Deg)
    (component errorOnAlias 1)
   )
   (views
    (icon
     (origin 19 308)
     (extent 163 25)
    )
    (detail
     (origin 31 441)
     (extent 239 198)
    )
    (terminals on)
    (active icon)
   )
  )
  (configuration
   (connect D17:1 D0:1)
   (connect D3:1 D0:2)
   (connect D16:1 D2:1)
   (connect D4:1 D2:2)
   (connect D11:1 D3:1)
   (connect D7:1 D4:1)
   (connect D7:2 D4:2)
   (connect D7:3 D4:3)
   (connect D8:1 D4:4)
   (connect D0:0 D6:0)
   (connect D2:1 D7:1)
   (connect D2:1 D10:1)
   (connect D7:1 D10:2)
   (connect D7:2 D10:3)
   (connect D7:3 D10:4)
   (connect D9:1 D10:5)
   (connect D10:1 D11:1)
   (connect D5:0 D13:0)
   (connect D17:1 D14:1)
   (connect D13:1 D15:1)
   (connect D13:1 D16:1)
   (connect D14:1 D16:2)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 1004 664)
   (configuration
    (connect D17:1 D0:1
     (Point 184 320)
     (Point 200 320)
     (Point 200 350)
     (Point 545 350)
    )
    (connect D3:1 D0:2
     (Point 530 530)
     (Point 545 530)
    )
    (connect D16:1 D2:1
     (Point 465 280)
     (Point 480 280)
     (Point 480 310)
     (Point 410 310)
     (Point 410 400)
     (Point 424 400)
    )
    (connect D4:1 D2:2
     (Point 361 420)
     (Point 424 420)
    )
    (connect D11:1 D3:1
     (Point 497 630)
     (Point 510 630)
     (Point 510 580)
     (Point 370 580)
     (Point 370 530)
     (Point 389 530)
    )
    (connect D7:1 D4:1
     (Point 187 400)
     (Point 278 400)
    )
    (connect D7:2 D4:2
     (Point 187 410)
     (Point 278 410)
    )
    (connect D7:3 D4:3
     (Point 187 420)
     (Point 278 420)
    )
    (connect D8:1 D4:4
     (Point 196 520)
     (Point 220 520)
     (Point 220 430)
     (Point 278 430)
    )
    (connect D0:0 D6:0
     (Point 770 625)
     (Point 770 655)
    )
    (connect D2:1 D7:1
     (Point 475 410)
     (Point 490 410)
     (Point 490 360)
     (Point 20 360)
     (Point 20 410)
     (Point 32 410)
    )
    (connect D2:1 D10:1
     (Point 475 410)
     (Point 490 410)
     (Point 490 480)
     (Point 270 480)
     (Point 270 610)
     (Point 278 610)
    )
    (connect D7:1 D10:2
     (Point 187 400)
     (Point 260 400)
     (Point 260 370)
     (Point 380 370)
     (Point 380 470)
     (Point 260 470)
     (Point 260 620)
     (Point 278 620)
    )
    (connect D7:2 D10:3
     (Point 187 410)
     (Point 250 410)
     (Point 250 630)
     (Point 278 630)
    )
    (connect D7:3 D10:4
     (Point 187 420)
     (Point 240 420)
     (Point 240 640)
     (Point 278 640)
    )
    (connect D9:1 D10:5
     (Point 195 650)
     (Point 278 650)
    )
    (connect D10:1 D11:1
     (Point 361 630)
     (Point 382 630)
    )
    (connect D5:0 D13:0
     (Point 100 183)
     (Point 100 195)
    )
    (connect D17:1 D14:1
     (Point 184 320)
     (Point 220 320)
    )
    (connect D13:1 D15:1
     (Point 141 230)
     (Point 160 230)
     (Point 160 270)
     (Point 182 270)
    )
    (connect D13:1 D16:1
     (Point 141 230)
     (Point 160 230)
     (Point 160 210)
     (Point 360 210)
     (Point 360 270)
     (Point 414 270)
    )
    (connect D14:1 D16:2
     (Point 379 310)
     (Point 400 310)
     (Point 400 290)
     (Point 414 290)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
