#! /usr/lib/veetest/veetest -r
(revision "A.00.00")
(date "Tue 02/Apr/1991")
(component 0 "Context"
 (name "HP VEE - multiplex.ex")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "EnumConstant"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Enum
     (name "Enum")
     (values
      ( "FIRST VALUE" 0)
      ( "SECOND VALUE" 1)
     )
     (datum "FIRST VALUE")
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Enum
     (shared yes)
     (datum "FIRST VALUE")
    )
   )
   (views
    (icon
    )
    (detail
     (origin 56 390)
     (extent 169 60)
     (format buttons)
    )
    (active detail)
   )
  )
  (component 1 "Constant"
   (name "Real")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Real")
     (datum 1234)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
    )
    (detail
     (origin 80 516)
     (extent 120 28)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 2 "Constant"
   (name "Real")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Real")
     (datum 4567)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
    )
    (detail
     (origin 80 606)
     (extent 120 28)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 3 "TextDisplay"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
    )
    (detail
     (origin 505 443)
     (extent 190 35)
    )
    (active detail)
   )
  )
  (component 4 "RepeatUntilBreak"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (description 11 5
     The Until Break object is used in this application
     to allow the Enum to output the enum value that
     corresponds to the button selection.  If no other
     threads are running (the RUN button has not been
     pressed), the Autoexecute mode of the Enum is
     sufficient to operate the model.  However, since
     AutoExecute is inoperative when other threads are
     running, the Until Break object guarantees that
     the output values are continually sent to the
     multiplex object, where it is used to pass one of
     the data values to the display.
    )
    (icon
     (origin 5 248)
     (extent 110 64)
     (iconImage loop.icon)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "Formula"
   (name "Multiplex")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Address")
     (optional yes)
    )
    (input 2
     (type data)
     (name "A")
     (optional yes)
    )
    (input 3
     (type data)
     (name "B")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "(ordinal(Address) ? B : A)")
   )
   (views
    (description 21 5
     The Address input can be supplied with either an
     Enum type or a number.  If the number is 0 or the
     the Enum type is the First in the list, the "A"
     input is passed through to the Result Output.  If
     the number is non-zero or the Enum is other than
     the first list value, the "B" input is passed to
     the output.
     
     A typical use would be to have a Toggle (0 or 1)
     or an Enum (Data A, Data B) select which data
     value to feed to a device.  Using the Formula
     object with the "c" language ?: construct allows
     a concise method that requires neither Junction,
     Gate, nor If-Then objects.  Note that the entire
     express is enclosed in parenthesis!
     
     The ordinal() function, found under the Math Real
     Part menu, converts an Enum to the number that
     represents the order of the Enum value in the
     list.  If given a non-Enum value, it acts like a
     no-operation.
    )
    (icon
     (origin 355 443)
     (extent 110 34)
    )
    (detail
     (origin 258 236)
     (extent 254 129)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "Note"
   (name "To Operate:")
   (interface
   )
   (implementation
    (component text 3 5
     Use the Enum to select one
     of the values to be sent to
     the AlphaNumeric display.
    )
   )
   (views
    (icon
     (extent 110 0)
     (iconImage notepad.icon)
    )
    (detail
     (origin 266 284)
     (extent 269 72)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 7 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 352 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 8 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "RepeatUntilBreak"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 115 268)
       (extent 110 64)
       (iconImage loop.icon)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Note"
       (name "NotePad")
       (interface
       )
       (implementation
        (component text 10 9
         PURPOSE:     Demonstrate use of a "Formula" object as a Multiplexor object.
         
         USER INPUT REQUIRED:  Select desired data value from the "Enum" object and observe
                      that value on the alphanumeric display.
         
         EXPLANATION: The Multiplex device, built from a "Formula" object, uses the Address
                      input to select either the A or the B data input to be passed through
                      to the output.  A detailed description of the Multiplexor is provided
                      in its Show Description menu.
         
        )
       )
       (views
        (description 2 9
         This notepad is displayed as a Show on Execute
         panel to present the information to the reader.
        )
        (icon
         (origin 160 205)
         (extent 78 25)
        )
        (detail
         (origin 36 162)
         (extent 848 437)
         (editing enabled)
        )
        (active icon)
       )
      )
      (component 1 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (description 7 9
         This tiny "thread" begins running when the 
         enclosing UserObject is executed.  When the user
         acknowledges the OK/DONE button, there is nothing
         left to execute, so the thread ends.  Since there
         are not other threads running, the User Object
         is completed and will exit, removing the Show on
         Execute pop-up display.
        )
        (icon
         (origin 171 272)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 55 78)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 detail
         (title off)
         (origin 51 176)
         (extent 816 465)
         (editing disabled)
        )
        (widget 1 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:1 D1:0)
     (connect D3:0 D1:1)
     (connect D0:1 D3:0)
    )
   )
   (views
    (icon
     (origin 175 368)
     (extent 110 25)
    )
    (panel
     (origin 11 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 113 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:1 D1:0
       (Point 227 300)
       (Point 258 300)
       (Point 258 340)
      )
      (connect D3:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D3:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D4:1 D0:0)
   (connect D0:0 D1:0)
   (connect D1:0 D2:0)
   (connect D5:1 D3:1)
   (connect D0:1 D5:1)
   (connect D1:1 D5:2)
   (connect D2:1 D5:3)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 1002 656)
   (configuration
    (connect D4:1 D0:0
     (Point 117 280)
     (Point 140 280)
     (Point 140 357)
    )
    (connect D0:0 D1:0
     (Point 140 452)
     (Point 140 483)
    )
    (connect D1:0 D2:0
     (Point 140 546)
     (Point 140 573)
    )
    (connect D5:1 D3:1
     (Point 467 460)
     (Point 502 460)
    )
    (connect D0:1 D5:1
     (Point 227 420)
     (Point 250 420)
     (Point 250 450)
     (Point 352 450)
    )
    (connect D1:1 D5:2
     (Point 202 530)
     (Point 250 530)
     (Point 250 460)
     (Point 352 460)
    )
    (connect D2:1 D5:3
     (Point 202 620)
     (Point 260 620)
     (Point 260 470)
     (Point 352 470)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
