#! /usr/lib/veetest/veetest -r
(revision "A.00.00")
(date "Tue 02/Apr/1991")
(component 0 "Context"
 (name "Importing An Array From a Text File")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 562 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 1 "Note"
   (name "Info About")
   (interface
   )
   (implementation
    (component text 29 5
     Overview:
     This model illustrates one way to import an array of
     numeric data from a text file.  In this case, the
     array is always one- or two-dimensional, but the size
     of each dimension is not known.
     
     Details:
     To run this model, your HP-UX system must include the
     awk shell command.
     
     To run this model, simply press "Start" or "Run".
     
     This is how the model works:
     
     The "Array File" name is concatenated with an awk
     command.  Awk is a HP-UX command that is useful for
     processing text files.  In this case, the awk command
     passed to "HP-UX Escape" reports the number of fields 
     (whitespace separated columns) and records (rows 
     separated by newlines) in the text file.  This row and
     column information is passed to "From File" which reads
     the specified number of elements, building the array
     as it goes.
     
     This approach relies on two important assumptions:
     
        * The array is one- or two-dimensional.
     
        * There are no missing elements.
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 8 120)
     (extent 525 221)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 2 "LiteralConstant"
   (name "awk command")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "awk command")
     (datum "awk \'{if(NR==1) print NF}END{print NR}\' ")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (origin 65 368)
     (extent 110 25)
    )
    (detail
     (origin 74 400)
     (extent 452 60)
    )
    (active icon)
   )
  )
  (component 3 "Formula"
   (name " + ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X+Y")
   )
   (views
    (icon
     (origin 217 388)
     (extent 46 25)
    )
    (detail
     (origin 270 115)
     (extent 70 110)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "LiteralConstant"
   (name "Array File")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Array File")
     (datum "/usr/lib/veetest/examples/concepts/io_txtin3.dat")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (origin 65 408)
     (extent 110 25)
    )
    (detail
     (origin 144 496)
     (extent 273 28)
    )
    (active icon)
   )
  )
  (component 5 "Start"
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 347 352)
     (extent 67 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "ShellEscape"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Command")
     (tag "Command")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Exit code")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "rows")
     (lock constraints)
     (optional yes)
    )
    (output 3
     (type data)
     (name "cols")
     (lock constraints)
     (optional yes)
    )
    (buffers in
     (buffer "Command")
    )
   )
   (implementation
    (attr iopath pipe read "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath pipe write "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      READ TEXT cols,rows REAL COUNT:1
    )
    (component shell "none")
    (component command "awk \'{if(NR==1) print NF}END{print NR}\' /usr/lib/veetest/examples/concepts/io_txtin3.dat")
    (component deathWait "Yes")
   )
   (views
    (icon
     (origin 321 408)
     (extent 118 64)
     (iconImage c.icon)
    )
    (detail
     (origin 81 375)
     (extent 978 171)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "TextDisplay"
   (name "Rows")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 46 0)
    )
    (detail
     (origin 555 373)
     (extent 190 35)
    )
    (active detail)
   )
  )
  (component 8 "TextDisplay"
   (name "Columns")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 161 478)
     (extent 78 25)
    )
    (detail
     (origin 555 453)
     (extent 190 35)
    )
    (active detail)
   )
  )
  (component 9 "FromFile"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "rows")
     (tag "rows")
     (optional yes)
    )
    (input 2
     (type data)
     (name "cols")
     (tag "cols")
     (optional yes)
    )
    (input 3
     (type control)
     (name "File Name")
     (tag "File Name")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (lock name constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath file read "/usr/lib/veetest/examples/concepts/io_txtin3.dat"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      READ TEXT x REAL COUNT:rows,cols
    )
   )
   (views
    (icon
     (origin 275 178)
     (extent 110 25)
    )
    (detail
     (origin 213 543)
     (extent 325 154)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 10 "TextDisplay"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 721 478)
     (extent 118 25)
    )
    (detail
     (origin 768 353)
     (extent 325 295)
    )
    (active detail)
   )
  )
  (configuration
   (connect D2:1 D3:1)
   (connect D4:1 D3:2)
   (connect D5:0 D6:0)
   (connect D3:1 D6:1)
   (connect D6:2 D7:1)
   (connect D6:3 D8:1)
   (connect D6:2 D9:1)
   (connect D6:3 D9:2)
   (connect D4:1 D9:3)
   (connect D9:1 D10:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 1250 911)
   (configuration
    (connect D2:1 D3:1
     (Point 177 380)
     (Point 190 380)
     (Point 190 390)
     (Point 214 390)
    )
    (connect D4:1 D3:2
     (Point 177 420)
     (Point 190 420)
     (Point 190 410)
     (Point 214 410)
    )
    (connect D5:0 D6:0
     (Point 380 391)
     (Point 380 405)
    )
    (connect D3:1 D6:1
     (Point 265 400)
     (Point 280 400)
     (Point 280 440)
     (Point 318 440)
    )
    (connect D6:2 D7:1
     (Point 441 440)
     (Point 460 440)
     (Point 460 390)
     (Point 552 390)
    )
    (connect D6:3 D8:1
     (Point 441 460)
     (Point 460 460)
     (Point 460 470)
     (Point 552 470)
    )
    (connect D6:2 D9:1
     (Point 441 440)
     (Point 470 440)
     (Point 470 490)
     (Point 100 490)
     (Point 100 570)
     (Point 110 570)
    )
    (connect D6:3 D9:2
     (Point 441 460)
     (Point 460 460)
     (Point 460 480)
     (Point 80 480)
     (Point 80 620)
     (Point 110 620)
    )
    (connect D4:1 D9:3
     (Point 177 420)
     (Point 190 420)
     (Point 190 450)
     (Point 90 450)
     (Point 90 670)
     (Point 110 670)
    )
    (connect D9:1 D10:1
     (Point 570 620)
     (Point 750 620)
     (Point 750 500)
     (Point 765 500)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
