#! /usr/lib/veetest/veetest -r
(revision "A.00.00")
(date "Thu 04/Apr/1991")
(component 0 "Context"
 (name "Feedback1 Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Start"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 56 307)
     (extent 69 39)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 1 "Formula"
   (name ".5*z1")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "z1")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 ".5*z1")
   )
   (views
    (icon
     (origin 381 344)
     (extent 78 25)
    )
    (detail
     (origin 377 108)
     (extent 79 204)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "Formula"
   (name " + ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X+Y")
   )
   (views
    (icon
     (origin 477 354)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "ForCount"
   (name "For Count")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component count 256)
   )
   (views
    (icon
     (iconImage loop.icon)
    )
    (detail
     (origin 8 459)
     (extent 165 34)
    )
    (active detail)
   )
  )
  (component 4 "Formula"
   (name ".5")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 ".5*a")
   )
   (views
    (icon
     (origin 547 354)
     (extent 46 25)
    )
    (detail
     (origin 557 193)
     (extent 79 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "VFunctionGenerator"
   (name "Square Wave")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component function Square)
    (component frequency 50)
    (component amplitude 1)
    (component dcOffset 0)
    (component phaseShift 180)
    (component numPoints 256)
    (component interval 0.02)
    (component degRad Deg)
    (component errorOnAlias 1)
   )
   (views
    (icon
     (origin 35 514)
     (extent 110 64)
     (iconImage virtual.icon)
    )
    (detail
     (origin 29 271)
     (extent 239 198)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "FromWaveform"
   (name "UnBuild Waveform")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Wf Data")
     (requires
      (datatype Waveform)
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Real Ary")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Interval")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 173 514)
     (extent 154 64)
     (iconImage unbuild.icon)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "Formula"
   (name "x(n)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "b[a]")
   )
   (views
    (icon
     (origin 377 474)
     (extent 46 25)
    )
    (detail
     (origin 457 318)
     (extent 79 104)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "YPlot"
   (name "one pole IIR filter")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "filtered")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "original")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 1)
    (component tracePin 2)
    (component graphMode rectangular)
   )
   (views
    (icon
     (extent 181 0)
     (iconImage display.icon)
    )
    (detail
     (origin 624 244)
     (extent 352 324)
     (displayMode scrollGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "y(n)")
      (domainName "n")
      (color 0x909090)
      (show 1)
      (range 0.75 1.05 3 linear)
     )
     (domain 125 140 3 linear)
     (trace 0 onScale 0
      (name "filtered")
      (color 0xffdd00)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "original")
      (color 0xccff)
      (lineType 1)
      (pointType 0)
     )
    )
    (active detail)
   )
  )
  (component 9 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 495 500)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 331 493)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About...")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 560 549)
         (extent 58 37)
        )
        (detail
         (origin 466 633)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "Overview of Feedback Example")
       (interface
       )
       (implementation
        (component text 24 9
         Purpose:
         This example illustrates feedback and how it can be used to implement a simple one-pole 
         IIR digital filter.
         
         User Input Required: none
         
         Explanation;
         The For Count, Function Generator (labeled Square Wave), UnBuild Waveform, and Formula
         (labeled x(n)) generates the sequence of numbers to be filtered.
         
         In general, the construction of digital filters involves storing previous values.  A one
         pole filter only needs one previous value of the output.  VEE provides a Shift Register
         which can maintain an arbitrary number of previous values.  How many are kept depends on
         the number of outputs added.
         
         At first glance, you might think the "1 Prev" output of the Shift Register should be
         used.  When feedback is used in VEE model, execution around the loop is done once and
         only once for each iteration.  Otherwise, infinite loops would be too easy to build.  
         This property, though, means a delay of one interaction is always present when feedback 
         is used.  Thus, this example show the Current output being used.  Actually, the Shift 
         Register is not needed for this simple filer as the feedback path could be connected
         directly to the formula box.
         
         The display shows how the edge of the square wave is smoothed by the low pass filter.
        )
       )
       (views
        (icon
         (origin 449 488)
         (extent 262 25)
        )
        (detail
         (origin 75 517)
         (extent 570 306)
         (editing enabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 86 135)
       (extent 849 571)
       (panel
        (origin 198 314)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 597 798)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 203 319)
         (extent 835 465)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 557 568)
       (extent 127 25)
      )
      (detail
       (origin 435 470)
       (extent 351 200)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 435 388)
     (extent 110 25)
    )
    (panel
     (origin 31 112)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 133 125)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 174 265)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 447 512)
       (Point 492 512)
      )
      (connect D2:0 D1:1
       (Point 620 595)
       (Point 620 610)
       (Point 310 610)
       (Point 310 512)
       (Point 328 512)
      )
      (connect D0:1 D2:0
       (Point 543 502)
       (Point 620 502)
       (Point 620 565)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 10 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 402 109)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 11 "ShiftRegister"
   (name "Shift Register")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
    (output 1
     (type data)
     (name "Current")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "1 Prev")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 190 328)
     (extent 143 96)
    )
    (detail
     (origin 203 344)
     (extent 87 64)
    )
    (terminals on)
    (active detail)
   )
  )
  (configuration
   (connect D11:1 D1:1)
   (connect D1:1 D2:1)
   (connect D7:1 D2:2)
   (connect D0:0 D3:0)
   (connect D2:1 D4:1)
   (connect D5:1 D6:1)
   (connect D3:1 D7:1)
   (connect D6:1 D7:2)
   (connect D4:1 D8:1)
   (connect D7:1 D8:2)
   (connect D2:1 D11:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 1191 776)
   (configuration
    (connect D11:1 D1:1
     (Point 372 356)
     (Point 372 356)
     (Point 372 356)
     (Point 378 356)
    )
    (connect D1:1 D2:1
     (Point 461 356)
     (Point 474 356)
    )
    (connect D7:1 D2:2
     (Point 425 486)
     (Point 460 486)
     (Point 460 376)
     (Point 474 376)
    )
    (connect D0:0 D3:0
     (Point 90 348)
     (Point 90 426)
    )
    (connect D2:1 D4:1
     (Point 525 366)
     (Point 544 366)
    )
    (connect D5:1 D6:1
     (Point 147 546)
     (Point 170 546)
    )
    (connect D3:1 D7:1
     (Point 175 476)
     (Point 374 476)
    )
    (connect D6:1 D7:2
     (Point 329 526)
     (Point 340 526)
     (Point 340 496)
     (Point 374 496)
    )
    (connect D4:1 D8:1
     (Point 595 366)
     (Point 610 366)
     (Point 610 326)
     (Point 621 326)
    )
    (connect D7:1 D8:2
     (Point 425 486)
     (Point 621 486)
    )
    (connect D2:1 D11:1
     (Point 525 366)
     (Point 525 296)
     (Point 140 296)
     (Point 140 376)
     (Point 150 376)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
