#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Tue 17/Sep/1991")
(component 0 "Context"
 (name "Comparative Bar Chart")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Context"
   (name "Generate Data")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Result")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Context"
     (name "100 random #s")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Array")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Collector"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (tag "Data")
        )
        (input 2
         (type trigger)
         (name "XEQ")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
       )
       (implementation
        (component clearAtPrerun 1)
        (component clearAtActivate 1)
       )
       (views
        (icon
         (origin 280 248)
         (extent 110 25)
        )
        (detail
         (origin 265 455)
         (extent 60 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "RandomNumber"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Rand Val")
         (lock name constraints)
        )
       )
       (implementation
        (component lowerLimit 0)
        (component upperLimit 1)
       )
       (views
        (icon
         (origin 107 258)
         (extent 127 25)
        )
        (detail
         (origin 109 410)
         (extent 222 60)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "ForCount"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Count")
         (lock name constraints)
        )
       )
       (implementation
        (component count 100)
       )
       (views
        (icon
         (origin 90 168)
         (extent 110 64)
         (iconImage "loop.icon")
        )
        (detail
         (origin 60 183)
         (extent 170 34)
        )
        (active detail)
       )
      )
      (configuration
       (connect D1:1 D0:1)
       (connect D2:0 D0:2)
       (connect D2:1 D1:0)
       (connect D0:1 O1:1)
      )
     )
     (views
      (icon
       (origin 25 285)
       (extent 127 25)
      )
      (detail
       (origin 31 130)
       (extent 388 200)
       (configuration
        (connect D1:1 D0:1
         (Point 236 270)
         (Point 250 270)
         (Point 250 250)
         (Point 277 250)
        )
        (connect D2:0 D0:2
         (Point 145 219)
         (Point 145 240)
         (Point 85 240)
         (Point 85 300)
         (Point 255 300)
         (Point 255 270)
         (Point 277 270)
        )
        (connect D2:1 D1:0
         (Point 232 200)
         (Point 250 200)
         (Point 250 240)
         (Point 170 240)
         (Point 170 255)
        )
        (connect D0:1 O1:1
         (Point 392 260)
         (Point 416 240)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Context"
     (name "100 random #s")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Array")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Collector"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (tag "Data")
        )
        (input 2
         (type trigger)
         (name "XEQ")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
       )
       (implementation
        (component clearAtPrerun 1)
        (component clearAtActivate 1)
       )
       (views
        (icon
         (origin 280 248)
         (extent 110 25)
        )
        (detail
         (origin 265 455)
         (extent 60 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "RandomNumber"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Rand Val")
         (lock name constraints)
        )
       )
       (implementation
        (component lowerLimit 0)
        (component upperLimit 1)
       )
       (views
        (icon
         (origin 107 258)
         (extent 127 25)
        )
        (detail
         (origin 109 410)
         (extent 222 60)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "ForCount"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Count")
         (lock name constraints)
        )
       )
       (implementation
        (component count 100)
       )
       (views
        (icon
         (origin 90 168)
         (extent 110 64)
         (iconImage "loop.icon")
        )
        (detail
         (origin 60 183)
         (extent 170 34)
        )
        (active detail)
       )
      )
      (configuration
       (connect D1:1 D0:1)
       (connect D2:0 D0:2)
       (connect D2:1 D1:0)
       (connect D0:1 O1:1)
      )
     )
     (views
      (icon
       (origin 5 395)
       (extent 127 25)
      )
      (detail
       (origin 31 130)
       (extent 388 200)
       (configuration
        (connect D1:1 D0:1
         (Point 236 270)
         (Point 250 270)
         (Point 250 250)
         (Point 277 250)
        )
        (connect D2:0 D0:2
         (Point 145 219)
         (Point 145 240)
         (Point 85 240)
         (Point 85 300)
         (Point 255 300)
         (Point 255 270)
         (Point 277 270)
        )
        (connect D2:1 D1:0
         (Point 232 200)
         (Point 250 200)
         (Point 250 240)
         (Point 170 240)
         (Point 170 255)
        )
        (connect D0:1 O1:1
         (Point 392 260)
         (Point 416 240)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Formula"
     (name "magDist()")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "From")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "Thru")
       (lock name constraints)
      )
      (input 4
       (type data)
       (name "Step")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "magDist(x,from,thru,step)")
     )
     (views
      (icon
       (origin 203 355)
       (extent 110 45)
      )
      (detail
       (origin 421 305)
       (extent 259 210)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Formula"
     (name "magDist()")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "From")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "Thru")
       (lock name constraints)
      )
      (input 4
       (type data)
       (name "Step")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "magDist(x,from,thru,step)")
     )
     (views
      (icon
       (origin 203 455)
       (extent 110 45)
      )
      (detail
       (origin 421 305)
       (extent 259 210)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "Constant"
     (name "Low Lim")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Low Lim")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 78 0)
      )
      (detail
       (origin 3 354)
       (extent 130 27)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 5 "Constant"
     (name "High Lim")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "High Lim")
       (datum 1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 0 463)
       (extent 137 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 6 "Constant"
     (name "step")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "step")
       (datum 0.1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 487 708)
       (extent 46 25)
      )
      (detail
       (origin 7 533)
       (extent 122 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (configuration
     (connect D0:1 D2:1)
     (connect D4:1 D2:2)
     (connect D5:1 D2:3)
     (connect D6:1 D2:4)
     (connect D1:1 D3:1)
     (connect D4:1 D3:2)
     (connect D5:1 D3:3)
     (connect D6:1 D3:4)
     (connect D2:1 O1:1)
     (connect D3:1 O2:1)
    )
   )
   (views
    (icon
     (origin 127 348)
     (extent 127 25)
    )
    (detail
     (origin 14 273)
     (extent 332 294)
     (configuration
      (connect D0:1 D2:1
       (Point 154 297)
       (Point 168 297)
       (Point 168 357)
       (Point 200 357)
      )
      (connect D4:1 D2:2
       (Point 135 367)
       (Point 200 367)
      )
      (connect D5:1 D2:3
       (Point 139 477)
       (Point 168 477)
       (Point 168 377)
       (Point 200 377)
      )
      (connect D6:1 D2:4
       (Point 131 547)
       (Point 158 547)
       (Point 158 497)
       (Point 208 497)
       (Point 208 437)
       (Point 188 437)
       (Point 188 387)
       (Point 200 387)
      )
      (connect D1:1 D3:1
       (Point 134 407)
       (Point 158 407)
       (Point 158 457)
       (Point 200 457)
      )
      (connect D4:1 D3:2
       (Point 135 367)
       (Point 178 367)
       (Point 178 467)
       (Point 200 467)
      )
      (connect D5:1 D3:3
       (Point 139 477)
       (Point 200 477)
      )
      (connect D6:1 D3:4
       (Point 131 547)
       (Point 158 547)
       (Point 158 487)
       (Point 200 487)
      )
      (connect D2:1 O1:1
       (Point 315 377)
       (Point 327 377)
       (Point 327 350)
       (Point 343 350)
      )
      (connect D3:1 O2:1
       (Point 315 477)
       (Point 327 477)
       (Point 327 510)
       (Point 343 510)
      )
     )
    )
    (active detail)
   )
  )
  (component 1 "Context"
   (name "Comparative Bars")
   (description 34 4
    Generates and displays a comparative bar chart
    using two 1-D arrays of input data.  The number
    of bars is equal to the number of array elements
    (arrays must be same size), and the "length" of
    each bar is set by the corresponding element data,
    which may be a positive or negative real or int32
    number.  Each corresponding input array element
    generates a pair of different-colored adjacent
    bars. 
    
    The display is autoscaled after plotting the bars
    using the maximum and minumum array data values
    and the number of bars.
    
    Display and trace labels, bar color, grid type,
    etc. can be set by clicking the Right Button on
    the display area and selecting the "Traces and
    Scales" entry from the resulting menu.  The gap
    between bars can be set using the "Spacing" box
    in the Bar Chart Detail view.
    
    If the bars appear to have black vertical lines,
    the number of fill strokes can be increased, at
    the expense of drawing speed, by reducing the
    Density in the Detail view of the FillBarMux
    object.
    
    It may prove useful to Secure the BarChart User
    Object after customizing, since this eliminates
    the Panel/Detail buttons and some menu selections
    that are no longer needed.  Be sure to save the
    unsecured object so you can make changes at a
    later date, however. 
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "First")
     (requires
      (shape "Array 1D")
     )
     (optional yes)
    )
    (input 2
     (type data)
     (name "Second")
     (requires
      (shape "Array 1D")
     )
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "YPlot"
     (name "XY Trace")
     (subType "XY_Trace")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Trace1")
       (lock constraints)
      )
      (input 2
       (type data)
       (name "Trace2")
       (lock constraints)
       (optional yes)
      )
      (input 3
       (type control)
       (name "Auto Scale")
       (lock name constraints)
       (optional yes)
      )
      (input 4
       (type control)
       (name "Next Curve")
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
      (component tracePin 1)
      (component tracePin 2)
      (component graphMode rectangular)
     )
     (views
      (icon
       (iconImage "display.icon")
      )
      (detail
       (origin 720 144)
       (extent 280 253)
       (displayMode scrollGraph)
       (graphType cartesian)
       (gridType frame)
       (scale 0
        (name "Y name")
        (domainName "X name")
        (pen 9)
        (show 1)
        (range 0 18 4 linear)
       )
       (domain 0 10 4 linear)
       (trace 0 onScale 0
        (name "Trace1")
        (pen 7)
        (lineType 1)
        (pointType 0)
       )
       (trace 1 onScale 0
        (name "Trace2")
        (pen 2)
        (lineType 1)
        (pointType 0)
       )
      )
      (active detail)
     )
    )
    (component 1 "Context"
     (name "BarFillMux")
     (description 16 6
      This Library Object generates a serpentine bar
      fill pattern and places the output on one of two
      selected output pins.  The other output produces
      an empty bar, since a Display device needs some
      data on each input pin before it will execute and
      show the data. 
      
      The BarFillMux object uses the techniques found in
      the BarFill library object to produce an array of
      coord data points needed to fill a bar.  It adds
      a "TraceNo" input to determine which output pin
      receives the bar data and which receives the empty
      bar; zero outputs the bar on Trace 1, non-zero on
      Trace 2.  Note that the "other" trace has a bar of
      height (a thin horizontal line is drawn).
      
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X-Start")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (optional yes)
      )
      (input 2
       (type data)
       (name "X-End")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (optional yes)
      )
      (input 3
       (type data)
       (name "Y-Max")
       (optional yes)
      )
      (input 4
       (type data)
       (name "Y-Min")
       (optional yes)
      )
      (input 5
       (type data)
       (name "TraceNo")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Trace1")
       (lock constraints)
       (optional yes)
      )
      (output 2
       (type data)
       (name "Trace2")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Formula"
       (name "NumPts")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "TraceNo")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "(TraceNo ? A : A[0])")
       )
       (views
        (icon
         (origin 581 418)
         (extent 78 25)
        )
        (detail
         (origin 508 318)
         (extent 214 104)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Formula"
       (name "NumPts")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "TraceNo")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "( NOT TraceNo ? A : A[0])")
       )
       (views
        (icon
         (origin 581 368)
         (extent 78 25)
        )
        (detail
         (origin 486 278)
         (extent 259 104)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "AllocateArray"
       (name "Alloc Real")
       (subType "Alloc_Real")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Init Value")
         (tag "Init Value")
         (requires
          (datatype Real)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (input 2
         (type data)
         (name "Dim Size 1")
         (tag "Dim Size 1")
         (requires
          (datatype Int32)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
        (buffers in
         (buffer "Init Value")
         (buffer "Dim Size 1")
        )
       )
       (implementation
        (component numDims 1)
        (component dimSizes "9")
        (component type "Real")
        (component initEnum "Init Value")
        (component initialValue
         (name "Init Value")
         (datum 0)
        )
        (component from 1)
        (component thru 10)
       )
       (views
        (icon
         (origin 375 418)
         (extent 110 25)
        )
        (detail
         (origin 286 525)
         (extent 229 111)
        )
        (active icon)
       )
      )
      (component 3 "AllocateArray"
       (name "Alloc Real")
       (subType "Alloc_Real")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Init Value")
         (tag "Init Value")
         (requires
          (datatype Real)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (input 2
         (type data)
         (name "Dim Size 1")
         (tag "Dim Size 1")
         (requires
          (datatype Int32)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
        (buffers in
         (buffer "Init Value")
         (buffer "Dim Size 1")
        )
       )
       (implementation
        (component numDims 1)
        (component dimSizes "9")
        (component type "Real")
        (component initEnum "Init Value")
        (component initialValue
         (name "Init Value")
         (datum 5)
        )
        (component from 1)
        (component thru 10)
       )
       (views
        (icon
         (origin 375 378)
         (extent 110 25)
        )
        (detail
         (origin 46 305)
         (extent 229 111)
        )
        (active icon)
       )
      )
      (component 4 "Formula"
       (name "Generate Y values")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "B")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "concat(transpose([b a a b]),b[0])")
       )
       (views
        (icon
         (origin 359 308)
         (extent 163 25)
        )
        (detail
         (origin 275 563)
         (extent 340 154)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 5 "Constant"
       (name "Density")
       (subType "Real")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Real")
         (lock name constraints)
        )
       )
       (implementation
        (component value Real
         (name "Density")
         (datum 0.03)
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Real
         (datum 0)
        )
       )
       (views
        (icon
         (origin 211 338)
         (extent 78 25)
        )
        (detail
         (origin 157 364)
         (extent 147 32)
         (showFormat real)
        )
        (active icon)
       )
      )
      (component 6 "Formula"
       (name "Duplicate each X element")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "B")
         (optional yes)
        )
        (input 3
         (type data)
         (name "n")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "concat(transpose([ramp(2*n,a,b) ramp(2*n,a,b)]),b)")
       )
       (views
        (icon
         (origin 297 253)
         (extent 226 34)
        )
        (detail
         (origin 93 353)
         (extent 484 154)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 7 "ToCoordinate"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X Data")
         (tag "X")
         (requires
          (datatype Real)
         )
         (lock constraints)
        )
        (input 2
         (type data)
         (name "Y Data")
         (tag "Y")
         (requires
          (datatype Real)
         )
         (lock constraints)
        )
        (output 1
         (type data)
         (name "Coord")
         (tag "Coord")
         (lock constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 545 268)
         (extent 110 25)
        )
        (detail
         (origin 510 175)
         (extent 50 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 8 "Formula"
       (name "NumPts")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "B")
         (optional yes)
        )
        (input 3
         (type data)
         (name "Density")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "intPart((b-a)/Density)")
       )
       (views
        (icon
         (origin 211 293)
         (extent 78 34)
        )
        (detail
         (origin 166 151)
         (extent 219 119)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 9 "Formula"
       (name " + ")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (lock name constraints)
        )
        (input 2
         (type data)
         (name "Y")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked yes)
        (component expr 1 "X+Y")
       )
       (views
        (icon
         (origin 187 368)
         (extent 46 25)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
       (connect D7:1 D0:1)
       (connect I5:1 D0:2)
       (connect D7:1 D1:1)
       (connect I5:1 D1:2)
       (connect I4:1 D2:1)
       (connect D8:1 D2:2)
       (connect D9:1 D3:1)
       (connect D8:1 D3:2)
       (connect D3:1 D4:1)
       (connect D2:1 D4:2)
       (connect I1:1 D6:1)
       (connect I2:1 D6:2)
       (connect D8:1 D6:3)
       (connect D6:1 D7:1)
       (connect D4:1 D7:2)
       (connect I1:1 D8:1)
       (connect I2:1 D8:2)
       (connect D5:1 D8:3)
       (connect I3:1 D9:1)
       (connect I4:1 D9:2)
       (connect D1:1 O1:1)
       (connect D0:1 O2:1)
      )
     )
     (views
      (icon
       (origin 565 148)
       (extent 110 65)
      )
      (panel
       (origin 350 255)
       (extent 170 231)
       (widget 5 detail
        (title on)
        (origin 360 311)
        (extent 147 32)
        (showFormat real)
       )
      )
      (detail
       (origin 154 245)
       (extent 542 230)
       (configuration
        (connect D7:1 D0:1
         (Point 657 280)
         (Point 670 280)
         (Point 670 310)
         (Point 570 310)
         (Point 570 370)
         (Point 560 370)
         (Point 560 420)
         (Point 578 420)
        )
        (connect I5:1 D0:2
         (Point 156 470)
         (Point 170 470)
         (Point 170 460)
         (Point 500 460)
         (Point 500 440)
         (Point 578 440)
        )
        (connect D7:1 D1:1
         (Point 657 280)
         (Point 670 280)
         (Point 670 310)
         (Point 570 310)
         (Point 570 370)
         (Point 578 370)
        )
        (connect I5:1 D1:2
         (Point 156 470)
         (Point 170 470)
         (Point 170 460)
         (Point 500 460)
         (Point 500 440)
         (Point 550 440)
         (Point 550 390)
         (Point 578 390)
        )
        (connect I4:1 D2:1
         (Point 156 420)
         (Point 372 420)
        )
        (connect D8:1 D2:2
         (Point 291 310)
         (Point 320 310)
         (Point 320 400)
         (Point 340 400)
         (Point 340 440)
         (Point 372 440)
        )
        (connect D9:1 D3:1
         (Point 235 380)
         (Point 372 380)
        )
        (connect D8:1 D3:2
         (Point 291 310)
         (Point 320 310)
         (Point 320 400)
         (Point 372 400)
        )
        (connect D3:1 D4:1
         (Point 487 390)
         (Point 500 390)
         (Point 500 360)
         (Point 340 360)
         (Point 340 310)
         (Point 356 310)
        )
        (connect D2:1 D4:2
         (Point 487 430)
         (Point 510 430)
         (Point 510 350)
         (Point 350 350)
         (Point 350 330)
         (Point 356 330)
        )
        (connect I1:1 D6:1
         (Point 156 270)
         (Point 170 270)
         (Point 170 260)
         (Point 294 260)
        )
        (connect I2:1 D6:2
         (Point 156 320)
         (Point 170 320)
         (Point 170 310)
         (Point 190 310)
         (Point 190 270)
         (Point 294 270)
        )
        (connect D8:1 D6:3
         (Point 291 310)
         (Point 300 310)
         (Point 300 300)
         (Point 280 300)
         (Point 280 280)
         (Point 294 280)
        )
        (connect D6:1 D7:1
         (Point 525 270)
         (Point 542 270)
        )
        (connect D4:1 D7:2
         (Point 524 320)
         (Point 530 320)
         (Point 530 290)
         (Point 542 290)
        )
        (connect I1:1 D8:1
         (Point 156 270)
         (Point 170 270)
         (Point 170 300)
         (Point 208 300)
        )
        (connect I2:1 D8:2
         (Point 156 320)
         (Point 170 320)
         (Point 170 310)
         (Point 208 310)
        )
        (connect D5:1 D8:3
         (Point 291 350)
         (Point 310 350)
         (Point 310 410)
         (Point 190 410)
         (Point 190 320)
         (Point 208 320)
        )
        (connect I3:1 D9:1
         (Point 156 370)
         (Point 184 370)
        )
        (connect I4:1 D9:2
         (Point 156 420)
         (Point 170 420)
         (Point 170 390)
         (Point 184 390)
        )
        (connect D1:1 O1:1
         (Point 661 380)
         (Point 680 380)
         (Point 680 310)
         (Point 693 310)
        )
        (connect D0:1 O2:1
         (Point 661 430)
         (Point 693 430)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "HalfBarSize")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "First")
       (optional yes)
      )
      (input 2
       (type data)
       (name "Second")
       (optional yes)
      )
      (input 3
       (type data)
       (name "BarNo")
       (optional yes)
      )
      (input 4
       (type data)
       (name "Half")
       (optional yes)
      )
      (input 5
       (type data)
       (name "Gap")
       (optional yes)
      )
      (output 1
       (type data)
       (name "X-Start")
       (lock constraints)
       (optional yes)
      )
      (output 2
       (type data)
       (name "X-Stop")
       (lock constraints)
       (optional yes)
      )
      (output 3
       (type data)
       (name "Y-Max")
       (lock constraints)
       (optional yes)
      )
      (output 4
       (type data)
       (name "Y-Min")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Formula"
       (name "first[i] or second[i]")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "first")
         (optional yes)
        )
        (input 2
         (type data)
         (name "second")
         (optional yes)
        )
        (input 3
         (type data)
         (name "i")
         (optional yes)
        )
        (input 4
         (type data)
         (name "half")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "(half ? second[i] : first[i])")
       )
       (views
        (icon
         (origin 211 178)
         (extent 199 45)
        )
        (detail
         (origin 423 408)
         (extent 295 204)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Formula"
       (name "From")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (optional yes)
        )
        (input 2
         (type data)
         (name "Inc")
         (optional yes)
        )
        (input 3
         (type data)
         (name "half")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "(half ? X+0.5 : X+Inc/2)")
       )
       (views
        (icon
         (origin 357 253)
         (extent 46 34)
        )
        (detail
         (origin 198 198)
         (extent 244 125)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "Formula"
       (name "To")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (optional yes)
        )
        (input 2
         (type data)
         (name "Inc")
         (optional yes)
        )
        (input 3
         (type data)
         (name "half")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "(half ? X+1-Inc/2 : X+0.5)")
       )
       (views
        (icon
         (origin 357 313)
         (extent 46 34)
        )
        (detail
         (origin 203 286)
         (extent 234 128)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 3 "Constant"
       (name "0")
       (subType "Real")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Real")
         (lock name constraints)
        )
       )
       (implementation
        (component value Real
         (name "0")
         (datum 0)
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Real
         (datum 0)
        )
       )
       (views
        (icon
         (origin 357 368)
         (extent 46 25)
        )
        (detail
         (origin 609 276)
         (extent 122 28)
         (showFormat real)
        )
        (active icon)
       )
      )
      (configuration
       (connect I1:1 D0:1)
       (connect I2:1 D0:2)
       (connect I3:1 D0:3)
       (connect I4:1 D0:4)
       (connect I3:1 D1:1)
       (connect I5:1 D1:2)
       (connect I4:1 D1:3)
       (connect I3:1 D2:1)
       (connect I5:1 D2:2)
       (connect I4:1 D2:3)
       (connect D1:1 O1:1)
       (connect D2:1 O2:1)
       (connect D0:1 O3:1)
       (connect D3:1 O4:1)
      )
     )
     (views
      (icon
       (origin 435 153)
       (extent 110 54)
      )
      (detail
       (origin 150 146)
       (extent 330 268)
       (configuration
        (connect I1:1 D0:1
         (Point 152 190)
         (Point 160 190)
         (Point 160 180)
         (Point 208 180)
        )
        (connect I2:1 D0:2
         (Point 152 240)
         (Point 170 240)
         (Point 170 190)
         (Point 208 190)
        )
        (connect I3:1 D0:3
         (Point 152 290)
         (Point 180 290)
         (Point 180 200)
         (Point 208 200)
        )
        (connect I4:1 D0:4
         (Point 152 340)
         (Point 190 340)
         (Point 190 210)
         (Point 208 210)
        )
        (connect I3:1 D1:1
         (Point 152 290)
         (Point 180 290)
         (Point 180 260)
         (Point 354 260)
        )
        (connect I5:1 D1:2
         (Point 152 390)
         (Point 340 390)
         (Point 340 270)
         (Point 354 270)
        )
        (connect I4:1 D1:3
         (Point 152 340)
         (Point 330 340)
         (Point 330 280)
         (Point 354 280)
        )
        (connect I3:1 D2:1
         (Point 152 290)
         (Point 180 290)
         (Point 180 260)
         (Point 320 260)
         (Point 320 320)
         (Point 354 320)
        )
        (connect I5:1 D2:2
         (Point 152 390)
         (Point 340 390)
         (Point 340 330)
         (Point 354 330)
        )
        (connect I4:1 D2:3
         (Point 152 340)
         (Point 354 340)
        )
        (connect D1:1 O1:1
         (Point 405 270)
         (Point 430 270)
         (Point 430 180)
         (Point 477 180)
        )
        (connect D2:1 O2:1
         (Point 405 330)
         (Point 420 330)
         (Point 420 250)
         (Point 477 250)
        )
        (connect D0:1 O3:1
         (Point 412 200)
         (Point 440 200)
         (Point 440 320)
         (Point 477 320)
        )
        (connect D3:1 O4:1
         (Point 405 380)
         (Point 420 380)
         (Point 420 390)
         (Point 477 390)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "ForCount"
     (name "2")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Count")
       (lock name constraints)
      )
     )
     (implementation
      (component count 2)
     )
     (views
      (icon
       (origin 581 338)
       (extent 78 64)
       (iconImage "loop.icon")
      )
      (detail
       (origin 705 273)
       (extent 170 34)
      )
      (active icon)
     )
    )
    (component 4 "ForCount"
     (name "For Count")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Count")
       (tag "Count")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Count")
       (lock name constraints)
      )
      (buffers in
       (buffer "Count")
      )
     )
     (implementation
      (component count 10)
     )
     (views
      (icon
       (origin 495 268)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
       (origin 615 253)
       (extent 170 34)
      )
      (active icon)
     )
    )
    (component 5 "FromArray"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (tag "Ary")
      )
      (output 1
       (type data)
       (name "SubAry")
       (tag "Result")
       (lock constraints)
      )
      (output 2
       (type data)
       (name "Type")
       (tag "Type")
       (lock constraints)
      )
      (output 3
       (type data)
       (name "NumDims")
       (tag "NumDims")
       (lock constraints)
      )
      (output 4
       (type data)
       (name "DimSizes")
       (tag "DimSizes")
       (lock constraints)
      )
      (output 5
       (type data)
       (name "TotSize")
       (tag "TotSize")
       (lock constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary")
     )
     (views
      (icon
       (origin 365 248)
       (extent 110 64)
       (iconImage "unbuild.icon")
      )
      (detail
       (origin 252 110)
       (extent 147 160)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 6 "Constant"
     (name "Spacing")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Spacing")
       (datum 0.45)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 441 388)
       (extent 78 25)
      )
      (detail
       (origin 357 374)
       (extent 147 32)
       (showFormat real)
      )
      (active detail)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D1:2 D0:2)
     (connect D4:0 D0:3)
     (connect D0:0 D0:4)
     (connect D2:1 D1:1)
     (connect D2:2 D1:2)
     (connect D2:3 D1:3)
     (connect D2:4 D1:4)
     (connect D3:1 D1:5)
     (connect I1:1 D2:1)
     (connect I2:1 D2:2)
     (connect D4:1 D2:3)
     (connect D3:1 D2:4)
     (connect D6:1 D2:5)
     (connect D4:1 D3:0)
     (connect D5:5 D4:1)
     (connect I1:1 D5:1)
    )
   )
   (views
    (icon
     (extent 154 0)
    )
    (panel
     (origin 411 280)
     (extent 419 280)
     (widget 0 detail
      (title off)
      (origin 415 284)
      (extent 414 274)
      (displayMode annotGraph)
      (graphType cartesian)
      (gridType frame)
      (scale 0
       (name "Y name")
       (domainName "X name")
       (pen 1)
       (show 1)
       (range 0 18 4 linear)
      )
      (domain 0 10 4 linear)
      (trace 0 onScale 0
       (name "Trace1")
       (pen 5)
       (lineType 1)
       (pointType 0)
      )
      (trace 1 onScale 0
       (name "Trace2")
       (pen 2)
       (lineType 1)
       (pointType 0)
      )
     )
    )
    (detail
     (origin 291 115)
     (extent 678 330)
     (configuration
      (connect D1:1 D0:1
       (Point 677 160)
       (Point 690 160)
       (Point 690 180)
       (Point 717 180)
      )
      (connect D1:2 D0:2
       (Point 677 200)
       (Point 690 200)
       (Point 690 240)
       (Point 717 240)
      )
      (connect D4:0 D0:3
       (Point 550 334)
       (Point 550 420)
       (Point 680 420)
       (Point 680 300)
       (Point 717 300)
      )
      (connect D0:0 D0:4
       (Point 860 399)
       (Point 860 420)
       (Point 700 420)
       (Point 700 360)
       (Point 717 360)
      )
      (connect D2:1 D1:1
       (Point 547 160)
       (Point 562 160)
      )
      (connect D2:2 D1:2
       (Point 547 170)
       (Point 562 170)
      )
      (connect D2:3 D1:3
       (Point 547 180)
       (Point 562 180)
      )
      (connect D2:4 D1:4
       (Point 547 190)
       (Point 562 190)
      )
      (connect D3:1 D1:5
       (Point 661 370)
       (Point 670 370)
       (Point 670 250)
       (Point 550 250)
       (Point 550 200)
       (Point 562 200)
      )
      (connect I1:1 D2:1
       (Point 293 200)
       (Point 310 200)
       (Point 310 160)
       (Point 432 160)
      )
      (connect I2:1 D2:2
       (Point 293 380)
       (Point 320 380)
       (Point 320 170)
       (Point 432 170)
      )
      (connect D4:1 D2:3
       (Point 607 300)
       (Point 620 300)
       (Point 620 260)
       (Point 540 260)
       (Point 540 230)
       (Point 420 230)
       (Point 420 180)
       (Point 432 180)
      )
      (connect D3:1 D2:4
       (Point 661 370)
       (Point 670 370)
       (Point 670 250)
       (Point 550 250)
       (Point 550 240)
       (Point 410 240)
       (Point 410 190)
       (Point 432 190)
      )
      (connect D6:1 D2:5
       (Point 506 390)
       (Point 530 390)
       (Point 530 430)
       (Point 330 430)
       (Point 330 200)
       (Point 432 200)
      )
      (connect D4:1 D3:0
       (Point 607 300)
       (Point 620 300)
       (Point 620 335)
      )
      (connect D5:5 D4:1
       (Point 477 300)
       (Point 492 300)
      )
      (connect I1:1 D5:1
       (Point 293 200)
       (Point 300 200)
       (Point 300 280)
       (Point 362 280)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 2 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 402 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 3 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 482)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 22 9
         PURPOSE:     Illustrates use of the CompBarChart library object to display two arrays
                      of data simultaneously.
         
         USER INPUT REQUIRED: Press Run to display the Bar Chart.
         
         EXPLANATION: To generate some interesting data to display, two array of 100 random numbers
                      between 0 and 1.0 are analyzed to get the magnitude Distribution in 10 "bins"
                      between 0 and 1.  The resulting arrays each have 10 elements representing the
                      number of numbers in each of the 10 bins.  The arrays are given to the 
                      CompBarChart library object to generate the display.
         
         IMPLEMENTATION: The CompBarChart library object provides additional usage information from
                      the Show Description choice in the object menu.  Setting colors, etc. is
                      described here, along with a description of the input requirements.  When
                      using the BarChart object in your models, you may want to place and size it,
                      then secure the User Object to prevent inadvertent changes.
         
                      Since the BarChart is a User Object, you may want to examine it to see how
                      the barchart is generated.  Some advanced techniques are used to generate
                      the serpentine fill pattern using parallel array operations to obtain the
                      needed speed.  
         
        )
       )
       (views
        (icon
         (origin 410 415)
         (extent 78 25)
        )
        (detail
         (origin 25 209)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 3 41)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 46 175)
         (extent 832 463)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 415 408)
     (extent 110 25)
    )
    (panel
     (origin 21 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 123 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 4 "TextDisplay"
   (name "Trace 1")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 857 150)
     (extent 147 240)
    )
    (active detail)
   )
  )
  (component 5 "TextDisplay"
   (name "Trace 2")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 847 460)
     (extent 147 240)
    )
    (active detail)
   )
  )
  (configuration
   (connect D0:1 D1:1)
   (connect D0:2 D1:2)
   (connect D0:1 D4:1)
   (connect D0:2 D5:1)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 862 547)
   (widget 2 detail
    (title on)
    (origin 430 121)
    (extent 397 82)
    (editing disabled)
   )
   (widget 4 detail
    (title on)
    (origin 29 279)
    (extent 135 279)
   )
   (widget 5 detail
    (title on)
    (origin 183 280)
    (extent 138 276)
   )
   (widget 3 panel
    (title on)
    (origin 30 123)
    (extent 319 77)
    (widget 1 icon
     (title off)
     (origin 132 136)
     (extent 114 39)
     (format button)
    )
   )
   (widget 1 panel
    (title on)
    (origin 356 280)
    (extent 471 280)
    (widget 0 detail
     (title off)
     (origin 361 285)
     (extent 464 274)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType frame)
     (scale 0
      (name "Y name")
      (domainName "X name")
      (pen 1)
      (show 1)
      (range 0 30 4 linear)
     )
     (domain 0 10 4 linear)
     (trace 0 onScale 0
      (name "Trace1")
      (pen 5)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "Trace2")
      (pen 2)
      (lineType 1)
      (pointType 0)
     )
    )
   )
  )
  (detail
   (origin 0 67)
   (extent 935 615)
   (configuration
    (connect D0:1 D1:1
     (Point 368 350)
     (Point 408 350)
    )
    (connect D0:2 D1:2
     (Point 368 510)
     (Point 390 510)
     (Point 390 490)
     (Point 408 490)
    )
    (connect D0:1 D4:1
     (Point 368 350)
     (Point 390 350)
     (Point 390 230)
     (Point 840 230)
     (Point 840 270)
     (Point 854 270)
    )
    (connect D0:2 D5:1
     (Point 368 510)
     (Point 390 510)
     (Point 390 580)
     (Point 844 580)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
