#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Sun 22/Sep/1991")
(component 0 "Context"
 (name "Pass-Fail Bar Chart Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Context"
   (name "Generate Data")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Result")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Constant"
     (name "Low Limit")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Low Limit")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 23 514)
       (extent 165 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 1 "Constant"
     (name "High Limit")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "High Limit")
       (datum 1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 18 584)
       (extent 174 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 2 "Context"
     (name "100 random #s")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Array")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Collector"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (tag "Data")
        )
        (input 2
         (type trigger)
         (name "XEQ")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
       )
       (implementation
        (component clearAtPrerun 1)
        (component clearAtActivate 1)
       )
       (views
        (icon
         (origin 280 248)
         (extent 110 25)
        )
        (detail
         (origin 265 455)
         (extent 60 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "RandomNumber"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Rand Val")
         (lock name constraints)
        )
       )
       (implementation
        (component lowerLimit 0)
        (component upperLimit 1)
       )
       (views
        (icon
         (origin 107 258)
         (extent 127 25)
        )
        (detail
         (origin 109 410)
         (extent 222 60)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "ForCount"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Count")
         (lock name constraints)
        )
       )
       (implementation
        (component count 100)
       )
       (views
        (icon
         (origin 90 168)
         (extent 110 64)
         (iconImage "loop.icon")
        )
        (detail
         (origin 60 183)
         (extent 170 34)
        )
        (active detail)
       )
      )
      (configuration
       (connect D1:1 D0:1)
       (connect D2:0 D0:2)
       (connect D2:1 D1:0)
       (connect D0:1 O1:1)
      )
     )
     (views
      (icon
       (origin 32 436)
       (extent 127 25)
      )
      (detail
       (origin 31 130)
       (extent 388 200)
       (configuration
        (connect D1:1 D0:1
         (Point 236 270)
         (Point 250 270)
         (Point 250 250)
         (Point 277 250)
        )
        (connect D2:0 D0:2
         (Point 145 219)
         (Point 145 240)
         (Point 85 240)
         (Point 85 300)
         (Point 255 300)
         (Point 255 270)
         (Point 277 270)
        )
        (connect D2:1 D1:0
         (Point 232 200)
         (Point 250 200)
         (Point 250 240)
         (Point 170 240)
         (Point 170 255)
        )
        (connect D0:1 O1:1
         (Point 392 260)
         (Point 416 240)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Constant"
     (name "step")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "step")
       (datum 0.1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 487 708)
       (extent 46 25)
      )
      (detail
       (origin 34 654)
       (extent 122 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 4 "Formula"
     (name "magDist()")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "From")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "Thru")
       (lock name constraints)
      )
      (input 4
       (type data)
       (name "Step")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "magDist(x,from,thru,step)")
     )
     (views
      (icon
       (origin 250 546)
       (extent 110 45)
      )
      (detail
       (origin 421 305)
       (extent 259 210)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D2:1 D4:1)
     (connect D0:1 D4:2)
     (connect D1:1 D4:3)
     (connect D3:1 D4:4)
     (connect D4:1 O1:1)
    )
   )
   (views
    (icon
     (extent 127 0)
    )
    (detail
     (origin 10 421)
     (extent 360 278)
     (configuration
      (connect D2:1 D4:1
       (Point 161 448)
       (Point 225 448)
       (Point 225 548)
       (Point 247 548)
      )
      (connect D0:1 D4:2
       (Point 190 528)
       (Point 215 528)
       (Point 215 558)
       (Point 247 558)
      )
      (connect D1:1 D4:3
       (Point 194 598)
       (Point 215 598)
       (Point 215 568)
       (Point 247 568)
      )
      (connect D3:1 D4:4
       (Point 158 668)
       (Point 225 668)
       (Point 225 578)
       (Point 247 578)
      )
      (connect D4:1 O1:1
       (Point 362 568)
       (Point 367 568)
       (Point 367 570)
       (Point 367 570)
      )
     )
    )
    (active detail)
   )
  )
  (component 1 "TextDisplay"
   (name "The Data")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 452 464)
     (extent 156 213)
    )
    (active detail)
   )
  )
  (component 2 "Context"
   (name "Pass/Fail Chart")
   (description 32 4
    Generates and displays a Pass/Fail bar chart from
    the 1-D input data array and a Limit.  The number
    of bars is equal to the number of array elements,
    the "length" of each bar is set by the value of
    each element (which may be a positive or negative
    real or int32 number), and the color of each bar
    is a function of the limit threshold value.  
    
    The display is autoscaled after plotting the bars
    using the maximum and minumum array data values
    and the number of bars.
    
    Display and trace labels, bar color, grid type,
    etc. can be set by clicking the Right Button on
    the display area and selecting the "Traces and
    Scales" entry from the resulting menu.  The gap
    between bars can be set using the "Spacing" box
    in the Bar Chart Detail view.
    
    If the bars appear to have black vertical lines,
    the number of fill strokes can be increased, at
    the expense of drawing speed, by reducing the
    Density in the Detail view of the FillBarMux
    object.
    
    It may prove useful to Secure the BarChart User
    Object after customizing, since this eliminates
    the Panel/Detail buttons and some menu selections
    that are no longer needed.  Be sure to save the
    unsecured object so you can make changes at a
    later date, however. 
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Ary")
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "ForCount"
     (name "For Count")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Count")
       (tag "Count")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Count")
       (lock name constraints)
      )
      (buffers in
       (buffer "Count")
      )
     )
     (implementation
      (component count 10)
     )
     (views
      (icon
       (origin 225 428)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
       (origin 615 253)
       (extent 170 34)
      )
      (active icon)
     )
    )
    (component 1 "YPlot"
     (name "XY Trace")
     (subType "XY_Trace")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "PASS")
       (lock constraints)
      )
      (input 2
       (type data)
       (name "FAIL")
       (lock constraints)
       (optional yes)
      )
      (input 3
       (type data)
       (name "Limit")
       (lock constraints)
       (optional yes)
      )
      (input 4
       (type control)
       (name "Auto Scale")
       (lock name constraints)
       (optional yes)
      )
      (input 5
       (type control)
       (name "Next Curve")
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
      (component tracePin 1)
      (component tracePin 2)
      (component tracePin 3)
      (component graphMode rectangular)
     )
     (views
      (icon
       (iconImage "display.icon")
      )
      (detail
       (origin 653 285)
       (extent 315 250)
       (displayMode annotGraph)
       (graphType cartesian)
       (gridType frame)
       (scale 0
        (name "Y name")
        (domainName "X name")
        (pen 9)
        (show 1)
        (range 0 16 4 linear)
       )
       (domain 0 10 4 linear)
       (trace 0 onScale 0
        (name "PASS")
        (pen 3)
        (lineType 1)
        (pointType 0)
       )
       (trace 1 onScale 0
        (name "FAIL")
        (pen 2)
        (lineType 1)
        (pointType 0)
       )
       (trace 2 onScale 0
        (name "Limit")
        (pen 4)
        (lineType 4)
        (pointType 0)
       )
      )
      (active detail)
     )
    )
    (component 2 "Context"
     (name "BarFillMux")
     (description 16 6
      This Library Object generates a serpentine bar
      fill pattern and places the output on one of two
      selected output pins.  The other output produces
      an empty bar, since a Display device needs some
      data on each input pin before it will execute and
      show the data. 
      
      The BarFillMux object uses the techniques found in
      the BarFill library object to produce an array of
      coord data points needed to fill a bar.  It adds
      a "TraceNo" input to determine which output pin
      receives the bar data and which receives the empty
      bar; zero outputs the bar on Trace 1, non-zero on
      Trace 2.  Note that the "other" trace has a bar of
      height (a thin horizontal line is drawn).
      
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X-Start")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (optional yes)
      )
      (input 2
       (type data)
       (name "X-End")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (optional yes)
      )
      (input 3
       (type data)
       (name "Y-Max")
       (optional yes)
      )
      (input 4
       (type data)
       (name "Y-Min")
       (optional yes)
      )
      (input 5
       (type data)
       (name "TraceNo")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Trace1")
       (lock constraints)
       (optional yes)
      )
      (output 2
       (type data)
       (name "Trace2")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Formula"
       (name "NumPts")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "TraceNo")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "(TraceNo ? A : A[0])")
       )
       (views
        (icon
         (origin 581 418)
         (extent 78 25)
        )
        (detail
         (origin 508 318)
         (extent 214 104)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Formula"
       (name "NumPts")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "TraceNo")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "( NOT TraceNo ? A : A[0])")
       )
       (views
        (icon
         (origin 581 368)
         (extent 78 25)
        )
        (detail
         (origin 486 278)
         (extent 259 104)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "AllocateArray"
       (name "Alloc Real")
       (subType "Alloc_Real")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Init Value")
         (tag "Init Value")
         (requires
          (datatype Real)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (input 2
         (type data)
         (name "Dim Size 1")
         (tag "Dim Size 1")
         (requires
          (datatype Int32)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
        (buffers in
         (buffer "Init Value")
         (buffer "Dim Size 1")
        )
       )
       (implementation
        (component numDims 1)
        (component dimSizes "26")
        (component type "Real")
        (component initEnum "Init Value")
        (component initialValue
         (name "Init Value")
         (datum 0)
        )
        (component from 1)
        (component thru 10)
       )
       (views
        (icon
         (origin 375 418)
         (extent 110 25)
        )
        (detail
         (origin 286 525)
         (extent 229 111)
        )
        (active icon)
       )
      )
      (component 3 "AllocateArray"
       (name "Alloc Real")
       (subType "Alloc_Real")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Init Value")
         (tag "Init Value")
         (requires
          (datatype Real)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (input 2
         (type data)
         (name "Dim Size 1")
         (tag "Dim Size 1")
         (requires
          (datatype Int32)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
        (buffers in
         (buffer "Init Value")
         (buffer "Dim Size 1")
        )
       )
       (implementation
        (component numDims 1)
        (component dimSizes "26")
        (component type "Real")
        (component initEnum "Init Value")
        (component initialValue
         (name "Init Value")
         (datum 11)
        )
        (component from 1)
        (component thru 10)
       )
       (views
        (icon
         (origin 375 378)
         (extent 110 25)
        )
        (detail
         (origin 46 305)
         (extent 229 111)
        )
        (active icon)
       )
      )
      (component 4 "Formula"
       (name "Generate Y values")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "B")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "concat(transpose([b a a b]),b[0])")
       )
       (views
        (icon
         (origin 359 308)
         (extent 163 25)
        )
        (detail
         (origin 275 563)
         (extent 340 154)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 5 "Constant"
       (name "Density")
       (subType "Real")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Real")
         (lock name constraints)
        )
       )
       (implementation
        (component value Real
         (name "Density")
         (datum 0.03)
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Real
         (datum 0)
        )
       )
       (views
        (icon
         (origin 211 338)
         (extent 78 25)
        )
        (detail
         (origin 157 364)
         (extent 147 32)
         (showFormat real)
        )
        (active icon)
       )
      )
      (component 6 "Formula"
       (name "Duplicate each X element")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "B")
         (optional yes)
        )
        (input 3
         (type data)
         (name "n")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "concat(transpose([ramp(2*n,a,b) ramp(2*n,a,b)]),b)")
       )
       (views
        (icon
         (origin 297 253)
         (extent 226 34)
        )
        (detail
         (origin 93 353)
         (extent 484 154)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 7 "ToCoordinate"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X Data")
         (tag "X")
         (requires
          (datatype Real)
         )
         (lock constraints)
        )
        (input 2
         (type data)
         (name "Y Data")
         (tag "Y")
         (requires
          (datatype Real)
         )
         (lock constraints)
        )
        (output 1
         (type data)
         (name "Coord")
         (tag "Coord")
         (lock constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 545 268)
         (extent 110 25)
        )
        (detail
         (origin 510 175)
         (extent 50 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 8 "Formula"
       (name "NumPts")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "B")
         (optional yes)
        )
        (input 3
         (type data)
         (name "Density")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "intPart((b-a)/Density)")
       )
       (views
        (icon
         (origin 211 293)
         (extent 78 34)
        )
        (detail
         (origin 166 151)
         (extent 219 119)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 9 "Formula"
       (name " + ")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (lock name constraints)
        )
        (input 2
         (type data)
         (name "Y")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked yes)
        (component expr 1 "X+Y")
       )
       (views
        (icon
         (origin 187 368)
         (extent 46 25)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
       (connect D7:1 D0:1)
       (connect I5:1 D0:2)
       (connect D7:1 D1:1)
       (connect I5:1 D1:2)
       (connect I4:1 D2:1)
       (connect D8:1 D2:2)
       (connect D9:1 D3:1)
       (connect D8:1 D3:2)
       (connect D3:1 D4:1)
       (connect D2:1 D4:2)
       (connect I1:1 D6:1)
       (connect I2:1 D6:2)
       (connect D8:1 D6:3)
       (connect D6:1 D7:1)
       (connect D4:1 D7:2)
       (connect I1:1 D8:1)
       (connect I2:1 D8:2)
       (connect D5:1 D8:3)
       (connect I3:1 D9:1)
       (connect I4:1 D9:2)
       (connect D1:1 O1:1)
       (connect D0:1 O2:1)
      )
     )
     (views
      (icon
       (origin 485 268)
       (extent 110 65)
      )
      (panel
       (origin 350 255)
       (extent 170 231)
       (widget 5 detail
        (title on)
        (origin 360 311)
        (extent 147 32)
        (showFormat real)
       )
      )
      (detail
       (origin 154 245)
       (extent 542 230)
       (configuration
        (connect D7:1 D0:1
         (Point 657 280)
         (Point 670 280)
         (Point 670 310)
         (Point 570 310)
         (Point 570 370)
         (Point 560 370)
         (Point 560 420)
         (Point 578 420)
        )
        (connect I5:1 D0:2
         (Point 156 470)
         (Point 170 470)
         (Point 170 460)
         (Point 500 460)
         (Point 500 440)
         (Point 578 440)
        )
        (connect D7:1 D1:1
         (Point 657 280)
         (Point 670 280)
         (Point 670 310)
         (Point 570 310)
         (Point 570 370)
         (Point 578 370)
        )
        (connect I5:1 D1:2
         (Point 156 470)
         (Point 170 470)
         (Point 170 460)
         (Point 500 460)
         (Point 500 440)
         (Point 550 440)
         (Point 550 390)
         (Point 578 390)
        )
        (connect I4:1 D2:1
         (Point 156 420)
         (Point 372 420)
        )
        (connect D8:1 D2:2
         (Point 291 310)
         (Point 320 310)
         (Point 320 400)
         (Point 340 400)
         (Point 340 440)
         (Point 372 440)
        )
        (connect D9:1 D3:1
         (Point 235 380)
         (Point 372 380)
        )
        (connect D8:1 D3:2
         (Point 291 310)
         (Point 320 310)
         (Point 320 400)
         (Point 372 400)
        )
        (connect D3:1 D4:1
         (Point 487 390)
         (Point 500 390)
         (Point 500 360)
         (Point 340 360)
         (Point 340 310)
         (Point 356 310)
        )
        (connect D2:1 D4:2
         (Point 487 430)
         (Point 510 430)
         (Point 510 350)
         (Point 350 350)
         (Point 350 330)
         (Point 356 330)
        )
        (connect I1:1 D6:1
         (Point 156 270)
         (Point 170 270)
         (Point 170 260)
         (Point 294 260)
        )
        (connect I2:1 D6:2
         (Point 156 320)
         (Point 170 320)
         (Point 170 310)
         (Point 190 310)
         (Point 190 270)
         (Point 294 270)
        )
        (connect D8:1 D6:3
         (Point 291 310)
         (Point 300 310)
         (Point 300 300)
         (Point 280 300)
         (Point 280 280)
         (Point 294 280)
        )
        (connect D6:1 D7:1
         (Point 525 270)
         (Point 542 270)
        )
        (connect D4:1 D7:2
         (Point 524 320)
         (Point 530 320)
         (Point 530 290)
         (Point 542 290)
        )
        (connect I1:1 D8:1
         (Point 156 270)
         (Point 170 270)
         (Point 170 300)
         (Point 208 300)
        )
        (connect I2:1 D8:2
         (Point 156 320)
         (Point 170 320)
         (Point 170 310)
         (Point 208 310)
        )
        (connect D5:1 D8:3
         (Point 291 350)
         (Point 310 350)
         (Point 310 410)
         (Point 190 410)
         (Point 190 320)
         (Point 208 320)
        )
        (connect I3:1 D9:1
         (Point 156 370)
         (Point 184 370)
        )
        (connect I4:1 D9:2
         (Point 156 420)
         (Point 170 420)
         (Point 170 390)
         (Point 184 390)
        )
        (connect D1:1 O1:1
         (Point 661 380)
         (Point 680 380)
         (Point 680 310)
         (Point 693 310)
        )
        (connect D0:1 O2:1
         (Point 661 430)
         (Point 693 430)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Context"
     (name "BarSize")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Array")
       (optional yes)
      )
      (input 2
       (type data)
       (name "BarNo")
       (optional yes)
      )
      (input 3
       (type data)
       (name "Gap")
       (optional yes)
      )
      (output 1
       (type data)
       (name "X-Start")
       (lock constraints)
       (optional yes)
      )
      (output 2
       (type data)
       (name "X-Stop")
       (lock constraints)
       (optional yes)
      )
      (output 3
       (type data)
       (name "Y-Max")
       (lock constraints)
       (optional yes)
      )
      (output 4
       (type data)
       (name "Y-Min")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Formula"
       (name "From")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (optional yes)
        )
        (input 2
         (type data)
         (name "Inc")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "X+Inc/2")
       )
       (views
        (icon
         (origin 197 153)
         (extent 46 34)
        )
        (detail
         (origin 327 180)
         (extent 97 101)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Formula"
       (name "To")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (optional yes)
        )
        (input 2
         (type data)
         (name "Inc")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "X+1-Inc/2")
       )
       (views
        (icon
         (origin 197 203)
         (extent 46 34)
        )
        (detail
         (origin 318 241)
         (extent 115 78)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "Formula"
       (name "y[i]")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "y")
         (optional yes)
        )
        (input 2
         (type data)
         (name "i")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "y[i]")
       )
       (views
        (icon
         (origin 197 253)
         (extent 46 34)
        )
        (detail
         (origin 200 461)
         (extent 90 78)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 3 "Constant"
       (name "0")
       (subType "Real")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Real")
         (lock name constraints)
        )
       )
       (implementation
        (component value Real
         (name "0")
         (datum 0)
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Real
         (datum 0)
        )
       )
       (views
        (icon
         (origin 187 308)
         (extent 46 25)
        )
        (detail
         (origin 279 446)
         (extent 122 28)
         (showFormat real)
        )
        (active icon)
       )
      )
      (configuration
       (connect I2:1 D0:1)
       (connect I3:1 D0:2)
       (connect I2:1 D1:1)
       (connect I3:1 D1:2)
       (connect I1:1 D2:1)
       (connect I2:1 D2:2)
       (connect D0:1 O1:1)
       (connect D1:1 O2:1)
       (connect D2:1 O3:1)
       (connect D3:1 O4:1)
      )
     )
     (views
      (icon
       (origin 361 278)
       (extent 78 45)
      )
      (detail
       (origin 103 134)
       (extent 194 212)
       (configuration
        (connect I2:1 D0:1
         (Point 105 250)
         (Point 130 250)
         (Point 130 210)
         (Point 160 210)
         (Point 160 160)
         (Point 194 160)
        )
        (connect I3:1 D0:2
         (Point 105 320)
         (Point 150 320)
         (Point 150 230)
         (Point 170 230)
         (Point 170 180)
         (Point 194 180)
        )
        (connect I2:1 D1:1
         (Point 105 250)
         (Point 130 250)
         (Point 130 210)
         (Point 194 210)
        )
        (connect I3:1 D1:2
         (Point 105 320)
         (Point 150 320)
         (Point 150 230)
         (Point 194 230)
        )
        (connect I1:1 D2:1
         (Point 105 180)
         (Point 140 180)
         (Point 140 260)
         (Point 194 260)
        )
        (connect I2:1 D2:2
         (Point 105 250)
         (Point 120 250)
         (Point 120 280)
         (Point 194 280)
        )
        (connect D0:1 O1:1
         (Point 245 170)
         (Point 294 170)
        )
        (connect D1:1 O2:1
         (Point 245 220)
         (Point 294 220)
        )
        (connect D2:1 O3:1
         (Point 245 270)
         (Point 294 270)
        )
        (connect D3:1 O4:1
         (Point 235 320)
         (Point 294 320)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "Constant"
     (name "Spacing")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Spacing")
       (datum 0.2)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 271 268)
       (extent 78 25)
      )
      (detail
       (origin 187 294)
       (extent 147 32)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 5 "FromArray"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (tag "Ary")
      )
      (output 1
       (type data)
       (name "SubAry")
       (tag "Result")
       (lock constraints)
      )
      (output 2
       (type data)
       (name "Type")
       (tag "Type")
       (lock constraints)
      )
      (output 3
       (type data)
       (name "NumDims")
       (tag "NumDims")
       (lock constraints)
      )
      (output 4
       (type data)
       (name "DimSizes")
       (tag "DimSizes")
       (lock constraints)
      )
      (output 5
       (type data)
       (name "TotSize")
       (tag "TotSize")
       (lock constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary")
     )
     (views
      (icon
       (origin 195 338)
       (extent 110 64)
       (iconImage "unbuild.icon")
      )
      (detail
       (origin 252 110)
       (extent 147 160)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 6 "Formula"
     (name "ColorTest")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "a<b")
     )
     (views
      (icon
       (origin 305 228)
       (extent 110 25)
      )
      (detail
       (origin 428 399)
       (extent 55 82)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 7 "Formula"
     (name "Threshold Limit")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "[coord(0,b) coord(a,b)]")
     )
     (views
      (icon
       (origin 408 498)
       (extent 145 25)
      )
      (detail
       (origin 275 578)
       (extent 241 104)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D5:5 D0:1)
     (connect D2:1 D1:1)
     (connect D2:2 D1:2)
     (connect D7:1 D1:3)
     (connect D0:0 D1:4)
     (connect D1:0 D1:5)
     (connect D3:1 D2:1)
     (connect D3:2 D2:2)
     (connect D3:3 D2:3)
     (connect D3:4 D2:4)
     (connect D6:1 D2:5)
     (connect I1:1 D3:1)
     (connect D0:1 D3:2)
     (connect D4:1 D3:3)
     (connect I1:1 D5:1)
     (connect D3:3 D6:1)
     (connect I2:1 D6:2)
     (connect D5:5 D7:1)
     (connect I2:1 D7:2)
    )
   )
   (views
    (icon
     (origin 478 498)
     (extent 145 25)
    )
    (panel
     (origin 601 116)
     (extent 378 249)
     (widget 1 detail
      (title off)
      (origin 605 120)
      (extent 371 241)
      (displayMode annotGraph)
      (graphType cartesian)
      (gridType frame)
      (scale 0
       (name "Y name")
       (domainName "X name")
       (pen 1)
       (show 1)
       (range 0 16 4 linear)
      )
      (domain 0 10 4 linear)
      (trace 0 onScale 0
       (name "PASS")
       (pen 3)
       (lineType 1)
       (pointType 0)
      )
      (trace 1 onScale 0
       (name "FAIL")
       (pen 2)
       (lineType 1)
       (pointType 0)
      )
      (trace 2 onScale 0
       (name "Limit")
       (pen 4)
       (lineType 4)
       (pointType 0)
      )
     )
    )
    (detail
     (origin 156 232)
     (extent 808 337)
     (configuration
      (connect D5:5 D0:1
       (Point 307 390)
       (Point 350 390)
       (Point 350 510)
       (Point 210 510)
       (Point 210 460)
       (Point 222 460)
      )
      (connect D2:1 D1:1
       (Point 597 280)
       (Point 610 280)
       (Point 610 310)
       (Point 650 310)
      )
      (connect D2:2 D1:2
       (Point 597 320)
       (Point 610 320)
       (Point 610 360)
       (Point 650 360)
      )
      (connect D7:1 D1:3
       (Point 555 510)
       (Point 580 510)
       (Point 580 410)
       (Point 650 410)
      )
      (connect D0:0 D1:4
       (Point 280 494)
       (Point 280 540)
       (Point 590 540)
       (Point 590 460)
       (Point 650 460)
      )
      (connect D1:0 D1:5
       (Point 810 537)
       (Point 810 560)
       (Point 630 560)
       (Point 630 510)
       (Point 650 510)
      )
      (connect D3:1 D2:1
       (Point 441 280)
       (Point 482 280)
      )
      (connect D3:2 D2:2
       (Point 441 290)
       (Point 482 290)
      )
      (connect D3:3 D2:3
       (Point 441 300)
       (Point 482 300)
      )
      (connect D3:4 D2:4
       (Point 441 310)
       (Point 482 310)
      )
      (connect D6:1 D2:5
       (Point 555 440)
       (Point 570 440)
       (Point 570 400)
       (Point 580 400)
       (Point 580 350)
       (Point 470 350)
       (Point 470 320)
       (Point 482 320)
      )
      (connect I1:1 D3:1
       (Point 158 320)
       (Point 170 320)
       (Point 170 240)
       (Point 350 240)
       (Point 350 290)
       (Point 358 290)
      )
      (connect D0:1 D3:2
       (Point 337 460)
       (Point 360 460)
       (Point 360 380)
       (Point 350 380)
       (Point 350 300)
       (Point 358 300)
      )
      (connect D4:1 D3:3
       (Point 336 310)
       (Point 358 310)
      )
      (connect I1:1 D5:1
       (Point 158 320)
       (Point 170 320)
       (Point 170 370)
       (Point 192 370)
      )
      (connect D3:3 D6:1
       (Point 441 300)
       (Point 460 300)
       (Point 460 340)
       (Point 370 340)
       (Point 370 420)
       (Point 385 420)
      )
      (connect I2:1 D6:2
       (Point 158 500)
       (Point 170 500)
       (Point 170 520)
       (Point 370 520)
       (Point 370 460)
       (Point 385 460)
      )
      (connect D5:5 D7:1
       (Point 307 390)
       (Point 350 390)
       (Point 350 500)
       (Point 405 500)
      )
      (connect I2:1 D7:2
       (Point 158 500)
       (Point 170 500)
       (Point 170 520)
       (Point 405 520)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 3 "Slider"
   (name "Limit")
   (subType "Real_Slider")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Real")
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Limit")
     (values range 0 20)
     (datum 8)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
    (component detents 0.5)
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 372 116)
     (extent 156 229)
    )
    (active detail)
   )
  )
  (component 4 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 482)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 28 9
         PURPOSE:     Illustrates use of the PFBarChart library object to display an array of data.
         
         USER INPUT REQUIRED: Press Run to display the Bar Chart.
         
         EXPLANATION: To generate some interesting data to display, an array of 100 random numbers
                      between 0 and 1.0 is analyzed to get the magnitude Distribution in 10 "bins"
                      between 0 and 1.  The resulting array has 10 elements representing the number
                      of numbers in each of the 10 bins.  This array is given to the PFBarChart
                      library object for display.  A slider provides the threshold/limit value for
                      determining the color of each bar.
         
                      The PFBarChart object uses the Threshold value to determine which of two
                      trace inputs to an XY should be used.  If you want to reverse the sense of
                      the test (values below the Limit will PASS), use the Traces and Scales menu
                      obtained by clicking the Right Button on the barchart graph to switch the
                      Labels (PASS and FAIL) and Trace Colors (Pen3 Pen4).
         
         IMPLEMENTATION:  The PFBarChart library object provides additional usage information from
                      the Show Description choice in the object menu.  Setting colors, etc. is
                      described here, along with a description of the input requirements.  When
                      using a BarChart object in your models, you may want to place and size it,
                      then secure the User Object to prevent inadvertent changes.  
         
                      Since the PFBarChart is a User Object, you may want to examine it to see how
                      the barchart is generated.  Some advanced techniques are used to generate
                      the serpentine fill pattern using parallel array operations to obtain the
                      needed speed.  
         
        )
       )
       (views
        (icon
         (origin 410 415)
         (extent 78 25)
        )
        (detail
         (origin 25 209)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 0 37)
       (extent 872 563)
       (panel
        (origin 26 168)
        (extent 868 525)
        (widget 0 icon
         (title off)
         (origin 425 652)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 31 176)
         (extent 851 458)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 415 408)
     (extent 110 25)
    )
    (panel
     (origin 21 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 123 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 5 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 5 5
     This example is provided as an
     illustration "as is", and Hewlett-
     Packard Company makes no warranty
     of any kind with regard to this
     example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 639 461)
     (extent 322 99)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 6 "Note"
   (name "To Operate")
   (interface
   )
   (implementation
    (component text 5 5
     Adjust the desired threshold
     limit and observe which bars
     colored red and green.  Click
     Info About for hints on
     reversing the test sense.
    )
   )
   (views
    (icon
     (origin 105 228)
     (extent 110 64)
     (iconImage "notepad.icon")
    )
    (detail
     (origin 19 251)
     (extent 323 99)
     (editing disabled)
    )
    (active detail)
   )
  )
  (configuration
   (connect D3:0 D0:0)
   (connect D0:1 D1:1)
   (connect D0:1 D2:1)
   (connect D3:1 D2:2)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 875 533)
   (widget 2 panel
    (title on)
    (origin 391 270)
    (extent 453 268)
    (widget 1 detail
     (title off)
     (origin 395 274)
     (extent 445 260)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType frame)
     (scale 0
      (name "Y name")
      (domainName "X name")
      (pen 1)
      (show 1)
      (range 0 16 4 linear)
     )
     (domain 0 10 4 linear)
     (trace 0 onScale 0
      (name "PASS")
      (pen 3)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "FAIL")
      (pen 2)
      (lineType 1)
      (pointType 0)
     )
     (trace 2 onScale 0
      (name "Limit")
      (pen 4)
      (lineType 4)
      (pointType 0)
     )
    )
   )
   (widget 4 panel
    (title on)
    (origin 18 117)
    (extent 193 97)
    (widget 1 icon
     (title off)
     (origin 54 139)
     (extent 114 39)
     (format button)
    )
   )
   (widget 1 detail
    (title on)
    (origin 18 270)
    (extent 154 265)
   )
   (widget 5 detail
    (title on)
    (origin 526 116)
    (extent 322 99)
    (editing disabled)
   )
   (widget 6 detail
    (title on)
    (origin 226 116)
    (extent 287 99)
    (editing disabled)
   )
   (widget 3 detail
    (title on)
    (origin 192 270)
    (extent 162 266)
   )
  )
  (detail
   (origin 0 67)
   (extent 935 615)
   (configuration
    (connect D3:0 D0:0
     (Point 450 347)
     (Point 450 370)
     (Point 200 370)
     (Point 200 388)
    )
    (connect D0:1 D1:1
     (Point 392 570)
     (Point 449 570)
    )
    (connect D0:1 D2:1
     (Point 392 570)
     (Point 420 570)
     (Point 420 410)
     (Point 560 410)
     (Point 560 180)
     (Point 598 180)
    )
    (connect D3:1 D2:2
     (Point 530 230)
     (Point 550 230)
     (Point 550 300)
     (Point 598 300)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
