#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Tue 17/Sep/1991")
(component 0 "Context"
 (name "Bar Chart Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "TextDisplay"
   (name "Data")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 46 0)
    )
    (detail
     (origin 472 508)
     (extent 156 204)
    )
    (active detail)
   )
  )
  (component 1 "Context"
   (name "Bar Chart Display")
   (description 30 4
    Generates and displays a bar chart using the 1-D
    array input data.  The number of bars is equal to
    the number of array elements, and the "length" of
    each bar is set by the corresponding element data,
    which may be a positive or negative real or int32
    number.
    
    The display is pre-autoscaled before plotting,
    using the maximum and minumum array data values
    and the number of bars.
    
    Display and trace labels, bar color, grid type,
    etc. can be set by clicking the Right Button on
    the display area and selecting the "Traces and
    Scales" entry from the resulting menu.  The gap
    between bars can be set using the "Spacing" box
    in the Bar Chart Detail view.
    
    If the bars appear to have vertical lines, the
    number of fill strokes can be increased, at the
    expense of drawing speed, by reducing the Density
    factor on the Detail view of the FillBar object.
    
    It may prove useful to Secure the BarChart User
    Object after customizing, since this eliminates
    the Panel/Detail buttons and some menu selections
    that are no longer needed.  Be sure to save the
    unsecured object so you can make changes at a
    later date, however.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Ary")
     (requires
      (shape "Array 1D")
     )
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "YPlot"
     (name "XY Trace")
     (subType "XY_Trace")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Trace1")
       (lock constraints)
      )
      (input 2
       (type control)
       (name "Auto Scale")
       (lock name constraints)
       (optional yes)
      )
      (input 3
       (type control)
       (name "Next Curve")
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
      (component tracePin 1)
      (component graphMode rectangular)
     )
     (views
      (icon
       (extent 110 0)
       (iconImage "display.icon")
      )
      (detail
       (origin 417 172)
       (extent 327 277)
       (displayMode scrollGraph)
       (graphType cartesian)
       (gridType frame)
       (scale 0
        (name "Y name")
        (domainName "X name")
        (pen 1)
        (show 1)
        (range 0 14 4 linear)
       )
       (domain 0 10 4 linear)
       (trace 0 onScale 0
        (name "Trace1")
        (pen 7)
        (lineType 1)
        (pointType 0)
       )
      )
      (active detail)
     )
    )
    (component 1 "ForCount"
     (name "For Count")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Count")
       (tag "Count")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Count")
       (lock name constraints)
      )
      (buffers in
       (buffer "Count")
      )
     )
     (implementation
      (component count 10)
     )
     (views
      (icon
       (origin 265 408)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
       (origin 615 253)
       (extent 170 34)
      )
      (active icon)
     )
    )
    (component 2 "Junction"
     (name "JCT")
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "C")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 327 253)
       (extent 46 34)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "FromArray"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (tag "Ary")
      )
      (output 1
       (type data)
       (name "SubAry")
       (tag "Result")
       (lock constraints)
      )
      (output 2
       (type data)
       (name "Type")
       (tag "Type")
       (lock constraints)
      )
      (output 3
       (type data)
       (name "NumDims")
       (tag "NumDims")
       (lock constraints)
      )
      (output 4
       (type data)
       (name "DimSizes")
       (tag "DimSizes")
       (lock constraints)
      )
      (output 5
       (type data)
       (name "TotSize")
       (tag "TotSize")
       (lock constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary")
     )
     (views
      (icon
       (origin 125 408)
       (extent 110 64)
       (iconImage "unbuild.icon")
      )
      (detail
       (origin 252 110)
       (extent 147 160)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "Do"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Do")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 297 368)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "Formula"
     (name "Upper Right")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "xmax")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "coord(xmax,max(a))")
     )
     (views
      (icon
       (origin 145 338)
       (extent 110 25)
      )
      (detail
       (origin 312 308)
       (extent 196 104)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 6 "Formula"
     (name "Lower Left")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "coord(0,min([min(a) 0]))")
     )
     (views
      (icon
       (origin 145 298)
       (extent 110 25)
      )
      (detail
       (origin 180 408)
       (extent 250 104)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "Constant"
     (name "Spacing")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Spacing")
       (datum 0.2)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 78 0)
      )
      (detail
       (origin 117 256)
       (extent 147 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 8 "Context"
     (name "BarSize")
     (description 5 6
      Examines the "n-th" element of the input array
      and outputs the X-start, X-stop values for the
      n-th bar, along with the Y-max and Y-min for the
      vertical location of the bar.
      
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Array")
       (optional yes)
      )
      (input 2
       (type data)
       (name "BarNo")
       (optional yes)
      )
      (input 3
       (type data)
       (name "Inc")
       (optional yes)
      )
      (output 1
       (type data)
       (name "X-Start")
       (lock constraints)
       (optional yes)
      )
      (output 2
       (type data)
       (name "X-Stop")
       (lock constraints)
       (optional yes)
      )
      (output 3
       (type data)
       (name "Y-Max")
       (lock constraints)
       (optional yes)
      )
      (output 4
       (type data)
       (name "Y-Min")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Formula"
       (name "y[i]")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "y")
         (optional yes)
        )
        (input 2
         (type data)
         (name "i")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "y[i]")
       )
       (views
        (icon
         (origin 117 193)
         (extent 46 34)
        )
        (detail
         (origin 200 461)
         (extent 90 78)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Formula"
       (name "From")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (optional yes)
        )
        (input 2
         (type data)
         (name "Inc")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "X+Inc/2")
       )
       (views
        (icon
         (origin 227 193)
         (extent 46 34)
        )
        (detail
         (origin 225 240)
         (extent 81 101)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "Formula"
       (name "To")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (optional yes)
        )
        (input 2
         (type data)
         (name "Inc")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "X+1-Inc/2")
       )
       (views
        (icon
         (origin 227 253)
         (extent 46 34)
        )
        (detail
         (origin 410 521)
         (extent 90 78)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 3 "Constant"
       (name "0")
       (subType "Real")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Real")
         (lock name constraints)
        )
       )
       (implementation
        (component value Real
         (name "0")
         (datum 0)
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Real
         (datum 0)
        )
       )
       (views
        (icon
         (origin 217 318)
         (extent 46 25)
        )
        (detail
         (origin 279 446)
         (extent 122 28)
         (showFormat real)
        )
        (active icon)
       )
      )
      (configuration
       (connect I1:1 D0:1)
       (connect I2:1 D0:2)
       (connect I2:1 D1:1)
       (connect I3:1 D1:2)
       (connect I2:1 D2:1)
       (connect I3:1 D2:2)
       (connect D1:1 O1:1)
       (connect D2:1 O2:1)
       (connect D0:1 O3:1)
       (connect D3:1 O4:1)
      )
     )
     (views
      (icon
       (origin 171 148)
       (extent 78 45)
      )
      (detail
       (origin 67 154)
       (extent 246 212)
       (configuration
        (connect I1:1 D0:1
         (Point 69 200)
         (Point 114 200)
        )
        (connect I2:1 D0:2
         (Point 69 270)
         (Point 80 270)
         (Point 80 220)
         (Point 114 220)
        )
        (connect I2:1 D1:1
         (Point 69 270)
         (Point 80 270)
         (Point 80 260)
         (Point 190 260)
         (Point 190 200)
         (Point 224 200)
        )
        (connect I3:1 D1:2
         (Point 69 340)
         (Point 80 340)
         (Point 80 280)
         (Point 200 280)
         (Point 200 220)
         (Point 224 220)
        )
        (connect I2:1 D2:1
         (Point 69 270)
         (Point 80 270)
         (Point 80 260)
         (Point 224 260)
        )
        (connect I3:1 D2:2
         (Point 69 340)
         (Point 80 340)
         (Point 80 280)
         (Point 224 280)
        )
        (connect D1:1 O1:1
         (Point 275 210)
         (Point 290 210)
         (Point 290 190)
         (Point 310 190)
        )
        (connect D2:1 O2:1
         (Point 275 270)
         (Point 290 270)
         (Point 290 240)
         (Point 310 240)
        )
        (connect D0:1 O3:1
         (Point 165 210)
         (Point 180 210)
         (Point 180 300)
         (Point 290 300)
         (Point 290 290)
         (Point 310 290)
        )
        (connect D3:1 O4:1
         (Point 265 330)
         (Point 280 330)
         (Point 280 340)
         (Point 310 340)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 9 "Context"
     (name "BarFill")
     (description 13 6
      Generates the serpentine fill pattern used to
      produce a bar.  The array of coord output 
      represents the line segment end points needed to
      fill the bar. 
      
      An empirical algorithm is used to determine how
      close the lines should be, based on the width of
      the bar.  For extremely high resolution displays
      or output devices, this may not be close enough,
      and the algorithm may need adjustment to give 
      good looking bars.  (Modify the NumPts object).
      
      
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X-Start")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (optional yes)
      )
      (input 2
       (type data)
       (name "X-End")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (optional yes)
      )
      (input 3
       (type data)
       (name "Y-Max")
       (optional yes)
      )
      (input 4
       (type data)
       (name "Y-Min")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Trace1")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Formula"
       (name "Generate Y values")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "B")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "concat(transpose([b a a b]),b[0])")
       )
       (views
        (icon
         (origin 469 328)
         (extent 163 25)
        )
        (detail
         (origin 275 563)
         (extent 340 154)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "ToCoordinate"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X Data")
         (tag "X")
         (requires
          (datatype Real)
         )
         (lock constraints)
        )
        (input 2
         (type data)
         (name "Y Data")
         (tag "Y")
         (requires
          (datatype Real)
         )
         (lock constraints)
        )
        (output 1
         (type data)
         (name "Coord")
         (tag "Coord")
         (lock constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 525 258)
         (extent 110 25)
        )
        (detail
         (origin 510 175)
         (extent 50 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "Constant"
       (name "Density")
       (subType "Real")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Real")
         (lock name constraints)
        )
       )
       (implementation
        (component value Real
         (name "Density")
         (datum 0.03)
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Real
         (datum 0)
        )
       )
       (views
        (icon
         (extent 78 0)
        )
        (detail
         (origin 191 243)
         (extent 138 34)
         (showFormat real)
        )
        (active detail)
       )
      )
      (component 3 "Formula"
       (name "Duplicate each X element")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "B")
         (optional yes)
        )
        (input 3
         (type data)
         (name "n")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "concat(transpose([ramp(2*n,a,b) ramp(2*n,a,b)]),b)")
       )
       (views
        (icon
         (origin 397 173)
         (extent 226 34)
        )
        (detail
         (origin 93 353)
         (extent 484 154)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 4 "AllocateArray"
       (name "Alloc Real")
       (subType "Alloc_Real")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Init Value")
         (tag "Init Value")
         (requires
          (datatype Real)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (input 2
         (type data)
         (name "Dim Size 1")
         (tag "Dim Size 1")
         (requires
          (datatype Int32)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
        (buffers in
         (buffer "Init Value")
         (buffer "Dim Size 1")
        )
       )
       (implementation
        (component numDims 1)
        (component dimSizes "26")
        (component type "Real")
        (component initEnum "Init Value")
        (component initialValue
         (name "Init Value")
         (datum 11)
        )
        (component from 1)
        (component thru 10)
       )
       (views
        (icon
         (origin 335 298)
         (extent 110 25)
        )
        (detail
         (origin 46 305)
         (extent 229 111)
        )
        (active icon)
       )
      )
      (component 5 "AllocateArray"
       (name "Alloc Real")
       (subType "Alloc_Real")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Init Value")
         (tag "Init Value")
         (requires
          (datatype Real)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (input 2
         (type data)
         (name "Dim Size 1")
         (tag "Dim Size 1")
         (requires
          (datatype Int32)
          (shape "Scalar")
         )
         (lock constraints)
         (optional yes)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
        (buffers in
         (buffer "Init Value")
         (buffer "Dim Size 1")
        )
       )
       (implementation
        (component numDims 1)
        (component dimSizes "26")
        (component type "Real")
        (component initEnum "Init Value")
        (component initialValue
         (name "Init Value")
         (datum 0)
        )
        (component from 1)
        (component thru 10)
       )
       (views
        (icon
         (origin 335 338)
         (extent 110 25)
        )
        (detail
         (origin 286 525)
         (extent 229 111)
        )
        (active icon)
       )
      )
      (component 6 "Formula"
       (name " + ")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (lock name constraints)
        )
        (input 2
         (type data)
         (name "Y")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked yes)
        (component expr 1 "X+Y")
       )
       (views
        (icon
         (origin 187 288)
         (extent 46 25)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (component 7 "Formula"
       (name "NumPts")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (input 2
         (type data)
         (name "B")
         (optional yes)
        )
        (input 3
         (type data)
         (name "Density")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "intPart((b-a)/Density)")
       )
       (views
        (icon
         (origin 391 233)
         (extent 78 34)
        )
        (detail
         (origin 356 200)
         (extent 219 120)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
       (connect D4:1 D0:1)
       (connect D5:1 D0:2)
       (connect D3:1 D1:1)
       (connect D0:1 D1:2)
       (connect I1:1 D3:1)
       (connect I2:1 D3:2)
       (connect D7:1 D3:3)
       (connect D6:1 D4:1)
       (connect D7:1 D4:2)
       (connect I4:1 D5:1)
       (connect D7:1 D5:2)
       (connect I3:1 D6:1)
       (connect I4:1 D6:2)
       (connect I1:1 D7:1)
       (connect I2:1 D7:2)
       (connect D2:1 D7:3)
       (connect D1:1 O1:1)
      )
     )
     (views
      (icon
       (origin 281 140)
       (extent 78 61)
      )
      (panel
       (origin 330 179)
       (extent 171 183)
       (widget 2 detail
        (title on)
        (origin 350 227)
        (extent 120 32)
        (showFormat real)
       )
      )
      (detail
       (origin 120 145)
       (extent 571 230)
       (configuration
        (connect D4:1 D0:1
         (Point 447 310)
         (Point 460 310)
         (Point 460 330)
         (Point 466 330)
        )
        (connect D5:1 D0:2
         (Point 447 350)
         (Point 466 350)
        )
        (connect D3:1 D1:1
         (Point 625 190)
         (Point 640 190)
         (Point 640 230)
         (Point 510 230)
         (Point 510 260)
         (Point 522 260)
        )
        (connect D0:1 D1:2
         (Point 634 340)
         (Point 650 340)
         (Point 650 310)
         (Point 510 310)
         (Point 510 280)
         (Point 522 280)
        )
        (connect I1:1 D3:1
         (Point 122 180)
         (Point 394 180)
        )
        (connect I2:1 D3:2
         (Point 122 240)
         (Point 130 240)
         (Point 130 190)
         (Point 394 190)
        )
        (connect D7:1 D3:3
         (Point 471 250)
         (Point 480 250)
         (Point 480 220)
         (Point 380 220)
         (Point 380 200)
         (Point 394 200)
        )
        (connect D6:1 D4:1
         (Point 235 300)
         (Point 332 300)
        )
        (connect D7:1 D4:2
         (Point 471 250)
         (Point 490 250)
         (Point 490 290)
         (Point 340 290)
         (Point 340 310)
         (Point 320 310)
         (Point 320 320)
         (Point 332 320)
        )
        (connect I4:1 D5:1
         (Point 122 360)
         (Point 130 360)
         (Point 130 340)
         (Point 332 340)
        )
        (connect D7:1 D5:2
         (Point 471 250)
         (Point 490 250)
         (Point 490 290)
         (Point 340 290)
         (Point 340 310)
         (Point 320 310)
         (Point 320 360)
         (Point 332 360)
        )
        (connect I3:1 D6:1
         (Point 122 300)
         (Point 130 300)
         (Point 130 290)
         (Point 184 290)
        )
        (connect I4:1 D6:2
         (Point 122 360)
         (Point 130 360)
         (Point 130 310)
         (Point 184 310)
        )
        (connect I1:1 D7:1
         (Point 122 180)
         (Point 360 180)
         (Point 360 240)
         (Point 388 240)
        )
        (connect I2:1 D7:2
         (Point 122 240)
         (Point 130 240)
         (Point 130 190)
         (Point 350 190)
         (Point 350 250)
         (Point 388 250)
        )
        (connect D2:1 D7:3
         (Point 331 260)
         (Point 388 260)
        )
        (connect D1:1 O1:1
         (Point 637 270)
         (Point 688 270)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D2:1 D0:1)
     (connect D4:1 D0:2)
     (connect D0:0 D0:3)
     (connect D4:0 D1:0)
     (connect D3:5 D1:1)
     (connect D9:1 D2:1)
     (connect D6:1 D2:2)
     (connect D5:1 D2:3)
     (connect I1:1 D3:1)
     (connect D5:0 D4:0)
     (connect D6:0 D5:0)
     (connect I1:1 D5:1)
     (connect D3:5 D5:2)
     (connect I1:1 D6:1)
     (connect I1:1 D8:1)
     (connect D1:1 D8:2)
     (connect D7:1 D8:3)
     (connect D8:1 D9:1)
     (connect D8:2 D9:2)
     (connect D8:3 D9:3)
     (connect D8:4 D9:4)
    )
   )
   (views
    (icon
     (origin 529 318)
     (extent 163 25)
    )
    (panel
     (origin 474 125)
     (extent 473 331)
     (widget 0 detail
      (title off)
      (origin 478 129)
      (extent 468 323)
      (displayMode annotGraph)
      (graphType cartesian)
      (gridType frame)
      (scale 0
       (name "Y name")
       (domainName "X name")
       (pen 1)
       (show 1)
       (range 0 14 4 linear)
      )
      (domain 0 10 4 linear)
      (trace 0 onScale 0
       (name "Trace1")
       (pen 7)
       (lineType 1)
       (pointType 0)
      )
     )
    )
    (detail
     (origin 56 122)
     (extent 689 417)
     (configuration
      (connect D2:1 D0:1
       (Point 375 270)
       (Point 390 270)
       (Point 390 220)
       (Point 414 220)
      )
      (connect D4:1 D0:2
       (Point 345 380)
       (Point 360 380)
       (Point 360 310)
       (Point 414 310)
      )
      (connect D0:0 D0:3
       (Point 580 451)
       (Point 580 470)
       (Point 390 470)
       (Point 390 400)
       (Point 414 400)
      )
      (connect D4:0 D1:0
       (Point 320 395)
       (Point 320 405)
      )
      (connect D3:5 D1:1
       (Point 237 460)
       (Point 250 460)
       (Point 250 440)
       (Point 262 440)
      )
      (connect D9:1 D2:1
       (Point 361 170)
       (Point 380 170)
       (Point 380 220)
       (Point 310 220)
       (Point 310 260)
       (Point 324 260)
      )
      (connect D6:1 D2:2
       (Point 257 310)
       (Point 290 310)
       (Point 290 270)
       (Point 324 270)
      )
      (connect D5:1 D2:3
       (Point 257 350)
       (Point 300 350)
       (Point 300 280)
       (Point 324 280)
      )
      (connect I1:1 D3:1
       (Point 58 340)
       (Point 110 340)
       (Point 110 440)
       (Point 122 440)
      )
      (connect D5:0 D4:0
       (Point 200 365)
       (Point 200 380)
       (Point 270 380)
       (Point 270 360)
       (Point 320 360)
       (Point 320 365)
      )
      (connect D6:0 D5:0
       (Point 200 325)
       (Point 200 335)
      )
      (connect I1:1 D5:1
       (Point 58 340)
       (Point 142 340)
      )
      (connect D3:5 D5:2
       (Point 237 460)
       (Point 250 460)
       (Point 250 390)
       (Point 130 390)
       (Point 130 360)
       (Point 142 360)
      )
      (connect I1:1 D6:1
       (Point 58 340)
       (Point 110 340)
       (Point 110 310)
       (Point 142 310)
      )
      (connect I1:1 D8:1
       (Point 58 340)
       (Point 90 340)
       (Point 90 160)
       (Point 168 160)
      )
      (connect D1:1 D8:2
       (Point 377 440)
       (Point 400 440)
       (Point 400 490)
       (Point 100 490)
       (Point 100 170)
       (Point 168 170)
      )
      (connect D7:1 D8:3
       (Point 266 270)
       (Point 280 270)
       (Point 280 260)
       (Point 290 260)
       (Point 290 210)
       (Point 160 210)
       (Point 160 180)
       (Point 168 180)
      )
      (connect D8:1 D9:1
       (Point 251 150)
       (Point 278 150)
      )
      (connect D8:2 D9:2
       (Point 251 160)
       (Point 278 160)
      )
      (connect D8:3 D9:3
       (Point 251 170)
       (Point 278 170)
      )
      (connect D8:4 D9:4
       (Point 251 180)
       (Point 278 180)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 2 "Context"
   (name "Generate Data")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Result")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Constant"
     (name "Low Limit")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Low Limit")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 28 356)
       (extent 165 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 1 "Constant"
     (name "High Limit")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "High Limit")
       (datum 1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 23 426)
       (extent 174 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 2 "Context"
     (name "100 random #s")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Array")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Collector"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (tag "Data")
        )
        (input 2
         (type trigger)
         (name "XEQ")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
       )
       (implementation
        (component clearAtPrerun 1)
        (component clearAtActivate 1)
       )
       (views
        (icon
         (origin 280 248)
         (extent 110 25)
        )
        (detail
         (origin 265 455)
         (extent 60 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "RandomNumber"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Rand Val")
         (lock name constraints)
        )
       )
       (implementation
        (component lowerLimit 0)
        (component upperLimit 1)
       )
       (views
        (icon
         (origin 107 258)
         (extent 127 25)
        )
        (detail
         (origin 109 410)
         (extent 222 60)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "ForCount"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Count")
         (lock name constraints)
        )
       )
       (implementation
        (component count 100)
       )
       (views
        (icon
         (origin 90 168)
         (extent 110 64)
         (iconImage "loop.icon")
        )
        (detail
         (origin 60 183)
         (extent 170 34)
        )
        (active detail)
       )
      )
      (configuration
       (connect D1:1 D0:1)
       (connect D2:0 D0:2)
       (connect D2:1 D1:0)
       (connect D0:1 O1:1)
      )
     )
     (views
      (icon
       (origin 37 278)
       (extent 127 25)
      )
      (detail
       (origin 31 130)
       (extent 388 200)
       (configuration
        (connect D1:1 D0:1
         (Point 236 270)
         (Point 250 270)
         (Point 250 250)
         (Point 277 250)
        )
        (connect D2:0 D0:2
         (Point 145 219)
         (Point 145 240)
         (Point 85 240)
         (Point 85 300)
         (Point 255 300)
         (Point 255 270)
         (Point 277 270)
        )
        (connect D2:1 D1:0
         (Point 232 200)
         (Point 250 200)
         (Point 250 240)
         (Point 170 240)
         (Point 170 255)
        )
        (connect D0:1 O1:1
         (Point 392 260)
         (Point 416 240)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Constant"
     (name "step")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "step")
       (datum 0.1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 487 708)
       (extent 46 25)
      )
      (detail
       (origin 39 496)
       (extent 122 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 4 "Formula"
     (name "magDist()")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "From")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "Thru")
       (lock name constraints)
      )
      (input 4
       (type data)
       (name "Step")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "magDist(x,from,thru,step)")
     )
     (views
      (icon
       (origin 255 388)
       (extent 110 45)
      )
      (detail
       (origin 421 305)
       (extent 259 210)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D2:1 D4:1)
     (connect D0:1 D4:2)
     (connect D1:1 D4:3)
     (connect D3:1 D4:4)
     (connect D4:1 O1:1)
    )
   )
   (views
    (icon
     (extent 127 0)
    )
    (detail
     (origin 20 261)
     (extent 360 278)
     (configuration
      (connect D2:1 D4:1
       (Point 166 290)
       (Point 230 290)
       (Point 230 390)
       (Point 252 390)
      )
      (connect D0:1 D4:2
       (Point 195 370)
       (Point 220 370)
       (Point 220 400)
       (Point 252 400)
      )
      (connect D1:1 D4:3
       (Point 199 440)
       (Point 220 440)
       (Point 220 410)
       (Point 252 410)
      )
      (connect D3:1 D4:4
       (Point 163 510)
       (Point 230 510)
       (Point 230 420)
       (Point 252 420)
      )
      (connect D4:1 O1:1
       (Point 367 410)
       (Point 377 410)
      )
     )
    )
    (active detail)
   )
  )
  (component 3 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 12 619)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 4 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 482)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 21 9
         PURPOSE:     Illustrates use of the BarChart library object to display an array of data.
         
         USER INPUT REQUIRED: Press Run to display the Bar Chart.
         
         EXPLANATION: To generate some interesting data to display, an array of 100 random numbers
                      between 0 and 1.0 is analyzed to get the magnitude Distribution in 10 "bins"
                      between 0 and 1.  The resulting array has 10 elements representing the number
                      of numbers in each of the 10 bins.  This array is given to the BarChart
                      library object for display.
         
         IMPLEMENTATION:  The BarChart library object provides additional usage information from
                      the Show Description choice in the object menu.  Setting colors, etc. is
                      described here, along with a description of the input requirements.  When
                      using the BarChart object in your models, you may want to place and size it,
                      then secure the User Object to prevent inadvertent changes.
         
                      Since the BarChart is a User Object, you may want to examine it to see how
                      the barchart is generated.  Some advanced techniques are used to generate
                      the serpentine fill pattern using parallel array operations to obtain the
                      needed speed.  
         
        )
       )
       (views
        (icon
         (origin 410 415)
         (extent 78 25)
        )
        (detail
         (origin 25 209)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 0 41)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 45 175)
         (extent 832 463)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 415 408)
     (extent 110 25)
    )
    (panel
     (origin 41 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 143 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D2:1 D0:1)
   (connect D2:1 D1:1)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 850 558)
   (widget 3 detail
    (title on)
    (origin 412 114)
    (extent 397 82)
    (editing disabled)
   )
   (widget 1 panel
    (title on)
    (origin 285 244)
    (extent 526 331)
    (widget 0 detail
     (title off)
     (origin 289 248)
     (extent 519 323)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType frame)
     (scale 0
      (name "Y name")
      (domainName "X name")
      (pen 1)
      (show 1)
      (range 0 14 4 linear)
     )
     (domain 0 10 4 linear)
     (trace 0 onScale 0
      (name "Trace1")
      (pen 7)
      (lineType 1)
      (pointType 0)
     )
    )
   )
   (widget 0 detail
    (title on)
    (origin 44 247)
    (extent 171 322)
   )
   (widget 4 panel
    (title on)
    (origin 41 117)
    (extent 319 77)
    (widget 1 icon
     (title off)
     (origin 143 130)
     (extent 114 39)
     (format button)
    )
   )
  )
  (detail
   (origin 0 67)
   (extent 1004 664)
   (configuration
    (connect D2:1 D0:1
     (Point 402 410)
     (Point 430 410)
     (Point 430 610)
     (Point 469 610)
    )
    (connect D2:1 D1:1
     (Point 402 410)
     (Point 420 410)
     (Point 420 290)
     (Point 471 290)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
