#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Thu 29/Aug/1991")
(component 0 "Context"
 (name "DS1 Pulse Template Test")
 (interface
  (sequence in)
  (sequence out)
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Constant"
   (name "Upper Points")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Coord")
     (lock name constraints)
    )
   )
   (implementation
    (component value Coord
     (name "Upper Points")
     (numDims 1)
     (size 11)
     (numCoordDims 2)
     (data
      [ (0,0.05) (2.5E-07,0.05) (3.25E-07,0.8) (3.26E-07,1.15) (4.25E-07,1.15) (5.000000000000001E-07,1.05) (6.75E-07,1.05) (7.25E-07,-0.07000000000000001) (1.1E-06,0.05) (1.25E-06,0.05) (2.004E-06,0.05) ]
     )
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Coord
     (numCoordDims 2)
     (datum (0,0))
    )
   )
   (views
    (icon
     (origin 141 488)
     (extent 118 25)
    )
    (detail
     (origin 13 448)
     (extent 194 64)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 1 "Constant"
   (name "Lower Points")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Coord")
     (lock name constraints)
    )
   )
   (implementation
    (component value Coord
     (name "Lower Points")
     (numDims 1)
     (size 13)
     (numCoordDims 2)
     (data
      [ (0,-0.05) (3.499999999999999E-07,-0.05) (3.51E-07,0.5) (4E-07,0.95) (5.000000000000001E-07,0.95) (6.000000000000001E-07,0.9) (6.5E-07,0.5) (6.51E-07,-0.45) (8.000000000000001E-07,-0.45) (9.25E-07,-0.2) (1.1E-06,-0.05) (1.25E-06,-0.05) (2.004E-06,-0.05) ]
     )
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Coord
     (numCoordDims 2)
     (datum (0,0))
    )
   )
   (views
    (icon
     (origin 141 658)
     (extent 118 25)
    )
    (detail
     (origin 13 618)
     (extent 194 64)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 2 "Comparator"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Ref Value")
     (tag "RefValue")
    )
    (input 2
     (type data)
     (name "Test Value")
     (tag "TestValue")
    )
    (output 1
     (type data)
     (name "Passed")
     (tag "Passed")
     (lock name constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "Failed")
     (tag "Failed")
     (lock name constraints)
     (optional yes)
    )
    (output 3
     (type data)
     (name "Failures")
     (tag "Failures")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (attr relation ">=")
   )
   (views
    (icon
     (origin 255 583)
     (extent 110 34)
    )
    (detail
     (origin 305 725)
     (extent 251 110)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "Comparator"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Ref Value")
     (tag "RefValue")
    )
    (input 2
     (type data)
     (name "Test Value")
     (tag "TestValue")
    )
    (output 1
     (type data)
     (name "Passed")
     (tag "Passed")
     (lock name constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "Failed")
     (tag "Failed")
     (lock name constraints)
     (optional yes)
    )
    (output 3
     (type data)
     (name "Failures")
     (tag "Failures")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (attr relation "<=")
   )
   (views
    (icon
     (origin 255 473)
     (extent 110 34)
    )
    (detail
     (origin 455 425)
     (extent 251 110)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "VectorConcatenator"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Array")
     (tag "Array")
     (lock constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 421 498)
     (extent 118 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "LiteralConstant"
   (name "Fail")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Fail")
     (datum "FAIL")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (origin 487 338)
     (extent 46 25)
    )
    (detail
     (origin 680 166)
     (extent 201 28)
    )
    (active icon)
   )
  )
  (component 6 "Junction"
   (name "JCT")
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 446 306)
     (extent 48 28)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "Formula"
   (name " AND ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "x AND y")
   )
   (views
    (icon
     (origin 440 246)
     (extent 80 28)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "LiteralConstant"
   (name "Pass")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Pass")
     (datum "PASS")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (origin 537 268)
     (extent 46 25)
    )
    (detail
     (origin 680 126)
     (extent 201 28)
    )
    (active icon)
   )
  )
  (component 9 "Junction"
   (name "JCT")
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 627 278)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 10 "TextDisplay"
   (name "Test Result")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 725 272)
     (extent 190 37)
    )
    (active detail)
   )
  )
  (component 11 "Note"
   (name "TO OPERATE")
   (interface
   )
   (implementation
    (component text 3 5
     Set a Reference Delay time
     using the slider and observe
     the resulting displays.
    )
   )
   (views
    (icon
     (origin 245 238)
     (extent 110 64)
     (iconImage "notepad.icon")
    )
    (detail
     (origin 270 255)
     (extent 180 90)
     (editing enabled)
    )
    (active icon)
   )
  )
  (component 12 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 592 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 13 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 482)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 14 9
         PURPOSE:      Simulates a DS1 Pulse Template test using previously stored waveform data.
         
         USER INPUT REQUIRED: Select a Reference Delay using the slider.
         
         EXPLANATION:  A common measurement in the telecomm field monitors the pulse shape from
                       a DS1 test fixture.  This model illustrates how to automate the waveform
                       template matching to a measured DS1 pulse. 
         
                       The Upper and Lower limits are defined using coordinates of the line
                       segment end points for the templates.  By passing the normalized measured
                       pulse through the upper and lower comparaters, any points outside the
                       template area are discovered and plotted.
                             
         
        )
       )
       (views
        (icon
         (origin 410 415)
         (extent 78 25)
        )
        (detail
         (origin 25 209)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 44 95)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 45 175)
         (extent 832 463)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 415 408)
     (extent 110 25)
    )
    (panel
     (origin 251 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 353 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 14 "Formula"
   (name "Normalize")
   (description 3 4
    The specification calls for normalized data.  This
    is computed by dividing the Y values by the +3 V
    max specification.  That is +3 V normalizes to 1.0.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "A/3")
   )
   (views
    (icon
     (origin 245 358)
     (extent 110 64)
     (iconImage "formula.icon")
    )
    (detail
     (origin 501 403)
     (extent 79 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 15 "Context"
   (name "Read Data Files")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "RefDly")
     (optional yes)
    )
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "FromArray"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (tag "Ary")
      )
      (input 2
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "SubAry")
       (tag "Result")
       (lock constraints)
      )
      (output 2
       (type data)
       (name "Type")
       (tag "Type")
       (lock constraints)
      )
      (output 3
       (type data)
       (name "NumDims")
       (tag "NumDims")
       (lock constraints)
      )
      (output 4
       (type data)
       (name "DimSizes")
       (tag "DimSizes")
       (lock constraints)
      )
      (output 5
       (type data)
       (name "TotSize")
       (tag "TotSize")
       (lock constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary[A:*]")
     )
     (views
      (icon
       (origin 505 288)
       (extent 110 64)
       (iconImage "unbuild.icon")
      )
      (detail
       (origin 612 290)
       (extent 147 160)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Formula"
     (name "RefDlyMappingFrom")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "xorig")
       (optional yes)
      )
      (input 2
       (type data)
       (name "RefDly")
       (optional yes)
      )
      (input 3
       (type data)
       (name "xinc")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "intPart(abs((xorig+RefDly)/xinc))")
     )
     (views
      (icon
       (origin 279 308)
       (extent 163 64)
       (iconImage "formula.icon")
      )
      (detail
       (origin 130 393)
       (extent 331 154)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "FromFile"
     (name "Read Preamble")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "pts")
       (lock constraints)
       (optional yes)
      )
      (output 2
       (type data)
       (name "cnt")
       (lock constraints)
       (optional yes)
      )
      (output 3
       (type data)
       (name "xinc")
       (lock constraints)
       (optional yes)
      )
      (output 4
       (type data)
       (name "xorig")
       (lock constraints)
       (optional yes)
      )
      (output 5
       (type data)
       (name "xref")
       (lock constraints)
       (optional yes)
      )
      (output 6
       (type data)
       (name "yinc")
       (lock constraints)
       (optional yes)
      )
      (output 7
       (type data)
       (name "yorig")
       (lock constraints)
       (optional yes)
      )
      (output 8
       (type data)
       (name "yref")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (attr iopath file read "/usr/lib/veetest/examples/applications/telecom1.dat"
       (readTerm "\n")
       (fs " ")
       (eol "\n")
       (multiField fullSyntax)
       (arrayFormat block)
      )
      (procedure
        READ TEXT pts REAL COUNT:1
        READ TEXT cnt REAL COUNT:1
        READ TEXT xinc REAL COUNT:1
        READ TEXT xorig REAL COUNT:1
        READ TEXT xref REAL COUNT:1
        READ TEXT yinc REAL COUNT:1
        READ TEXT yorig REAL COUNT:1
        READ TEXT yref REAL COUNT:1
      )
     )
     (views
      (icon
       (origin 82 498)
       (extent 127 85)
      )
      (detail
       (origin 108 403)
       (extent 324 274)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "FromFile"
     (name "Read Raw Data")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "X")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (attr iopath file read "/usr/lib/veetest/examples/applications/telecom2.dat"
       (readTerm "\n")
       (fs " ")
       (eol "\n")
       (multiField fullSyntax)
       (arrayFormat block)
      )
      (procedure
        READ TEXT x REAL COUNT:501
      )
     )
     (views
      (icon
       (origin 297 268)
       (extent 127 25)
      )
      (detail
       (origin 338 294)
       (extent 324 153)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "ToFunction"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "InArray")
       (tag "InArray")
       (lock constraints)
      )
      (input 2
       (type data)
       (name "Map To 1")
       (tag "Map To 1")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "OutFunc")
       (tag "OutFunc")
       (lock constraints)
      )
      (buffers in
       (buffer "Map To 1")
      )
     )
     (implementation
      (component numDims 1)
      (component xMappings "Linear")
      (component mapFroms "0")
      (component mapTos "1.672E-06")
     )
     (views
      (icon
       (origin 531 378)
       (extent 118 64)
       (iconImage "build.icon")
      )
      (detail
       (origin 442 333)
       (extent 347 154)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "Formula"
     (name "RefDlyMappingTo")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "RefDly")
       (optional yes)
      )
      (input 2
       (type data)
       (name "pts")
       (optional yes)
      )
      (input 3
       (type data)
       (name "xinc")
       (optional yes)
      )
      (input 4
       (type data)
       (name "xorig")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "((pts*xinc)+xorig)+RefDly")
     )
     (views
      (icon
       (origin 288 398)
       (extent 145 64)
       (iconImage "formula.icon")
      )
      (detail
       (origin 142 333)
       (extent 277 254)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 6 "Junction"
     (name "JCT")
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "C")
       (optional yes)
      )
      (input 4
       (type data)
       (name "D")
       (optional yes)
      )
      (input 5
       (type data)
       (name "E")
       (optional yes)
      )
      (input 6
       (type data)
       (name "F")
       (optional yes)
      )
      (input 7
       (type data)
       (name "G")
       (optional yes)
      )
      (input 8
       (type data)
       (name "H")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 337 498)
       (extent 46 85)
      )
      (detail
       (origin 545 335)
       (extent 40 410)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "ScrollingTextDisplay"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (origin 425 528)
       (extent 190 25)
      )
      (detail
       (origin 570 446)
       (extent 260 188)
       (bufferSize 256)
      )
      (active icon)
     )
    )
    (component 8 "Formula"
     (name "Scale Y")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "unscaled")
       (optional yes)
      )
      (input 2
       (type data)
       (name "yinc")
       (optional yes)
      )
      (input 3
       (type data)
       (name "yorig")
       (optional yes)
      )
      (input 4
       (type data)
       (name "yref")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "(unscaled-yref)*yinc+yorig")
     )
     (views
      (icon
       (origin 721 398)
       (extent 78 64)
       (iconImage "formula.icon")
      )
      (detail
       (origin 541 358)
       (extent 268 204)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D3:1 D0:1)
     (connect D1:1 D0:2)
     (connect D2:4 D1:1)
     (connect I1:1 D1:2)
     (connect D2:3 D1:3)
     (connect D0:1 D4:1)
     (connect D5:1 D4:2)
     (connect I1:1 D5:1)
     (connect D2:1 D5:2)
     (connect D2:3 D5:3)
     (connect D2:4 D5:4)
     (connect D2:1 D6:1)
     (connect D2:2 D6:2)
     (connect D2:3 D6:3)
     (connect D2:4 D6:4)
     (connect D2:5 D6:5)
     (connect D2:6 D6:6)
     (connect D2:7 D6:7)
     (connect D2:8 D6:8)
     (connect D6:1 D7:1)
     (connect D4:1 D8:1)
     (connect D2:6 D8:2)
     (connect D2:7 D8:3)
     (connect D2:8 D8:4)
     (connect D8:1 O1:1)
    )
   )
   (views
    (icon
     (origin 38 378)
     (extent 145 25)
    )
    (detail
     (origin 71 246)
     (extent 818 448)
     (configuration
      (connect D3:1 D0:1
       (Point 426 280)
       (Point 460 280)
       (Point 460 300)
       (Point 502 300)
      )
      (connect D1:1 D0:2
       (Point 444 340)
       (Point 502 340)
      )
      (connect D2:4 D1:1
       (Point 211 530)
       (Point 200 530)
       (Point 200 320)
       (Point 276 320)
      )
      (connect I1:1 D1:2
       (Point 73 480)
       (Point 80 480)
       (Point 80 410)
       (Point 230 410)
       (Point 230 340)
       (Point 276 340)
      )
      (connect D2:3 D1:3
       (Point 211 520)
       (Point 240 520)
       (Point 240 360)
       (Point 276 360)
      )
      (connect D0:1 D4:1
       (Point 617 300)
       (Point 630 300)
       (Point 630 360)
       (Point 520 360)
       (Point 520 390)
       (Point 528 390)
      )
      (connect D5:1 D4:2
       (Point 435 430)
       (Point 528 430)
      )
      (connect I1:1 D5:1
       (Point 73 480)
       (Point 80 480)
       (Point 80 410)
       (Point 285 410)
      )
      (connect D2:1 D5:2
       (Point 211 500)
       (Point 230 500)
       (Point 230 420)
       (Point 285 420)
      )
      (connect D2:3 D5:3
       (Point 211 520)
       (Point 240 520)
       (Point 240 430)
       (Point 285 430)
      )
      (connect D2:4 D5:4
       (Point 211 530)
       (Point 250 530)
       (Point 250 440)
       (Point 285 440)
      )
      (connect D2:1 D6:1
       (Point 211 500)
       (Point 334 500)
      )
      (connect D2:2 D6:2
       (Point 211 510)
       (Point 334 510)
      )
      (connect D2:3 D6:3
       (Point 211 520)
       (Point 334 520)
      )
      (connect D2:4 D6:4
       (Point 211 530)
       (Point 334 530)
      )
      (connect D2:5 D6:5
       (Point 211 540)
       (Point 334 540)
      )
      (connect D2:6 D6:6
       (Point 211 550)
       (Point 334 550)
      )
      (connect D2:7 D6:7
       (Point 211 560)
       (Point 334 560)
      )
      (connect D2:8 D6:8
       (Point 211 570)
       (Point 334 570)
      )
      (connect D6:1 D7:1
       (Point 385 540)
       (Point 422 540)
      )
      (connect D4:1 D8:1
       (Point 651 410)
       (Point 718 410)
      )
      (connect D2:6 D8:2
       (Point 211 550)
       (Point 200 550)
       (Point 200 620)
       (Point 690 620)
       (Point 690 420)
       (Point 718 420)
      )
      (connect D2:7 D8:3
       (Point 211 560)
       (Point 310 560)
       (Point 310 610)
       (Point 680 610)
       (Point 680 430)
       (Point 718 430)
      )
      (connect D2:8 D8:4
       (Point 211 570)
       (Point 320 570)
       (Point 320 600)
       (Point 670 600)
       (Point 670 440)
       (Point 718 440)
      )
      (connect D8:1 O1:1
       (Point 801 430)
       (Point 820 430)
       (Point 820 480)
       (Point 886 480)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 16 "Slider"
   (name "Ref Delay")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type control)
     (name "MaxValue")
     (tag "MaxValue")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (input 2
     (type control)
     (name "MinValue")
     (tag "MinValue")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Real")
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Ref Delay")
     (values range 2.5E-07 4.5E-07)
     (datum 4.2E-07)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 3.25E-07)
    )
    (component detents 1E-08)
   )
   (views
    (icon
     (origin 615 368)
     (extent 110 25)
    )
    (detail
     (origin 30 172)
     (extent 181 177)
    )
    (active detail)
   )
  )
  (component 17 "Start"
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 87 92)
     (extent 67 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 18 "YPlot"
   (name "DS1 PULSE")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Fail Points")
    )
    (input 2
     (type data)
     (name "Upper Limit")
     (optional yes)
    )
    (input 3
     (type data)
     (name "Test Signal")
     (optional yes)
    )
    (input 4
     (type data)
     (name "Lower Limit")
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 1)
    (component tracePin 2)
    (component tracePin 3)
    (component tracePin 4)
    (component graphMode rectangular)
   )
   (views
    (icon
     (origin 905 433)
     (extent 110 54)
    )
    (detail
     (origin 592 357)
     (extent 397 347)
     (displayMode scrollGraph)
     (graphType cartesian)
     (gridType off)
     (scale 0
      (name "Amplitude")
      (domainName "Time")
      (pen 9)
      (show 1)
      (range -0.6000000000000001 1.2 3 linear)
     )
     (domain 0 2E-06 3 linear)
     (trace 0 onScale 0
      (name "Fail Points")
      (pen 2)
      (lineType 2)
      (pointType 1)
     )
     (trace 1 onScale 0
      (name "Upper Limit")
      (pen 3)
      (lineType 1)
      (pointType 0)
     )
     (trace 2 onScale 0
      (name "Test Signal")
      (pen 1)
      (lineType 1)
      (pointType 0)
     )
     (trace 3 onScale 0
      (name "Lower Limit")
      (pen 3)
      (lineType 1)
      (pointType 0)
     )
     (markerInterpolate 1)
    )
    (active detail)
   )
  )
  (configuration
   (connect D15:0 D0:0)
   (connect D0:0 D1:0)
   (connect D1:1 D2:1)
   (connect D14:1 D2:2)
   (connect D0:1 D3:1)
   (connect D14:1 D3:2)
   (connect D3:3 D4:1)
   (connect D2:3 D4:2)
   (connect D6:1 D5:0)
   (connect D3:2 D6:1)
   (connect D2:2 D6:2)
   (connect D3:1 D7:1)
   (connect D2:1 D7:2)
   (connect D7:1 D8:0)
   (connect D8:1 D9:1)
   (connect D5:1 D9:2)
   (connect D9:1 D10:1)
   (connect D15:1 D14:1)
   (connect D16:1 D15:1)
   (connect D17:0 D16:0)
   (connect D4:1 D18:1)
   (connect D0:1 D18:2)
   (connect D14:1 D18:3)
   (connect D1:1 D18:4)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 927 628)
   (widget 10 detail
    (title on)
    (origin 373 240)
    (extent 176 36)
   )
   (widget 16 detail
    (title on)
    (origin 55 321)
    (extent 153 346)
   )
   (widget 18 detail
    (title on)
    (origin 284 320)
    (extent 587 346)
    (displayMode annotGraph)
    (graphType cartesian)
    (gridType off)
    (scale 0
     (name "Amplitude")
     (domainName "Time")
     (pen 9)
     (show 1)
     (range -0.6000000000000001 1.2 3 linear)
    )
    (domain 0 2E-06 3 linear)
    (trace 0 onScale 0
     (name "Fail Points")
     (pen 2)
     (lineType 2)
     (pointType 1)
    )
    (trace 1 onScale 0
     (name "Upper Limit")
     (pen 3)
     (lineType 1)
     (pointType 0)
    )
    (trace 2 onScale 0
     (name "Test Signal")
     (pen 1)
     (lineType 1)
     (pointType 0)
    )
    (trace 3 onScale 0
     (name "Lower Limit")
     (pen 3)
     (lineType 1)
     (pointType 0)
    )
    (markerInterpolate 1)
   )
   (widget 12 detail
    (title on)
    (origin 513 108)
    (extent 397 82)
    (editing disabled)
   )
   (widget 13 panel
    (title on)
    (origin 306 109)
    (extent 193 79)
    (widget 1 icon
     (title off)
     (origin 341 125)
     (extent 114 39)
     (format button)
    )
   )
   (widget 11 detail
    (title on)
    (origin 18 110)
    (extent 271 76)
    (editing disabled)
   )
  )
  (detail
   (origin 0 67)
   (extent 1004 664)
   (configuration
    (connect D15:0 D0:0
     (Point 110 405)
     (Point 110 415)
    )
    (connect D0:0 D1:0
     (Point 110 514)
     (Point 110 585)
    )
    (connect D1:1 D2:1
     (Point 209 650)
     (Point 230 650)
     (Point 230 590)
     (Point 252 590)
    )
    (connect D14:1 D2:2
     (Point 357 390)
     (Point 370 390)
     (Point 370 440)
     (Point 240 440)
     (Point 240 610)
     (Point 252 610)
    )
    (connect D0:1 D3:1
     (Point 209 480)
     (Point 252 480)
    )
    (connect D14:1 D3:2
     (Point 357 390)
     (Point 370 390)
     (Point 370 440)
     (Point 240 440)
     (Point 240 500)
     (Point 252 500)
    )
    (connect D3:3 D4:1
     (Point 367 500)
     (Point 418 500)
    )
    (connect D2:3 D4:2
     (Point 367 610)
     (Point 380 610)
     (Point 380 520)
     (Point 418 520)
    )
    (connect D6:1 D5:0
     (Point 496 320)
     (Point 510 320)
     (Point 510 335)
    )
    (connect D3:2 D6:1
     (Point 367 490)
     (Point 380 490)
     (Point 380 310)
     (Point 443 310)
    )
    (connect D2:2 D6:2
     (Point 367 600)
     (Point 430 600)
     (Point 430 330)
     (Point 443 330)
    )
    (connect D3:1 D7:1
     (Point 367 480)
     (Point 390 480)
     (Point 390 250)
     (Point 437 250)
    )
    (connect D2:1 D7:2
     (Point 367 590)
     (Point 400 590)
     (Point 400 270)
     (Point 437 270)
    )
    (connect D7:1 D8:0
     (Point 522 260)
     (Point 560 260)
     (Point 560 265)
    )
    (connect D8:1 D9:1
     (Point 585 280)
     (Point 624 280)
    )
    (connect D5:1 D9:2
     (Point 535 350)
     (Point 570 350)
     (Point 570 300)
     (Point 624 300)
    )
    (connect D9:1 D10:1
     (Point 675 290)
     (Point 722 290)
    )
    (connect D15:1 D14:1
     (Point 185 390)
     (Point 242 390)
    )
    (connect D16:1 D15:1
     (Point 213 260)
     (Point 230 260)
     (Point 230 370)
     (Point 30 370)
     (Point 30 390)
     (Point 35 390)
    )
    (connect D17:0 D16:0
     (Point 120 131)
     (Point 120 139)
    )
    (connect D4:1 D18:1
     (Point 541 510)
     (Point 560 510)
     (Point 560 410)
     (Point 589 410)
    )
    (connect D0:1 D18:2
     (Point 209 480)
     (Point 230 480)
     (Point 230 540)
     (Point 570 540)
     (Point 570 490)
     (Point 589 490)
    )
    (connect D14:1 D18:3
     (Point 357 390)
     (Point 370 390)
     (Point 370 440)
     (Point 240 440)
     (Point 240 640)
     (Point 440 640)
     (Point 440 570)
     (Point 589 570)
    )
    (connect D1:1 D18:4
     (Point 209 650)
     (Point 589 650)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
