#! /usr/lib/veetest/veetest -r
(revision "A.00.00")
(date "Wed 10/Apr/1991")
(component 0 "Context"
 (name "Mixer Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Context"
   (name "Create Mapping Array")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Ary")
     (optional yes)
    )
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else If")
       (lock name constraints)
      )
      (output 3
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a==\"Linear\"")
      (component expr "a==\"Log\"")
     )
     (views
      (icon
       (origin 271 533)
       (extent 78 34)
      )
      (detail
       (origin 456 253)
       (extent 149 94)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "FromFunction"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Function")
       (tag "Function")
      )
      (output 1
       (type data)
       (name "Dim 1 Map")
       (tag "Dim 1 Map")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Dim 1 From")
       (tag "Dim 1 From")
       (lock name constraints)
      )
      (output 3
       (type data)
       (name "Dim 1 To")
       (tag "Dim 1 To")
       (lock name constraints)
      )
     )
     (implementation
      (component numDims 1)
     )
     (views
      (icon
       (origin 71 593)
       (extent 118 34)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Formula"
     (name "logRamp(numElem,from,thru)")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "numElem")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "from")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "thru")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "logRamp(numElem,from,thru)")
     )
     (views
      (icon
       (origin 258 593)
       (extent 244 34)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Formula"
     (name "ramp(numElem,from,thru)")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "numElem")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "from")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "thru")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "ramp(numElem,from,thru)")
     )
     (views
      (icon
       (origin 292 643)
       (extent 217 34)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "FromArray"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (tag "Ary")
      )
      (output 1
       (type data)
       (name "SubAry")
       (tag "Result")
       (lock constraints)
      )
      (output 2
       (type data)
       (name "Type")
       (tag "Type")
       (lock constraints)
      )
      (output 3
       (type data)
       (name "NumDims")
       (tag "NumDims")
       (lock constraints)
      )
      (output 4
       (type data)
       (name "DimSizes")
       (tag "DimSizes")
       (lock constraints)
      )
      (output 5
       (type data)
       (name "TotSize")
       (tag "TotSize")
       (lock constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary")
     )
     (views
      (icon
       (origin 75 523)
       (extent 110 54)
      )
      (detail
       (origin 132 450)
       (extent 147 160)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "Junction"
     (name "JCT")
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 537 608)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 6 "ToFunction"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "InArray")
       (tag "InArray")
       (lock constraints)
      )
      (input 2
       (type data)
       (name "Map From 1")
       (tag "Map From 1")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (input 3
       (type data)
       (name "Map To 1")
       (tag "Map To 1")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "OutFunc")
       (tag "OutFunc")
       (lock constraints)
      )
      (buffers in
       (buffer "Map From 1")
       (buffer "Map To 1")
      )
     )
     (implementation
      (component numDims 1)
      (component xMappings "Linear")
      (component mapFroms "0")
      (component mapTos "819300")
     )
     (views
      (icon
       (origin 621 608)
       (extent 118 64)
       (iconImage build.icon)
      )
      (detail
       (extent 0 83)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect I1:1 D1:1)
     (connect D0:2 D2:0)
     (connect D4:5 D2:1)
     (connect D1:2 D2:2)
     (connect D1:3 D2:3)
     (connect D0:1 D3:0)
     (connect D4:5 D3:1)
     (connect D1:2 D3:2)
     (connect D1:3 D3:3)
     (connect I1:1 D4:1)
     (connect D2:1 D5:1)
     (connect D3:1 D5:2)
     (connect D5:1 D6:1)
     (connect D1:2 D6:2)
     (connect D1:3 D6:3)
     (connect D6:1 O1:1)
    )
   )
   (views
    (description 10 5
     Certain array types have mappings: functions,
     spectra, and waveforms.  This library object 
     creates an array which contains the "x" values 
     for the "y" values in the mapped array.
     
     For a spectrum, the array contains the frequencies
     of the values in the spectrum.
     
     For a waveform, the array contains time values for
     the points in the waveform.
    )
    (icon
     (origin 135 598)
     (extent 190 25)
    )
    (detail
     (origin 48 503)
     (extent 814 194)
     (configuration
      (connect D1:1 D0:1
       (Point 191 600)
       (Point 200 600)
       (Point 200 590)
       (Point 220 590)
       (Point 220 550)
       (Point 268 550)
      )
      (connect I1:1 D1:1
       (Point 50 610)
       (Point 58 610)
       (Point 58 610)
       (Point 68 610)
      )
      (connect D0:2 D2:0
       (Point 351 550)
       (Point 380 550)
       (Point 380 590)
      )
      (connect D4:5 D2:1
       (Point 187 570)
       (Point 210 570)
       (Point 210 600)
       (Point 255 600)
      )
      (connect D1:2 D2:2
       (Point 191 610)
       (Point 255 610)
      )
      (connect D1:3 D2:3
       (Point 191 620)
       (Point 255 620)
      )
      (connect D0:1 D3:0
       (Point 351 540)
       (Point 400 540)
       (Point 400 640)
      )
      (connect D4:5 D3:1
       (Point 187 570)
       (Point 210 570)
       (Point 210 600)
       (Point 240 600)
       (Point 240 580)
       (Point 270 580)
       (Point 270 650)
       (Point 289 650)
      )
      (connect D1:2 D3:2
       (Point 191 610)
       (Point 240 610)
       (Point 240 660)
       (Point 289 660)
      )
      (connect D1:3 D3:3
       (Point 191 620)
       (Point 230 620)
       (Point 230 670)
       (Point 289 670)
      )
      (connect I1:1 D4:1
       (Point 50 610)
       (Point 59 610)
       (Point 59 550)
       (Point 72 550)
      )
      (connect D2:1 D5:1
       (Point 504 610)
       (Point 534 610)
      )
      (connect D3:1 D5:2
       (Point 511 660)
       (Point 520 660)
       (Point 520 630)
       (Point 534 630)
      )
      (connect D5:1 D6:1
       (Point 585 620)
       (Point 618 620)
      )
      (connect D1:2 D6:2
       (Point 191 610)
       (Point 230 610)
       (Point 230 520)
       (Point 600 520)
       (Point 600 640)
       (Point 618 640)
      )
      (connect D1:3 D6:3
       (Point 191 620)
       (Point 230 620)
       (Point 230 670)
       (Point 270 670)
       (Point 270 690)
       (Point 530 690)
       (Point 530 660)
       (Point 618 660)
      )
      (connect D6:1 O1:1
       (Point 741 640)
       (Point 760 640)
       (Point 760 610)
       (Point 859 610)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 1 "Constant"
   (name "Q")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Q")
     (datum 500)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 23 0)
    )
    (detail
     (origin 18 633)
     (extent 85 34)
    )
    (active detail)
   )
  )
  (component 2 "Start"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 36 431)
     (extent 69 39)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "Formula"
   (name " * ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X*Y")
   )
   (views
    (icon
     (origin 180 526)
     (extent 41 29)
    )
    (detail
     (origin 228 218)
     (extent 79 104)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "Formula"
   (name "fft(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "fft(x)")
   )
   (views
    (icon
     (origin 246 526)
     (extent 68 29)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "Formula"
   (name " * ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X*Y")
   )
   (views
    (icon
     (origin 380 576)
     (extent 41 29)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "YPlot"
   (name "Magnitude Spectrum")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "unfiltered")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "filtered")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 1)
    (component tracePin 2)
    (component graphMode freqmag)
   )
   (views
    (icon
     (iconImage display.icon)
    )
    (detail
     (origin 464 230)
     (extent 533 521)
     (displayMode scrollGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Mag")
      (domainName "Freq")
      (color 0x909090)
      (show 1)
      (range 0 4000 4 linear)
     )
     (domain 495000 505000 4 linear)
     (trace 0 onScale 0
      (name "unfiltered")
      (color 0xffdd00)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "filtered")
      (color 0xccff)
      (lineType 1)
      (pointType 0)
     )
     (marker 0 onTrace 0)
     (marker 1 onTrace 1)
     (marker 2)
    )
    (active detail)
   )
  )
  (component 7 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 3 5
     This example is provided as an illustration "as is", 
     and Hewlett-Packard Company makes no warranty of any 
     kind with regard to this example. 
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 470 119)
     (extent 500 63)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 8 "VFunctionGenerator"
   (name "500 kHz sine")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component function Cosine)
    (component frequency 500000)
    (component amplitude 1)
    (component dcOffset 0)
    (component phaseShift 0)
    (component numPoints 16384)
    (component interval 0.01)
    (component degRad Deg)
    (component errorOnAlias 1)
   )
   (views
    (icon
     (origin 11 538)
     (extent 118 25)
    )
    (detail
     (origin 31 451)
     (extent 239 198)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "VFunctionGenerator"
   (name "2 kHz sine")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component function Cosine)
    (component frequency 2000)
    (component amplitude 1)
    (component dcOffset 0)
    (component phaseShift 0)
    (component numPoints 16384)
    (component interval 0.01)
    (component degRad Deg)
    (component errorOnAlias 1)
   )
   (views
    (icon
     (origin 15 488)
     (extent 110 25)
    )
    (detail
     (origin 31 401)
     (extent 239 198)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 10 "Constant"
   (name "Center Freq")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Center Freq")
     (datum 498000)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 19 716)
     (extent 183 29)
    )
    (active detail)
   )
  )
  (component 11 "Formula"
   (name "band pass")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "w")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Q")
     (optional yes)
    )
    (input 3
     (type data)
     (name "fo")
     (optional yes)
    )
    (output 1
     (type data)
     (name " ")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "w*(fo/Q)/((w^2-fo^2)+j(w*fo/Q))")
   )
   (views
    (icon
     (origin 243 703)
     (extent 95 34)
    )
    (detail
     (origin 132 606)
     (extent 326 128)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 12 "Note"
   (name "Overview of Mixer Example")
   (interface
   )
   (implementation
    (component text 47 5
     Purpose: The example demonstrates how to:
     1. simulate signals using the virtual
     source,
     2. obtain information from a 
     sophisticated data structure.
     
     Required user input: none.  Simply press
     Start or Run.  The model requires a
     significant time to execute.
     
     Explanation:
     The two function generators, "2 kHz sine"
     and "500kHz sine", are multiplied 
     together on a point by point basis.  The
     result of this mixing operation is a 
     signal with frequency components at the
     sum and difference of the input 
     frequencies.  The yellow trace in the 
     "Magnitude Spectrum" display shows these
     two components. 
     
     More complicated waveforms can be 
     constructed in HP VEE by using the other
     virtual sources, arbitrary waveform 
     builders, and math functions.
     
     The next part of the example applies a
     filter to the signal.  The filter is the
     same one used in the analogfilt.ex 
     example.
     
     The transfer function of the filter is
     evaluated at the same frequencies as the
     fft is evaluated.  The output of the 
     "fft(x)" object is a Spectrum.  This 
     Spectrum is used with the library 
     object "Create Mapping Array" to create
     an array of the frequencies.
     
     The filtering operation is accomplished
     by multiplying the transfer function of
     the filter with the spectrum of signal.
     The result is shown in the blue trace 
     on the "Magnitude Spectrum" display.
     
     
     
    )
   )
   (views
    (icon
     (extent 235 0)
    )
    (detail
     (origin 31 118)
     (extent 398 305)
     (editing disabled)
    )
    (active detail)
   )
  )
  (configuration
   (connect D4:1 D0:1)
   (connect D9:1 D3:1)
   (connect D8:1 D3:2)
   (connect D3:1 D4:1)
   (connect D4:1 D5:1)
   (connect D11:1 D5:2)
   (connect D3:1 D6:1)
   (connect D5:1 D6:2)
   (connect D9:0 D8:0)
   (connect D2:0 D9:0)
   (connect D0:1 D11:1)
   (connect D1:1 D11:2)
   (connect D10:1 D11:3)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 980 636)
   (configuration
    (connect D4:1 D0:1
     (Point 316 540)
     (Point 330 540)
     (Point 330 580)
     (Point 120 580)
     (Point 120 610)
     (Point 132 610)
    )
    (connect D9:1 D3:1
     (Point 127 500)
     (Point 150 500)
     (Point 150 530)
     (Point 177 530)
    )
    (connect D8:1 D3:2
     (Point 131 550)
     (Point 177 550)
    )
    (connect D3:1 D4:1
     (Point 223 540)
     (Point 243 540)
    )
    (connect D4:1 D5:1
     (Point 316 540)
     (Point 330 540)
     (Point 330 580)
     (Point 377 580)
    )
    (connect D11:1 D5:2
     (Point 340 720)
     (Point 360 720)
     (Point 360 600)
     (Point 377 600)
    )
    (connect D3:1 D6:1
     (Point 223 540)
     (Point 230 540)
     (Point 230 510)
     (Point 440 510)
     (Point 440 360)
     (Point 461 360)
    )
    (connect D5:1 D6:2
     (Point 423 590)
     (Point 440 590)
     (Point 440 620)
     (Point 461 620)
    )
    (connect D9:0 D8:0
     (Point 70 515)
     (Point 70 535)
    )
    (connect D2:0 D9:0
     (Point 70 472)
     (Point 70 485)
    )
    (connect D0:1 D11:1
     (Point 327 610)
     (Point 340 610)
     (Point 340 640)
     (Point 220 640)
     (Point 220 710)
     (Point 240 710)
    )
    (connect D1:1 D11:2
     (Point 105 650)
     (Point 210 650)
     (Point 210 720)
     (Point 240 720)
    )
    (connect D10:1 D11:3
     (Point 204 730)
     (Point 222 730)
     (Point 222 730)
     (Point 240 730)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
