#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Tue 17/Sep/1991")
(component 0 "Context"
 (name "HP VEE-Test: 3852A DAC Example")
 (interface
  (sequence in)
  (sequence out)
 )
 (implementation
  (trigMode rad)
  (locked no)
  (component 0 "Constant"
   (name "NRDGS")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "NRDGS")
     (datum 1024)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 14 224)
     (extent 152 32)
    )
    (active detail)
   )
  )
  (component 1 "LiteralConstant"
   (name "SPER")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "SPER")
     (datum "5e-5")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (extent 46 0)
    )
    (detail
     (origin 17 145)
     (extent 146 30)
    )
    (active detail)
   )
  )
  (component 2 "Constant"
   (name "# of blocks")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "# of blocks")
     (datum 500)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 15 306)
     (extent 171 28)
    )
    (active detail)
   )
  )
  (component 3 "Constant"
   (name "Block size")
   (subType "Integer")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Int32")
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Block size")
     (datum 2048)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 10 404)
     (extent 180 33)
     (showFormat int)
    )
    (active detail)
   )
  )
  (component 4 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 6 5
     This example is provided 
     as an illustration "as 
     is", and Hewlett-Packard
     Company makes no warranty 
     of any kind with regard to 
     this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 719 122)
     (extent 263 117)
     (editing enabled)
    )
    (active detail)
   )
  )
  (component 5 "Gate"
   (description 4 4
    The gate object will allow the current block of
    readings to pass to the HP-UX Escape object when-
    ever the top sequence in pin is pinged by the
    If/Then object titled "A MOD 20 == 0".
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (tag "InData")
    )
    (output 1
     (type data)
     (name "X")
     (tag "OutData")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 727 288)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "IODevice"
   (name "GPIO Data Transfer (GPIO@12)")
   (description 18 4
    Readings are read from the GPIO interface here.
    Readings are placed on the interface in a packed 
    format, 2 bytes per reading. The transaction in
    this Direct I/O object is reading in Int32, or
    two readings at a time. Notice that the number of
    Int32s to read is entered via the variable, cnt.
    In this case this value is 2048. This means that
    4096 readings are being brought into VEE TEST
    every time this object operates. The purpose in 
    reading such large blocks of data is to stay ahead 
    of the 44702A/B's sample rate. If the internal
    memory of the voltmeter is allowed to fill up the
    voltmeter will stop. Depending on the power of the
    controller, it's process load, LAN traffic, and
    disc volume, the size of the blocks can be 
    modified to keep up with the 44702A/B's sample
    rate. 
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "cnt")
     (tag "cnt")
     (optional yes)
    )
    (output 1
     (type data)
     (name "raw")
     (requires
      (datatype Int16)
     )
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (comp iopath "GPIO Transfer")
    (procedure
      READ BINARY raw INT32 COUNT:cnt
    )
   )
   (views
    (icon
     (origin 409 328)
     (extent 262 64)
     (iconImage "/usr/lib/veetest/bitmaps/inst.icon")
    )
    (detail
     (origin 318 603)
     (extent 365 75)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "ForCount"
   (name "For Count")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Count")
     (tag "Count")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (lock name constraints)
    )
    (buffers in
     (buffer "Count")
    )
   )
   (implementation
    (component count 500)
   )
   (views
    (icon
     (origin 254 376)
     (extent 112 69)
     (iconImage "loop.icon")
    )
    (detail
     (origin 408 601)
     (extent 184 39)
    )
    (active icon)
   )
  )
  (component 8 "IODevice"
   (name "Trigger 3852A")
   (description 1 4
    The 44702A/B is triggered here.
   )
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (comp iopath "HP 3852A")
    (procedure
      WRITE TEXT "SCTRIG SGL" EOL
    )
   )
   (views
    (icon
     (origin 247 288)
     (extent 127 64)
     (iconImage "/usr/lib/veetest/bitmaps/inst.icon")
    )
    (detail
     (origin 229 352)
     (extent 303 57)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 345 330)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 181 323)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 61 182)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "Explanation")
       (interface
       )
       (implementation
        (component text 35 9
         This example shows a complete data acquisition solution that incorporates instrument control,
         data gathering, and data processing and report generation. The model in example "gpio1.ex"
         shows a usual data acquisition solution of instrument control and gathering where readings
         are simply put to disc once they are read from the interface bus. This model offers a more 
         complete solution and is a combination of the examples "gpio1.ex" and "analysis.ex".
         
         The objects titled "3852A Setup", "GPIO Data Transfer Setup", "Trigger 3852A", and "GPIO Data
         Transfer" are identical to the same objects in the example "gpio1.ex". They setup the 44702A/B 
         voltmeter within the 3852A, initiate the voltmeter's Data Buffer register prepatory to reading
         the GPIO interface, trigger the voltmeter, and read blocks of data from the GPIO interface, 
         respectively. More complete explanations can be found under the Show Description choice under 
         the object menu for each of the above mentioned objects as well as the Gate and If/Then objects.
         
         Once a block of readings has been read by the Direct I/O object titled "GPIO Data Transfer"
         the readings are output to file by using the To File object. By using the If/Then object titled
         "A MOD 20 == 0"  and the Gate object every 20th block of readings is allowed to be unpacked by
         a concurrent 'C' process managed by the HP-UX Escape object. Note that the READ transaction 
         in the Direct I/O object and the WRITE transactions in the To File and HP-UX Escape objects 
         use the Int32 datatype instead of an Int16 datatype. The readings returned by the 44702A/B
         voltmeter via GPIO are in a 16-bit packed format, however the Int16 datatype, while apparently
         well matched to the size of each packed reading, is not supported for purposes other than I/O
         within VEE. This means any Int16 will be promoted to an Int32 upon output from an I/O object's
         data output pin. This promotion incurs a slight overhead. It is more efficient to use the Int32 
         datatype to read and write the packed readings, this avoids any promotions or demotions between 
         Int16 and Int32 datatypes. Therefore when the block size is specified as 2048 this means 4096 
         readings are being read from the GPIO interface by the Direct I/O object.
         
         By allowing only every 20th block of 4096 readings to be unpacked and displayed, this model 
         is able to run efficiently enough to keep pace with the 44702A/B within the 3852A. In order
         to maintain a constant throughput of data being supplied by an instrument maintaining a high
         sample rate the execution of the Direct I/O object reading the interface and any down thread
         objects such as To File, Formula, Display etc. must be as efficient as possible. Displaying
         only a few of the data samples increases the models performance. For more information 
         concerning HP VEE-Test and the 3852A please see application note number 1206-01 titled 
         "Complete data Acquisition Solutions with HP VEE-Test".
        )
       )
       (views
        (icon
         (origin 395 468)
         (extent 110 25)
        )
        (detail
         (origin 21 230)
         (extent 898 361)
         (editing enabled)
        )
        (active detail)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 29 92)
       (extent 926 523)
       (panel
        (origin 19 188)
        (extent 922 485)
        (widget 0 icon
         (title off)
         (origin 453 603)
         (extent 58 37)
        )
        (widget 1 detail
         (title on)
         (origin 32 236)
         (extent 899 351)
         (editing enabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 372 418)
       (extent 217 25)
      )
      (detail
       (origin 12 159)
       (extent 916 522)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D0:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 435 408)
     (extent 110 25)
    )
    (panel
     (origin 404 124)
     (extent 293 73)
     (widget 1 icon
      (title off)
      (origin 506 137)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 2 110)
     (extent 956 601)
     (configuration
      (connect D1:1 D0:1
       (Point 297 342)
       (Point 342 342)
      )
      (connect D0:0 D1:1
       (Point 368 357)
       (Point 368 380)
       (Point 160 380)
       (Point 160 342)
       (Point 178 342)
      )
      (connect D0:1 D2:0
       (Point 393 332)
       (Point 400 332)
       (Point 400 140)
       (Point 480 140)
       (Point 480 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 10 "IfThenElse"
   (name "A MOD 20 == 0")
   (description 7 4
    This If/Then object's argument is true when ever
    the current count output by the For Count object
    is evenly divisible by 20. When this happens the
    "then" data output pin is fired allowing the 
    Gate object to pass the current block of readings
    to the HP-UX object for unpacking and finally to
    the Display object.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "A MOD 20==0")
   )
   (views
    (icon
     (origin 537 258)
     (extent 127 25)
    )
    (detail
     (origin 521 235)
     (extent 149 70)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "ToFile"
   (name "To File")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (tag "A")
     (optional yes)
    )
   )
   (implementation
    (attr iopath file write "/tmp/rawdata"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE BINARY a INT32
    )
   )
   (views
    (icon
     (origin 710 346)
     (extent 80 29)
    )
    (detail
     (origin 577 253)
     (extent 356 175)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 12 "YPlot"
   (name "Voltage vs Time")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Trace1")
     (lock constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 1)
    (component graphMode rectangular)
   )
   (views
    (icon
     (origin 468 598)
     (extent 145 64)
     (iconImage "display.icon")
    )
    (detail
     (origin 20 508)
     (extent 960 224)
     (displayMode scrollGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Volts")
      (domainName "Time")
      (pen 9)
      (show 1)
      (range -6 6 3 linear)
     )
     (domain 0 4500 3 linear)
     (trace 0 onScale 0
      (name "Trace1")
      (pen 4)
      (lineType 1)
      (pointType 0)
     )
    )
    (active detail)
   )
  )
  (component 13 "IODevice"
   (name "GPIO Data Transfer Setup")
   (description 10 4
    The IOCONTROL transactions are equivalent to the
    CONTROL commands in HP BASIC. With the voltmeter
    in the 3852A, the 44702A/B, the GPIO control line,
    CTL0, is used with the Data Buffer register. The
    first transaction sets CTL1 high and CTL0 low 
    prepatory to accessing the 44702's Data Buffer. 
    Sending the 4 (binary 100) addresses the Data 
    Buffer register.The last transactions sets the 
    CTL lines back to their normal state.
    
   )
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (comp iopath "GPIO Transfer")
    (procedure
      WRITE IOCONTROL CTL 1
      WRITE BINARY 4 INT16
      WRITE IOCONTROL CTL 0
    )
   )
   (views
    (icon
     (origin 197 208)
     (extent 226 64)
     (iconImage "/usr/lib/veetest/bitmaps/inst.icon")
    )
    (detail
     (origin 134 197)
     (extent 353 86)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 14 "IODevice"
   (name "3852A Setup")
   (description 7 4
    The series of commands here configure the 44702A/B
    to take DC Voltage readings from the 3852A's 
    external terminal. The readings are transferred
    via GPIO to the controller. Two of the parameters
    are entered as variables, SPER and NRDGS. The SPER
    value of 5e-5 will cause readings to be taken at
    20,000 readings/sec.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Intrvl")
     (tag "Intrvl")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Numrdgs")
     (tag "Numrdgs")
     (optional yes)
    )
   )
   (implementation
    (comp iopath "HP 3852A")
    (procedure
      WRITE TEXT "RESET" EOL
      WRITE TEXT "OUTBUF ON; INBUF ON; DISABLE LABELS;DISP OFF" EOL
      WRITE TEXT "USE 100" EOL
      WRITE TEXT "SCANMODE ON" EOL
      WRITE TEXT "SCTRIG HOLD" EOL
      WRITE TEXT "CONF DCV" EOL
      WRITE TEXT "TERM EXT" EOL
      WRITE TEXT "RANGE 9" EOL
      WRITE TEXT "RDGS GPIO" EOL
      WRITE TEXT "NRDGS ",Numrdgs EOL
      WRITE TEXT "SPER ",Intrvl EOL
      WRITE TEXT "SCDELAY 0" EOL
      WRITE TEXT "ASCAN ON" EOL
      WRITE TEXT "STTRIG HOLD" EOL
    )
   )
   (views
    (icon
     (origin 255 108)
     (extent 110 64)
     (iconImage "/usr/lib/veetest/bitmaps/inst.icon")
    )
    (detail
     (origin 88 111)
     (extent 494 258)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 15 "ShellEscape"
   (description 27 4
    The UP-UX Escape object manages the executable 
    "unpack.exe", the source for which is in the file 
    "unpack.c". This program unpacks a number of 
    packed 16 bit 44702A/B readings and returns them 
    as 64 bit reals. The number of readings to be 
    unpacked is input to the program as a command line 
    argument. The HP-UX Escape writes the packed data
    to the process via the process's stdin pipe and
    reads the unpacked data from it's stdout pipe.
    Since the program is written to run continuously,
    reading and writing data from and to the HP-UX
    Escape, the Wait for child exit choice on the 
    object is set to "No".
    
    An important point is that UNIX pipes have a 
    default size of 8192 bytes. If more than this 
    amount is written to a pipe using the WRITE 
    transaction, the pipe will block causing HP VEE 
    to hang. This is why the constant box titled 
    block size has 2048 entered into it (remember 
    that for efficiency the transactions are all 
    Int32 so that 2048 Int32 x 2 readings/Int32 x 
    2 bytes/reading = 8192 ). It is possible to 
    change the size of the pipes by reconfiguring 
    the HP-UX kernel.
    
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "rawIn")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Command")
     (tag "Command")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (input 3
     (type data)
     (name "cnt")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Exit code")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "dataOut")
     (lock constraints)
     (optional yes)
    )
    (buffers in
     (buffer "Command")
    )
   )
   (implementation
    (attr iopath pipe read "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath pipe write "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE BINARY rawIn INT16
      READ BINARY dataOut REAL COUNT:cnt
    )
    (component shell "none")
    (component command "/usr/lib/veetest/examples/3852A/unpack.exe 4096")
    (component deathWait "No")
   )
   (views
    (icon
     (origin 821 328)
     (extent 118 64)
     (iconImage "c.icon")
    )
    (detail
     (origin 244 274)
     (extent 632 173)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 16 "ToString"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "result")
     (lock name constraints)
    )
   )
   (implementation
    (attr iopath string write "string"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "/usr/lib/veetest/examples/3852A/unpack.exe ",2*a EOL
    )
   )
   (views
    (icon
     (origin 675 418)
     (extent 110 25)
    )
    (detail
     (origin 264 353)
     (extent 642 114)
    )
    (terminals on)
    (active icon)
   )
  )
  (configuration
   (connect D10:1 D5:0)
   (connect D6:1 D5:1)
   (connect D7:1 D6:0)
   (connect D3:1 D6:1)
   (connect D8:0 D7:0)
   (connect D2:1 D7:1)
   (connect D13:0 D8:0)
   (connect D7:1 D10:1)
   (connect D6:1 D11:1)
   (connect D15:2 D12:1)
   (connect D14:0 D13:0)
   (connect D1:1 D14:1)
   (connect D0:1 D14:2)
   (connect D5:1 D15:1)
   (connect D16:1 D15:2)
   (connect D3:1 D15:3)
   (connect D3:1 D16:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 995 668)
   (configuration
    (connect D10:1 D5:0
     (Point 666 260)
     (Point 750 260)
     (Point 750 285)
    )
    (connect D6:1 D5:1
     (Point 673 360)
     (Point 690 360)
     (Point 690 300)
     (Point 724 300)
    )
    (connect D7:1 D6:0
     (Point 368 410)
     (Point 390 410)
     (Point 390 310)
     (Point 540 310)
     (Point 540 325)
    )
    (connect D3:1 D6:1
     (Point 192 420)
     (Point 210 420)
     (Point 210 460)
     (Point 400 460)
     (Point 400 360)
     (Point 406 360)
    )
    (connect D8:0 D7:0
     (Point 310 354)
     (Point 310 373)
    )
    (connect D2:1 D7:1
     (Point 188 320)
     (Point 210 320)
     (Point 210 410)
     (Point 251 410)
    )
    (connect D13:0 D8:0
     (Point 310 274)
     (Point 310 285)
    )
    (connect D7:1 D10:1
     (Point 368 410)
     (Point 390 410)
     (Point 390 310)
     (Point 500 310)
     (Point 500 270)
     (Point 534 270)
    )
    (connect D6:1 D11:1
     (Point 673 360)
     (Point 707 360)
    )
    (connect D15:2 D12:1
     (Point 941 380)
     (Point 960 380)
     (Point 960 410)
     (Point 820 410)
     (Point 820 470)
     (Point 650 470)
     (Point 650 460)
     (Point 410 460)
     (Point 410 470)
     (Point 200 470)
     (Point 200 460)
     (Point 10 460)
     (Point 10 620)
     (Point 17 620)
    )
    (connect D14:0 D13:0
     (Point 310 174)
     (Point 310 205)
    )
    (connect D1:1 D14:1
     (Point 165 160)
     (Point 190 160)
     (Point 190 120)
     (Point 252 120)
    )
    (connect D0:1 D14:2
     (Point 168 240)
     (Point 180 240)
     (Point 180 190)
     (Point 200 190)
     (Point 200 160)
     (Point 252 160)
    )
    (connect D5:1 D15:1
     (Point 775 300)
     (Point 800 300)
     (Point 800 340)
     (Point 818 340)
    )
    (connect D16:1 D15:2
     (Point 787 430)
     (Point 800 430)
     (Point 800 360)
     (Point 818 360)
    )
    (connect D3:1 D15:3
     (Point 192 420)
     (Point 210 420)
     (Point 210 460)
     (Point 400 460)
     (Point 400 430)
     (Point 660 430)
     (Point 660 460)
     (Point 810 460)
     (Point 810 380)
     (Point 818 380)
    )
    (connect D3:1 D16:1
     (Point 192 420)
     (Point 210 420)
     (Point 210 460)
     (Point 400 460)
     (Point 400 430)
     (Point 672 430)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
