#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Sun 07/Apr/1991")
(component 0 "Context"
 (name "Trajectory Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 529 128)
     (extent 382 84)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 1 "Constant"
   (name "Drag")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Drag")
     (datum 0.02)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 47 358)
     (extent 46 25)
    )
    (detail
     (origin 78 335)
     (extent 165 30)
    )
    (active icon)
   )
  )
  (component 2 "Note"
   (name "Overview of \"traj.ex\" Example")
   (interface
   )
   (implementation
    (component text 15 5
     Purpose:
     To show the detail view and the panel view of a
     model.
     
     User Input Required:
     1. Press Start to start the model.
     
     2. Press the Panel button to see the panel view
     and press Start.
     
     Explanation:
     The panel view usually only contains enough
     information to run the model (such as a Start
     object, input fields, and output display). 
     
    )
   )
   (views
    (icon
     (extent 271 0)
    )
    (detail
     (origin 30 119)
     (extent 460 142)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 3 "SlidingWindow"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (tag "Data")
     (requires
      (shape "Scalar")
     )
     (lock constraints)
    )
    (output 1
     (type data)
     (name "Array")
     (tag "Array")
     (lock constraints)
    )
   )
   (implementation
    (component vecSize 100)
    (component triggerSize 100)
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 59 568)
     (extent 163 25)
    )
    (detail
     (origin 51 479)
     (extent 248 63)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "ToWaveform"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Array")
     (tag "Array")
     (requires
      (datatype Real)
     )
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Time Span")
     (tag "Time Span")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Wf")
     (tag "Wf")
     (lock name constraints)
    )
    (buffers in
     (buffer "Time Span")
    )
   )
   (implementation
    (component interval 5)
   )
   (views
    (icon
     (origin 242 568)
     (extent 136 64)
     (iconImage build.icon)
    )
    (detail
     (origin 234 570)
     (extent 212 60)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "Formula"
   (name " * ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X*Y")
   )
   (views
    (icon
     (origin 157 608)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "Constant"
   (name "Time/Interation")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Time/Interation")
     (datum 0.05)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 38 406)
     (extent 145 29)
    )
    (detail
     (origin 1 406)
     (extent 219 28)
    )
    (active icon)
   )
  )
  (component 7 "Constant"
   (name "Initial Vel")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Initial Vel")
     (datum 40)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 35 456)
     (extent 110 29)
    )
    (detail
     (origin 35 485)
     (extent 171 30)
    )
    (active icon)
   )
  )
  (component 8 "ForCount"
   (name "100 iterations")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component count 100)
   )
   (views
    (icon
     (origin 242 328)
     (extent 136 64)
     (iconImage loop)
    )
    (detail
     (origin 195 113)
     (extent 210 34)
    )
    (active icon)
   )
  )
  (component 9 "Start"
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 277 272)
     (extent 67 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 10 "Counter"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
    (output 1
     (type data)
     (name "Count")
     (tag "Count")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 431 348)
     (extent 78 25)
    )
    (detail
     (origin 485 323)
     (extent 150 34)
    )
    (active icon)
   )
  )
  (component 11 "YPlot"
   (name "A, V, D vs. Time")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Accel")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "Velocity")
     (lock constraints)
     (optional yes)
    )
    (input 3
     (type data)
     (name "Distance")
     (lock constraints)
     (optional yes)
    )
    (input 4
     (type control)
     (name "Auto Scale")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 1)
    (component tracePin 2)
    (component tracePin 3)
    (component graphMode time)
   )
   (views
    (icon
     (extent 154 0)
     (iconImage display.icon)
    )
    (detail
     (origin 640 397)
     (extent 360 326)
     (displayMode scrollGraph)
     (graphType cartesian)
     (gridType axis)
     (scale 0
      (name "Mag")
      (domainName "Time")
      (color 0x909090)
      (show 1)
      (range -50 40 4 linear)
     )
     (domain 0 5 4 linear)
     (trace 0 onScale 0
      (name "Accel")
      (color 0xffdd00)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "Velocity")
      (color 0xccff)
      (lineType 1)
      (pointType 0)
     )
     (trace 2 onScale 0
      (name "Distance")
      (color 0xffaaaa)
      (lineType 1)
      (pointType 0)
     )
     (marker 0 onTrace 0)
    )
    (active detail)
   )
  )
  (component 12 "Formula"
   (name "distance")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "velocity")
     (optional yes)
    )
    (output 1
     (type data)
     (name " ")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "integral(velocity)")
   )
   (views
    (description 3 5
     This Formula object integrates the entire
     array of velocity data to compute the distance
     of the projectile.
    )
    (icon
     (origin 527 586)
     (extent 86 29)
    )
    (detail
     (origin 458 618)
     (extent 184 45)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "Junction"
   (name "JCT")
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 170 466)
     (extent 41 29)
    )
    (detail
     (origin 209 355)
     (extent 42 86)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 14 "Formula"
   (name "compute next Velocity")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "drag")
     (optional yes)
    )
    (input 2
     (type data)
     (name "delta")
     (optional yes)
    )
    (input 3
     (type data)
     (name "v")
     (optional yes)
    )
    (output 1
     (type data)
     (name " ")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "v-(9.8+drag*v^2*signof(v))*delta")
   )
   (views
    (icon
     (origin 259 418)
     (extent 203 45)
    )
    (detail
     (origin 249 290)
     (extent 312 140)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 15 "Formula"
   (name "accel")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "deriv(x,1)")
   )
   (views
    (description 3 5
     This Formula object takes the derivative of the
     entire array of velocity data to compute the 
     acceleration of the projectile.
    )
    (icon
     (origin 541 428)
     (extent 78 25)
    )
    (detail
     (origin 543 413)
     (extent 124 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (configuration
   (connect D13:1 D3:1)
   (connect D3:1 D4:1)
   (connect D5:1 D4:2)
   (connect D10:1 D5:1)
   (connect D6:1 D5:2)
   (connect D9:0 D8:0)
   (connect D8:1 D10:1)
   (connect D15:1 D11:1)
   (connect D4:1 D11:2)
   (connect D12:1 D11:3)
   (connect D4:0 D11:4)
   (connect D4:1 D12:1)
   (connect D7:1 D13:1)
   (connect D14:1 D13:2)
   (connect D8:1 D14:0)
   (connect D1:1 D14:1)
   (connect D6:1 D14:2)
   (connect D13:1 D14:3)
   (connect D4:1 D15:1)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 820 504)
   (widget 7 detail
    (title on)
    (origin 69 294)
    (extent 197 24)
   )
   (widget 1 detail
    (title on)
    (origin 68 365)
    (extent 199 29)
   )
   (widget 6 detail
    (title on)
    (origin 69 441)
    (extent 195 31)
   )
   (widget 9 icon
    (title off)
    (origin 114 130)
    (extent 111 72)
   )
   (widget 11 detail
    (title on)
    (origin 304 128)
    (extent 480 439)
    (displayMode annotGraph)
    (graphType cartesian)
    (gridType axis)
    (scale 0
     (name "Mag")
     (domainName "Time")
     (color 0x909090)
     (show 1)
     (range -50 40 4 linear)
    )
    (domain 0 5 4 linear)
    (trace 0 onScale 0
     (name "Accel")
     (color 0xffdd00)
     (lineType 1)
     (pointType 0)
    )
    (trace 1 onScale 0
     (name "Velocity")
     (color 0xccff)
     (lineType 1)
     (pointType 0)
    )
    (trace 2 onScale 0
     (name "Distance")
     (color 0xffaaaa)
     (lineType 1)
     (pointType 0)
    )
    (marker 0 onTrace 1)
   )
  )
  (detail
   (origin 0 67)
   (extent 993 648)
   (configuration
    (connect D13:1 D3:1
     (Point 213 480)
     (Point 230 480)
     (Point 230 510)
     (Point 40 510)
     (Point 40 580)
     (Point 56 580)
    )
    (connect D3:1 D4:1
     (Point 224 580)
     (Point 239 580)
    )
    (connect D5:1 D4:2
     (Point 205 620)
     (Point 239 620)
    )
    (connect D10:1 D5:1
     (Point 511 360)
     (Point 530 360)
     (Point 530 390)
     (Point 500 390)
     (Point 500 530)
     (Point 130 530)
     (Point 130 610)
     (Point 154 610)
    )
    (connect D6:1 D5:2
     (Point 185 420)
     (Point 200 420)
     (Point 200 390)
     (Point 100 390)
     (Point 100 400)
     (Point 20 400)
     (Point 20 630)
     (Point 154 630)
    )
    (connect D9:0 D8:0
     (Point 310 311)
     (Point 310 325)
    )
    (connect D8:1 D10:1
     (Point 380 360)
     (Point 428 360)
    )
    (connect D15:1 D11:1
     (Point 621 440)
     (Point 637 440)
    )
    (connect D4:1 D11:2
     (Point 380 600)
     (Point 510 600)
     (Point 510 520)
     (Point 637 520)
    )
    (connect D12:1 D11:3
     (Point 615 600)
     (Point 637 600)
    )
    (connect D4:0 D11:4
     (Point 310 634)
     (Point 310 680)
     (Point 637 680)
    )
    (connect D4:1 D12:1
     (Point 380 600)
     (Point 524 600)
    )
    (connect D7:1 D13:1
     (Point 147 470)
     (Point 167 470)
    )
    (connect D14:1 D13:2
     (Point 464 440)
     (Point 480 440)
     (Point 480 520)
     (Point 160 520)
     (Point 160 490)
     (Point 167 490)
    )
    (connect D8:1 D14:0
     (Point 380 360)
     (Point 400 360)
     (Point 400 400)
     (Point 360 400)
     (Point 360 415)
    )
    (connect D1:1 D14:1
     (Point 95 370)
     (Point 210 370)
     (Point 210 430)
     (Point 256 430)
    )
    (connect D6:1 D14:2
     (Point 185 420)
     (Point 200 420)
     (Point 200 440)
     (Point 256 440)
    )
    (connect D13:1 D14:3
     (Point 213 480)
     (Point 230 480)
     (Point 230 450)
     (Point 256 450)
    )
    (connect D4:1 D15:1
     (Point 380 600)
     (Point 510 600)
     (Point 510 440)
     (Point 538 440)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
