#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Tue 02/Apr/1991")
(component 0 "Context"
 (name "Read/Write File Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "TextDisplay"
   (name "DATA FROM FILE")
   (interface
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 0)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 377 308)
     (extent 136 25)
    )
    (detail
     (origin 575 410)
     (extent 210 40)
    )
    (active detail)
   )
  )
  (component 1 "ShellEscape"
   (name "sh -c \"rm Data File\"")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Exit code")
     (lock name constraints)
    )
   )
   (implementation
    (attr iopath pipe read "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath pipe write "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (component shell "sh")
    (component command "rm /tmp/example.data")
    (component deathWait "Yes")
   )
   (views
    (description 15 5
     This HP-UX Escape is used to run a unix ksh
     shell with the "rm" command on the default
     file.  
     
     For the advanced student, remember that a unix
     rm performs an "unlink" operation that removes
     the directory entry with the filename but does
     not actually delete the file until after all
     processes have closed the file.  In this example,
     the "rm" does the unlink, but the file is not
     removed until "Post Run" that occurs when STOP
     is executed.  You may want to place a From File
     device _after_ this device to verify that data
     can still be accessed even when the file has been
     removed from the directory. 
    )
    (icon
     (origin 465 648)
     (extent 190 25)
    )
    (detail
     (origin 500 542)
     (extent 388 116)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "ExitProcess"
   (name "Stop")
   (interface
    (sequence in)
   )
   (implementation
    (comp code 0)
   )
   (views
    (icon
     (origin 537 688)
     (extent 46 25)
    )
    (detail
     (origin 506 513)
     (extent 129 34)
    )
    (active icon)
   )
  )
  (component 3 "Delay"
   (name "0.5 Sec")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (component delay 0.5)
   )
   (views
    (icon
     (origin 711 638)
     (extent 78 25)
    )
    (detail
     (origin 757 443)
     (extent 147 34)
    )
    (active icon)
   )
  )
  (component 4 "ToFile"
   (name "Write new Data to File")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
   )
   (implementation
    (attr iopath file write "/tmp/example.data"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      EXECUTE REWIND
      WRITE TEXT a EOL
    )
   )
   (views
    (description 10 5
     This To File device first rewinds the file (sets
     the output file pointer back to beginning of file),
     then writes the new value to the file.
     
     The Write Mode, as set from the Object Menu, must
     be "OVERWRITE", since rewinding is not allowed in
     Append mode.  Remember that all To File devices
     that write to the same file name will SHARE a 
     common Write Mode selection; changing it for one
     changes it for all.
    )
    (icon
     (origin 626 598)
     (extent 208 25)
    )
    (detail
     (origin 620 518)
     (extent 271 105)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 5 "ToFile"
   (name "No, create defaultfile")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
   )
   (implementation
    (attr iopath file write "/tmp/example.data"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "200" EOL
    )
   )
   (views
    (description 11 5
     If the file errors during rewind, we will assume
     that it doesn't exist.  (To be extremely robust,
     the error number should indicate "file not found",
     since a few other errors could cause the rewind to
     fail.)
     
     This ToFile writes an initial value to the file.
     Although it doesn't matter whether the Write Mode
     is Append or Overwrite when the file is first
     created, remember that ALL ToFile devices with
     the same file name will SHARE a common Write Mode!
    )
    (icon
     (origin 486 288)
     (extent 208 25)
    )
    (detail
     (origin 589 249)
     (extent 273 103)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 6 "Formula"
   (name " - ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X-Y")
   )
   (views
    (icon
     (origin 367 608)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "IfThenElse"
   (name "A >= 0")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "a>=0")
   )
   (views
    (icon
     (origin 451 608)
     (extent 78 25)
    )
    (detail
     (origin 449 578)
     (extent 73 104)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "FromFile"
   (name "Does File Exist?")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type exception)
     (name "Error")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath file read "/tmp/example.data"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      EXECUTE REWIND
      READ TEXT null REAL COUNT:1
    )
   )
   (views
    (description 17 5
     The recommended way to determine if a file exists
     is to REWIND it in a From File device.  If the
     file does not exist, an error is generated. 
     
     For our application, we also want to insure that
     the data in the file can be read.  The second
     transaction reads one Real number into the "null"
     variable.  (Null accepts and then discards all
     data sent to it.)
     
     Why would a REWIND in a TO File not be a good way
     to test for file existence?  Remember that a file
     opened for Write can be in Append or Overwrite
     mode, and Rewind is illegal in append.  Also,
     opening a To File will create an empty file if
     one does not exist.
     
    )
    (icon
     (origin 93 348)
     (extent 154 25)
    )
    (detail
     (origin 42 255)
     (extent 287 90)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 9 "RepeatUntilBreak"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 145 368)
     (extent 110 64)
     (iconImage loop.icon)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 10 "FromFile"
   (name "Read the data from file")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath file read "/tmp/example.data"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      EXECUTE REWIND
      READ TEXT x REAL COUNT:1
    )
   )
   (views
    (description 16 5
     Each time through the loop, we read the data that
     was last written to the file.  We must always
     REWIND the file before reading to insure the
     READ transaction will not hit an EOF.
     
     IMPORTANT:  Rewinding the "read" file pointer will
     rewind all From File devices with the same data
     file name, since all share a common File pointer.
     
     However, this has no effect on a ToFile device
     write file pointer for the same file name.  The
     existence of two file pointers, one for reading
     and one for writing, may seem strange, but it does
     allow one thread to write ahead of another thread
     that is reading and processing the data.
     
    )
    (icon
     (origin 327 498)
     (extent 217 25)
    )
    (detail
     (origin 107 473)
     (extent 326 94)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 11 "Constant"
   (name "Amt to Deduct")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Amt to Deduct")
     (datum 25)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 97 428)
     (extent 127 25)
    )
    (detail
     (origin 80 616)
     (extent 201 28)
    )
    (active detail)
   )
  )
  (component 12 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 570 118)
     (extent 401 84)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 13 "Note"
   (interface
   )
   (implementation
    (component text 4 5
     Press RUN to operate
     this example.  Most
     devices have a Show
     Description info box.
    )
   )
   (views
    (icon
    )
    (detail
     (origin 347 120)
     (extent 206 81)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 14 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "If != 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 301 322)
       (extent 78 25)
      )
      (detail
       (origin 299 278)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 153 315)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "RepeatUntilBreak"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 75 238)
       (extent 110 64)
       (iconImage loop.icon)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 310 409)
         (extent 58 37)
        )
        (detail
         (origin 466 633)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (interface
       )
       (implementation
        (component text 25 9
         PURPOSE:  Illustrate how to save data between successive executions of a program by
                   writing the latest data to a file after reading and modifying data previously
                   written to the same file.
         
         USER INPUT REQUIRED:  Press RUN several times, watching the program deduct a constant
                   value from the data value in the file.  You may want to use the Edit menu to
                   enable "Show Execution Flow" before running so you can see the operation of
                   the program.
         
         EXPLANATION:  Most devices have a "Show Description" dialog box that can be viewed by
                   selecting this from the device's Object Menu.  Detailed explanation for each
                   device is found there.
         
                   Several techniques are illustrated in this example, such as: a) How to
                   determine if a file exists, and if not how to create it; b) How to read and
                   write data to and from the same file (possible because there are two file
                   pointers -- one to retain the current position for writing data and another
                   to retain the position for reading data);  c) How to continually "overwrite"
                   data in a file instead of appending each new data to the end of existing 
                   data; 
         
                   These techniques are useful in cases where calibration data must be read and
                   updated from a file, where "global" data must be saved between subsequent
                   executions of a Vee program, or to allow one "thread" to write data to a
                   file while another "thread" reads the data.
        )
       )
       (views
        (icon
         (origin 301 348)
         (extent 78 25)
        )
        (detail
         (origin 6 132)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 55 78)
       (extent 849 571)
       (panel
        (origin 18 158)
        (extent 845 533)
        (widget 1 detail
         (title off)
         (origin 31 170)
         (extent 816 465)
         (editing disabled)
        )
        (widget 0 icon
         (title off)
         (origin 417 643)
         (extent 58 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 332 412)
       (extent 217 25)
      )
      (detail
       (origin 228 275)
       (extent 405 230)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:1 D1:0)
     (connect D3:0 D1:1)
     (connect D0:1 D3:0)
    )
   )
   (views
    (icon
     (origin 175 368)
     (extent 110 25)
    )
    (panel
     (origin 11 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 113 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 269 334)
       (Point 298 334)
      )
      (connect D2:1 D1:0
       (Point 187 270)
       (Point 210 270)
       (Point 210 312)
      )
      (connect D3:0 D1:1
       (Point 440 439)
       (Point 440 460)
       (Point 130 460)
       (Point 130 334)
       (Point 150 334)
      )
      (connect D0:1 D3:0
       (Point 381 324)
       (Point 440 324)
       (Point 440 409)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D10:1 D0:1)
   (connect D7:2 D1:0)
   (connect D1:0 D2:0)
   (connect D4:0 D3:0)
   (connect D7:1 D4:0)
   (connect D6:1 D4:1)
   (connect D8:1 D5:1)
   (connect D10:1 D6:1)
   (connect D11:1 D6:2)
   (connect D6:1 D7:1)
   (connect D8:0 D9:0)
   (connect D9:1 D10:0)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 980 653)
   (configuration
    (connect D10:1 D0:1
     (Point 465 520)
     (Point 490 520)
     (Point 490 430)
     (Point 572 430)
    )
    (connect D7:2 D1:0
     (Point 531 630)
     (Point 560 630)
     (Point 560 645)
    )
    (connect D1:0 D2:0
     (Point 560 675)
     (Point 560 685)
    )
    (connect D4:0 D3:0
     (Point 750 625)
     (Point 750 635)
    )
    (connect D7:1 D4:0
     (Point 531 610)
     (Point 550 610)
     (Point 550 470)
     (Point 750 470)
     (Point 750 485)
    )
    (connect D6:1 D4:1
     (Point 415 620)
     (Point 430 620)
     (Point 430 600)
     (Point 490 600)
     (Point 490 570)
     (Point 577 570)
    )
    (connect D8:1 D5:1
     (Point 391 300)
     (Point 546 300)
    )
    (connect D10:1 D6:1
     (Point 465 520)
     (Point 490 520)
     (Point 490 560)
     (Point 480 560)
     (Point 480 590)
     (Point 364 590)
     (Point 364 610)
    )
    (connect D11:1 D6:2
     (Point 283 630)
     (Point 364 630)
    )
    (connect D6:1 D7:1
     (Point 415 620)
     (Point 431 620)
     (Point 431 620)
     (Point 448 620)
    )
    (connect D8:0 D9:0
     (Point 200 347)
     (Point 200 365)
    )
    (connect D9:1 D10:0
     (Point 257 400)
     (Point 270 400)
     (Point 270 440)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
