#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Tue 02/Apr/1991")
(component 0 "Context"
 (name "Optimize 1 Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Constant"
   (name "Array of Numbers")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Array of Numbers")
     (numDims 1)
     (size 10)
     (data
      [ 23.1 102 34.6 59 -11 45 78.90000000000001 12 -99 45 ]
     )
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (description 12 5
     This is a Real Constant (from the Data menu)
     that used the "config" option to change size
     from a scalar constant to an array of constants.
     
     The numbers in the device can be changed by
     clicking over the number to be edited, typing
     the new number, then using Tab to go to the
     next number or Return to stop editing the
     constant data.  You can resize the array by
     accessing the Object Menu "config" selection
     and changing the size, or by using the Insert
     Line and Delete Line keyboard keys.
    )
    (icon
     (extent 154 0)
    )
    (detail
     (origin 17 267)
     (extent 207 199)
    )
    (active detail)
   )
  )
  (component 1 "Constant"
   (name "Constant")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Constant")
     (datum 100)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (description 5 5
     This device was a "Real Constant" from the Data
     Menu.  Although it displays an integer, you
     can enter any number between -1E308 and +1E308.
     
     
    )
    (icon
     (extent 110 0)
    )
    (detail
     (origin 253 419)
     (extent 156 28)
    )
    (active detail)
   )
  )
  (component 2 "Formula"
   (name " * ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X*Y")
   )
   (views
    (icon
     (origin 447 384)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "Constant"
   (name "Array of Numbers")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Array of Numbers")
     (numDims 1)
     (size 10)
     (data
      [ 23.1 102 34.6 59 -11 45 78.90000000000001 12 -99 45 ]
     )
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (description 12 5
     This is a "Real Constant" (from the Data menu)
     that used the "config" option to change size
     from a scalar constant to an array of constants.
     
     The numbers in the device can be changed by
     clicking over the number to be edited, typing
     the new number, then using Tab to go to the
     next number or Return to stop editing the
     constant data.  You can resize the array by
     accessing the Object Menu "config" selection
     and changing the size, or by using the Insert
     Line and Delete Line keyboard keys.
    )
    (icon
     (extent 154 0)
    )
    (detail
     (origin 11 560)
     (extent 219 192)
    )
    (active detail)
   )
  )
  (component 4 "TextDisplay"
   (name "Display Results")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 145 0)
    )
    (detail
     (origin 561 272)
     (extent 219 208)
    )
    (active detail)
   )
  )
  (component 5 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 555 119)
     (extent 391 83)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 6 "Collector"
   (name "Collector")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (tag "Data")
    )
    (input 2
     (type trigger)
     (name "XEQ")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Array")
     (tag "Array")
     (lock constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (description 11 5
     To return the results as an array, we need to
     put the output of each element's multiplication
     into an array.
     
     The collector "collects" every number presented
     to the Data input into an array that "grows"
     as each item is collected.
     
     Whenever the XEQ pin receives a signal, the
     Collector sends the currently collected array
     to it's output pin.
    )
    (icon
     (origin 735 568)
     (extent 110 25)
    )
    (detail
     (origin 609 778)
     (extent 33 104)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 7 "Formula"
   (name "Formula")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (optional yes)
    )
    (input 3
     (type data)
     (name "I")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "A[I]*B")
   )
   (views
    (description 10 5
     The "Formula" object multiplies the Ith element
     of array A by the constant B, sending the answer
     out on the Result pin.
     
     This device executes 10 times (once for each
     element of the input array) because the "For
     Count" object provides successive values for I.
     
     If the size of the array changes, so must the
     "For Count" value.
    )
    (icon
     (origin 341 598)
     (extent 78 64)
     (iconImage formula.icon)
    )
    (detail
     (origin 571 563)
     (extent 88 154)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 8 "TextDisplay"
   (name "Display Results")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 145 0)
    )
    (detail
     (origin 761 566)
     (extent 219 208)
    )
    (active detail)
   )
  )
  (component 9 "Constant"
   (name "Constant")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Constant")
     (datum 100)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (description 5 5
     This device was a "Real Constant" from the Data
     Menu.  Although it displays an integer, you
     can enter any number between -1E308 and +1E308.
     
     
    )
    (icon
     (extent 110 0)
    )
    (detail
     (origin 272 666)
     (extent 156 28)
    )
    (active detail)
   )
  )
  (component 10 "Note"
   (name "Non-optimum way")
   (interface
   )
   (implementation
    (component text 2 5
     Using element-by-element
     math on an array.
    )
   )
   (views
    (icon
     (extent 145 0)
    )
    (detail
     (origin 264 556)
     (extent 233 49)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 11 "ForCount"
   (name "For Count")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Count")
     (tag "Count")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (lock name constraints)
    )
    (buffers in
     (buffer "Count")
    )
   )
   (implementation
    (component count 10)
   )
   (views
    (description 12 5
     This "iterator" is similar to a DO loop or a
     For loop that provides an increasing output
     each time it executes.  The first iteration
     supplies 0, the second 1, the third 2, etc.
     
     When all 10 iterations (0 to 9) are complete,
     the Sequence Out pin on the bottom generates
     a signal that is used by the Collector to
     signal iteration complete.
     
     If the size of the array changes, so must the
     count in this object.
    )
    (icon
     (iconImage loop.icon)
    )
    (detail
     (origin 318 793)
     (extent 165 34)
    )
    (active detail)
   )
  )
  (component 12 "FromArray"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Ary")
     (tag "Ary")
    )
    (output 1
     (type data)
     (name "SubAry")
     (tag "Result")
     (lock constraints)
    )
    (output 2
     (type data)
     (name "Type")
     (tag "Type")
     (lock constraints)
    )
    (output 3
     (type data)
     (name "NumDims")
     (tag "NumDims")
     (lock constraints)
    )
    (output 4
     (type data)
     (name "DimSizes")
     (tag "DimSizes")
     (lock constraints)
    )
    (output 5
     (type data)
     (name "TotSize")
     (tag "TotSize")
     (lock constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "Ary")
   )
   (views
    (description 2 5
     We need to find the size of the array so we can
     step thru each element using the "For Loop".
    )
    (icon
     (origin 165 788)
     (extent 110 64)
     (iconImage unbuild.icon)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "Note"
   (name "To Operate:")
   (interface
   )
   (implementation
    (component text 4 5
     Press RUN and look
     at examples, or
     click on Info About
     for help.
    )
   )
   (views
    (icon
     (extent 110 0)
     (iconImage notepad.icon)
    )
    (detail
     (origin 342 120)
     (extent 196 80)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 14 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 375 306)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 211 299)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About this Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 441 642)
         (extent 58 37)
        )
        (detail
         (origin 466 633)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "Optimize1.ex Example")
       (interface
       )
       (implementation
        (component text 17 9
         PURPOSE:     Using parallel math on arrays instead of repeating loops on each
                      element of data.   This example multiplies each of 10 numbers in an
                      array by 100.
         
         USER INPUT REQUIRED: Click on RUN to calculate and display results.  Most devices have a
                      Show Description that can be accessed from their object menus.
         
         EXPLANATION: A very powerful feature of HP VEE is the parallel operation on
                      all elements of an array without explicitly generating loops or other
                      methods of accessing each array element.  For example, to multiply all
                      elements of an array by 100, just supply the array and a Scalar
                      Constant "100" to the multiply operator.
         
                      You can use other constants by clicking on the Constant field, enter
                      a new value, then click on RUN to display the results.  You may want
                      to replace the "multiply" device with others from the Math menu such
                      as +, -, abs(), sqrt(), etc. and observe the displayed results.
        )
       )
       (views
        (icon
         (origin 395 408)
         (extent 190 25)
        )
        (detail
         (origin 72 207)
         (extent 836 427)
         (editing disabled)
        )
        (active detail)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 44 64)
       (extent 913 613)
       (panel
        (origin 26 163)
        (extent 909 575)
        (widget 0 icon
         (title off)
         (origin 451 662)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 43 176)
         (extent 872 471)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 372 418)
       (extent 217 25)
      )
      (detail
       (origin 14 162)
       (extent 913 517)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 195 188)
     (extent 110 25)
    )
    (panel
     (origin 11 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 113 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 111)
     (extent 953 599)
     (configuration
      (connect D1:1 D0:1
       (Point 327 318)
       (Point 372 318)
      )
      (connect D2:0 D1:1
       (Point 480 445)
       (Point 480 464)
       (Point 190 464)
       (Point 190 318)
       (Point 208 318)
      )
      (connect D0:1 D2:0
       (Point 423 308)
       (Point 480 308)
       (Point 480 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 15 "Note"
   (name "Optimum way")
   (interface
   )
   (implementation
    (component text 2 5
     Using parallel math on
     Array data.
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 273 272)
     (extent 235 56)
     (editing disabled)
    )
    (active detail)
   )
  )
  (configuration
   (connect D0:1 D2:1)
   (connect D1:1 D2:2)
   (connect D2:1 D4:1)
   (connect D7:1 D6:1)
   (connect D11:0 D6:2)
   (connect D3:1 D7:1)
   (connect D9:1 D7:2)
   (connect D11:1 D7:3)
   (connect D6:1 D8:1)
   (connect D12:5 D11:1)
   (connect D3:1 D12:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 980 653)
   (configuration
    (connect D0:1 D2:1
     (Point 226 366)
     (Point 430 366)
     (Point 430 386)
     (Point 444 386)
    )
    (connect D1:1 D2:2
     (Point 411 433)
     (Point 444 433)
     (Point 444 406)
    )
    (connect D2:1 D4:1
     (Point 495 396)
     (Point 510 396)
     (Point 510 376)
     (Point 558 376)
    )
    (connect D7:1 D6:1
     (Point 731 640)
     (Point 740 640)
     (Point 740 740)
     (Point 540 740)
     (Point 540 800)
     (Point 556 800)
    )
    (connect D11:0 D6:2
     (Point 400 829)
     (Point 400 860)
     (Point 556 860)
    )
    (connect D3:1 D7:1
     (Point 232 656)
     (Point 250 656)
     (Point 250 620)
     (Point 440 620)
     (Point 440 630)
     (Point 510 630)
     (Point 510 590)
     (Point 528 590)
    )
    (connect D9:1 D7:2
     (Point 430 680)
     (Point 450 680)
     (Point 450 640)
     (Point 528 640)
    )
    (connect D11:1 D7:3
     (Point 485 810)
     (Point 510 810)
     (Point 510 690)
     (Point 528 690)
    )
    (connect D6:1 D8:1
     (Point 704 830)
     (Point 720 830)
     (Point 720 750)
     (Point 750 750)
     (Point 750 670)
     (Point 758 670)
    )
    (connect D12:5 D11:1
     (Point 277 840)
     (Point 290 840)
     (Point 290 810)
     (Point 315 810)
    )
    (connect D3:1 D12:1
     (Point 232 656)
     (Point 250 656)
     (Point 250 770)
     (Point 150 770)
     (Point 150 820)
     (Point 162 820)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
