#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name "Communicating With HP BASIC/UX")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 572 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 1 "Note"
   (name "Info About...")
   (interface
   )
   (implementation
    (component text 44 5
     Overview:
     This model contains two examples of how you can
     communicate with HP BASIC/UX using the 
     "Init HP BASIC/UX" and "To/From HP BASIC/UX" objects.  
     
     Details:
     You must have already purchased and installed 
     HP BASIC/UX using the standard installation 
     procedure to run this model.
     
     Refer to the "Note Pads" next to each thread for
     additional information specific to each case.
     
     Use the "Timers" to compare the execution speeds of 
     each approach.  Specific execution times will vary
     widely based on your computer configuration; these
     results are typical:
     
     * Time to execute Case #1 or 
       first iteration of Case #2       15 seconds
     
     * Time to execute subsequent 
       iterations of Case #2            150 milliseconds
     
     Note that each thread containing an "Init HP BASIC/UX"
     object creates its own HP BASIC/UX process.  
     
     When an "Init HP BASIC/UX" object executes, it checks
     to see if an HP BASIC/UX process corresponding to that 
     object exits.  It one already exits, nothing happens.
     If one does not exits, a new one is created.
     
     Note that the pipe names are different for each
     thread; this is a must.
     
     There is no ready-made way to terminate an HP BASIC/UX
     process from inside HP VEE.  You must design your
     HP BASIC/UX program so that it can QUIT at the proper
     time or you must kill it with the HP-UX command 
     rmbkill.
     
     Related Files: io_rmbux1a.bas
                    io_rmbux1b.bas
     
    )
   )
   (views
    (icon
     (extent 127 0)
    )
    (detail
     (origin 13 122)
     (extent 534 216)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 2 "Slider"
   (name "Int Slider")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Int Slider")
     (values range 0 100)
     (datum 87)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
    (component detents 1)
   )
   (views
    (icon
    )
    (detail
     (origin 389 387)
     (extent 182 127)
    )
    (active detail)
   )
  )
  (component 3 "Note"
   (name "Case #1")
   (interface
   )
   (implementation
    (component text 12 5
     This thread illustrates how to use
     HP BASIC/UX by running a BASIC program
     that executes only once per press of
     the "Start" button.
     
     The HP BASIC/UX program io_rmbux1a.bas
     simply reads a number, adds 1 to the
     number, sends it back, and QUITs.
     
     Note that booting each new instance of
     HP BASIC/UX requires a significant
     amount of time.
    )
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 20 378)
     (extent 360 225)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 4 "NamedPipe"
   (name "To/From HP BASIC/UX")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (tag "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath file read "/tmp/from_rmb"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath file append "/tmp/to_rmb"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT a INT EOL
      READ TEXT x INT COUNT:1
    )
   )
   (views
    (icon
     (iconImage basic.icon)
    )
    (detail
     (origin 624 389)
     (extent 323 122)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 5 "HPBasic"
   (name "Init HP BASIC/UX")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (component progname "/usr/lib/veetest/examples/concepts/io_rmbux1a.bas")
   )
   (views
    (icon
    )
    (detail
     (origin 666 303)
     (extent 228 34)
    )
    (active detail)
   )
  )
  (component 6 "Start"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 746 211)
     (extent 69 39)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "Timer"
   (name "Timer")
   (interface
    (sequence out)
    (input 1
     (type data)
     (name "Time1")
    )
    (input 2
     (type data)
     (name "Time2")
    )
    (output 1
     (type data)
     (name "T2 - T1")
     (tag "dTime")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
    )
    (detail
     (origin 1046 273)
     (extent 129 34)
    )
    (active detail)
   )
  )
  (component 8 "ScrollingTextDisplay"
   (name "Logging AlphaNumeric")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 0)
    (component clearAtActivate 0)
   )
   (views
    (icon
    )
    (detail
     (origin 1017 388)
     (extent 267 124)
     (bufferSize 256)
    )
    (active detail)
   )
  )
  (component 9 "Slider"
   (name "Int Slider")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Int Slider")
     (values range -1 100)
     (datum 52)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
    (component detents 1)
   )
   (views
    (icon
    )
    (detail
     (origin 399 717)
     (extent 182 127)
    )
    (active detail)
   )
  )
  (component 10 "NamedPipe"
   (name "To/From HP BASIC/UX")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (tag "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath file read "/tmp/from_rmb2"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath file append "/tmp/to_rmb2"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT a INT EOL
      READ TEXT x INT COUNT:1
    )
   )
   (views
    (icon
     (iconImage basic.icon)
    )
    (detail
     (origin 634 719)
     (extent 323 122)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 11 "Timer"
   (name "Timer")
   (interface
    (sequence out)
    (input 1
     (type data)
     (name "Time1")
    )
    (input 2
     (type data)
     (name "Time2")
    )
    (output 1
     (type data)
     (name "T2 - T1")
     (tag "dTime")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
    )
    (detail
     (origin 1076 633)
     (extent 129 34)
    )
    (active detail)
   )
  )
  (component 12 "ScrollingTextDisplay"
   (name "Logging AlphaNumeric")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 0)
    (component clearAtActivate 0)
   )
   (views
    (icon
    )
    (detail
     (origin 1027 718)
     (extent 267 124)
     (bufferSize 256)
    )
    (active detail)
   )
  )
  (component 13 "Start"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 756 541)
     (extent 69 39)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 14 "HPBasic"
   (name "Init HP BASIC/UX")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (component progname "/usr/lib/veetest/examples/concepts/io_rmbux1b.bas")
   )
   (views
    (icon
    )
    (detail
     (origin 676 643)
     (extent 228 34)
    )
    (active detail)
   )
  )
  (component 15 "Note"
   (name "Case #2")
   (interface
   )
   (implementation
    (component text 28 5
     This thread illustrates how to use
     HP BASIC/UX by running a program
     that executes and remains active.
     
     The HP BASIC/UX program io_rmbux1b.bas
     reads a number and determines its
     sign (positive or negative).  If
     the number is positive, the program
     adds 1 to the number and returns the
     incremented value.  If the number is
     negative, the program returns -1 and
     QUITs.
     
     Note that subsequent clicks on "Start"
     produce results very quickly.
     
     The first time you click on Start,
     HP VEE creates a new instance of 
     HP BASIC/UX runs the program 
     io_rmbux1b.bas.  The program remains 
     active until you send it a negative
     value.
     
     
     
     
     
     
    )
   )
   (views
    (icon
     (origin 211 578)
     (extent 78 25)
    )
    (detail
     (origin 13 656)
     (extent 374 189)
     (editing disabled)
    )
    (active detail)
   )
  )
  (configuration
   (connect D5:0 D4:0)
   (connect D2:1 D4:1)
   (connect D6:0 D5:0)
   (connect D6:0 D7:1)
   (connect D4:0 D7:2)
   (connect D4:1 D8:1)
   (connect D14:0 D10:0)
   (connect D9:1 D10:1)
   (connect D13:0 D11:1)
   (connect D10:0 D11:2)
   (connect D10:1 D12:1)
   (connect D13:0 D14:0)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 980 653)
   (configuration
    (connect D5:0 D4:0
     (Point 780 339)
     (Point 780 356)
    )
    (connect D2:1 D4:1
     (Point 573 450)
     (Point 581 450)
    )
    (connect D6:0 D5:0
     (Point 780 252)
     (Point 780 270)
    )
    (connect D6:0 D7:1
     (Point 780 252)
     (Point 780 260)
     (Point 910 260)
     (Point 910 280)
     (Point 1043 280)
    )
    (connect D4:0 D7:2
     (Point 780 513)
     (Point 780 530)
     (Point 1000 530)
     (Point 1000 300)
     (Point 1043 300)
    )
    (connect D4:1 D8:1
     (Point 979 450)
     (Point 1014 450)
    )
    (connect D14:0 D10:0
     (Point 790 679)
     (Point 790 686)
    )
    (connect D9:1 D10:1
     (Point 583 780)
     (Point 591 780)
    )
    (connect D13:0 D11:1
     (Point 790 582)
     (Point 790 590)
     (Point 930 590)
     (Point 930 640)
     (Point 1073 640)
    )
    (connect D10:0 D11:2
     (Point 790 843)
     (Point 790 860)
     (Point 1000 860)
     (Point 1000 660)
     (Point 1073 660)
    )
    (connect D10:1 D12:1
     (Point 989 780)
     (Point 1024 780)
    )
    (connect D13:0 D14:0
     (Point 790 582)
     (Point 790 610)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
