#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Tue 02/Apr/1991")
(component 0 "Context"
 (name "Enums and CASE transactions")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 5 5
     This example is provided as an
     illustration "as is", and 
     Hewlett-Packard Company makes 
     no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 655 431)
     (extent 291 99)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 1 "EnumConstant"
   (name "Enum")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Enum
     (name "Enum")
     (values
      ( "Horse" 0)
      ( "Cat" 1)
      ( "Dog" 2)
     )
     (datum "Cat")
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Enum
     (shared yes)
     (datum "Horse")
    )
   )
   (views
    (icon
    )
    (detail
     (origin 6 167)
     (extent 129 26)
     (format list)
    )
    (active detail)
   )
  )
  (component 2 "Note"
   (name "Explanation")
   (interface
   )
   (implementation
    (component text 25 5
     This example shows the use of the Enumerated types and
     the WRITE CASE I/O transaction together.  The Enum object
     has three values: "Horse", "Cat", "Dog".  The WRITE CASE
     transaction has three possible cases: "Colt", "Kitten",
     "Puppy".  Clicking on the Enum button causes a list to 
     appear; choose one of the adult animals.  Because the Enum
     object has AutoExecute turned on the thread starts executing
     when the selection is made.  An enumerated type has an 
     implicit ordinal value, whatever choice is made will map
     into the cases of the WRITE CASE transaction.  If "Dog" 
     is selected in the Enum object, the ordinal value '2' is 
     seen by the variable 'A' in the To String object.  This 
     maps into the third case, "Puppy".  
     
     Note that an enumerated type's value starts at zero.  Also
     note that an Integer could just have easily been given to the 
     'A' variable. This integer would have been 0, 1, or 2. 
     If the number is less than zero or greater than n-1 where 
     n is the number of cases, then an error will appear.
     
     The Enum type has the ability to display its values as a 
     pop-up list, a cyclic list, or a list of buttons.  
     
     Use this ability to map easily understood strings into
     other strings. 
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 15 290)
     (extent 591 301)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 3 "ToString"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (tag "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "result")
     (lock name constraints)
    )
   )
   (implementation
    (attr iopath string write "string"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE CASE a OF "Colt","Kitten","Puppy" EOL
    )
   )
   (views
    (icon
     (origin 495 258)
     (extent 110 25)
    )
    (detail
     (origin 206 120)
     (extent 438 121)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 4 "TextDisplay"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
    )
    (detail
     (origin 734 163)
     (extent 192 35)
    )
    (active detail)
   )
  )
  (configuration
   (connect D1:1 D3:1)
   (connect D3:1 D4:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 935 615)
   (configuration
    (connect D1:1 D3:1
     (Point 137 180)
     (Point 163 180)
    )
    (connect D3:1 D4:1
     (Point 716 180)
     (Point 731 180)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
