#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name "Net Present Value Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Constant"
   (name "CashFlows")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "CashFlows")
     (numDims 1)
     (size 13)
     (data
      [ -14500 1650 3000 10000 -2000 0 1000 5000 4000 -2000 500 -1000 -150 ]
     )
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (description 9 5
     This is a "Data -> Constant -> Real" object, with
     the "Config... Array Elements" set to 12.
     Increasing this value would allow entry of a
     larger initial number of cash flows.  However,
     HP VEE allows additional data to be added at the
     end of a defined input array by merely pressing
     the "Tab" or "down-arrow" key from the last
     element of the input.  The object is then 
     automatically reconfigured to the new size.
    )
    (icon
     (extent 110 0)
    )
    (detail
     (origin 46 197)
     (extent 169 166)
    )
    (active detail)
   )
  )
  (component 1 "Start"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (description 7 5
     This is a "Flow -> Start" object.
     
     It is used as an alternative to "Run", especially
     when it is desired to activate a single thread
     in a multi-thread model.  In this example, "Run"
     and "Start" provide essentially the same function.
     
    )
    (icon
     (origin 96 101)
     (extent 69 39)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "Formula"
   (name " / ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X/Y")
   )
   (views
    (description 6 5
     This is a "Math -> +-*/ -> /" object. 
     
     Note that each element of the "CashFlows" array 
     is divided by the corresponding element in the
     array built by the "Collector" object.  An example
     of the parallel math capabilities of HP VEE.
    )
    (icon
     (origin 417 338)
     (extent 46 25)
    )
    (detail
     (origin 556 288)
     (extent 79 104)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "Formula"
   (name "sum(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "sum(x)")
   )
   (views
    (description 4 5
     This is a "AdvMath -> Array -> sum(x)" object.
     
     It provides the sum of all elements in a one
     dimensional array.
    )
    (icon
     (origin 541 338)
     (extent 78 25)
    )
    (detail
     (origin 811 313)
     (extent 88 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "Formula"
   (name "sum(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "sum(x)")
   )
   (views
    (description 4 5
     This is an "AdvMath -> Array -> sum(x)" object.
     
     It provides the sum of all elements of a one
     dimensional array.
    )
    (icon
     (origin 271 268)
     (extent 78 25)
    )
    (detail
     (origin 301 193)
     (extent 88 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "TextDisplay"
   (name "Sum of Cash Flows")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (description 5 5
     This is a "Display -> AlphaNumeric" object.
     
     It is used to display a single output in this
     case, but may also be used to display an array
     output.  See the "Individual PV" object.
    )
    (icon
     (extent 163 0)
    )
    (detail
     (origin 399 262)
     (extent 222 37)
    )
    (active detail)
   )
  )
  (component 6 "FromArray"
   (name "CashFlows Size")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Ary")
     (tag "Ary")
    )
    (output 1
     (type data)
     (name "SubAry")
     (tag "Result")
     (lock constraints)
    )
    (output 2
     (type data)
     (name "Type")
     (tag "Type")
     (lock constraints)
    )
    (output 3
     (type data)
     (name "NumDims")
     (tag "NumDims")
     (lock constraints)
    )
    (output 4
     (type data)
     (name "DimSizes")
     (tag "DimSizes")
     (lock constraints)
    )
    (output 5
     (type data)
     (name "TotSize")
     (tag "TotSize")
     (lock constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "Ary")
   )
   (views
    (description 6 5
     This is a "Data -> UnBuild Data -> Array" object.
     
     It is used in this example merely to obtain the
     number of values entered into the "CashFlows"
     object, or, in other words, to determine the size
     of the "CashFlow" array.
    )
    (icon
     (origin 62 428)
     (extent 136 64)
     (iconImage unbuild.icon)
    )
    (detail
     (origin 65 421)
     (extent 101 158)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "ForCount"
   (name "For Count")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Count")
     (tag "Count")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (lock name constraints)
    )
    (buffers in
     (buffer "Count")
    )
   )
   (implementation
    (component count 13)
   )
   (views
    (description 6 5
     This is a "Flow -> Repeat -> For Count" object.
     
     This object is used for looping a defined number 
     of cycles.  However, as indicated in this case,
     the number of cycles may be obtained from the
     result of preceeding calculations.
    )
    (icon
     (origin 245 431)
     (extent 90 58)
     (iconImage loop.icon)
    )
    (detail
     (origin 288 477)
     (extent 165 47)
    )
    (active icon)
   )
  )
  (component 8 "Constant"
   (name "Discount Rate, %")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Discount Rate, %")
     (datum 9)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0.1)
    )
   )
   (views
    (description 7 5
     This is a "Data -> Constant -> Real" object, used
     for data input, in this case for the desired
     "Discount Rate".  The value is entered in a
     percent format instead of as a decimal value
     (ie, 12 rather than .12) merely because this seems
     more natural.  The value is converted to decimal
     in the following formula object.
    )
    (icon
     (origin 281 548)
     (extent 154 25)
    )
    (detail
     (origin 14 556)
     (extent 213 28)
    )
    (active detail)
   )
  )
  (component 9 "Constant"
   (name "Periods/Year")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Periods/Year")
     (datum 12)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0.1)
    )
   )
   (views
    (description 3 5
     This is a "Data -> Constant -> Real" object, used
     for data input, in this case for the number of 
     periods which will occur in a year.
    )
    (icon
     (origin 281 548)
     (extent 118 25)
    )
    (detail
     (origin 14 636)
     (extent 213 28)
    )
    (active detail)
   )
  )
  (component 10 "Formula"
   (name " (1+R/P/100)^N ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "N")
     (optional yes)
    )
    (input 2
     (type data)
     (name "R")
     (optional yes)
    )
    (input 3
     (type data)
     (name "P")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "(1+R/P/100)^N")
   )
   (views
    (description 6 5
     This is a "Math -> Formula" object.
     
     A number of input elements acting as "named 
     variables" may be used by the mathematical 
     formula entered into this object to produce the
     output result.
    )
    (icon
     (origin 268 583)
     (extent 145 34)
    )
    (detail
     (origin 426 502)
     (extent 138 136)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "TextDisplay"
   (name "Net Present Value")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (description 5 5
     This is a "Display -> AlphaNumeric" object.
     
     It is used to display a single output in this
     case, but may also be used to display an array
     output.  See the "Individual PV" object.
    )
    (icon
     (origin 809 388)
     (extent 163 25)
    )
    (detail
     (origin 701 332)
     (extent 218 37)
     (formatter
      (realFormat fixed)
      (realSigDigits 16)
      (realRadixSpec 2)
      (integerBase decimal)
     )
    )
    (active detail)
   )
  )
  (component 12 "Collector"
   (name "Collector")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (tag "Data")
    )
    (input 2
     (type trigger)
     (name "XEQ")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Array")
     (tag "Array")
     (lock constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (description 4 5
     This is a "Data -> Collector" object.
     
     The "Collector" builds a one dimensional array
     from individual data elements.
    )
    (icon
     (origin 455 588)
     (extent 110 25)
    )
    (detail
     (origin 849 628)
     (extent 33 104)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "TextDisplay"
   (name "Individual PV")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (description 5 5
     This is a "Display -> AlphaNumeric" object.
     
     Note that this display device may be use to show
     either a single element, or the multiple elements
     of an array.
    )
    (icon
     (origin 727 558)
     (extent 127 25)
    )
    (detail
     (origin 713 422)
     (extent 215 256)
     (formatter
      (realFormat fixed)
      (realSigDigits 16)
      (realRadixSpec 2)
      (integerBase decimal)
     )
    )
    (active detail)
   )
  )
  (component 14 "Context"
   (name "Overview of Simple NPV Example")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Note"
     (name "Note Pad")
     (interface
     )
     (implementation
      (component text 39 7
       PURPOSE: Demonstrate financial capabilities of HP VEE, using a simple
       		 Net Present Value model with no provision for effect of taxes.
       
       REQUIRED USER DATA: None, to run example.  Input values may be changed.
       
       EXPLANATION: You may change the Annual Interest Rate and Number of
        Periods per Year as well as Cash Flows for each individual period,
        including the total number of Cash Flows.  Click on "Discount Rate"
        and enter annual rate.  Similarly, click the "Periods/Year" and
        "CashFlows" data fields to enter data.  You may position the cursor
        on Cash Flow Field to change, type in the value, then use "Tab" to
        enter value and cycle down to the next Cash Flow field.  To add a
        line, simply press "Tab" from the last line, or "Insert line" from
        any location.  To delete a line, position cursor on line and press
        "Delete line".  When all desired data has been entered, click "Run"
        or "Start" to run program.
       
       Note: follows convention that money received entered as a positive
             Cash Flow, and that money paid out entered as a negative Cash 
             Flow.  Hence, a positive NPV indicates achievement of the
             discount rate goal.  If Cash Flows are assumed to occur at the
       	  END of each period, do not use the 0000: entry line.  Cash Flows
       	  starting with the 0000: entry line effectively occur at the
       	  BEGINNING of each period.
       
       To exit "Info", press "OK" below.
       Additional Information: Use slide at right to view remaining text.
       
       
        Please click "Detail" (left above menu bar) to view the model from
        another perspective.  One might thus observe the inherent advantages
        of using the "Panel" feature of HP VEE on display layout and
        organization of data.  Also note that calculations are easily
        achieved using array math.
       
        By bringing up the "Object Menu" for each device and selecting
        "Show Description", additional information will be shown for the
        specific object.
       
      )
     )
     (views
      (description 1 7
       This is a "Display, Note Pad" object
      )
      (icon
       (extent 110 0)
      )
      (detail
       (origin 369 364)
       (extent 383 112)
       (editing disabled)
      )
      (active detail)
     )
    )
    (component 1 "Confirm"
     (name "OK")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 382 281)
       (extent 57 39)
      )
      (detail
       (origin 420 311)
       (extent 70 38)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
    )
    (ShowOnExecPanel
     (origin 217 113)
     (extent 691 598)
     (panel
      (origin 257 110)
      (extent 687 560)
      (widget 1 icon
       (title off)
       (origin 571 625)
       (extent 58 37)
      )
      (widget 0 detail
       (title off)
       (origin 265 124)
       (extent 671 491)
       (editing disabled)
      )
     )
    )
   )
   (views
    (description 9 5
     This is a "Device -> User Object" object.
     
     This object is shown in its "iconized" state, but
     because it has been converted to a panel, its 
     contents may be shown by clicking the "Info"
     button.  It consists of a "Display -> Note Pad"
     object, and a combination of "Flow -> Start" and
     "Flow -> OK" "buttons", used for keeping the panel
     visible, until a confirmation click on "OK"
    )
    (icon
     (origin 670 198)
     (extent 280 25)
    )
    (detail
     (origin 357 263)
     (extent 466 234)
     (configuration
     )
    )
    (active icon)
   )
  )
  (component 15 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an illustration
     "as is", and Hewlett-Packard Company makes
     no warranty of any kind with regard to 
     this example.
    )
   )
   (views
    (description 1 5
     This is a "Display -> Note Pad" object.
    )
    (icon
     (origin 320 98)
     (extent 181 25)
    )
    (detail
     (origin 253 120)
     (extent 395 80)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 16 "Toggle"
   (name "Info")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type control)
     (name "Reset")
     (lock name constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Info")
     (values range 0 1)
     (datum 0)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (description 8 5
     This is a "Data -> Toggle" object.
     
     It outputs a value of 1 when pressed, but not
     automatically on "Run".  It is used here in
     conjunction with the following "!=0" (or
     "If/Then") object to prevent the information panel
     from displaying except when the "Info" toggle is
     manually activated.
    )
    (icon
     (origin 680 91)
     (extent 60 39)
     (format button)
    )
    (detail
     (origin 838 106)
     (extent 24 48)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 17 "IfThenElse"
   (name "!= 0")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "a!=0")
   )
   (views
    (description 8 5
     This is a "Flow -> If/Then" object.
     
     Its name has been modified to "!=0" so that in
     the icon state its function is still apparent,
     which in this case is to prevent the "Info" panel
     from displaying unless the preceding "Toggle"
     button has been "clicked" such that it outputs
     a 1 value.
    )
    (icon
     (origin 767 128)
     (extent 46 25)
    )
    (detail
     (origin 209 308)
     (extent 73 64)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 18 "Note"
   (name "Note Pad")
   (interface
   )
   (implementation
    (component text 4 5
     This is a simple Net Present Value
     calculation model.  Click "Start"
     to see example calculation results.
     Click "Info" for more details.
    )
   )
   (views
    (description 7 5
     This is a "Display -> Note Pad" object.
     
     It is used here as a part of the main panel as a
     means of providing introductory information.
     Note that it may be shown only as an icon on the
     Detail workarea, while appearing in the Main Panel
     in an expanded state.
    )
    (icon
     (origin 255 228)
     (extent 110 25)
    )
    (detail
     (origin 6 260)
     (extent 328 81)
     (editing disabled)
    )
    (active icon)
   )
  )
  (configuration
   (connect D1:0 D0:0)
   (connect D0:1 D2:1)
   (connect D12:1 D2:2)
   (connect D2:1 D3:1)
   (connect D0:1 D4:1)
   (connect D4:1 D5:1)
   (connect D0:1 D6:1)
   (connect D6:5 D7:1)
   (connect D7:1 D10:1)
   (connect D8:1 D10:2)
   (connect D9:1 D10:3)
   (connect D3:1 D11:1)
   (connect D10:1 D12:1)
   (connect D7:0 D12:2)
   (connect D2:1 D13:1)
   (connect D17:1 D14:0)
   (connect D17:0 D16:1)
   (connect D16:1 D17:1)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 908 644)
   (widget 16 icon
    (title off)
    (origin 57 98)
    (extent 70 39)
    (format button)
   )
   (widget 1 icon
    (title off)
    (origin 170 98)
    (extent 69 39)
   )
   (widget 9 detail
    (title on)
    (origin 52 335)
    (extent 191 27)
   )
   (widget 13 detail
    (title on)
    (origin 640 240)
    (extent 205 245)
    (formatter
     (realFormat fixed)
     (realSigDigits 16)
     (realRadixSpec 2)
     (integerBase decimal)
    )
   )
   (widget 18 detail
    (title off)
    (origin 303 80)
    (extent 328 81)
    (editing disabled)
   )
   (widget 8 detail
    (title on)
    (origin 50 238)
    (extent 192 30)
   )
   (widget 0 detail
    (title on)
    (origin 303 239)
    (extent 198 246)
   )
   (widget 5 detail
    (title on)
    (origin 302 532)
    (extent 201 41)
   )
   (widget 11 detail
    (title on)
    (origin 639 534)
    (extent 208 37)
    (formatter
     (realFormat fixed)
     (realSigDigits 16)
     (realRadixSpec 2)
     (integerBase decimal)
    )
   )
   (widget 15 detail
    (title on)
    (origin 377 626)
    (extent 395 80)
    (editing disabled)
   )
  )
  (detail
   (origin 0 67)
   (extent 958 589)
   (configuration
    (connect D1:0 D0:0
     (Point 130 142)
     (Point 130 164)
    )
    (connect D0:1 D2:1
     (Point 217 280)
     (Point 250 280)
     (Point 250 340)
     (Point 414 340)
    )
    (connect D12:1 D2:2
     (Point 567 600)
     (Point 580 600)
     (Point 580 510)
     (Point 400 510)
     (Point 400 360)
     (Point 414 360)
    )
    (connect D2:1 D3:1
     (Point 465 350)
     (Point 538 350)
    )
    (connect D0:1 D4:1
     (Point 217 280)
     (Point 268 280)
    )
    (connect D4:1 D5:1
     (Point 351 280)
     (Point 396 280)
    )
    (connect D0:1 D6:1
     (Point 217 280)
     (Point 250 280)
     (Point 250 340)
     (Point 240 340)
     (Point 240 390)
     (Point 40 390)
     (Point 40 460)
     (Point 59 460)
    )
    (connect D6:5 D7:1
     (Point 200 480)
     (Point 220 480)
     (Point 220 460)
     (Point 242 460)
    )
    (connect D7:1 D10:1
     (Point 337 460)
     (Point 350 460)
     (Point 350 510)
     (Point 260 510)
     (Point 260 590)
     (Point 265 590)
    )
    (connect D8:1 D10:2
     (Point 229 570)
     (Point 250 570)
     (Point 250 600)
     (Point 265 600)
    )
    (connect D9:1 D10:3
     (Point 229 650)
     (Point 250 650)
     (Point 250 610)
     (Point 265 610)
    )
    (connect D3:1 D11:1
     (Point 621 350)
     (Point 698 350)
    )
    (connect D10:1 D12:1
     (Point 415 600)
     (Point 430 600)
     (Point 430 590)
     (Point 452 590)
    )
    (connect D7:0 D12:2
     (Point 290 491)
     (Point 290 520)
     (Point 440 520)
     (Point 440 610)
     (Point 452 610)
    )
    (connect D2:1 D13:1
     (Point 465 350)
     (Point 520 350)
     (Point 520 380)
     (Point 590 380)
     (Point 590 550)
     (Point 710 550)
    )
    (connect D17:1 D14:0
     (Point 815 130)
     (Point 830 130)
     (Point 830 170)
     (Point 810 170)
     (Point 810 195)
    )
    (connect D17:0 D16:1
     (Point 790 155)
     (Point 790 170)
     (Point 670 170)
     (Point 670 110)
     (Point 677 110)
    )
    (connect D16:1 D17:1
     (Point 742 110)
     (Point 750 110)
     (Point 750 140)
     (Point 764 140)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
