#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Wed 10/Apr/1991")
(component 0 "Context"
 (name "Lissajous Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "VFunctionGenerator"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Frequency")
     (tag "Frequency")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Func")
     (lock name constraints)
    )
    (buffers in
     (buffer "Frequency")
    )
   )
   (implementation
    (component function Sine)
    (component frequency 1000)
    (component amplitude 1)
    (component dcOffset 0)
    (component phaseShift 0)
    (component numPoints 512)
    (component interval 0.02)
    (component degRad Deg)
    (component errorOnAlias 1)
   )
   (views
    (icon
     (origin 264 408)
     (extent 172 64)
     (iconImage virtual.icon)
    )
    (detail
     (origin 506 111)
     (extent 239 198)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 1 "VFunctionGenerator"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Frequency")
     (tag "Frequency")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (input 2
     (type data)
     (name "Phase")
     (tag "Phase")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Func")
     (lock name constraints)
    )
    (buffers in
     (buffer "Frequency")
     (buffer "Phase")
    )
   )
   (implementation
    (component function Sine)
    (component frequency 2000)
    (component amplitude 1)
    (component dcOffset 0)
    (component phaseShift 0)
    (component numPoints 512)
    (component interval 0.02)
    (component degRad Deg)
    (component errorOnAlias 1)
   )
   (views
    (icon
     (origin 264 498)
     (extent 172 64)
     (iconImage virtual.icon)
    )
    (detail
     (origin 586 661)
     (extent 239 198)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "TextDisplay"
   (name "Phase Shift")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 249 614)
     (extent 183 32)
    )
    (active detail)
   )
  )
  (component 3 "Formula"
   (name " / ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X/Y")
   )
   (views
    (icon
     (origin 397 298)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "TextDisplay"
   (name "Frequency Ratio")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 145 0)
    )
    (detail
     (origin 501 292)
     (extent 219 37)
    )
    (active detail)
   )
  )
  (component 5 "Constant"
   (name "Real")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Real")
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Real")
     (datum 1000)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
    )
    (detail
     (origin 239 306)
     (extent 122 28)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 6 "XYPlot"
   (name "Lissajous")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "XData")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "YData1")
     (lock constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 2)
    (component graphMode rectangular)
   )
   (views
    (icon
     (extent 110 0)
     (iconImage display.icon)
    )
    (detail
     (origin 530 372)
     (extent 360 296)
     (displayMode graphOnly)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Y name")
      (domainName "X name")
      (color 0x909090)
      (show 1)
      (range -1 1 4 linear)
     )
     (domain -1 1 4 linear)
     (trace 0 onScale 0
      (name "YData1")
      (color 0xffdd00)
      (lineType 1)
      (pointType 0)
     )
    )
    (terminals on)
    (active detail)
   )
  )
  (component 7 "ForRange"
   (name "Phase")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
    (component from 0)
    (component thru 180)
    (component step 30)
   )
   (views
    (icon
     (extent 78 0)
     (iconImage loop.icon)
    )
    (detail
     (origin 5 507)
     (extent 170 86)
    )
    (active detail)
   )
  )
  (component 8 "ForRange"
   (name "For Range")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
    (component from 1000)
    (component thru 5000)
    (component step 500)
   )
   (views
    (icon
     (iconImage loop.icon)
    )
    (detail
     (origin 5 357)
     (extent 170 86)
    )
    (active detail)
   )
  )
  (component 9 "Start"
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 57 262)
     (extent 67 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 10 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 5 5
     This example is provided as an
     illustration "as is", and Hewlett-
     Packard Company makes no warranty
     of any kind with regard to this
     example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 368 120)
     (extent 325 100)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 11 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 325 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 161 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About...")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 520 419)
         (extent 58 37)
        )
        (detail
         (origin 466 633)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "Info About This Example")
       (interface
       )
       (implementation
        (component text 19 9
         EXPLANATION: Lissajous patterns are generated by applying a reference sinusoidal
          waveform to the X input of an "X vs Y Display" and applying a comparison waveform
          to the display's Y input.  The resulting pattern depends on the frequency ratio
          and the relative phase of the two waveforms. 
         
          When the ratio of frequencies is an exact integer, the pattern is stationary, and
          the frequency ratio is the number of times the sides of the figure are tangent to 
          a horizontal line divided by the number of times the ends are tangent to a 
          vertical line.
         
          If the ratio is not a rational number, the pattern behaves as if the relative phase
          is continuously changing.  In this example, the ratios are rational.
         
          The relative phase changes the shape of the pattern but does not alter the number
          of horizontal and vertical tangent points.  The phase difference can be calculated 
          as: sin Theta = B/A , where Theta is the phase angle, A is the value of the curve
          at X=0 (the y intercept),  and B is the maximum Y value of the curve.  The sign of 
          the phase depends on the quadrant.
         
        )
       )
       (views
        (icon
         (origin 582 348)
         (extent 217 64)
         (iconImage /usr/lib/veetest/bitmaps/notepad.icon)
        )
        (detail
         (origin 270 305)
         (extent 560 131)
         (editing disabled)
        )
        (active detail)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 0 135)
       (extent 847 447)
       (panel
        (origin 29 166)
        (extent 843 409)
        (widget 0 icon
         (title off)
         (origin 402 530)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 48 172)
         (extent 797 352)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 387 358)
       (extent 127 25)
      )
      (detail
       (origin 265 260)
       (extent 351 200)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D0:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 435 388)
     (extent 110 25)
    )
    (panel
     (origin 21 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 123 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 277 362)
       (Point 322 362)
      )
      (connect D0:0 D1:1
       (Point 348 377)
       (Point 348 400)
       (Point 140 400)
       (Point 140 362)
       (Point 158 362)
      )
      (connect D0:1 D2:0
       (Point 373 352)
       (Point 380 352)
       (Point 380 340)
       (Point 450 340)
       (Point 450 355)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D5:1 D0:1)
   (connect D8:1 D1:1)
   (connect D7:1 D1:2)
   (connect D7:1 D2:1)
   (connect D8:1 D3:1)
   (connect D5:1 D3:2)
   (connect D3:1 D4:1)
   (connect D0:1 D6:1)
   (connect D1:1 D6:2)
   (connect D8:1 D7:0)
   (connect D9:0 D8:0)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 870 650)
   (widget 9 icon
    (title off)
    (origin 34 125)
    (extent 113 75)
   )
   (widget 2 detail
    (title on)
    (origin 186 117)
    (extent 195 44)
   )
   (widget 10 detail
    (title on)
    (origin 489 115)
    (extent 325 100)
    (editing disabled)
   )
   (widget 6 detail
    (title on)
    (origin 80 302)
    (extent 720 391)
    (displayMode graphOnly)
    (graphType cartesian)
    (gridType grid)
    (scale 0
     (name "Y name")
     (domainName "X name")
     (color 0x909090)
     (show 1)
     (range -1 1 4 linear)
    )
    (domain -1 1 4 linear)
    (trace 0 onScale 0
     (name "YData1")
     (color 0xffdd00)
     (lineType 1)
     (pointType 0)
    )
   )
   (widget 4 detail
    (title on)
    (origin 181 206)
    (extent 210 43)
   )
  )
  (detail
   (origin 0 67)
   (extent 980 636)
   (configuration
    (connect D5:1 D0:1
     (Point 363 320)
     (Point 380 320)
     (Point 380 360)
     (Point 240 360)
     (Point 240 440)
     (Point 261 440)
    )
    (connect D8:1 D1:1
     (Point 177 400)
     (Point 200 400)
     (Point 200 460)
     (Point 210 460)
     (Point 210 510)
     (Point 261 510)
    )
    (connect D7:1 D1:2
     (Point 177 550)
     (Point 261 550)
    )
    (connect D7:1 D2:1
     (Point 177 550)
     (Point 220 550)
     (Point 220 630)
     (Point 246 630)
    )
    (connect D8:1 D3:1
     (Point 177 400)
     (Point 210 400)
     (Point 210 260)
     (Point 380 260)
     (Point 380 300)
     (Point 394 300)
    )
    (connect D5:1 D3:2
     (Point 363 320)
     (Point 394 320)
    )
    (connect D3:1 D4:1
     (Point 445 310)
     (Point 498 310)
    )
    (connect D0:1 D6:1
     (Point 438 440)
     (Point 457 440)
    )
    (connect D1:1 D6:2
     (Point 438 530)
     (Point 450 530)
     (Point 450 600)
     (Point 457 600)
    )
    (connect D8:1 D7:0
     (Point 177 400)
     (Point 200 400)
     (Point 200 460)
     (Point 90 460)
     (Point 90 474)
    )
    (connect D9:0 D8:0
     (Point 90 301)
     (Point 90 324)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
