#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name " Convection Coefficient Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Slider"
   (name "Lgth. or Dia.")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Lgth. or Dia.")
     (values range 0 6)
     (datum 1.25)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
    (component detents 0.25)
   )
   (views
    (description 9 5
     This "Data -> Real Slider" object is one of
     several input devices that has the advantage of
     providing either a direct value entry (click on
     the entry field), or a slider bar which may be
     moved to change the value.  This also provides a
     rough graphical concept of the value, much the
     same as a bar chart gives a quick overall 
     impression of values.
      
    )
    (icon
     (origin 47 268)
     (extent 127 25)
    )
    (detail
     (origin 10 125)
     (extent 181 191)
    )
    (active detail)
   )
  )
  (component 1 "Slider"
   (name "Temp. Delta")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Temp. Delta")
     (values range 0 1000)
     (datum 510)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
    (component detents 10)
   )
   (views
    (description 7 5
     This a "Data -> Real Slider" object.
     In this case it is being used for a coarse
     setting of the Temperature Delta value.
     
     For more information, see "Show Description" for
     the fine "Temp. Delta" slider, and especially the
     "Lgth. or Dia." slider object.
    )
    (icon
     (extent 110 0)
    )
    (detail
     (origin 9 356)
     (extent 182 208)
    )
    (active detail)
   )
  )
  (component 2 "Slider"
   (name "Temp. Delta")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Temp. Delta")
     (values range 0 9)
     (datum 4)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
    (component detents 1)
   )
   (views
    (description 7 5
     This is a "Data -> Real Slider" object.
     In this case it is being used for setting a finer
     resolution Temperature Delta value.
     
     For more information, see "Show Description" for
     the coarse "Temp. Delta" slider, and especially
     the "Lgth. or Dia." slider object.
    )
    (icon
     (extent 110 0)
    )
    (detail
     (origin 9 604)
     (extent 182 132)
    )
    (active detail)
   )
  )
  (component 3 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
      This example is provided as an
      illustration "as is", and Hewlett-Packard
      Company makes no warranty of any kind
      with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 602 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 4 "Junction"
   (name "JCT")
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 657 358)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "Junction"
   (name "JCT")
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
    )
    (input 3
     (type data)
     (name "C")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (description 8 5
     This is a "Flow -> Junction" object.  It is
     somewhat different than other objects, in that
     it only needs one input value on any one of its
     input pins, in order to be able to supply an
     output.  That is in fact its function, to pass on
     the single value input that it has available when
     it becomes activated.
      
    )
    (icon
     (origin 767 213)
     (extent 46 34)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "LiteralConstant"
   (name "Tran")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Tran")
     (datum "Flow is in Transition Range")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (origin 797 308)
     (extent 46 25)
    )
    (detail
     (origin 700 286)
     (extent 201 28)
    )
    (active icon)
   )
  )
  (component 7 "Junction"
   (name "JCT")
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 717 278)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "Formula"
   (name " + ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X+Y")
   )
   (views
    (icon
     (origin 217 628)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "TextDisplay"
   (name "Convection Coef. h")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 172 0)
    )
    (detail
     (origin 724 623)
     (extent 273 35)
     (formatter
      (realFormat standard)
      (realSigDigits 4)
      (realRadixSpec 4)
      (integerBase decimal)
     )
    )
    (active detail)
   )
  )
  (component 10 "Junction"
   (name "JCT")
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
    )
    (input 3
     (type data)
     (name "C")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 637 613)
     (extent 46 34)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "EnumConstant"
   (name "Surface Type")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Enum
     (name "Surface Type")
     (values
      ( "Vert. Plate" 0)
      ( "H/V Pipes" 1)
      ( "Horz. Plate up" 2)
      ( "Horz. Plate down" 3)
     )
     (datum "H/V Pipes")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Enum
     (shared yes)
     (datum "Vert. Plate")
    )
   )
   (views
    (description 12 5
     This is a "Data -> Enum" object, which has the 
     "Format -> Buttons" option from the object menu
     enabled.  This provides a quick graphical method
     of selecting values for defined, often used items
     from a list, rather than having to know and enter
     specific values.  Since the entries listed in
     this object are descriptive text, some means of
     correlating to actual values must be provided.
     This example does this by a downstream "If/Then"
     check of the "Enum" selection's ordinal value.
     Check "Show Description" for these "If/Then"
     objects and also "Help" for "Enum".
    )
    (icon
     (extent 118 0)
    )
    (detail
     (origin 198 259)
     (extent 184 103)
     (format buttons)
    )
    (active detail)
   )
  )
  (component 12 "IfThenElse"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "ordinal(A)<2")
   )
   (views
    (description 6 5
     This "Flow -> If/Then" object is a first pass
     "filter" for the upstream enum values, to switch
     between one of the following "If/Then" objects
     which provides final resolution for the action
     to be taken based on the enum value.
     
    )
    (icon
     (origin 401 278)
     (extent 78 25)
    )
    (detail
     (origin 347 205)
     (extent 136 70)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "LiteralConstant"
   (name "Turb")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Turb")
     (datum "Flow is in Turbulent Region")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (origin 747 388)
     (extent 46 25)
    )
    (detail
     (origin 630 366)
     (extent 201 28)
    )
    (active icon)
   )
  )
  (component 14 "LiteralConstant"
   (name "Out")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Out")
     (datum "Data is outside Bounds")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (origin 717 428)
     (extent 46 25)
    )
    (detail
     (origin 590 446)
     (extent 201 28)
    )
    (active icon)
   )
  )
  (component 15 "Junction"
   (name "JCT")
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 627 418)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 16 "Formula"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "L")
     (optional yes)
    )
    (input 2
     (type data)
     (name "T")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "L^3*T")
   )
   (views
    (icon
     (origin 261 128)
     (extent 78 25)
    )
    (detail
     (origin 251 126)
     (extent 79 110)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 17 "TextDisplay"
   (name "(T*(L^3)) Range")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (description 1 5
     This is a "Display -> AlphaNumeric" object.
    )
    (icon
     (origin 421 126)
     (extent 119 28)
    )
    (detail
     (origin 368 165)
     (extent 224 33)
     (formatter
      (realFormat standard)
      (realSigDigits 4)
      (realRadixSpec 4)
      (integerBase decimal)
     )
    )
    (active icon)
   )
  )
  (component 18 "IfThenElse"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "L")
     (optional yes)
    )
    (input 2
     (type data)
     (name "T")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else If")
     (lock name constraints)
    )
    (output 3
     (type data)
     (name "Else If")
     (lock name constraints)
    )
    (output 4
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr ".01<=(L^3)*T AND (L^3)*T<=990")
    (component expr "990<(L^3)*T AND (L^3)*T<=1010")
    (component expr "1010<(L^3)*T AND (L^3)*T<1000000")
   )
   (views
    (description 8 5
     This "Flow -> If/Then" object provides the final
     filter for determining further action based on
     the upstream "Enum" value, and is used when one
     of the first two selections is chosen.  It will
     determine the surface flow condition based on
     the Temperature and Length of the surface over
     which the flow occurs.
     
    )
    (icon
     (origin 517 218)
     (extent 86 45)
    )
    (detail
     (origin 391 219)
     (extent 318 124)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 19 "IfThenElse"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "L")
     (optional yes)
    )
    (input 2
     (type data)
     (name "T")
     (optional yes)
    )
    (input 3
     (type data)
     (name "C")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else If")
     (lock name constraints)
    )
    (output 3
     (type data)
     (name "Else If")
     (lock name constraints)
    )
    (output 4
     (type data)
     (name "Else If")
     (lock name constraints)
    )
    (output 5
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "ordinal(C)==3 AND .3<=(L^3)*T AND (L^3)*T<30000")
    (component expr "ordinal(C)==2 AND .1<(L^3)*T AND (L^3)*T<=19")
    (component expr "ordinal(C)==2 AND 19<(L^3)*T AND (L^3)*T<=21")
    (component expr "ordinal(C)==2 AND 21<(L^3)*T AND (L^3)*T<30000")
   )
   (views
    (description 7 5
     This "Flow -> If/Then" object provides the final
     filter for determining further action based on
     the upstream "Enum" value, and is used when one
     of the last two selections is chosen.  It will
     determine the surface flow condition based on
     the Temperature and Length of the surface over
     which the flow occurs.
    )
    (icon
     (origin 517 323)
     (extent 86 54)
    )
    (detail
     (origin 325 314)
     (extent 451 154)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 20 "Formula"
   (name "LFormula")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "L")
     (optional yes)
    )
    (input 2
     (type data)
     (name "T")
     (optional yes)
    )
    (input 3
     (type data)
     (name "C")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "(C[0:0]*(T/L)^.25)")
   )
   (views
    (icon
     (origin 465 493)
     (extent 110 35)
    )
    (detail
     (origin 412 449)
     (extent 196 204)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 21 "Formula"
   (name "LTFormula")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "L")
     (optional yes)
    )
    (input 2
     (type data)
     (name "T")
     (optional yes)
    )
    (input 3
     (type data)
     (name "Cx")
     (optional yes)
    )
    (input 4
     (type data)
     (name "Cy")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "((Cx*(T/L)^.25)+(Cy*(T)^(1/3)))/2")
   )
   (views
    (icon
     (origin 403 566)
     (extent 115 49)
    )
    (detail
     (origin 282 529)
     (extent 337 204)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 22 "Formula"
   (name "TFormula")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "T")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Cy")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "(Cy*(T)^(1/3))")
   )
   (views
    (icon
     (origin 495 628)
     (extent 110 25)
    )
    (detail
     (origin 463 622)
     (extent 154 119)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 23 "FromCoordinate"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Coord Data")
     (requires
      (datatype Coord)
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "X Data")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Y Data")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 347 667)
     (extent 127 25)
    )
    (detail
     (origin 380 535)
     (extent 23 70)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 24 "FromArray"
   (name "Get Coef.")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "C")
     (tag "Ary")
    )
    (input 2
     (type data)
     (name "Ary")
     (optional yes)
    )
    (output 1
     (type data)
     (name "SubAry")
     (tag "Result")
     (lock constraints)
    )
    (output 2
     (type data)
     (name "Type")
     (tag "Type")
     (lock constraints)
    )
    (output 3
     (type data)
     (name "NumDims")
     (tag "NumDims")
     (lock constraints)
    )
    (output 4
     (type data)
     (name "DimSizes")
     (tag "DimSizes")
     (lock constraints)
    )
    (output 5
     (type data)
     (name "TotSize")
     (tag "TotSize")
     (lock constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "Ary[ordinal(C):ordinal(C)]")
   )
   (views
    (icon
     (origin 225 692)
     (extent 110 54)
    )
    (detail
     (origin 147 540)
     (extent 286 160)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 25 "Constant"
   (name "Coef L,T")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Coord
     (name "Coef L,T")
     (numDims 1)
     (size 4)
     (numCoordDims 2)
     (data
      [ (0.29,0.21) (0.25,0.18) (0.27,0.22) (0.12,0) ]
     )
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Coord
     (numCoordDims 2)
     (datum (0,0))
    )
   )
   (views
    (description 8 5
     This "Data -> Constant -> Coord" object contains
     a coordinate array of constants, one set of which
     is selected based on the "Surface Type" enum
     ordinal value.  Using a coordinate pair provides
     an easy way of associating the laminar and
     turbulent flow coefficients for each type of
     surface that may be chosen.
     
    )
    (icon
     (origin 85 748)
     (extent 110 25)
    )
    (detail
     (origin 23 636)
     (extent 214 90)
     (showFormat real)
    )
    (active icon)
   )
  )
  (component 26 "Junction"
   (name "JCT")
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
    )
    (input 3
     (type data)
     (name "C")
     (optional yes)
    )
    (input 4
     (type data)
     (name "D")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 884 403)
     (extent 53 54)
    )
    (detail
     (origin 875 246)
     (extent 40 210)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 27 "LiteralConstant"
   (name "Lam")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Lam")
     (datum "Flow is in Laminar Range")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (origin 817 248)
     (extent 46 25)
    )
    (detail
     (origin 730 167)
     (extent 201 28)
    )
    (active icon)
   )
  )
  (component 28 "TextDisplay"
   (name "Flow Range")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 659 529)
     (extent 342 40)
    )
    (active detail)
   )
  )
  (component 29 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 447 378)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info ")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 328 370)
       (extent 64 41)
       (format button)
      )
      (detail
       (origin 292 333)
       (extent 16 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Details of Natural Convection Coefficient Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "OK")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 520 501)
         (extent 61 39)
        )
        (detail
         (origin 436 473)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (interface
       )
       (implementation
        (component text 41 9
         PURPOSE: Demonstrate the use of HP VEE with a Natural Convection Heat Transfer Model
          that will calculate the heat transfer coefficient, "h", for several body or surface 
          types.
         
         USER INPUT REQUIRED: None  to run example as set up.  To use other values, note
          that three data inputs are required: length (or diameter) of surface, surface
          to ambient temperature differential, and surface "type" under consideration.
          By moving slider handles or entering data by clicking on the entry fields (below
          slider title), you may enter  length and temperature.  Coarse (tens) and fine
          (ones) sliders are used to provide better resolution for "Temp. Delta".  Clicking
          on a button next to one of the enumerated "Surface Types" easily defines the
          surface type.  Finally, click "Run" (on the right side of the title bar) to calculate
          the result (that is, the heat transfer coefficient) based on the input values. 
         
         EXPLANATION: This model is based on a simplified formula with constants and valid
          ranges that yield conservative design values.  Valid ranges are based on the
          "Surface Type" and the value of "Surface/Ambient Temperature Delta" multiplied by
          the surface "Length" (or diameter) cubed.  The range value is displayed just for
          reference, since the textual display indicating flow type (laminar, transitional,
          or turbulent) is of primary interest.  Simplified constants which are appropriate
          for laminar and turbulent flow conditions for each surface type are contained in
          one "Data -> Constant -> Coord" object as a set of paired values.  One pair is
          chosen for calculation requirements based on the "Surface Type" selection mentioned
          above.  This "Enum" selection also affects determination of surface flow conditions.
         
          Click  "Detail" (on the left side of the title bar) to review specific construction
          details of this model and to better appreciate the display organization benefits
          of HP VEE's panel view.  Most of the objects are iconized to save space, but may
          be opened by double-clicking on the icons.  From the object menu, select "Help"
          and (for some objects) "Show Description" for more information on each object.  For 
          example, "Show Description" for the "Surface Type" object provides some details 
          about how enumerated selections require further processing.  In this example, 
          control over which coefficients, ranges, and flow indicator outputs are used is
          dependent on proper processing (or "parsing") of the enumerated values. 
         
          It may also be interesting to explore the "Info" button, which in the detail view
          is a panel, built from a "Device -> UserObject" and produces this display upon
          its activation.  It has its own "Detail" button, which may be used to investigate
          its own construction details, such as the fact that it contains yet another panel.
          These are actually nested "UserObjects" effectively functioning as independent
          "sub-models".
        )
       )
       (views
        (icon
         (origin 541 538)
         (extent 78 25)
        )
        (detail
         (origin 126 231)
         (extent 848 437)
         (editing disabled)
        )
        (active detail)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 22 106)
       (extent 833 588)
       (panel
        (origin 126 175)
        (extent 829 550)
        (widget 0 icon
         (title off)
         (origin 517 682)
         (extent 52 36)
        )
        (widget 1 detail
         (title off)
         (origin 143 190)
         (extent 806 483)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 345 549)
       (extent 451 25)
      )
      (detail
       (origin 117 170)
       (extent 866 520)
       (configuration
       )
      )
      (active panel)
      (active panel)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D0:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 705 648)
     (extent 110 25)
    )
    (panel
     (origin 572 706)
     (extent 256 47)
     (widget 1 icon
      (title off)
      (origin 669 711)
      (extent 60 37)
      (format button)
     )
    )
    (detail
     (origin 112 124)
     (extent 857 590)
     (configuration
      (connect D1:1 D0:1
       (Point 394 390)
       (Point 420 390)
       (Point 420 390)
       (Point 444 390)
      )
      (connect D0:0 D1:1
       (Point 470 405)
       (Point 470 430)
       (Point 310 430)
       (Point 310 390)
       (Point 325 390)
      )
      (connect D0:1 D2:0
       (Point 495 380)
       (Point 540 380)
       (Point 540 142)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 30 "Note"
   (name "Overview of Example")
   (interface
   )
   (implementation
    (component text 5 5
      This is an Natural Convection
      Heat Transfer Coefficient Model.
      Click "Run" to see example 
      calculation results. Click "Info" 
      for more details.
    )
   )
   (views
    (icon
     (origin 390 167)
     (extent 181 25)
    )
    (detail
     (origin 319 114)
     (extent 323 131)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 31 "Note"
   (name "Coarse")
   (interface
   )
   (implementation
   )
   (views
    (icon
     (origin 41 448)
     (extent 78 25)
    )
    (detail
     (origin 10 415)
     (extent 180 90)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 32 "Note"
   (name "Fine")
   (interface
   )
   (implementation
   )
   (views
    (icon
     (origin 47 668)
     (extent 46 25)
    )
    (detail
     (origin 10 605)
     (extent 180 90)
     (editing disabled)
    )
    (active icon)
   )
  )
  (configuration
   (connect D18:3 D4:1)
   (connect D19:4 D4:2)
   (connect D18:1 D5:1)
   (connect D19:1 D5:2)
   (connect D19:2 D5:3)
   (connect D7:1 D6:0)
   (connect D18:2 D7:1)
   (connect D19:3 D7:2)
   (connect D1:1 D8:1)
   (connect D2:1 D8:2)
   (connect D10:1 D9:1)
   (connect D20:1 D10:1)
   (connect D21:1 D10:2)
   (connect D22:1 D10:3)
   (connect D11:1 D12:1)
   (connect D4:1 D13:0)
   (connect D15:1 D14:0)
   (connect D18:4 D15:1)
   (connect D19:5 D15:2)
   (connect D0:1 D16:1)
   (connect D8:1 D16:2)
   (connect D16:1 D17:1)
   (connect D12:1 D18:0)
   (connect D0:1 D18:1)
   (connect D8:1 D18:2)
   (connect D12:2 D19:0)
   (connect D0:1 D19:1)
   (connect D8:1 D19:2)
   (connect D11:1 D19:3)
   (connect D5:1 D20:0)
   (connect D0:1 D20:1)
   (connect D8:1 D20:2)
   (connect D23:1 D20:3)
   (connect D7:1 D21:0)
   (connect D0:1 D21:1)
   (connect D8:1 D21:2)
   (connect D23:1 D21:3)
   (connect D23:2 D21:4)
   (connect D4:1 D22:0)
   (connect D8:1 D22:1)
   (connect D23:2 D22:2)
   (connect D24:1 D23:1)
   (connect D11:1 D24:1)
   (connect D25:1 D24:2)
   (connect D27:1 D26:1)
   (connect D6:1 D26:2)
   (connect D13:1 D26:3)
   (connect D14:1 D26:4)
   (connect D5:1 D27:0)
   (connect D26:1 D28:1)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 910 653)
   (widget 11 detail
    (title on)
    (origin 248 292)
    (extent 205 101)
    (format buttons)
   )
   (widget 0 detail
    (title on)
    (origin 30 108)
    (extent 181 191)
   )
   (widget 9 detail
    (title on)
    (origin 583 296)
    (extent 223 35)
    (formatter
     (realFormat standard)
     (realSigDigits 4)
     (realRadixSpec 4)
     (integerBase decimal)
    )
   )
   (widget 17 detail
    (title on)
    (origin 584 455)
    (extent 224 33)
    (formatter
     (realFormat standard)
     (realSigDigits 4)
     (realRadixSpec 4)
     (integerBase decimal)
    )
   )
   (widget 29 panel
    (title off)
    (origin 249 165)
    (extent 77 50)
    (widget 1 icon
     (title off)
     (origin 254 171)
     (extent 68 38)
     (format button)
    )
   )
   (widget 28 detail
    (title on)
    (origin 583 372)
    (extent 313 40)
   )
   (widget 1 detail
    (title on)
    (origin 31 339)
    (extent 182 200)
   )
   (widget 2 detail
    (title on)
    (origin 32 575)
    (extent 182 132)
   )
   (widget 31 icon
    (title off)
    (origin 59 432)
    (extent 78 25)
   )
   (widget 32 icon
    (title off)
    (origin 83 638)
    (extent 46 25)
   )
   (widget 30 detail
    (title on)
    (origin 370 108)
    (extent 326 129)
    (editing disabled)
   )
   (widget 3 detail
    (title on)
    (origin 481 578)
    (extent 404 107)
    (editing disabled)
   )
  )
  (detail
   (origin 0 67)
   (extent 979 648)
   (configuration
    (connect D18:3 D4:1
     (Point 605 240)
     (Point 720 240)
     (Point 720 320)
     (Point 640 320)
     (Point 640 360)
     (Point 654 360)
    )
    (connect D19:4 D4:2
     (Point 605 360)
     (Point 620 360)
     (Point 620 380)
     (Point 654 380)
    )
    (connect D18:1 D5:1
     (Point 605 220)
     (Point 684 220)
     (Point 684 220)
     (Point 764 220)
    )
    (connect D19:1 D5:2
     (Point 605 330)
     (Point 630 330)
     (Point 630 310)
     (Point 640 310)
     (Point 640 230)
     (Point 764 230)
    )
    (connect D19:2 D5:3
     (Point 605 340)
     (Point 730 340)
     (Point 730 240)
     (Point 764 240)
    )
    (connect D7:1 D6:0
     (Point 765 290)
     (Point 820 290)
     (Point 820 305)
    )
    (connect D18:2 D7:1
     (Point 605 230)
     (Point 620 230)
     (Point 620 280)
     (Point 714 280)
    )
    (connect D19:3 D7:2
     (Point 605 350)
     (Point 620 350)
     (Point 620 300)
     (Point 714 300)
    )
    (connect D1:1 D8:1
     (Point 193 460)
     (Point 210 460)
     (Point 210 610)
     (Point 200 610)
     (Point 200 630)
     (Point 214 630)
    )
    (connect D2:1 D8:2
     (Point 193 670)
     (Point 200 670)
     (Point 200 650)
     (Point 214 650)
    )
    (connect D10:1 D9:1
     (Point 685 630)
     (Point 700 630)
     (Point 700 640)
     (Point 721 640)
    )
    (connect D20:1 D10:1
     (Point 577 510)
     (Point 610 510)
     (Point 610 620)
     (Point 634 620)
    )
    (connect D21:1 D10:2
     (Point 520 590)
     (Point 620 590)
     (Point 620 630)
     (Point 634 630)
    )
    (connect D22:1 D10:3
     (Point 607 640)
     (Point 620 640)
     (Point 620 640)
     (Point 634 640)
    )
    (connect D11:1 D12:1
     (Point 384 310)
     (Point 390 310)
     (Point 390 290)
     (Point 398 290)
    )
    (connect D4:1 D13:0
     (Point 705 370)
     (Point 770 370)
     (Point 770 385)
    )
    (connect D15:1 D14:0
     (Point 675 430)
     (Point 690 430)
     (Point 690 410)
     (Point 740 410)
     (Point 740 425)
    )
    (connect D18:4 D15:1
     (Point 605 250)
     (Point 630 250)
     (Point 630 290)
     (Point 600 290)
     (Point 600 420)
     (Point 624 420)
    )
    (connect D19:5 D15:2
     (Point 605 370)
     (Point 630 370)
     (Point 630 400)
     (Point 610 400)
     (Point 610 440)
     (Point 624 440)
    )
    (connect D0:1 D16:1
     (Point 193 220)
     (Point 210 220)
     (Point 210 130)
     (Point 258 130)
    )
    (connect D8:1 D16:2
     (Point 265 640)
     (Point 280 640)
     (Point 280 580)
     (Point 370 580)
     (Point 370 510)
     (Point 450 510)
     (Point 450 250)
     (Point 410 250)
     (Point 410 200)
     (Point 250 200)
     (Point 250 150)
     (Point 258 150)
    )
    (connect D16:1 D17:1
     (Point 341 140)
     (Point 353 140)
     (Point 353 140)
     (Point 418 140)
    )
    (connect D12:1 D18:0
     (Point 481 280)
     (Point 500 280)
     (Point 500 210)
     (Point 560 210)
     (Point 560 215)
    )
    (connect D0:1 D18:1
     (Point 193 220)
     (Point 210 220)
     (Point 210 210)
     (Point 400 210)
     (Point 400 230)
     (Point 514 230)
    )
    (connect D8:1 D18:2
     (Point 265 640)
     (Point 280 640)
     (Point 280 580)
     (Point 370 580)
     (Point 370 510)
     (Point 450 510)
     (Point 450 250)
     (Point 514 250)
    )
    (connect D12:2 D19:0
     (Point 481 300)
     (Point 560 300)
     (Point 560 320)
    )
    (connect D0:1 D19:1
     (Point 193 220)
     (Point 210 220)
     (Point 210 210)
     (Point 400 210)
     (Point 400 230)
     (Point 470 230)
     (Point 470 330)
     (Point 514 330)
    )
    (connect D8:1 D19:2
     (Point 265 640)
     (Point 280 640)
     (Point 280 580)
     (Point 370 580)
     (Point 370 510)
     (Point 450 510)
     (Point 450 350)
     (Point 514 350)
    )
    (connect D11:1 D19:3
     (Point 384 310)
     (Point 400 310)
     (Point 400 370)
     (Point 514 370)
    )
    (connect D5:1 D20:0
     (Point 815 230)
     (Point 970 230)
     (Point 970 490)
     (Point 860 490)
     (Point 860 470)
     (Point 520 470)
     (Point 520 490)
    )
    (connect D0:1 D20:1
     (Point 193 220)
     (Point 210 220)
     (Point 210 210)
     (Point 400 210)
     (Point 400 230)
     (Point 470 230)
     (Point 470 330)
     (Point 440 330)
     (Point 440 500)
     (Point 462 500)
    )
    (connect D8:1 D20:2
     (Point 265 640)
     (Point 280 640)
     (Point 280 580)
     (Point 370 580)
     (Point 370 510)
     (Point 462 510)
    )
    (connect D23:1 D20:3
     (Point 476 669)
     (Point 500 669)
     (Point 500 639)
     (Point 380 639)
     (Point 380 520)
     (Point 462 520)
    )
    (connect D7:1 D21:0
     (Point 765 290)
     (Point 780 290)
     (Point 780 350)
     (Point 690 350)
     (Point 690 400)
     (Point 640 400)
     (Point 640 410)
     (Point 630 410)
     (Point 630 460)
     (Point 510 460)
     (Point 510 550)
     (Point 460 550)
     (Point 460 563)
    )
    (connect D0:1 D21:1
     (Point 193 220)
     (Point 210 220)
     (Point 210 210)
     (Point 400 210)
     (Point 400 230)
     (Point 470 230)
     (Point 470 330)
     (Point 440 330)
     (Point 440 500)
     (Point 390 500)
     (Point 390 570)
     (Point 400 570)
    )
    (connect D8:1 D21:2
     (Point 265 640)
     (Point 280 640)
     (Point 280 580)
     (Point 400 580)
    )
    (connect D23:1 D21:3
     (Point 476 669)
     (Point 500 669)
     (Point 500 639)
     (Point 380 639)
     (Point 380 590)
     (Point 400 590)
    )
    (connect D23:2 D21:4
     (Point 476 689)
     (Point 490 689)
     (Point 490 659)
     (Point 480 659)
     (Point 480 649)
     (Point 370 649)
     (Point 370 600)
     (Point 400 600)
    )
    (connect D4:1 D22:0
     (Point 705 370)
     (Point 720 370)
     (Point 720 400)
     (Point 700 400)
     (Point 700 460)
     (Point 640 460)
     (Point 640 550)
     (Point 550 550)
     (Point 550 625)
    )
    (connect D8:1 D22:1
     (Point 265 640)
     (Point 280 640)
     (Point 280 630)
     (Point 492 630)
    )
    (connect D23:2 D22:2
     (Point 476 689)
     (Point 490 689)
     (Point 490 659)
     (Point 480 659)
     (Point 480 650)
     (Point 492 650)
    )
    (connect D24:1 D23:1
     (Point 337 699)
     (Point 350 699)
     (Point 350 689)
     (Point 330 689)
     (Point 330 679)
     (Point 344 679)
    )
    (connect D11:1 D24:1
     (Point 384 310)
     (Point 400 310)
     (Point 400 389)
     (Point 260 389)
     (Point 260 669)
     (Point 210 669)
     (Point 210 699)
     (Point 222 699)
    )
    (connect D25:1 D24:2
     (Point 197 760)
     (Point 210 760)
     (Point 210 739)
     (Point 222 739)
    )
    (connect D27:1 D26:1
     (Point 865 260)
     (Point 880 260)
     (Point 880 290)
     (Point 870 290)
     (Point 870 410)
     (Point 881 410)
    )
    (connect D6:1 D26:2
     (Point 845 320)
     (Point 860 320)
     (Point 860 420)
     (Point 881 420)
    )
    (connect D13:1 D26:3
     (Point 795 400)
     (Point 810 400)
     (Point 810 430)
     (Point 881 430)
    )
    (connect D14:1 D26:4
     (Point 765 440)
     (Point 823 440)
     (Point 823 440)
     (Point 881 440)
    )
    (connect D5:1 D27:0
     (Point 815 230)
     (Point 840 230)
     (Point 840 245)
    )
    (connect D26:1 D28:1
     (Point 939 430)
     (Point 960 430)
     (Point 960 469)
     (Point 870 469)
     (Point 870 459)
     (Point 780 459)
     (Point 780 479)
     (Point 650 479)
     (Point 650 549)
     (Point 656 549)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
