#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name " Spring Natural Frequency Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Constant"
   (name "turns")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "turns")
     (datum 10)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 59 0)
    )
    (detail
     (origin 36 626)
     (extent 129 28)
    )
    (active detail)
   )
  )
  (component 1 "Constant"
   (name "length")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "length")
     (datum 12)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 68 0)
    )
    (detail
     (origin 36 696)
     (extent 128 29)
    )
    (active detail)
   )
  )
  (component 2 "Constant"
   (name "dwire")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "dwire")
     (datum 0.5)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 59 0)
    )
    (detail
     (origin 36 556)
     (extent 129 28)
    )
    (active detail)
   )
  )
  (component 3 "Constant"
   (name "Rigidity")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Rigidity")
     (datum 12000000)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 86 0)
    )
    (detail
     (origin 36 486)
     (extent 129 28)
    )
    (active detail)
   )
  )
  (component 4 "Toggle"
   (name "Info")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type control)
     (name "Reset")
     (lock name constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Info")
     (values range 0 1)
     (datum 0)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (origin 270 241)
     (extent 60 39)
     (format button)
    )
    (detail
     (origin 278 324)
     (extent 25 52)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "IfThenElse"
   (name "!= 0")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "a!=0")
   )
   (views
    (icon
     (origin 347 248)
     (extent 46 25)
    )
    (detail
     (origin 209 308)
     (extent 73 64)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "Constant"
   (name "Min Freq")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Min Freq")
     (datum 15)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 383 511)
     (extent 110 39)
    )
    (detail
     (origin 311 376)
     (extent 139 29)
    )
    (active detail)
   )
  )
  (component 7 "ForRange"
   (name "dcoil")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component from 12)
    (component thru 18)
    (component step 1)
   )
   (views
    (icon
     (extent 59 0)
    )
    (detail
     (origin 6 357)
     (extent 168 86)
    )
    (active detail)
   )
  )
  (component 8 "Start"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 56 121)
     (extent 69 39)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "ForRange"
   (name "Mass")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component from 2)
    (component thru 10)
    (component step 2)
   )
   (views
    (icon
     (extent 50 0)
    )
    (detail
     (origin 6 207)
     (extent 168 86)
    )
    (active detail)
   )
  )
  (component 10 "Formula"
   (name "Formula")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Mass")
     (optional yes)
    )
    (input 2
     (type data)
     (name "dcoil")
     (optional yes)
    )
    (input 3
     (type data)
     (name "Grigid")
     (optional yes)
    )
    (input 4
     (type data)
     (name "dwire")
     (optional yes)
    )
    (input 5
     (type data)
     (name "turns")
     (optional yes)
    )
    (input 6
     (type data)
     (name "Length")
     (optional yes)
    )
    (output 1
     (type data)
     (name " ")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "((Grigid*dwire^4)/(8*turns*dcoil^3)*(Mass+Length/3))")
   )
   (views
    (icon
     (origin 292 658)
     (extent 77 65)
    )
    (detail
     (origin 109 467)
     (extent 482 248)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "Note"
   (name "Overview of Example")
   (interface
   )
   (implementation
    (component text 5 5
      This is a Coil Spring Natural
        Frequency Example. 
      Click "Start" to see example
        calculation results.
      Click "Info" for more details.
    )
   )
   (views
    (icon
     (origin 287 491)
     (extent 154 39)
    )
    (detail
     (origin 185 120)
     (extent 290 101)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 12 "Context"
   (name "Overview of Coil Spring Example")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Confirm"
     (name "OK")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 559 591)
       (extent 62 39)
      )
      (detail
       (origin 146 233)
       (extent 79 34)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Note"
     (name "NotePad")
     (interface
     )
     (implementation
      (component text 31 7
       PURPOSE: Demonstrate the calculation of natural frequency for a coil spring using a
        model constructed in HP VEE, wherein a number of variable parameters are used.
       
       USER INPUT REQUIRED:  None.  Click on "Start" to run the model.   You may change any 
        values displayed on the panel.
       
       EXPLANATION: The natural frequency is displayed as a graph versus the spring diameter for
        each step in the range of mass associated with the spring system.  Each parameter may be
        individually changed, and the effect of the change may then be plotted.  However, the
        plots for some (extreme) values may not be very useful, unless both scales on the
        display are changed to logarithmic mode, in order to minimize the compression of plots
        which must cover extreme ranges.  This may be done by clicking the plot display's object
        menu button (upper left corner of object) using the left mouse button, or anywhere on the
        plot display using the right mouse button, and selecting "Traces & Scales...".  On the
        resulting pop-up panel click on each "Mapping:" button to change the mode from "Linear"
        to "Log".  You may also select the number of log cycles to display.  Another useful
        change to the display format may be accomplished using the object menu by selecting
        "Panel Menu -> Scales & Sliders".  This makes it easy to use "Auto Scale", or to specify
        the scale limits.
       
       The model was built using HP VEE's panel approach because of the better organized and
        simplified appearance this makes possible.  To review the specific objects used to build
        the model, click on the "Detail" button located on the left of the title bar.  Some of 
        the objects accessible in this mode have been iconized.  Double clicking on an icon will
        activate its open view.  Selecting "Help" or "Show Description" from an object menu may
        also provide additional useful information.
       
       The program uses several features of HP VEE, including data input objects, "Display on
        Execute" panel, "X vs Y Plot" display and a "Formula" object.
       
       To exit this information panel, click "OK" below.
      )
     )
     (views
      (icon
       (origin 391 398)
       (extent 78 25)
      )
      (detail
       (origin 165 316)
       (extent 851 489)
       (editing disabled)
      )
      (active detail)
     )
    )
    (configuration
    )
    (ShowOnExecPanel
     (origin 31 78)
     (extent 881 594)
     (panel
      (origin 2 112)
      (extent 877 556)
      (widget 0 icon
       (title off)
       (origin 399 625)
       (extent 57 37)
      )
      (widget 1 detail
       (title off)
       (origin 14 124)
       (extent 850 493)
       (editing disabled)
      )
     )
    )
   )
   (views
    (icon
     (origin 410 268)
     (extent 40 24)
     (label off)
    )
    (detail
     (origin 160 252)
     (extent 520 254)
     (configuration
     )
    )
    (active icon)
   )
  )
  (component 13 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
      This example is provided as an
      illustration "as is", and Hewlett-Packard
      Company makes no warranty of any kind
      with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 537 619)
     (extent 387 102)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 14 "Note"
   (name "Mass 10")
   (interface
   )
   (implementation
    (component text 2 5
     Variation between
     graphs lines is mass
    )
   )
   (views
    (icon
     (origin 801 278)
     (extent 78 25)
    )
    (detail
     (origin 742 257)
     (extent 197 46)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 15 "Note"
   (name "Mass 2")
   (interface
   )
   (implementation
    (component text 2 5
     Variation between
     graphs lines is mass
    )
   )
   (views
    (icon
     (origin 631 398)
     (extent 78 25)
    )
    (detail
     (origin 572 377)
     (extent 197 46)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 16 "XYPlot"
   (name "Natural Frequency")
   (interface
    (sequence out)
    (input 1
     (type data)
     (name "XData")
     (lock name)
    )
    (input 2
     (type data)
     (name "YData1")
     (lock name)
    )
    (input 3
     (type data)
     (name "MinFreq")
     (lock constraints)
     (optional yes)
    )
    (input 4
     (type control)
     (name "Next Curve")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 2)
    (component tracePin 3)
    (component graphMode rectangular)
   )
   (views
    (description 2 5
     This is a "Display, X vs Y Plot" object
     
    )
    (icon
     (origin 659 308)
     (extent 163 45)
    )
    (detail
     (origin 504 131)
     (extent 472 418)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Freq")
      (domainName "Coil Diam")
      (color 0x909090)
      (show 1)
      (range 0 80 3 linear)
     )
     (domain 12 18 3 linear)
     (trace 0 onScale 0
      (name "YData1")
      (color 0xffdd00)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "MinFreq")
      (color 0xccff)
      (lineType 5)
      (pointType 0)
     )
    )
    (active detail)
   )
  )
  (component 17 "Note"
   (name "Note Pad")
   (interface
   )
   (implementation
    (component text 9 5
      A "Note Pad" object may be effectively
      used as a reminder of some of the
      model details and reasons for such
      things as why a minimum frequency is
      necessary.  For example:
      
      "See which diameter spring is the
      lowest cost between 12 and 15 ( >15
      gives too low a natural frequency)."
    )
   )
   (views
    (icon
     (origin 337 551)
     (extent 106 39)
    )
    (detail
     (origin 180 469)
     (extent 381 182)
     (editing disabled)
    )
    (active icon)
   )
  )
  (configuration
   (connect D5:0 D4:1)
   (connect D4:1 D5:1)
   (connect D9:1 D7:0)
   (connect D8:0 D9:0)
   (connect D9:1 D10:1)
   (connect D7:1 D10:2)
   (connect D3:1 D10:3)
   (connect D2:1 D10:4)
   (connect D0:1 D10:5)
   (connect D1:1 D10:6)
   (connect D5:1 D12:0)
   (connect D7:1 D16:1)
   (connect D10:1 D16:2)
   (connect D6:1 D16:3)
   (connect D9:1 D16:4)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 912 645)
   (widget 9 detail
    (title on)
    (origin 20 277)
    (extent 168 86)
   )
   (widget 3 detail
    (title on)
    (origin 202 278)
    (extent 129 28)
   )
   (widget 2 detail
    (title on)
    (origin 204 364)
    (extent 129 28)
   )
   (widget 0 detail
    (title on)
    (origin 204 452)
    (extent 129 28)
   )
   (widget 1 detail
    (title on)
    (origin 204 534)
    (extent 130 28)
   )
   (widget 7 detail
    (title on)
    (origin 19 477)
    (extent 168 86)
   )
   (widget 4 icon
    (title off)
    (origin 72 91)
    (extent 66 40)
    (format button)
   )
   (widget 8 icon
    (title off)
    (origin 73 158)
    (extent 69 39)
   )
   (widget 16 detail
    (title on)
    (origin 353 225)
    (extent 551 482)
    (displayMode annotGraph)
    (graphType cartesian)
    (gridType grid)
    (scale 0
     (name "Freq")
     (domainName "Coil Diam")
     (color 0x909090)
     (show 1)
     (range 0 80 3 linear)
    )
    (domain 12 18 3 linear)
    (trace 0 onScale 0
     (name "YData1")
     (color 0xffdd00)
     (lineType 1)
     (pointType 0)
    )
    (trace 1 onScale 0
     (name "MinFreq")
     (color 0xccff)
     (lineType 5)
     (pointType 0)
    )
   )
   (widget 14 icon
    (title off)
    (origin 698 424)
    (extent 78 25)
   )
   (widget 15 icon
    (title off)
    (origin 502 537)
    (extent 71 25)
   )
   (widget 13 detail
    (title on)
    (origin 518 108)
    (extent 386 80)
    (editing disabled)
   )
   (widget 11 detail
    (title off)
    (origin 206 72)
    (extent 305 113)
    (editing disabled)
   )
  )
  (detail
   (origin 0 67)
   (extent 973 646)
   (configuration
    (connect D5:0 D4:1
     (Point 370 275)
     (Point 370 300)
     (Point 250 300)
     (Point 250 260)
     (Point 267 260)
    )
    (connect D4:1 D5:1
     (Point 332 260)
     (Point 344 260)
    )
    (connect D9:1 D7:0
     (Point 176 250)
     (Point 200 250)
     (Point 200 310)
     (Point 90 310)
     (Point 90 324)
    )
    (connect D8:0 D9:0
     (Point 90 162)
     (Point 90 174)
    )
    (connect D9:1 D10:1
     (Point 176 250)
     (Point 200 250)
     (Point 200 310)
     (Point 230 310)
     (Point 230 490)
     (Point 260 490)
     (Point 260 660)
     (Point 289 660)
    )
    (connect D7:1 D10:2
     (Point 176 400)
     (Point 220 400)
     (Point 220 670)
     (Point 289 670)
    )
    (connect D3:1 D10:3
     (Point 167 500)
     (Point 210 500)
     (Point 210 680)
     (Point 289 680)
    )
    (connect D2:1 D10:4
     (Point 167 570)
     (Point 200 570)
     (Point 200 690)
     (Point 289 690)
    )
    (connect D0:1 D10:5
     (Point 167 640)
     (Point 190 640)
     (Point 190 700)
     (Point 289 700)
    )
    (connect D1:1 D10:6
     (Point 166 710)
     (Point 227 710)
     (Point 227 710)
     (Point 289 710)
    )
    (connect D5:1 D12:0
     (Point 395 250)
     (Point 430 250)
     (Point 430 265)
    )
    (connect D7:1 D16:1
     (Point 176 400)
     (Point 220 400)
     (Point 220 320)
     (Point 480 320)
     (Point 480 190)
     (Point 501 190)
    )
    (connect D10:1 D16:2
     (Point 371 690)
     (Point 470 690)
     (Point 470 330)
     (Point 490 330)
     (Point 490 290)
     (Point 501 290)
    )
    (connect D6:1 D16:3
     (Point 452 390)
     (Point 476 390)
     (Point 476 390)
     (Point 501 390)
    )
    (connect D9:1 D16:4
     (Point 176 250)
     (Point 200 250)
     (Point 200 310)
     (Point 230 310)
     (Point 230 490)
     (Point 501 490)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
