#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name "Beam Deflection Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Start"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 56 211)
     (extent 69 39)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 1 "Toggle"
   (name "Info")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type control)
     (name "Reset")
     (lock name constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Info")
     (values range 0 1)
     (datum 0)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (origin 30 121)
     (extent 60 39)
     (format button)
    )
    (detail
     (origin 230 334)
     (extent 20 52)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "YPlot"
   (name "Beam Deflection (inches)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Uniform")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "Sum")
     (lock constraints)
     (optional yes)
    )
    (input 3
     (type data)
     (name "Difference")
     (lock constraints)
     (optional yes)
    )
    (input 4
     (type data)
     (name "Ramp")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 1)
    (component tracePin 2)
    (component tracePin 3)
    (component tracePin 4)
    (component graphMode rectangular)
   )
   (views
    (description 2 5
      This is a "Display -> XY Trace" object.
     
    )
    (icon
     (origin 905 338)
     (extent 226 64)
     (iconImage display.icon)
    )
    (detail
     (origin 713 186)
     (extent 515 528)
     (displayMode scrollGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Deflection")
      (domainName "Distance from Support (inches)")
      (color 0x909090)
      (show 1)
      (range 0 1 3 linear)
     )
     (domain 0 180 3 linear)
     (trace 0 onScale 0
      (name "Uniform")
      (color 0xffdd00)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "Sum")
      (color 0xff0000)
      (lineType 1)
      (pointType 0)
     )
     (trace 2 onScale 0
      (name "Difference")
      (color 0xccff)
      (lineType 1)
      (pointType 0)
     )
     (trace 3 onScale 0
      (name "Ramp")
      (color 0xee44)
      (lineType 1)
      (pointType 0)
     )
     (marker 0 onTrace 0)
     (marker 1 onTrace 1)
    )
    (active detail)
   )
  )
  (component 3 "Constant"
   (name "Elastic Modulus ")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Elastic Modulus ")
     (datum 28000000)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 95 158)
     (extent 154 25)
    )
    (detail
     (origin 7 385)
     (extent 187 30)
    )
    (active detail)
   )
  )
  (component 4 "Constant"
   (name "Length, ft.")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Length, ft.")
     (datum 14)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 35 308)
     (extent 110 25)
    )
    (detail
     (origin 8 304)
     (extent 165 33)
    )
    (active detail)
   )
  )
  (component 5 "Constant"
   (name "Load lb/ft")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Load lb/ft")
     (datum 20)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (description 8 5
     This is a "Data -> Constant -> Real" object.
     It is used to enter the uniform load in pounds per
     foot acting on the beam, as well as the maximum 
     value for the ramp load.  The initial load of 20
     lb./ft. represents a value consistent with a full
     flow of water in a 6 inch pipe.
     
     
    )
    (icon
     (origin 95 158)
     (extent 110 25)
    )
    (detail
     (origin 13 465)
     (extent 174 31)
    )
    (active detail)
   )
  )
  (component 6 "Constant"
   (name "Beam Dia, in.")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Beam Dia, in.")
     (datum 6)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 95 158)
     (extent 127 25)
    )
    (detail
     (origin 8 543)
     (extent 184 34)
    )
    (active detail)
   )
  )
  (component 7 "Constant"
   (name "Wall Thickness")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Wall Thickness")
     (datum 0.1)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 95 158)
     (extent 127 25)
    )
    (detail
     (origin 9 624)
     (extent 183 33)
    )
    (active detail)
   )
  )
  (component 8 "Formula"
   (name " + ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X+Y")
   )
   (views
    (icon
     (origin 627 398)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "Formula"
   (name " - ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X-Y")
   )
   (views
    (icon
     (origin 637 498)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 10 "Formula"
   (name "Deflection")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "xbeam")
     (optional yes)
    )
    (input 2
     (type data)
     (name "E")
     (optional yes)
    )
    (input 3
     (type data)
     (name "I")
     (optional yes)
    )
    (input 4
     (type data)
     (name "L")
     (optional yes)
    )
    (input 5
     (type data)
     (name "Load")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "load*xbeam^2/(24*E*I)*(xbeam^2+6*L^2-4*L*xbeam)")
   )
   (views
    (icon
     (origin 375 348)
     (extent 110 64)
     (iconImage formula.icon)
    )
    (detail
     (origin 192 254)
     (extent 457 254)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "Formula"
   (name "Deflection")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "xbeam")
     (optional yes)
    )
    (input 2
     (type data)
     (name "E")
     (optional yes)
    )
    (input 3
     (type data)
     (name "I")
     (optional yes)
    )
    (input 4
     (type data)
     (name "L")
     (optional yes)
    )
    (input 5
     (type data)
     (name "Load")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "load*xbeam^2/(120*L*E*I)*(10*L^3-10*L^2*xbeam+5*L*xbeam^2-xbeam^3)")
   )
   (views
    (icon
     (origin 375 448)
     (extent 110 64)
     (iconImage formula.icon)
    )
    (detail
     (origin 93 354)
     (extent 655 254)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 12 "Formula"
   (name "load/12")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "a/12")
   )
   (views
    (icon
     (origin 201 468)
     (extent 78 25)
    )
    (detail
     (origin 181 454)
     (extent 79 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "Formula"
   (name "Mmnt of Inertia")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "dia")
     (optional yes)
    )
    (input 2
     (type data)
     (name "thk")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "pi/64*(dia^4-(dia-2*thk)^4)")
   )
   (views
    (icon
     (origin 218 548)
     (extent 145 64)
     (iconImage formula.icon)
    )
    (detail
     (origin 136 542)
     (extent 269 79)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 14 "ToCoordinate"
   (name "Build Coord")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X Data")
     (tag "X")
     (requires
      (datatype Real)
     )
     (lock constraints)
    )
    (input 2
     (type data)
     (name "Y Data")
     (tag "Y")
     (requires
      (datatype Real)
     )
     (lock constraints)
    )
    (output 1
     (type data)
     (name "Coord")
     (tag "Coord")
     (lock constraints)
    )
   )
   (implementation
   )
   (views
    (description 11 5
     This "Data -> Build Data -> Coord" object is used
     to build a collection of coordinate data points
     from the arrays provided by the ramp and formula
     objects connected.  The "X values" are equivalent
     to lengths along the beam, and each equivalent
     "Y value" is the deflection at the corresponding
     position along the beam.
     
     The icon image was generated specifically to
     provide a graphic representation of the beam and
     its load, which is a "ramp" load in this case.
    )
    (icon
     (origin 531 601)
     (extent 158 79)
     (label off)
     (iconImage /usr/lib/veetest/examples/applications/rampload.icon)
    )
    (detail
     (origin 570 589)
     (extent 60 104)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 15 "Constant"
   (name "Nx")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Nx")
     (datum 168)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 147 198)
     (extent 46 25)
    )
    (detail
     (origin 109 194)
     (extent 102 35)
    )
    (active icon)
   )
  )
  (component 16 "Constant"
   (name "BL:0")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "BL:0")
     (datum 0)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 147 238)
     (extent 46 25)
    )
    (detail
     (origin 96 234)
     (extent 129 35)
    )
    (active icon)
   )
  )
  (component 17 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 5 5
      This example is provided as 
      an illustration "as is", and
      Hewlett-Packard Company makes
      no warranty of any kind with
      regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 244 121)
     (extent 293 98)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 18 "TextDisplay"
   (name "Mmnt of Inertia")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 116 0)
    )
    (detail
     (origin 249 682)
     (extent 242 36)
     (formatter
      (realFormat engineering)
      (realSigDigits 16)
      (realRadixSpec 5)
      (integerBase decimal)
     )
    )
    (active detail)
   )
  )
  (component 19 "IfThenElse"
   (name "!= 0")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "a!=0")
   )
   (views
    (icon
     (origin 117 128)
     (extent 46 25)
    )
    (detail
     (origin 79 129)
     (extent 73 64)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 20 "Formula"
   (name "ramp(numElem,from,thru)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "numElem")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "from")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock name constraints)
    )
    (input 3
     (type data)
     (name "thru")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "ramp(numElem,from,thru)")
   )
   (views
    (description 4 5
     This "ramp(numElem,from,thru)" object is used to 
     easily generate a series of uniformly spaced 
     "X values" used to represent the beam length in 
     the beam deflection calculations.
    )
    (icon
     (origin 252 233)
     (extent 217 34)
    )
    (detail
     (origin 232 170)
     (extent 266 160)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 21 "ToCoordinate"
   (name "Build Coord")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X Data")
     (tag "X")
     (requires
      (datatype Real)
     )
     (lock constraints)
    )
    (input 2
     (type data)
     (name "Y Data")
     (tag "Y")
     (requires
      (datatype Real)
     )
     (lock constraints)
    )
    (output 1
     (type data)
     (name "Coord")
     (tag "Coord")
     (lock constraints)
    )
   )
   (implementation
   )
   (views
    (description 11 5
     This "Data -> Build Data -> Coord" object is used
     to build a collection of coordinate data points
     from the arrays provided by the ramp and formula
     objects connected.  The "X values" are equivalent
     to lengths along the beam, and each equivalent
     "Y value" is the deflection at the corresponding
     position along the beam.
     
     The icon image was generated specifically to
     provide a graphic representation of the beam and
     its load, which in this case is a "uniform" load.
    )
    (icon
     (origin 511 231)
     (extent 158 79)
     (label off)
     (iconImage /usr/lib/veetest/examples/applications/uni4mload.icon)
    )
    (detail
     (origin 565 218)
     (extent 60 104)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 22 "Formula"
   (name "L*12")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "a*12")
   )
   (views
    (icon
     (origin 197 308)
     (extent 46 25)
    )
    (detail
     (origin 207 193)
     (extent 79 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 23 "Context"
   (name "Details of Beam Deflection Example")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Start"
     (name "Start")
     (interface
      (sequence out)
     )
     (implementation
     )
     (views
      (icon
       (origin 656 201)
       (extent 69 39)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Confirm"
     (name " OK ")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 661 262)
       (extent 58 37)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Note"
     (name "Note Pad")
     (interface
     )
     (implementation
      (component text 30 7
       PURPOSE: Demonstrate the use of HP VEE in a cantilever beam deflection problem.
        This model uses an "XY Trace" display to show the deflection of a beam under 
        uniform, ramp, and combined load situations. 
       
       USER DATA REQUIRED: You may change any of the displayed values; click on the
        value and type over it to enter a new value.  Note the use of "M" for E6 (10^6)
        and "m" for E-3 (10^-3), which you can use instead of typing zeros.  You may 
        also use other abbreviations, such as "K" for E3 (10^3).
       
       EXPLANATION: The example values are consistent with a 6" dia. pipe (cantilever
        supported at one end) loaded with a full flow of water (uniform load), and an
        additional ramp force acting either as a load or a support.  HP VEE allows
        the results of an equation (in array form) to be handled with the ease of a
        simple number.  As may be seen on the display, the two basic deflection
        equation results can be both summed and differenced.  By positioning a
        triangular marker (click spot on graph), precise values may be read at the 
        bottom of the graph's display.  Click on a colored line button to change
        the color of a line to which a marker is attached.
       
        The model is built using the panel approach, which simplifies data entry
        and viewing.  Click on the "Detail" button (left on the title bar) to see the
        individual objects which make up the model.  Since several objects have been
        iconized, double click on any of these to change to the open view.
       
        Additional information for some of the objects may be provided with the object
        menu "Show Description" feature.  From the object menu, "Help" may also be 
        directly accessed for the object.
       
        Click "OK" to exit this information panel.
       
      )
     )
     (views
      (description 2 7
       This is a "Display, Note Pad" object
       
      )
      (icon
       (extent 110 0)
      )
      (detail
       (origin 68 195)
       (extent 585 410)
       (editing disabled)
      )
      (active detail)
     )
    )
    (configuration
     (connect D0:0 D1:0)
    )
    (ShowOnExecPanel
     (origin 132 101)
     (extent 818 589)
     (panel
      (origin 3 115)
      (extent 814 551)
      (widget 2 detail
       (title off)
       (origin 22 138)
       (extent 773 462)
       (editing disabled)
      )
      (widget 1 icon
       (title off)
       (origin 348 612)
       (extent 58 37)
      )
     )
    )
   )
   (views
    (description 2 5
     This is a "Device, UserObject" object
     
    )
    (icon
     (origin 180 158)
     (extent 40 24)
     (label off)
    )
    (detail
     (origin 43 149)
     (extent 715 462)
     (configuration
      (connect D0:0 D1:0
       (Point 690 242)
       (Point 690 259)
      )
     )
    )
    (active icon)
   )
  )
  (component 24 "Note"
   (name "Overview of Beam Example")
   (interface
   )
   (implementation
    (component text 5 5
     PURPOSE: A graphic display of cantilevered beam 
     deflection under uniform, ramp, and combined loads.
     
     USER DATA REQUIRED:  None.  Click "Start" or "Run" to
     view example results. Click "Info" for more details.
    )
   )
   (views
    (icon
     (origin 617 108)
     (extent 226 25)
    )
    (detail
     (origin 428 99)
     (extent 524 103)
     (editing disabled)
    )
    (active icon)
   )
  )
  (configuration
   (connect D19:0 D1:1)
   (connect D21:1 D2:1)
   (connect D8:1 D2:2)
   (connect D9:1 D2:3)
   (connect D14:1 D2:4)
   (connect D0:0 D4:0)
   (connect D21:1 D8:1)
   (connect D14:1 D8:2)
   (connect D21:1 D9:1)
   (connect D14:1 D9:2)
   (connect D20:1 D10:1)
   (connect D3:1 D10:2)
   (connect D13:1 D10:3)
   (connect D22:1 D10:4)
   (connect D12:1 D10:5)
   (connect D20:1 D11:1)
   (connect D3:1 D11:2)
   (connect D13:1 D11:3)
   (connect D22:1 D11:4)
   (connect D12:1 D11:5)
   (connect D5:1 D12:1)
   (connect D6:1 D13:1)
   (connect D7:1 D13:2)
   (connect D20:1 D14:1)
   (connect D11:1 D14:2)
   (connect D13:1 D18:1)
   (connect D1:1 D19:1)
   (connect D15:1 D20:1)
   (connect D16:1 D20:2)
   (connect D22:1 D20:3)
   (connect D20:1 D21:1)
   (connect D10:1 D21:2)
   (connect D4:1 D22:1)
   (connect D19:1 D23:0)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 1000 644)
   (widget 0 icon
    (title off)
    (origin 42 153)
    (extent 69 39)
   )
   (widget 3 detail
    (title on)
    (origin 5 679)
    (extent 182 28)
   )
   (widget 4 detail
    (title on)
    (origin 5 485)
    (extent 184 29)
   )
   (widget 5 detail
    (title on)
    (origin 5 582)
    (extent 183 28)
   )
   (widget 1 icon
    (title off)
    (origin 42 94)
    (extent 69 40)
    (format button)
   )
   (widget 18 detail
    (title on)
    (origin 8 403)
    (extent 182 32)
    (formatter
     (realFormat engineering)
     (realSigDigits 16)
     (realRadixSpec 5)
     (integerBase decimal)
    )
   )
   (widget 7 detail
    (title on)
    (origin 7 324)
    (extent 182 28)
   )
   (widget 6 detail
    (title on)
    (origin 5 252)
    (extent 182 28)
   )
   (widget 2 detail
    (title on)
    (origin 271 245)
    (extent 692 462)
    (displayMode annotGraph)
    (graphType cartesian)
    (gridType grid)
    (scale 0
     (name "Deflection")
     (domainName "Distance from Support, inches")
     (color 0x909090)
     (show 1)
     (range 0 1 3 linear)
    )
    (scale 1
     (name "Defl. in.")
     (domainName "Distance from Support, inches")
     (color 0xffffff)
     (show 0)
     (range 0 1 3 linear)
    )
    (domain 0 170 3 linear)
    (trace 0 onScale 0
     (name "Uniform")
     (color 0xffdd00)
     (lineType 1)
     (pointType 0)
    )
    (trace 1 onScale 0
     (name "Sum")
     (color 0xff0000)
     (lineType 1)
     (pointType 0)
    )
    (trace 2 onScale 0
     (name "Difference")
     (color 0xccff)
     (lineType 1)
     (pointType 0)
    )
    (trace 3 onScale 0
     (name "Ramp")
     (color 0xee44)
     (lineType 1)
     (pointType 0)
    )
    (marker 0 onTrace 0)
    (marker 1 onTrace 1)
   )
   (widget 21 icon
    (title off)
    (origin 400 287)
    (extent 158 79)
    (label off)
    (iconImage /usr/lib/veetest/examples/applications/uni4mload.icon)
   )
   (widget 14 icon
    (title off)
    (origin 401 460)
    (extent 158 79)
    (label off)
    (iconImage /usr/lib/veetest/examples/applications/rampload.icon)
   )
   (widget 17 detail
    (title on)
    (origin 680 108)
    (extent 299 100)
    (editing disabled)
   )
   (widget 24 detail
    (title on)
    (origin 131 107)
    (extent 512 99)
    (editing disabled)
   )
  )
  (detail
   (origin 0 67)
   (extent 980 639)
   (configuration
    (connect D19:0 D1:1
     (Point 140 155)
     (Point 140 180)
     (Point 10 180)
     (Point 10 140)
     (Point 27 140)
    )
    (connect D21:1 D2:1
     (Point 671 270)
     (Point 690 270)
     (Point 690 250)
     (Point 710 250)
    )
    (connect D8:1 D2:2
     (Point 675 410)
     (Point 690 410)
     (Point 690 380)
     (Point 710 380)
    )
    (connect D9:1 D2:3
     (Point 685 510)
     (Point 710 510)
    )
    (connect D14:1 D2:4
     (Point 691 640)
     (Point 700 640)
     (Point 700 640)
     (Point 710 640)
    )
    (connect D0:0 D4:0
     (Point 90 252)
     (Point 90 271)
    )
    (connect D21:1 D8:1
     (Point 671 270)
     (Point 690 270)
     (Point 690 330)
     (Point 610 330)
     (Point 610 400)
     (Point 624 400)
    )
    (connect D14:1 D8:2
     (Point 691 640)
     (Point 700 640)
     (Point 700 580)
     (Point 620 580)
     (Point 620 520)
     (Point 610 520)
     (Point 610 420)
     (Point 624 420)
    )
    (connect D21:1 D9:1
     (Point 671 270)
     (Point 690 270)
     (Point 690 330)
     (Point 610 330)
     (Point 610 400)
     (Point 600 400)
     (Point 600 500)
     (Point 634 500)
    )
    (connect D14:1 D9:2
     (Point 691 640)
     (Point 700 640)
     (Point 700 580)
     (Point 620 580)
     (Point 620 520)
     (Point 634 520)
    )
    (connect D20:1 D10:1
     (Point 471 250)
     (Point 490 250)
     (Point 490 280)
     (Point 480 280)
     (Point 480 290)
     (Point 360 290)
     (Point 360 360)
     (Point 372 360)
    )
    (connect D3:1 D10:2
     (Point 196 400)
     (Point 220 400)
     (Point 220 370)
     (Point 372 370)
    )
    (connect D13:1 D10:3
     (Point 365 580)
     (Point 380 580)
     (Point 380 530)
     (Point 360 530)
     (Point 360 380)
     (Point 372 380)
    )
    (connect D22:1 D10:4
     (Point 245 320)
     (Point 270 320)
     (Point 270 390)
     (Point 372 390)
    )
    (connect D12:1 D10:5
     (Point 281 480)
     (Point 310 480)
     (Point 310 400)
     (Point 372 400)
    )
    (connect D20:1 D11:1
     (Point 471 250)
     (Point 490 250)
     (Point 490 280)
     (Point 480 280)
     (Point 480 320)
     (Point 510 320)
     (Point 510 430)
     (Point 350 430)
     (Point 350 460)
     (Point 372 460)
    )
    (connect D3:1 D11:2
     (Point 196 400)
     (Point 300 400)
     (Point 300 470)
     (Point 372 470)
    )
    (connect D13:1 D11:3
     (Point 365 580)
     (Point 380 580)
     (Point 380 530)
     (Point 360 530)
     (Point 360 480)
     (Point 372 480)
    )
    (connect D22:1 D11:4
     (Point 245 320)
     (Point 270 320)
     (Point 270 390)
     (Point 340 390)
     (Point 340 490)
     (Point 372 490)
    )
    (connect D12:1 D11:5
     (Point 281 480)
     (Point 300 480)
     (Point 300 500)
     (Point 372 500)
    )
    (connect D5:1 D12:1
     (Point 189 480)
     (Point 193 480)
     (Point 193 480)
     (Point 198 480)
    )
    (connect D6:1 D13:1
     (Point 194 560)
     (Point 204 560)
     (Point 204 560)
     (Point 215 560)
    )
    (connect D7:1 D13:2
     (Point 194 640)
     (Point 210 640)
     (Point 210 600)
     (Point 215 600)
    )
    (connect D20:1 D14:1
     (Point 471 250)
     (Point 490 250)
     (Point 490 280)
     (Point 480 280)
     (Point 480 320)
     (Point 510 320)
     (Point 510 430)
     (Point 520 430)
     (Point 520 620)
     (Point 528 620)
    )
    (connect D11:1 D14:2
     (Point 487 480)
     (Point 510 480)
     (Point 510 660)
     (Point 528 660)
    )
    (connect D13:1 D18:1
     (Point 365 580)
     (Point 380 580)
     (Point 380 630)
     (Point 230 630)
     (Point 230 700)
     (Point 246 700)
    )
    (connect D1:1 D19:1
     (Point 92 140)
     (Point 114 140)
    )
    (connect D15:1 D20:1
     (Point 195 210)
     (Point 210 210)
     (Point 210 240)
     (Point 249 240)
    )
    (connect D16:1 D20:2
     (Point 195 250)
     (Point 222 250)
     (Point 222 250)
     (Point 249 250)
    )
    (connect D22:1 D20:3
     (Point 245 320)
     (Point 260 320)
     (Point 260 290)
     (Point 230 290)
     (Point 230 260)
     (Point 249 260)
    )
    (connect D20:1 D21:1
     (Point 471 250)
     (Point 489 250)
     (Point 489 250)
     (Point 508 250)
    )
    (connect D10:1 D21:2
     (Point 487 380)
     (Point 500 380)
     (Point 500 330)
     (Point 490 330)
     (Point 490 290)
     (Point 508 290)
    )
    (connect D4:1 D22:1
     (Point 175 320)
     (Point 194 320)
    )
    (connect D19:1 D23:0
     (Point 165 130)
     (Point 200 130)
     (Point 200 155)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
