#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name "Analog Filter Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "XYPlot"
   (name "Magnitude vs. Frequency")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "XData")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "low pass")
     (lock constraints)
    )
    (input 3
     (type data)
     (name "band pass")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 2)
    (component tracePin 3)
    (component graphMode rectangular)
   )
   (views
    (icon
     (extent 217 0)
     (iconImage display.icon)
    )
    (detail
     (origin 570 122)
     (extent 360 296)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Magnitude")
      (domainName "Frequency")
      (color 0x909090)
      (show 1)
      (range 0.0001 1 4 log)
     )
     (domain 2 20000 4 log)
     (trace 0 onScale 0
      (name "low pass")
      (color 0xffdd00)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "band pass")
      (color 0xccff)
      (lineType 1)
      (pointType 0)
     )
    )
    (active detail)
   )
  )
  (component 1 "XYPlot"
   (name "Phase vs. Frequency")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "XData")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "low pass")
     (lock constraints)
    )
    (input 3
     (type data)
     (name "band pass")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 2)
    (component tracePin 3)
    (component graphMode rectangular)
   )
   (views
    (icon
     (extent 181 0)
     (iconImage display.icon)
    )
    (detail
     (origin 570 462)
     (extent 360 296)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Phase")
      (domainName "Frequency")
      (color 0x909090)
      (show 1)
      (range -180 0 4 linear)
     )
     (domain 2 20000 4 log)
     (trace 0 onScale 0
      (name "low pass")
      (color 0xffdd00)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "band pass")
      (color 0xccff)
      (lineType 1)
      (pointType 0)
     )
    )
    (active detail)
   )
  )
  (component 2 "Formula"
   (name "band pass")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "f")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Q")
     (optional yes)
    )
    (input 3
     (type data)
     (name "fo")
     (optional yes)
    )
    (output 1
     (type data)
     (name " ")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "f*(fo/Q)/((f^2-fo^2)+j(f*fo/Q))")
   )
   (views
    (description 14 5
     The LaPlace transform for a two pole bandpass
     filter is:
                     2
                    s  fo/Q
       H(s) = ------------------------
                 2              2
                s  - s fo/Q - fo
     
     where "fo" is the frequency of maximum response 
     and "Q" is the selectivity of the filter.
     
     To display the spectrum, we substituted "jf" for
     "s".
     
    )
    (icon
     (origin 333 693)
     (extent 95 34)
    )
    (detail
     (origin 275 567)
     (extent 340 126)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "Formula"
   (name "phase(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "phase(x)")
   )
   (views
    (icon
     (origin 457 696)
     (extent 86 29)
    )
    (detail
     (origin 492 600)
     (extent 116 60)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "Formula"
   (name "mag(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "mag(x)")
   )
   (views
    (icon
     (origin 476 256)
     (extent 68 29)
    )
    (detail
     (origin 512 160)
     (extent 96 60)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "Formula"
   (name "mag(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "mag(x)")
   )
   (views
    (icon
     (origin 476 356)
     (extent 68 29)
    )
    (detail
     (origin 512 260)
     (extent 96 60)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 5 5
     This example is provided as an
     illustration "as is", and 
     Hewlett-Packard Company makes 
     no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 15 261)
     (extent 291 99)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 7 "Start"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 186 391)
     (extent 69 39)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "Formula"
   (name "ramp")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name " ")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "ramp(1000,0,20000)")
   )
   (views
    (description 13 5
     The "ramp(numElem,from,thru)" function generates
     a 1D array whose size is "numElem" long.  The 
     values in the array are evenly spaced starting 
     at the "from" value and ending with the "thru"
     value.
     
     A "For Range" object could have been used to 
     generate the same numbers one at a time.  In HP 
     VEE, however, arrays are processed almost as fast
     as scalars by "Formula" objects and displays.  
     Thus, more efficient models use array builders 
     rather than iterators wherever possible.
     
    )
    (icon
     (origin 197 476)
     (extent 46 29)
    )
    (detail
     (origin 169 568)
     (extent 223 45)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "Constant"
   (name "pole")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "pole")
     (datum 500)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 50 0)
    )
    (detail
     (origin 11 535)
     (extent 98 30)
    )
    (active detail)
   )
  )
  (component 10 "Formula"
   (name "low pass")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "f")
     (optional yes)
    )
    (input 2
     (type data)
     (name "a")
     (optional yes)
    )
    (output 1
     (type data)
     (name " ")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "a/(a+j(f))")
   )
   (views
    (description 13 5
     This is the formula for the transfer function of
     a one pole low pass filter.  The LaPlace transform
     would be:
                a
       H(s)= --------
              a + s
     
     where "a" is the location of the pole.  To 
     generate a spectrum, we substituted " jf" for 
     "s".
     
     
       
    )
    (icon
     (origin 307 536)
     (extent 86 29)
    )
    (detail
     (origin 360 487)
     (extent 151 86)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "Formula"
   (name "phase(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "phase(x)")
   )
   (views
    (icon
     (origin 447 536)
     (extent 86 29)
    )
    (detail
     (origin 492 500)
     (extent 116 60)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 12 "Constant"
   (name "Q")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Q")
     (datum 5)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 207 598)
     (extent 46 25)
    )
    (detail
     (origin 28 613)
     (extent 85 34)
    )
    (active detail)
   )
  )
  (component 13 "Constant"
   (name "fo")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "fo")
     (datum 500)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 32 0)
    )
    (detail
     (origin 26 693)
     (extent 89 35)
    )
    (active detail)
   )
  )
  (component 14 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 325 310)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 161 303)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About...")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 370 519)
         (extent 58 37)
        )
        (detail
         (origin 466 633)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "Overview of Analog Filter Example")
       (interface
       )
       (implementation
        (component text 34 9
         PURPOSE: This example shows how to:
         1. Display the transfer function of a filter.
         2. Use array math rather than iterators.
         
         USER INPUT REQUIRED:  None. Simply click on "Start".
         
         EXPLANATION: The magnitude and phase response of two filters, a one pole 
         low pass and a two pole band pass, are calculated  and displayed.
         
         The "Formula" object titled "ramp" generates a 1D array containing 1000
         numbers equally spaced from 0 to 20,000.  The range and number of points
         can be edited to any frequency range of interest.  Look at its "Show 
         Description" for more information.
         
         The "Formula" objects titled "low pass" and "band pass" apply a function
         to each element in the input array.  The result is an array of complex
         numbers, one for each  frequency.  Their "Show Descriptions"  explain
         their operation in more detail.
         
         The "mag(x)" object calculates the magnitude of each complex number in
         the array.  The result is also an array.  The "phase(x)" object calculates
         the phase of each complex number in the array.  The units of the phase
         result is determined by the "Trig Mode" preference set under "Preferences"
         in the "File" menu.
         
         The magnitude and phase are displayed in "XY Trace" displays.  The X input
         in each case is the array of frequencies.  The Y inputs come from the
         respective "mag(x) " and  "phase(x)" objects.
         
         This example allows you to change characteristics of the filter by
         entering numbers in a "Constant" object.  These could also be sliders.
         
         You can analyze other transfer characteristics by changing the "Formula"
         objects. 
        )
       )
       (views
        (icon
         (origin 537 558)
         (extent 307 25)
        )
        (detail
         (origin 208 334)
         (extent 384 252)
         (editing disabled)
        )
        (active detail)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 86 135)
       (extent 725 519)
       (panel
        (origin 30 160)
        (extent 721 481)
        (widget 0 icon
         (title off)
         (origin 330 594)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 42 170)
         (extent 700 413)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 327 388)
       (extent 127 25)
      )
      (detail
       (origin 205 290)
       (extent 351 200)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D0:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 435 388)
     (extent 110 25)
    )
    (panel
     (origin 11 132)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 113 145)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 277 322)
       (Point 322 322)
      )
      (connect D0:0 D1:1
       (Point 348 337)
       (Point 348 360)
       (Point 140 360)
       (Point 140 322)
       (Point 158 322)
      )
      (connect D0:1 D2:0
       (Point 373 312)
       (Point 390 312)
       (Point 390 385)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D8:1 D0:1)
   (connect D4:1 D0:2)
   (connect D5:1 D0:3)
   (connect D8:1 D1:1)
   (connect D11:1 D1:2)
   (connect D3:1 D1:3)
   (connect D8:1 D2:1)
   (connect D12:1 D2:2)
   (connect D13:1 D2:3)
   (connect D2:1 D3:1)
   (connect D10:1 D4:1)
   (connect D2:1 D5:1)
   (connect D7:0 D8:0)
   (connect D8:1 D10:1)
   (connect D9:1 D10:2)
   (connect D10:1 D11:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 981 635)
   (configuration
    (connect D8:1 D0:1
     (Point 245 490)
     (Point 260 490)
     (Point 260 510)
     (Point 420 510)
     (Point 420 170)
     (Point 567 170)
    )
    (connect D4:1 D0:2
     (Point 546 270)
     (Point 567 270)
    )
    (connect D5:1 D0:3
     (Point 546 370)
     (Point 567 370)
    )
    (connect D8:1 D1:1
     (Point 245 490)
     (Point 260 490)
     (Point 260 510)
     (Point 567 510)
    )
    (connect D11:1 D1:2
     (Point 535 550)
     (Point 550 550)
     (Point 550 610)
     (Point 567 610)
    )
    (connect D3:1 D1:3
     (Point 545 710)
     (Point 567 710)
    )
    (connect D8:1 D2:1
     (Point 245 490)
     (Point 260 490)
     (Point 260 550)
     (Point 310 550)
     (Point 310 700)
     (Point 330 700)
    )
    (connect D12:1 D2:2
     (Point 115 630)
     (Point 150 630)
     (Point 150 710)
     (Point 330 710)
    )
    (connect D13:1 D2:3
     (Point 117 710)
     (Point 140 710)
     (Point 140 720)
     (Point 330 720)
    )
    (connect D2:1 D3:1
     (Point 430 710)
     (Point 454 710)
    )
    (connect D10:1 D4:1
     (Point 395 550)
     (Point 430 550)
     (Point 430 270)
     (Point 473 270)
    )
    (connect D2:1 D5:1
     (Point 430 710)
     (Point 440 710)
     (Point 440 700)
     (Point 450 700)
     (Point 450 370)
     (Point 473 370)
    )
    (connect D7:0 D8:0
     (Point 220 432)
     (Point 220 473)
    )
    (connect D8:1 D10:1
     (Point 245 490)
     (Point 260 490)
     (Point 260 540)
     (Point 304 540)
    )
    (connect D9:1 D10:2
     (Point 111 550)
     (Point 130 550)
     (Point 130 560)
     (Point 304 560)
    )
    (connect D10:1 D11:1
     (Point 395 550)
     (Point 444 550)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
