#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name "Slots Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Note"
   (interface
   )
   (implementation
    (component text 4 5
     Most devices have
     a "Show Description"
     box with details
     on their operation.
    )
   )
   (views
    (icon
    )
    (detail
     (origin 357 110)
     (extent 206 80)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 1 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 584 108)
     (extent 392 84)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 2 "Start"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 126 221)
     (extent 69 39)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "ExitProcess"
   (name "Exit Program")
   (interface
    (sequence in)
   )
   (implementation
    (comp code 0)
   )
   (views
    (icon
     (origin 99 446)
     (extent 122 29)
    )
    (detail
     (origin 666 539)
     (extent 192 34)
    )
    (active icon)
   )
  )
  (component 4 "RepeatUntilBreak"
   (name "Until Break")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (description 6 5
     This device continues to rerun the "PULL" thread
     until a "break" device operates.  The thread that
     is activated by this device constitutes the entire
     slot machine for one cycle of spinning, evaluating
     the results, displaying the winnings, and recalcing
     the bankroll.
    )
    (icon
     (origin 102 367)
     (extent 116 26)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "Context"
   (name "DING - DING")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode rad)
    (locked no)
    (component 0 "LiteralConstant"
     (name "A WINNER!")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "A WINNER!")
       (datum "  $100 JACKPOT IS YOURS")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (datum "")
      )
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 631 383)
       (extent 259 54)
      )
      (active detail)
     )
    )
    (configuration
    )
    (ShowOnExecPanel
     (origin 332 253)
     (extent 330 158)
     (panel
      (origin 334 289)
      (extent 326 120)
      (widget 0 detail
       (title on)
       (origin 371 339)
       (extent 259 54)
      )
     )
    )
   )
   (views
    (icon
     (origin 835 467)
     (extent 110 26)
    )
    (detail
     (origin 560 310)
     (extent 360 181)
     (configuration
     )
    )
    (active icon)
   )
  )
  (component 6 "ForCount"
   (name "Gimme 5")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component count 5)
   )
   (views
    (icon
     (origin 842 396)
     (extent 77 29)
    )
    (detail
     (origin 578 303)
     (extent 165 34)
    )
    (active icon)
   )
  )
  (component 7 "RandomNumber"
   (name "Random Number")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Rand Val")
     (lock name constraints)
    )
   )
   (implementation
    (component lowerLimit 8)
    (component upperLimit 15)
   )
   (views
    (icon
     (origin 413 237)
     (extent 134 26)
    )
    (detail
     (origin 24 110)
     (extent 219 57)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "Context"
   (name "Spin Da Wheel")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "SubAry")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "SubAry")
     (lock constraints)
     (optional yes)
    )
    (output 3
     (type data)
     (name "SubAry")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "LiteralConstant"
     (name "Text")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "Text")
       (numDims 1)
       (size 6)
       (data
        [ "BAR" "BELL" "APPLE" "CHERRY" "PLUM" "7" ]
       )
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (datum "")
      )
     )
     (views
      (description 17 7
       This Text Constant generates a 1-dimension array
       of text strings.  For this example, each "picture"
       on the wheel is entered once in the list.  
       
       Spinning the wheel is done by randomly selecting
       one of the array elements.  For example, the
       third element is "Cherry" and is accessed as
       text[3].
       
       To make the "wheel" more realistic, you could add
       many array elements to the text device, varying
       the odds of selecting a particular element by how
       many times it is represented in the list.  If you
       do change the array size from 6 elements, you must
       change the Random Number generators to produce
       new indices from 0 to the max number of elements.
       
      )
      (icon
      )
      (detail
       (origin 263 254)
       (extent 151 134)
      )
      (active detail)
     )
    )
    (component 1 "RandomNumber"
     (name "Random Number")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Rand Val")
       (lock name constraints)
      )
     )
     (implementation
      (component lowerLimit 0)
      (component upperLimit 5.999)
     )
     (views
      (icon
       (origin 273 407)
       (extent 134 26)
      )
      (detail
       (origin 57 205)
       (extent 219 57)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "RandomNumber"
     (name "Random Number")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Rand Val")
       (lock name constraints)
      )
     )
     (implementation
      (component lowerLimit 0)
      (component upperLimit 5.999)
     )
     (views
      (icon
       (origin 273 457)
       (extent 134 26)
      )
      (detail
       (origin 71 287)
       (extent 219 57)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Formula"
     (name "UnBuild Array")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (optional yes)
      )
      (input 2
       (type data)
       (name "I")
       (optional yes)
      )
      (output 1
       (type data)
       (name "SubAry")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary[I]")
     )
     (views
      (icon
       (origin 463 497)
       (extent 134 26)
      )
      (detail
       (origin 326 348)
       (extent 83 47)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "Formula"
     (name "UnBuild Array")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (optional yes)
      )
      (input 2
       (type data)
       (name "I")
       (optional yes)
      )
      (output 1
       (type data)
       (name "SubAry")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary[I]")
     )
     (views
      (icon
       (origin 453 447)
       (extent 134 26)
      )
      (detail
       (origin 326 348)
       (extent 83 47)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "Formula"
     (name "UnBuild Array")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (optional yes)
      )
      (input 2
       (type data)
       (name "I")
       (optional yes)
      )
      (output 1
       (type data)
       (name "SubAry")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary[I]")
     )
     (views
      (icon
       (origin 453 397)
       (extent 134 26)
      )
      (detail
       (origin 326 348)
       (extent 83 47)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 6 "RandomNumber"
     (name "Random Number")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Rand Val")
       (lock name constraints)
      )
     )
     (implementation
      (component lowerLimit 0)
      (component upperLimit 5.999)
     )
     (views
      (icon
       (origin 273 507)
       (extent 134 26)
      )
      (detail
       (origin 73 365)
       (extent 219 57)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D0:1 D3:1)
     (connect D6:1 D3:2)
     (connect D0:1 D4:1)
     (connect D2:1 D4:2)
     (connect D0:1 D5:1)
     (connect D1:1 D5:2)
     (connect D5:1 O1:1)
     (connect D4:1 O2:1)
     (connect D3:1 O3:1)
    )
   )
   (views
    (description 7 5
     This user object encapsulates the devices needed
     to repeatedly spin each of the three "wheels" a
     random number of times.
     
     It provides three outputs, one for each wheel,
     every time they are spun.  The For count device
     determines how many times to spin them.
    )
    (icon
     (origin 425 413)
     (extent 131 34)
    )
    (detail
     (origin 237 210)
     (extent 426 340)
     (configuration
      (connect D0:1 D3:1
       (Point 416 321)
       (Point 450 321)
       (Point 450 380)
       (Point 430 380)
       (Point 430 500)
       (Point 460 500)
      )
      (connect D6:1 D3:2
       (Point 409 520)
       (Point 460 520)
      )
      (connect D0:1 D4:1
       (Point 416 321)
       (Point 450 321)
       (Point 450 380)
       (Point 430 380)
       (Point 430 450)
       (Point 450 450)
      )
      (connect D2:1 D4:2
       (Point 409 470)
       (Point 450 470)
      )
      (connect D0:1 D5:1
       (Point 416 321)
       (Point 450 321)
       (Point 450 400)
      )
      (connect D1:1 D5:2
       (Point 409 420)
       (Point 450 420)
      )
      (connect D5:1 O1:1
       (Point 589 410)
       (Point 600 410)
       (Point 600 270)
       (Point 660 270)
      )
      (connect D4:1 O2:1
       (Point 589 460)
       (Point 610 460)
       (Point 610 390)
       (Point 660 390)
      )
      (connect D3:1 O3:1
       (Point 599 510)
       (Point 660 510)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "Accumulator"
   (name "Accumulator")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (tag "InData")
     (requires
      (shape "Scalar")
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Data")
     (tag "accumData")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (description 4 5
     The accumulator keeps a running account of the
     bankroll by adding whatever data is presented on
     the input (positive numbers add, negative will
     subtract). 
    )
    (icon
     (origin 495 498)
     (extent 110 25)
    )
    (detail
     (origin 459 533)
     (extent 183 34)
    )
    (active icon)
   )
  )
  (component 10 "Confirm"
   (name "PULL")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Go")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (description 8 5
     This Confirm/OK device pauses execution of the
     thread until the button is activated by the user,
     at which point the remainder of the thread is
     processed.
     
     Since there is nothing tied to the sequence out
     pin, execution of the thread will stop after all
     the "hosted" thread has completed.
    )
    (icon
     (origin 240 441)
     (extent 60 39)
    )
    (detail
     (origin 243 327)
     (extent 65 47)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 93 231)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 115 223)
       (extent 51 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Context"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Note"
       (name "NotePad")
       (interface
       )
       (implementation
        (component text 20 9
         Purpose:  To illustrate an interactive model build from many types of devices.
         
         User Input Required:  Press RUN to start the program.  Press PULL to spin the wheel.
         
         Explanation:  This example provides two "faces" -- the Panel view and the Detail view.
                    You can use the Panel and Detail buttons in the title bar to switch between
                    the views.  Generally, the panel view provides the user interface to a model,
                    while the Detail view provides the implementation details.  The program can
                    be operated from either view, but with some loss of user friendliness.
         
                    Most of the building blocks are provided by User Objects that encapsulate
                    the detailed steps necessary to perform a function such as "SpinDaWheel",
                    which spins the three wheels a random number of times each time the User
                    Object operates.  
         
                    Many of the devices have a "Show Description" entry that details why and how
                    the device operates; you can access this by right-clicking on each device and
                    then selecting ShowDescription from the resulting Object menu.
         
         
        )
       )
       (views
        (icon
         (origin 400 351)
         (extent 78 25)
        )
        (detail
         (origin 36 162)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (component 1 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 410 415)
         (extent 58 37)
        )
        (detail
         (origin 466 633)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 55 78)
       (extent 849 571)
       (panel
        (origin 18 150)
        (extent 845 533)
        (widget 0 detail
         (title off)
         (origin 31 162)
         (extent 816 465)
         (editing disabled)
        )
        (widget 1 icon
         (title off)
         (origin 417 635)
         (extent 58 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 385 408)
       (extent 110 25)
      )
      (detail
       (origin 255 310)
       (extent 351 200)
       (configuration
       )
      )
      (active icon)
     )
    )
    (component 2 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 257 238)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "RepeatUntilBreak"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 25 148)
       (extent 110 64)
       (iconImage loop.icon)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D3:1 D0:0)
     (connect D1:0 D0:1)
     (connect D2:1 D1:0)
     (connect D0:1 D2:1)
    )
   )
   (views
    (icon
     (origin 175 368)
     (extent 110 25)
    )
    (panel
     (origin 11 108)
     (extent 319 77)
     (widget 0 icon
      (title off)
      (origin 113 121)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 111)
     (extent 912 591)
     (configuration
      (connect D3:1 D0:0
       (Point 137 180)
       (Point 150 180)
       (Point 150 228)
      )
      (connect D1:0 D0:1
       (Point 440 435)
       (Point 440 450)
       (Point 70 450)
       (Point 70 250)
       (Point 90 250)
      )
      (connect D2:1 D1:0
       (Point 305 240)
       (Point 440 240)
       (Point 440 405)
      )
      (connect D0:1 D2:1
       (Point 209 250)
       (Point 254 250)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 12 "TextDisplay"
   (name "Text")
   (interface
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 658 210)
     (extent 124 40)
    )
    (detail
     (origin 658 210)
     (extent 120 37)
    )
    (active detail)
   )
  )
  (component 13 "TextDisplay"
   (name "Text")
   (interface
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 658 270)
     (extent 124 40)
    )
    (detail
     (origin 658 270)
     (extent 120 37)
    )
    (active detail)
   )
  )
  (component 14 "TextDisplay"
   (name "Text")
   (interface
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 658 330)
     (extent 124 40)
    )
    (detail
     (origin 658 330)
     (extent 120 37)
    )
    (active detail)
   )
  )
  (component 15 "ForCount"
   (name "For Count")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Count")
     (tag "Count")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (lock name constraints)
    )
    (buffers in
     (buffer "Count")
    )
   )
   (implementation
    (component count 10)
   )
   (views
    (description 9 5
     The Random number feeding this iterator determines
     how many times the "Spin Da Wheel" user object is
     to be run.  Each time it runs, it produces a new
     set of random values on the output.  
     
     When the For Count has run the User Object the
     desired number of times, it's Sequence Out pin is
     activated to allow the Sequence In on the Payoff
     calculation User Object to run.
    )
    (icon
     (origin 433 306)
     (extent 95 29)
    )
    (detail
     (origin 346 605)
     (extent 165 34)
    )
    (active icon)
   )
  )
  (component 16 "Context"
   (name "YOU HAVE WON:")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
   )
   (implementation
    (trigMode rad)
    (locked no)
    (component 0 "Delay"
     (name "Delay")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (component delay 1.25)
     )
     (views
      (icon
       (origin 821 576)
       (extent 59 29)
      )
      (detail
       (origin 563 462)
       (extent 129 34)
      )
      (active icon)
     )
    )
    (component 1 "TextDisplay"
     (name "AlphaNumeric")
     (interface
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
      )
      (detail
       (origin 754 523)
       (extent 192 35)
      )
      (active detail)
     )
    )
    (component 2 "ToString"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (tag "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "result")
       (lock name constraints)
      )
     )
     (implementation
      (attr iopath string write "string"
       (readTerm "\n")
       (fs " ")
       (eol "\n")
       (multiField fullSyntax)
       (arrayFormat block)
      )
      (procedure
        WRITE TEXT "$",a EOL
      )
     )
     (views
      (icon
       (origin 615 528)
       (extent 110 25)
      )
      (detail
       (origin 278 380)
       (extent 238 120)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D1:0 D0:0)
     (connect D2:1 D1:1)
     (connect I1:1 D2:1)
    )
    (ShowOnExecPanel
     (origin 384 266)
     (extent 222 112)
     (panel
      (origin 761 503)
      (extent 218 74)
      (widget 1 detail
       (title off)
       (origin 777 520)
       (extent 192 35)
      )
     )
    )
   )
   (views
    (description 3 5
     This user object uses the Show Panel on Execute
     to pop up it's Panel over the main panel whenever
     a payoff is done.  
    )
    (icon
     (origin 833 517)
     (extent 134 26)
    )
    (detail
     (origin 600 440)
     (extent 360 181)
     (configuration
      (connect D1:0 D0:0
       (Point 850 560)
       (Point 850 573)
      )
      (connect D2:1 D1:1
       (Point 727 540)
       (Point 751 540)
      )
      (connect I1:1 D2:1
       (Point 602 540)
       (Point 602 540)
       (Point 602 540)
       (Point 612 540)
      )
     )
    )
    (active icon)
   )
  )
  (component 17 "Context"
   (name "Calc Payoff")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (optional yes)
    )
    (input 3
     (type data)
     (name "C")
     (optional yes)
    )
    (output 1
     (type data)
     (name "DING")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "Pay")
     (lock constraints)
     (optional yes)
    )
    (output 3
     (type data)
     (name "DUNK")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode rad)
    (locked no)
    (component 0 "IfThenElse"
     (name "Find Matches")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (optional yes)
      )
      (input 3
       (type data)
       (name "C")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else If")
       (lock name constraints)
      )
      (output 3
       (type data)
       (name "Else If")
       (lock name constraints)
      )
      (output 4
       (type data)
       (name "Else If")
       (lock name constraints)
      )
      (output 5
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "A==B AND B==C AND A==\"BAR\"")
      (component expr "(A==B AND A==\"BAR\") OR (B==C AND B==\"BAR\") OR (C==A AND C==\"BAR\")")
      (component expr "(A==B AND A==\"7\") OR (B==C AND B==\"7\") OR (C==A AND C==\"7\")")
      (component expr "A==B OR B==C OR C==A")
     )
     (views
      (description 11 7
       This If/Then device has three expressions that
       examine the input text strings, looking for
       matches with the displayed payoff.  If you
       open this device to the detailed view, it is
       very large.  Maximizing the "Calc Payoff" by
       clicking on the Max botton in the title bar is
       recommended.
       
       Note: the odds are hard-coded in the expressions.
       An astute student could consider other ways of
       making the payoff decision without using If/then.
      )
      (icon
       (origin 436 313)
       (extent 129 54)
      )
      (detail
       (origin 382 224)
       (extent 268 243)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Constant"
     (name "$100")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "$100")
       (datum 100)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 625 336)
       (extent 50 29)
      )
      (detail
       (origin 341 243)
       (extent 147 28)
      )
      (active icon)
     )
    )
    (component 2 "Constant"
     (name "$20")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "$20")
       (datum 20)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 630 406)
       (extent 41 29)
      )
      (detail
       (origin 304 252)
       (extent 147 28)
      )
      (active icon)
     )
    )
    (component 3 "Constant"
     (name "$10")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "$10")
       (datum 10)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 630 466)
       (extent 41 29)
      )
      (detail
       (origin 306 308)
       (extent 147 28)
      )
      (active icon)
     )
    )
    (component 4 "Constant"
     (name "$5")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "$5")
       (datum 5)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 633 526)
       (extent 34 29)
      )
      (detail
       (origin 309 367)
       (extent 147 28)
      )
      (active icon)
     )
    )
    (component 5 "Junction"
     (name "JCT")
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
       (optional yes)
      )
      (input 3
       (type data)
       (name "C")
       (lock name constraints)
       (optional yes)
      )
      (input 4
       (type data)
       (name "D")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 718 448)
       (extent 64 45)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 6 "Constant"
     (name "Each Bet = -$5")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Each Bet = -$5")
       (datum -5)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (description 6 7
       This CONSTANT determines how much each bet costs.
       
       As an exercise, you might want to have several 
       PULL devices with each feeding a different 
       constant device.  This would allow playing with
       different number of "coins" each time.
      )
      (icon
       (origin 442 516)
       (extent 136 29)
      )
      (detail
       (origin 515 516)
       (extent 210 28)
      )
      (active icon)
     )
    )
    (configuration
     (connect I1:1 D0:1)
     (connect I2:1 D0:2)
     (connect I3:1 D0:3)
     (connect D0:1 D1:0)
     (connect D0:2 D2:0)
     (connect D0:3 D3:0)
     (connect D0:4 D4:0)
     (connect D1:1 D5:1)
     (connect D2:1 D5:2)
     (connect D3:1 D5:3)
     (connect D4:1 D5:4)
     (connect D0:5 D6:0)
     (connect D0:1 O1:1)
     (connect D5:1 O2:1)
     (connect D6:1 O3:1)
    )
   )
   (views
    (description 18 5
     This user object "examines" the state of each
     wheel after the spin to see if any of the payoff
     combinations are present.  Although not elegant,
     the method is to use a large If/Then with suitable
     expressions to test the three inputs.
     
     If none of the payoffs are found, neither of the
     top output pins are activated, and -5 is sent out
     the bottom pin to be subtracted from the bankroll
     before the next iteration of the Until Break is
     performed.  
     
     If a payoff is found, the "pay" output will have
     the dollar value to add to the bankroll.  If the
     jackpot payoff is found, the upper output pin will
     also be activated to allow the Gimme 5 to flash
     a win box on the panel 5 times.
      
    )
    (icon
     (origin 662 413)
     (extent 116 34)
    )
    (detail
     (origin 393 277)
     (extent 405 307)
     (configuration
      (connect I1:1 D0:1
       (Point 395 330)
       (Point 410 330)
       (Point 410 320)
       (Point 433 320)
      )
      (connect I2:1 D0:2
       (Point 395 440)
       (Point 410 440)
       (Point 410 340)
       (Point 433 340)
      )
      (connect I3:1 D0:3
       (Point 395 550)
       (Point 420 550)
       (Point 420 360)
       (Point 433 360)
      )
      (connect D0:1 D1:0
       (Point 567 320)
       (Point 580 320)
       (Point 580 310)
       (Point 650 310)
       (Point 650 333)
      )
      (connect D0:2 D2:0
       (Point 567 330)
       (Point 610 330)
       (Point 610 380)
       (Point 650 380)
       (Point 650 403)
      )
      (connect D0:3 D3:0
       (Point 567 340)
       (Point 580 340)
       (Point 580 450)
       (Point 650 450)
       (Point 650 463)
      )
      (connect D0:4 D4:0
       (Point 567 350)
       (Point 590 350)
       (Point 590 510)
       (Point 650 510)
       (Point 650 523)
      )
      (connect D1:1 D5:1
       (Point 677 350)
       (Point 700 350)
       (Point 700 450)
       (Point 715 450)
      )
      (connect D2:1 D5:2
       (Point 673 420)
       (Point 690 420)
       (Point 690 460)
       (Point 715 460)
      )
      (connect D3:1 D5:3
       (Point 673 480)
       (Point 690 480)
       (Point 690 470)
       (Point 715 470)
      )
      (connect D4:1 D5:4
       (Point 669 540)
       (Point 700 540)
       (Point 700 480)
       (Point 715 480)
      )
      (connect D0:5 D6:0
       (Point 567 360)
       (Point 600 360)
       (Point 600 390)
       (Point 510 390)
       (Point 510 513)
      )
      (connect D0:1 O1:1
       (Point 567 320)
       (Point 580 320)
       (Point 580 310)
       (Point 710 310)
       (Point 710 330)
       (Point 795 330)
      )
      (connect D5:1 O2:1
       (Point 784 470)
       (Point 790 470)
       (Point 790 440)
       (Point 795 440)
      )
      (connect D6:1 O3:1
       (Point 580 530)
       (Point 600 530)
       (Point 600 570)
       (Point 690 570)
       (Point 690 550)
       (Point 795 550)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 18 "Junction"
   (name "JCT")
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
     (optional yes)
    )
    (input 3
     (type data)
     (name "C")
     (lock name constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (description 5 5
     The Bankroll calculation "adds" whatever value
     is passed thru this device.  At start (PreRun),
     it is passed the 100 to start the bankroll; after
     each payoff, either winnings are added or another
     5$ is subtracted.
    )
    (icon
     (origin 409 493)
     (extent 62 34)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 19 "ToString"
   (name "To String")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (tag "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "result")
     (lock name constraints)
    )
   )
   (implementation
    (attr iopath string write "string"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "$",a," Left" EOL
    )
   )
   (views
    (description 10 5
     Because the player would expect his bankroll to
     be in dollars, we can use the To String device to
     format a displayable string that is prefaced with
     a $.
     
     Another way to accomplish this would be to "add"
     the string "$" to the payroll amount.  Because
     adding unlike types converts the lower type (a
     real number) to the higher type (a string), the
     result would be a string formated as we desire.
    )
    (icon
     (origin 635 498)
     (extent 110 25)
    )
    (detail
     (origin 183 438)
     (extent 308 105)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 20 "IfThenElse"
   (name "A > 0")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "a>0")
   )
   (views
    (description 4 5
     Test to see if there is any money left in the
     bankroll.  If not, we exit.  Otherwise, it's
     OK to spin the wheel again.
     
    )
    (icon
     (origin 511 567)
     (extent 78 26)
    )
    (detail
     (origin 533 505)
     (extent 64 90)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 21 "Break"
   (interface
    (sequence in)
   )
   (implementation
   )
   (views
    (icon
     (origin 561 608)
     (extent 78 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 22 "TextDisplay"
   (name "Your Bankroll")
   (interface
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 655 586)
     (extent 131 29)
    )
    (detail
     (origin 360 493)
     (extent 201 35)
    )
    (active icon)
   )
  )
  (component 23 "Constant"
   (name "Start $$$")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Start $$$")
     (datum 100)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (description 6 5
     This CONSTANT sets the initial value of your
     Bankroll every time the Slot Machine is started.
     
     The Default is $100.  An exercise would be to
     read this value from a text file that is updated
     after each spin with the remaining bankroll.
    )
    (icon
     (origin 113 286)
     (extent 95 29)
    )
    (detail
     (origin 78 286)
     (extent 165 28)
    )
    (active icon)
   )
  )
  (component 24 "Note"
   (name "The Odds")
   (interface
   )
   (implementation
    (component text 6 5
       THE PAYOFF FOR THIS MACHINE
       -------    ----------------
       $ 100      3 BARs
       $  20      Any 2 BARs
       $  10      Any 2 Sevens
       $   5      any pair
    )
   )
   (views
    (icon
     (origin 116 517)
     (extent 89 26)
    )
    (detail
     (origin 2 467)
     (extent 277 126)
     (editing disabled)
    )
    (active icon)
   )
  )
  (configuration
   (connect D4:0 D3:0)
   (connect D23:0 D4:0)
   (connect D6:1 D5:0)
   (connect D17:1 D6:0)
   (connect D10:1 D7:0)
   (connect D15:1 D8:0)
   (connect D18:1 D9:1)
   (connect D4:1 D10:0)
   (connect D8:1 D12:1)
   (connect D8:2 D13:1)
   (connect D8:3 D14:1)
   (connect D7:1 D15:1)
   (connect D17:2 D16:1)
   (connect D15:0 D17:0)
   (connect D8:1 D17:1)
   (connect D8:2 D17:2)
   (connect D8:3 D17:3)
   (connect D23:1 D18:1)
   (connect D17:2 D18:2)
   (connect D17:3 D18:3)
   (connect D9:1 D19:1)
   (connect D19:0 D20:0)
   (connect D9:1 D20:1)
   (connect D20:2 D21:0)
   (connect D19:1 D22:1)
   (connect D2:0 D23:0)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 995 648)
   (widget 13 detail
    (title off)
    (origin 422 97)
    (extent 124 40)
   )
   (widget 14 detail
    (title off)
    (origin 553 97)
    (extent 124 40)
   )
   (widget 12 detail
    (title off)
    (origin 291 98)
    (extent 124 40)
   )
   (widget 22 detail
    (title on)
    (origin 392 198)
    (extent 201 35)
   )
   (widget 10 icon
    (title off)
    (origin 469 287)
    (extent 60 39)
   )
   (widget 1 detail
    (title on)
    (origin 324 622)
    (extent 392 84)
    (editing disabled)
   )
   (widget 24 detail
    (title on)
    (origin 543 449)
    (extent 290 122)
    (editing disabled)
   )
   (widget 11 panel
    (title on)
    (origin 184 448)
    (extent 299 125)
    (widget 0 icon
     (title off)
     (origin 271 475)
     (extent 114 39)
     (format button)
    )
   )
  )
  (detail
   (origin 0 67)
   (extent 978 635)
   (configuration
    (connect D4:0 D3:0
     (Point 160 395)
     (Point 160 443)
    )
    (connect D23:0 D4:0
     (Point 160 317)
     (Point 160 340)
     (Point 160 340)
     (Point 160 364)
    )
    (connect D6:1 D5:0
     (Point 921 410)
     (Point 940 410)
     (Point 940 440)
     (Point 890 440)
     (Point 890 464)
    )
    (connect D17:1 D6:0
     (Point 780 420)
     (Point 800 420)
     (Point 800 380)
     (Point 880 380)
     (Point 880 393)
    )
    (connect D10:1 D7:0
     (Point 302 460)
     (Point 320 460)
     (Point 320 220)
     (Point 480 220)
     (Point 480 234)
    )
    (connect D15:1 D8:0
     (Point 530 320)
     (Point 550 320)
     (Point 550 350)
     (Point 490 350)
     (Point 490 410)
    )
    (connect D18:1 D9:1
     (Point 473 510)
     (Point 492 510)
    )
    (connect D4:1 D10:0
     (Point 220 380)
     (Point 270 380)
     (Point 270 438)
    )
    (connect D8:1 D12:1
     (Point 558 420)
     (Point 590 420)
     (Point 590 230)
     (Point 655 228)
    )
    (connect D8:2 D13:1
     (Point 558 430)
     (Point 610 430)
     (Point 610 290)
     (Point 655 288)
    )
    (connect D8:3 D14:1
     (Point 558 440)
     (Point 630 440)
     (Point 630 350)
     (Point 655 348)
    )
    (connect D7:1 D15:1
     (Point 549 250)
     (Point 570 250)
     (Point 570 280)
     (Point 410 280)
     (Point 410 320)
     (Point 430 320)
    )
    (connect D17:2 D16:1
     (Point 780 430)
     (Point 810 430)
     (Point 810 530)
     (Point 830 530)
    )
    (connect D15:0 D17:0
     (Point 480 337)
     (Point 480 350)
     (Point 410 350)
     (Point 410 470)
     (Point 710 470)
     (Point 710 400)
     (Point 720 400)
     (Point 720 410)
    )
    (connect D8:1 D17:1
     (Point 558 420)
     (Point 608 420)
     (Point 608 420)
     (Point 659 420)
    )
    (connect D8:2 D17:2
     (Point 558 430)
     (Point 608 430)
     (Point 608 430)
     (Point 659 430)
    )
    (connect D8:3 D17:3
     (Point 558 440)
     (Point 608 440)
     (Point 608 440)
     (Point 659 440)
    )
    (connect D23:1 D18:1
     (Point 210 300)
     (Point 330 300)
     (Point 330 500)
     (Point 406 500)
    )
    (connect D17:2 D18:2
     (Point 780 430)
     (Point 810 430)
     (Point 810 660)
     (Point 380 660)
     (Point 380 510)
     (Point 406 510)
    )
    (connect D17:3 D18:3
     (Point 780 440)
     (Point 800 440)
     (Point 800 650)
     (Point 390 650)
     (Point 390 520)
     (Point 406 520)
    )
    (connect D9:1 D19:1
     (Point 607 510)
     (Point 632 510)
    )
    (connect D19:0 D20:0
     (Point 690 525)
     (Point 690 550)
     (Point 550 550)
     (Point 550 564)
    )
    (connect D9:1 D20:1
     (Point 607 510)
     (Point 620 510)
     (Point 620 540)
     (Point 490 540)
     (Point 490 580)
     (Point 508 580)
    )
    (connect D20:2 D21:0
     (Point 591 590)
     (Point 600 590)
     (Point 600 605)
    )
    (connect D19:1 D22:1
     (Point 747 510)
     (Point 760 510)
     (Point 760 560)
     (Point 640 560)
     (Point 640 600)
     (Point 652 600)
    )
    (connect D2:0 D23:0
     (Point 160 262)
     (Point 160 272)
     (Point 160 272)
     (Point 160 283)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
