#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name "Zero fill an array")
 (interface
 )
 (implementation
  (trigMode rad)
  (locked no)
  (component 0 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 572 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 1 "TextDisplay"
   (name "Output Array")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 118 0)
    )
    (detail
     (origin 598 250)
     (extent 165 181)
    )
    (active detail)
   )
  )
  (component 2 "TextDisplay"
   (name "Output Array")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 118 0)
    )
    (detail
     (origin 798 250)
     (extent 165 181)
    )
    (active detail)
   )
  )
  (component 3 "Constant"
   (name "# of Zeros")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "# of Zeros")
     (datum 5)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 13 394)
     (extent 174 32)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 4 "FromArray"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Ary")
     (tag "Ary")
    )
    (output 1
     (type data)
     (name "SubAry")
     (tag "Result")
     (lock constraints)
    )
    (output 2
     (type data)
     (name "Type")
     (tag "Type")
     (lock constraints)
    )
    (output 3
     (type data)
     (name "NumDims")
     (tag "NumDims")
     (lock constraints)
    )
    (output 4
     (type data)
     (name "DimSizes")
     (tag "DimSizes")
     (lock constraints)
    )
    (output 5
     (type data)
     (name "TotSize")
     (tag "TotSize")
     (lock constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "Ary")
   )
   (views
    (icon
     (origin 37 698)
     (extent 127 64)
     (iconImage unbuild.icon)
    )
    (detail
     (origin 65 511)
     (extent 70 158)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "Constant"
   (name "Total Length")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Total Length")
     (datum 9)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 118 0)
    )
    (detail
     (origin 14 814)
     (extent 192 32)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 6 "VectorConcatenator"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Array")
     (tag "Array")
     (lock constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 511 438)
     (extent 118 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "Formula"
   (name "ramp(numElem,from,thru)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "numElem")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "from")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock name constraints)
    )
    (input 3
     (type data)
     (name "thru")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "ramp(numElem,from,thru)")
   )
   (views
    (icon
     (origin 342 773)
     (extent 217 34)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "VectorConcatenator"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Array")
     (tag "Array")
     (lock constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 611 768)
     (extent 118 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "TextDisplay"
   (name "Output Array")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 118 0)
    )
    (detail
     (origin 606 582)
     (extent 169 176)
    )
    (active detail)
   )
  )
  (component 10 "TextDisplay"
   (name "Output Array")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 118 0)
    )
    (detail
     (origin 796 582)
     (extent 168 176)
    )
    (active detail)
   )
  )
  (component 11 "Formula"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (optional yes)
    )
    (input 3
     (type data)
     (name "C")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "concat(A,ramp(C-B,0,0))")
   )
   (views
    (icon
     (origin 541 618)
     (extent 78 64)
     (iconImage formula.icon)
    )
    (detail
     (origin 286 579)
     (extent 219 123)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 12 "Constant"
   (name "0")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Int32")
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "0")
     (datum 0)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (origin 257 808)
     (extent 46 25)
    )
    (detail
     (origin 455 456)
     (extent 150 28)
     (showFormat int)
    )
    (active icon)
   )
  )
  (component 13 "Formula"
   (name " - ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X-Y")
   )
   (views
    (icon
     (origin 257 768)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 14 "Formula"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "L")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "concat(A,ramp(L,0,0))")
   )
   (views
    (description 4 5
     The formula device can incorporate as "functions"
     any of the math or AdvMath selections.  Generally,
     the object name gives the syntax to use when
     building a formula.
    )
    (icon
     (origin 541 618)
     (extent 78 64)
     (iconImage formula.icon)
    )
    (detail
     (origin 277 252)
     (extent 216 77)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 15 "Constant"
   (name "Input Array")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Input Array")
     (numDims 1)
     (size 4)
     (data
      [ 22 33 44 55 ]
     )
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 18 257)
     (extent 164 87)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 16 "Constant"
   (name "Input Array")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Input Array")
     (numDims 1)
     (size 4)
     (data
      [ 22 33 44 55 ]
     )
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 10 576)
     (extent 160 89)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 17 "AllocateArray"
   (name "Alloc Real")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Dim Size 1")
     (tag "Dim Size 1")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Array")
     (tag "Array")
     (lock constraints)
    )
    (buffers in
     (buffer "Dim Size 1")
    )
   )
   (implementation
    (component numDims 1)
    (component dimSizes "5")
    (component type "Real")
    (component initEnum "Init Value")
    (component initialValue
     (name "Init Value")
     (datum 0)
    )
    (component from 1)
    (component thru 10)
   )
   (views
    (icon
    )
    (detail
     (origin 239 417)
     (extent 243 87)
    )
    (active detail)
   )
  )
  (component 18 "Note"
   (name "To Operate:")
   (interface
   )
   (implementation
    (component text 2 5
     Press RUN and look at
     the examples.
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 348 128)
     (extent 204 45)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 19 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Note"
       (name "NotePad")
       (interface
       )
       (implementation
        (component text 25 9
         PURPOSE:     Illustrate several methods of extending an array by zero filling to a
                      prescribed length.  Use of math functions within the "Formula" device is 
                      illustrated, as is use of "Alloc Array" and ramp to generate fixed arrays.
         
         USER INPUT REQUIRED:  Press RUN, then scroll around the examples, looking at the various
                      methods and functions.
         
         EXPLANATION: Math operations on two or more arrays require that the arrays be the same
                      shape and length.  In order to add a 5 element array to a 10 element array,
                      the 5 element array must first be zero-filled to a length of 10 before the
                      element-by-element output array can be generated.
         
                      Several methods of zero-filling an array are shown in this example.  They
                      all make use of "concatenation" to combine the initial array with an all
                      zero array.  The "Formula" object can be used to perform the entire
                      operation efficiently in one object, or the individual operations can be
                      constructed from the component objects.  The output arrays are generated 
                      using both constructions in each example.
         
                      Two types of examples are shown.  The first assumes that a fixed number of
                      zeros must be added to the input array, while the second assumes that a 
                      variable length input array must be extended to a specified length.  Note
                      that error recovery in cases where the input array is larger than the
                      requested output array is not illustrated, primarily because the examples
                      are meant as learning tools rather than finished functions.
        )
       )
       (views
        (description 2 9
         This notepad is displayed as a Show on Execute
         panel to present the information to the reader.
        )
        (icon
         (origin 160 185)
         (extent 78 25)
        )
        (detail
         (origin 36 162)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (component 1 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (description 7 9
         This tiny "thread" begins running when the 
         enclosing UserObject is executed.  When the user
         acknowledges the OK/DONE button, there is nothing
         left to execute, so the thread ends.  Since there
         are not other threads running, the User Object
         is completed and will exit, removing the Show on
         Execute pop-up display.
        )
        (icon
         (origin 171 252)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 55 78)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 1 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
        (widget 0 detail
         (title off)
         (origin 51 176)
         (extent 822 465)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 140)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 175 368)
     (extent 110 25)
    )
    (panel
     (origin 11 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 113 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D14:1 D1:1)
   (connect D6:1 D2:1)
   (connect D16:1 D4:1)
   (connect D15:1 D6:1)
   (connect D17:1 D6:2)
   (connect D13:1 D7:1)
   (connect D12:1 D7:2)
   (connect D12:1 D7:3)
   (connect D16:1 D8:1)
   (connect D7:1 D8:2)
   (connect D11:1 D9:1)
   (connect D8:1 D10:1)
   (connect D16:1 D11:1)
   (connect D4:5 D11:2)
   (connect D5:1 D11:3)
   (connect D5:1 D13:1)
   (connect D4:5 D13:2)
   (connect D15:1 D14:1)
   (connect D3:1 D14:2)
   (connect D3:1 D17:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 993 648)
   (configuration
    (connect D14:1 D1:1
     (Point 565 290)
     (Point 580 290)
     (Point 580 340)
     (Point 595 340)
    )
    (connect D6:1 D2:1
     (Point 631 450)
     (Point 790 450)
     (Point 790 340)
     (Point 795 340)
    )
    (connect D16:1 D4:1
     (Point 172 620)
     (Point 190 620)
     (Point 190 690)
     (Point 20 690)
     (Point 20 730)
     (Point 34 730)
    )
    (connect D15:1 D6:1
     (Point 184 300)
     (Point 200 300)
     (Point 200 350)
     (Point 500 350)
     (Point 500 440)
     (Point 508 440)
    )
    (connect D17:1 D6:2
     (Point 484 460)
     (Point 508 460)
    )
    (connect D13:1 D7:1
     (Point 305 780)
     (Point 339 780)
    )
    (connect D12:1 D7:2
     (Point 305 820)
     (Point 320 820)
     (Point 320 790)
     (Point 339 790)
    )
    (connect D12:1 D7:3
     (Point 305 820)
     (Point 320 820)
     (Point 320 800)
     (Point 339 800)
    )
    (connect D16:1 D8:1
     (Point 172 620)
     (Point 190 620)
     (Point 190 720)
     (Point 580 720)
     (Point 580 770)
     (Point 608 770)
    )
    (connect D7:1 D8:2
     (Point 561 790)
     (Point 608 790)
    )
    (connect D11:1 D9:1
     (Point 577 640)
     (Point 590 640)
     (Point 590 670)
     (Point 603 670)
    )
    (connect D8:1 D10:1
     (Point 731 780)
     (Point 770 780)
     (Point 770 670)
     (Point 793 670)
    )
    (connect D16:1 D11:1
     (Point 172 620)
     (Point 190 620)
     (Point 190 600)
     (Point 243 600)
    )
    (connect D4:5 D11:2
     (Point 166 750)
     (Point 200 750)
     (Point 200 640)
     (Point 243 640)
    )
    (connect D5:1 D11:3
     (Point 208 830)
     (Point 230 830)
     (Point 230 760)
     (Point 220 760)
     (Point 220 680)
     (Point 243 680)
    )
    (connect D5:1 D13:1
     (Point 208 830)
     (Point 230 830)
     (Point 230 770)
     (Point 254 770)
    )
    (connect D4:5 D13:2
     (Point 166 750)
     (Point 240 750)
     (Point 240 790)
     (Point 254 790)
    )
    (connect D15:1 D14:1
     (Point 184 300)
     (Point 200 300)
     (Point 200 270)
     (Point 234 270)
    )
    (connect D3:1 D14:2
     (Point 189 410)
     (Point 210 410)
     (Point 210 310)
     (Point 234 310)
    )
    (connect D3:1 D17:1
     (Point 189 410)
     (Point 220 410)
     (Point 220 460)
     (Point 236 460)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
