#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name "On-Cycle clock tick Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "TextDisplay"
   (name "Day Number")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 435 393)
     (extent 190 35)
    )
    (active detail)
   )
  )
  (component 1 "TextDisplay"
   (name "Month Number")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 118 0)
    )
    (detail
     (origin 434 473)
     (extent 192 35)
    )
    (active detail)
   )
  )
  (component 2 "Formula"
   (name "month(aDate)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "aDate")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "month(aDate)")
   )
   (views
    (icon
     (origin 231 478)
     (extent 118 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "TextDisplay"
   (name "Year")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 46 0)
    )
    (detail
     (origin 435 553)
     (extent 190 35)
    )
    (active detail)
   )
  )
  (component 4 "Formula"
   (name "year(aDate)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "aDate")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "year(aDate)")
   )
   (views
    (icon
     (origin 235 558)
     (extent 110 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "Formula"
   (name "mday(aDate)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "aDate")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "mday(aDate)")
   )
   (views
    (icon
     (origin 235 398)
     (extent 110 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "OnCycle"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component cycle 1)
   )
   (views
    (icon
     (iconImage loop.icon)
    )
    (detail
     (origin 20 273)
     (extent 160 34)
    )
    (active detail)
   )
  )
  (component 7 "Formula"
   (name "dmyToDate(d,m,y)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "D")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "M")
     (lock name constraints)
    )
    (input 3
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Date")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "dmyToDate(d,m,y)")
   )
   (views
    (icon
     (origin 433 313)
     (extent 154 34)
    )
    (detail
     (origin 736 460)
     (extent 178 160)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 340)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 333)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Note"
       (name "NotePad")
       (interface
       )
       (implementation
        (component text 28 9
         PURPOSE:      Use the Repeat "On Cycle" device to generate a 1-second Time-Of-Day
                       clock.
         
         USER INPUT REQUIRED:  Press RUN to start the clock.
         
         EXPLANATION:  The On Cycle object repeatedly executes the sub-thread attached to its
                       output pin every NNN seconds,  allowing objects in the sub-thread to 
                       be executed at regular intervals.  Here "NNN" is set in the "On Cycle"
                       object.
         
                       Unlike the "Repeat Until Break" device that outputs an "empty" container
                       to the devices on it's sub-thread, the "On Cycle" outputs the current
                       "timestamp" value.  An "AlphaNumeric" display, with the number format
                       changed to "Date/Time", is used to display the timestamp each time the
                       On Cycle executes.
         
                       "On Cycle" does not restart it's sub-thread unless the thread has
                       completed the previous execution;  thus, if the thread took 1.5 seconds
                       to execute, a 1 second On Cycle would wait for the next occurrence of
                       the time interval, running every 2 seconds instead of the 1 second
                       specified.  
         
                       Also illustrated in this example is the use of "Number Format" for the
                       "AlphaNumeric Display" to display a time/date number as a formatted Time
                       and/or Date.  Delta Time format is useful when two time/date numbers are
                       subtracted.
         
                       The time/date can be "disected" using devices from the Math Menu.
        )
       )
       (views
        (description 2 9
         This notepad is displayed as a Show on Execute
         panel to present the information to the reader.
        )
        (icon
         (origin 160 185)
         (extent 78 25)
        )
        (detail
         (origin 36 162)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (component 1 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (description 7 9
         This tiny "thread" begins running when the 
         enclosing UserObject is executed.  When the user
         acknowledges the OK/DONE button, there is nothing
         left to execute, so the thread ends.  Since there
         are not other threads running, the User Object
         is completed and will exit, removing the Show on
         Execute pop-up display.
        )
        (icon
         (origin 171 252)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 55 78)
       (extent 849 571)
       (panel
        (origin 58 144)
        (extent 845 533)
        (widget 0 detail
         (title off)
         (origin 71 156)
         (extent 816 465)
         (editing disabled)
        )
        (widget 1 icon
         (title off)
         (origin 457 629)
         (extent 58 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 408)
       (extent 217 25)
      )
      (detail
       (origin 17 140)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (component 3 "RepeatUntilBreak"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 125 258)
       (extent 110 64)
       (iconImage loop.icon)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D3:1 D1:0)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 175 368)
     (extent 110 25)
    )
    (panel
     (origin 11 112)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 113 125)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 352)
       (Point 362 352)
      )
      (connect D3:1 D1:0
       (Point 237 290)
       (Point 258 290)
       (Point 258 330)
      )
      (connect D2:0 D1:1
       (Point 460 435)
       (Point 460 450)
       (Point 180 450)
       (Point 180 352)
       (Point 198 352)
      )
      (connect D0:1 D2:0
       (Point 413 342)
       (Point 460 342)
       (Point 460 405)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 9 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 552 109)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 10 "Note"
   (name "To Operate:")
   (interface
   )
   (implementation
    (component text 3 5
     Press RUN and look
     at the various
     displays.
    )
   )
   (views
    (icon
     (extent 110 0)
     (iconImage notepad.icon)
    )
    (detail
     (origin 349 113)
     (extent 183 74)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 11 "TextDisplay"
   (name "Day of Week")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 765 233)
     (extent 190 35)
    )
    (active detail)
   )
  )
  (component 12 "Formula"
   (name "wday(aDate)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "aDate")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "wday(aDate)")
   )
   (views
    (icon
     (origin 635 238)
     (extent 110 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "TextDisplay"
   (name "AlphaNumeric (Time/Date)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 226 0)
    )
    (detail
     (origin 265 245)
     (extent 330 31)
     (formatter
      (realFormat timeStamp)
      (realSigDigits 4)
      (realRadixSpec 4)
      (timeStamp dateTime)
      (timeFormat HMS H24)
      (dateFormat WDMY)
      (integerBase decimal)
     )
    )
    (active detail)
   )
  )
  (component 14 "TextDisplay"
   (name "Midnight (Time/Date)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 190 0)
    )
    (detail
     (origin 625 315)
     (extent 330 31)
     (formatter
      (realFormat timeStamp)
      (realSigDigits 4)
      (realRadixSpec 4)
      (timeStamp dateTime)
      (timeFormat HMS H24)
      (dateFormat WDMY)
      (integerBase decimal)
     )
    )
    (active detail)
   )
  )
  (component 15 "Formula"
   (name "Formula to compute Midnight")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "dmyToDate(mday(a),month(a),year(a))")
   )
   (views
    (icon
     (origin 161 628)
     (extent 253 25)
    )
    (detail
     (origin 101 652)
     (extent 349 37)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 16 "Formula"
   (name " - ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X-Y")
   )
   (views
    (icon
     (origin 557 618)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 17 "TextDisplay"
   (name "HH:MM:SS (delta time)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 199 0)
    )
    (detail
     (origin 660 556)
     (extent 280 29)
     (formatter
      (realFormat timeStamp)
      (realSigDigits 4)
      (realRadixSpec 4)
      (timeStamp deltaTime)
      (timeFormat HMS H24)
      (dateFormat DMY)
      (integerBase decimal)
     )
    )
    (active detail)
   )
  )
  (component 18 "Note"
   (interface
   )
   (implementation
    (component text 5 5
     To obtain just the HH:MM:SS
     for today, subtract Midnight
     from the current time.   |
                              |
                              V
    )
   )
   (views
    (icon
    )
    (detail
     (origin 651 409)
     (extent 299 102)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 19 "TextDisplay"
   (name "Midnight (Time/Date)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 190 0)
    )
    (detail
     (origin 635 655)
     (extent 330 31)
     (formatter
      (realFormat timeStamp)
      (realSigDigits 4)
      (realRadixSpec 4)
      (timeStamp dateTime)
      (timeFormat HMS H24)
      (dateFormat WDMY)
      (integerBase decimal)
     )
    )
    (active detail)
   )
  )
  (configuration
   (connect D5:1 D0:1)
   (connect D2:1 D1:1)
   (connect D6:1 D2:1)
   (connect D4:1 D3:1)
   (connect D6:1 D4:1)
   (connect D6:1 D5:1)
   (connect D5:1 D7:1)
   (connect D2:1 D7:2)
   (connect D4:1 D7:3)
   (connect D12:1 D11:1)
   (connect D6:1 D12:1)
   (connect D6:1 D13:1)
   (connect D7:1 D14:1)
   (connect D6:1 D15:1)
   (connect D6:1 D16:1)
   (connect D15:1 D16:2)
   (connect D16:1 D17:1)
   (connect D15:1 D19:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 980 651)
   (configuration
    (connect D5:1 D0:1
     (Point 347 410)
     (Point 432 410)
    )
    (connect D2:1 D1:1
     (Point 351 490)
     (Point 431 490)
    )
    (connect D6:1 D2:1
     (Point 182 290)
     (Point 200 290)
     (Point 200 490)
     (Point 228 490)
    )
    (connect D4:1 D3:1
     (Point 347 570)
     (Point 432 570)
    )
    (connect D6:1 D4:1
     (Point 182 290)
     (Point 200 290)
     (Point 200 570)
     (Point 232 570)
    )
    (connect D6:1 D5:1
     (Point 182 290)
     (Point 200 290)
     (Point 200 410)
     (Point 232 410)
    )
    (connect D5:1 D7:1
     (Point 347 410)
     (Point 380 410)
     (Point 380 320)
     (Point 430 320)
    )
    (connect D2:1 D7:2
     (Point 351 490)
     (Point 390 490)
     (Point 390 330)
     (Point 430 330)
    )
    (connect D4:1 D7:3
     (Point 347 570)
     (Point 400 570)
     (Point 400 340)
     (Point 430 340)
    )
    (connect D12:1 D11:1
     (Point 747 250)
     (Point 762 250)
    )
    (connect D6:1 D12:1
     (Point 182 290)
     (Point 610 290)
     (Point 610 250)
     (Point 632 250)
    )
    (connect D6:1 D13:1
     (Point 182 290)
     (Point 230 290)
     (Point 230 260)
     (Point 262 260)
    )
    (connect D7:1 D14:1
     (Point 589 330)
     (Point 622 330)
    )
    (connect D6:1 D15:1
     (Point 182 290)
     (Point 200 290)
     (Point 200 570)
     (Point 40 570)
     (Point 40 670)
     (Point 58 670)
    )
    (connect D6:1 D16:1
     (Point 182 290)
     (Point 200 290)
     (Point 200 570)
     (Point 220 570)
     (Point 220 600)
     (Point 540 600)
     (Point 540 620)
     (Point 554 620)
    )
    (connect D15:1 D16:2
     (Point 522 670)
     (Point 540 670)
     (Point 540 640)
     (Point 554 640)
    )
    (connect D16:1 D17:1
     (Point 605 630)
     (Point 620 630)
     (Point 620 610)
     (Point 640 610)
     (Point 640 570)
     (Point 657 570)
    )
    (connect D15:1 D19:1
     (Point 522 670)
     (Point 632 670)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
