#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name "Optimize 2 Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 610 107)
     (extent 381 86)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 1 "ToArray"
   (name "Get Values")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Array")
     (tag "Array")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "Datum")
     (tag "Datum")
     (requires
      (shape "Scalar")
     )
     (lock constraints)
    )
    (input 3
     (type data)
     (name "Index 1")
     (tag "Index 1")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock constraints)
    )
    (input 4
     (type data)
     (name "Index 2")
     (tag "Index 2")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock constraints)
    )
    (input 5
     (type trigger)
     (name "XEQ")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Array")
     (tag "Array")
     (lock constraints)
    )
   )
   (implementation
    (component numDims 2)
   )
   (views
    (description 12 5
     Using the allocated, but empty array, of the
     correct size, we use the Set Values device to
     place each element as it is read from the data
     file.  The I and J indexes, generated by the
     For Count iterators, indicate the array position
     for each data item.
     
     After all data as been "inserted" into the array,
     the XEQ pin is activated to send the completed
     array to the display, using the ToString device
     to format the output so it will fit on the display.
     
    )
    (icon
     (origin 825 208)
     (extent 110 64)
     (iconImage build.icon)
    )
    (detail
     (origin 671 113)
     (extent 158 254)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "ForCount"
   (name "For Count")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Count")
     (tag "Count")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (lock name constraints)
    )
    (buffers in
     (buffer "Count")
    )
   )
   (implementation
    (component count 7)
   )
   (views
    (description 5 5
     This iterator is used to access, in turn, each
     of the rows of the Allocated Real array.  As
     each row number is output, the column iterator
     iterates through each of the column numbers while
     data is read from the file into the array.
    )
    (icon
     (origin 565 248)
     (extent 110 64)
     (iconImage loop.icon)
    )
    (detail
     (origin 498 493)
     (extent 165 34)
    )
    (active icon)
   )
  )
  (component 3 "ForCount"
   (name "For Count")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Count")
     (tag "Count")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (lock name constraints)
    )
    (buffers in
     (buffer "Count")
    )
   )
   (implementation
    (component count 4)
   )
   (views
    (description 9 5
     This iterator indexes through the columns of
     the previously selected row.  Note that the
     column number is also used to activate the
     Sequence in pin on the From File to cause it
     to read the next data value from the file that
     corresponds to the current row and column
     indices.
     
     
    )
    (icon
     (origin 585 338)
     (extent 110 64)
     (iconImage loop.icon)
    )
    (detail
     (origin 498 493)
     (extent 165 34)
    )
    (active icon)
   )
  )
  (component 4 "FromFile"
   (name "From File - Read each element")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath file read "/usr/lib/veetest/examples/concepts/optimize2.dat"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      READ TEXT x REAL COUNT:1
    )
   )
   (views
    (description 6 5
     Each real number is read from the data file, 
     using white space as separators.  This READ
     operation pays no attention to the arrangement
     of the data -- the values could be just one
     long line or one value per line.
     
    )
    (icon
     (origin 85 398)
     (extent 271 25)
    )
    (detail
     (origin 41 465)
     (extent 639 70)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 5 "ToString"
   (name "To String")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "result")
     (lock name constraints)
    )
   )
   (implementation
    (attr iopath string write "string"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField dataOnly)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT a
    )
   )
   (views
    (description 7 5
     Although the AlphaNumeric display will display
     the resulting 2D array, the ToString object is
     used to reformat each row of the output as one
     text string, with data separated by a few spaces.
     
     The result is a 1D array of text strings, each
     element representing one row of the output array.
    )
    (icon
     (origin 825 288)
     (extent 110 25)
    )
    (detail
     (origin 606 253)
     (extent 202 55)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "AllocateArray"
   (name "Alloc Real Array")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Dim Size 1")
     (tag "Dim Size 1")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (input 2
     (type data)
     (name "Dim Size 2")
     (tag "Dim Size 2")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Array")
     (tag "Array")
     (lock constraints)
    )
    (buffers in
     (buffer "Dim Size 1")
     (buffer "Dim Size 2")
    )
   )
   (implementation
    (component numDims 2)
    (component dimSizes "7" "4")
    (component type "Real")
    (component initEnum "Init Value")
    (component initialValue
     (name "Init Value")
     (datum 0)
    )
    (component from 1)
    (component thru 10)
   )
   (views
    (description 5 5
     This device generates an empty array of Real
     numbers according to the numrow and numcol
     inputs.  The resulting 2-D array is used by
     the Set Values object to place each of the
     data items being read from the data file.
    )
    (icon
     (origin 553 208)
     (extent 154 25)
    )
    (detail
     (origin 478 258)
     (extent 230 125)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "TextDisplay"
   (name "AlphaNumeric")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
    )
    (detail
     (origin 782 630)
     (extent 176 160)
    )
    (active detail)
   )
  )
  (component 8 "ToString"
   (name "To String")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "result")
     (lock name constraints)
    )
   )
   (implementation
    (attr iopath string write "string"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField dataOnly)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT a
    )
   )
   (views
    (description 8 5
     Although the AlphaNumeric display will display
     the resulting 2D array, the ToString object is
     used to reformat each row of the output as one
     text string, with data separated by a few spaces.
     
     The result is a 1D array of text strings, each
     element representing one row of the output array.
     
    )
    (icon
     (origin 645 748)
     (extent 110 25)
    )
    (detail
     (origin 464 533)
     (extent 202 55)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "FromFile"
   (name "From File - Read array size")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "numrow")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "numcol")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath file read "/usr/lib/veetest/examples/concepts/optimize2.dat"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      EXECUTE REWIND
      READ TEXT numrow,numcol REAL COUNT:1
    )
   )
   (views
    (description 9 5
     The first line of the data file has two integers
     that define the number of rows and number of 
     columns of the data in the file.  
     
     We REWIND the file first, since all instances of
     From File that share the same file name will also
     share the same read pointer.  We want to insure
     the read starts at the first of the file, although
     rewinding is not needed in this example.
    )
    (icon
     (origin 85 398)
     (extent 253 25)
    )
    (detail
     (origin 45 308)
     (extent 390 85)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 10 "Note"
   (name "To Operate:")
   (interface
   )
   (implementation
    (component text 4 5
     Press RUN and then
     look at examples, or
     press Info About for
     additional help.
    )
   )
   (views
    (icon
     (extent 110 0)
     (iconImage notepad.icon)
    )
    (detail
     (origin 364 108)
     (extent 212 85)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 11 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 173 361)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 337 368)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About this Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 363 414)
         (extent 58 37)
        )
        (detail
         (origin 466 633)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "notepad")
       (interface
       )
       (implementation
        (component text 29 9
         PURPOSE:     Reading a 2 dimensioned array of data from a file.
         
         USER INPUT REQUIRED:  Press RUN and look at the data displays from both of the methods.
                      Each device has a Show Description selection to provide additional detail.
         
         EXPLANATION: The problem is to efficiently read in a variable 2-D array
                      of data from a file.  The example file (optimize2.dat) is as follows:
         
                      7  4
                      11 12 13 14
                      21 22 23 24
                      31 32 33 34
                      41 42 43 44
                      51 52 53 54
                      61 62 63 64
                      71 72 73 74
         
                      The first method uses a From File to read the # rows (7) and # cols (4)
                      from the file.  Using nested loops, the successive array indices are
                      computed and a data value is read From File and inserted into the Array.
                      When all data is read, the Build Array output is displayed.
         
                      The second method uses two features to simplify the task.  One FromFile
                      device is used to first rewind the file, then read the data size, and
                      finally read all the data.  Note that the array indices on the first line
                      of the data file are read and sent to two output data pins (numrow and
                      numcol).  Although the outputs are not used, these "variables" are used
                      in the next transaction in the count field where they specify reading a
                      2-D array into X.  The size of the array is numrows by numcolumns.
        )
       )
       (views
        (icon
         (origin 361 338)
         (extent 78 25)
        )
        (detail
         (origin 7 148)
         (extent 727 525)
         (editing enabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 55 78)
       (extent 864 636)
       (panel
        (origin 20 151)
        (extent 860 598)
        (widget 1 detail
         (title off)
         (origin 41 165)
         (extent 814 533)
         (editing enabled)
        )
        (widget 0 icon
         (title off)
         (origin 418 703)
         (extent 58 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 342 438)
       (extent 217 25)
      )
      (detail
       (origin 255 290)
       (extent 351 200)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D2:0 D0:1)
     (connect D0:1 D1:1)
     (connect D1:1 D2:0)
    )
   )
   (views
    (icon
     (origin 435 428)
     (extent 110 25)
    )
    (panel
     (origin 22 109)
     (extent 317 82)
     (widget 0 icon
      (title off)
      (origin 124 122)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 0 107)
     (extent 900 587)
     (configuration
      (connect D2:0 D0:1
       (Point 450 465)
       (Point 450 480)
       (Point 150 480)
       (Point 150 380)
       (Point 170 380)
      )
      (connect D0:1 D1:1
       (Point 289 380)
       (Point 334 380)
      )
      (connect D1:1 D2:0
       (Point 385 370)
       (Point 450 370)
       (Point 450 435)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 12 "Note"
   (name "The Complex Method:")
   (interface
   )
   (implementation
   )
   (views
    (icon
     (origin 110 238)
     (extent 181 25)
    )
    (detail
     (origin 53 408)
     (extent 274 25)
     (editing enabled)
    )
    (active icon)
   )
  )
  (component 13 "FromFile"
   (name "From File")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "numrow")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "numcol")
     (lock constraints)
     (optional yes)
    )
    (output 3
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath file read "/usr/lib/veetest/examples/concepts/optimize2.dat"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      EXECUTE REWIND
      READ TEXT numrow,numcol REAL COUNT:1
      READ TEXT x REAL COUNT:numrow,numcol
    )
   )
   (views
    (description 26 5
     This example uses the From File to to the entire
     read operation.  First, we rewind the data file,
     since it shares the same file pointer as the
     first method. (If we didn't we would get EOF on
     the first read attempt.).
     
     The next transaction reads the first two real
     numbers from the datafile into numrow and numcol
     output pins.  Note that we need not use the data
     sent to the pins outside the From File object;
     
     The third transaction reads the entire array from
     the datafile using the COUNT parameter to define
     the shape of the array (i.e., COUNT n,m means 2D
     array, n,m,l means 3D, etc.).  The actual values
     of the COUNT parameter are taken from the data
     previously read into the numrow and numcol output
     pins.  
     
     It is generally true that data READ into an output
     pin can be used by subsequent transactions any
     place a number would be allowed.  Although not
     illustrated in this example, a data Input pin 
     could be added to the From File device to allow
     another device to specify the COUNT parameters.
     
    )
    (icon
     (origin 85 398)
     (extent 110 25)
    )
    (detail
     (origin 43 674)
     (extent 514 113)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 14 "TextDisplay"
   (name "AlphaNumeric")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
    )
    (detail
     (origin 770 381)
     (extent 181 158)
    )
    (active detail)
   )
  )
  (component 15 "Note"
   (name "The Optimum Method:")
   (interface
   )
   (implementation
   )
   (views
    (icon
     (origin 120 598)
     (extent 181 25)
    )
    (detail
     (origin 183 478)
     (extent 274 25)
     (editing enabled)
    )
    (active icon)
   )
  )
  (configuration
   (connect D6:1 D1:1)
   (connect D4:1 D1:2)
   (connect D2:1 D1:3)
   (connect D3:1 D1:4)
   (connect D2:0 D1:5)
   (connect D9:1 D2:1)
   (connect D2:1 D3:0)
   (connect D9:2 D3:1)
   (connect D3:1 D4:0)
   (connect D1:1 D5:1)
   (connect D9:1 D6:1)
   (connect D9:2 D6:2)
   (connect D8:1 D7:1)
   (connect D13:3 D8:1)
   (connect D14:0 D13:0)
   (connect D5:1 D14:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 986 651)
   (configuration
    (connect D6:1 D1:1
     (Point 709 220)
     (Point 822 220)
    )
    (connect D4:1 D1:2
     (Point 712 500)
     (Point 730 500)
     (Point 730 230)
     (Point 822 230)
    )
    (connect D2:1 D1:3
     (Point 677 280)
     (Point 740 280)
     (Point 740 240)
     (Point 822 240)
    )
    (connect D3:1 D1:4
     (Point 697 370)
     (Point 750 370)
     (Point 750 250)
     (Point 822 250)
    )
    (connect D2:0 D1:5
     (Point 620 314)
     (Point 620 330)
     (Point 700 330)
     (Point 700 320)
     (Point 760 320)
     (Point 760 260)
     (Point 822 260)
    )
    (connect D9:1 D2:1
     (Point 507 330)
     (Point 530 330)
     (Point 530 280)
     (Point 562 280)
    )
    (connect D2:1 D3:0
     (Point 677 280)
     (Point 690 280)
     (Point 690 320)
     (Point 640 320)
     (Point 640 335)
    )
    (connect D9:2 D3:1
     (Point 507 370)
     (Point 582 370)
    )
    (connect D3:1 D4:0
     (Point 697 370)
     (Point 710 370)
     (Point 710 410)
     (Point 360 410)
     (Point 360 432)
    )
    (connect D1:1 D5:1
     (Point 937 240)
     (Point 950 240)
     (Point 950 280)
     (Point 810 280)
     (Point 810 300)
     (Point 822 300)
    )
    (connect D9:1 D6:1
     (Point 507 330)
     (Point 530 330)
     (Point 530 210)
     (Point 550 210)
    )
    (connect D9:2 D6:2
     (Point 507 370)
     (Point 540 370)
     (Point 540 230)
     (Point 550 230)
    )
    (connect D8:1 D7:1
     (Point 757 760)
     (Point 770 760)
     (Point 770 710)
     (Point 779 710)
    )
    (connect D13:3 D8:1
     (Point 629 760)
     (Point 642 760)
    )
    (connect D14:0 D13:0
     (Point 860 541)
     (Point 860 560)
     (Point 320 560)
     (Point 320 641)
    )
    (connect D5:1 D14:1
     (Point 937 300)
     (Point 950 300)
     (Point 950 330)
     (Point 760 330)
     (Point 760 380)
     (Point 750 380)
     (Point 750 460)
     (Point 767 460)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
