#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Wed 10/Apr/1991")
(component 0 "Context"
 (name "Instrument I/O Methods")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 562 99)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 1 "Start"
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 477 172)
     (extent 67 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "Constant"
   (name "Real")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Real")
     (datum 2345)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
    )
    (detail
     (origin 470 286)
     (extent 120 28)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 3 "Confirm"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Go")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 501 342)
     (extent 58 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "Constant"
   (name "Real")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Real")
     (datum 987000)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
    )
    (detail
     (origin 470 476)
     (extent 120 28)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 5 "HPIDIncr"
   (name "fgen")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "FREQUENCY")
     (tag "FREQUENCY")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (component driver "fgen")
    (component filename "hp3325b.cid")
   )
   (views
    (icon
     (origin 441 358)
     (extent 78 64)
     (iconImage io.icon)
    )
    (detail
     (origin 750 493)
     (extent 90 54)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 6 "Confirm"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Go")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 501 522)
     (extent 58 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "Constant"
   (name "Real")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Real")
     (datum 0.0123)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
    )
    (detail
     (origin 470 636)
     (extent 120 28)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 8 "HPIDState"
   (name "fgen")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "FREQUENCY")
     (tag "FREQUENCY")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (component driver "fgen")
    (component filename "hp3325b.cid")
    (component state
     (idComp
      (name "FUNCTION")
      (typeStr "Enum")
      (state "Valid")
      (value "SINE")
     )
     (idComp
      (name "FREQ_UPPER_LIM")
      (typeStr "Real")
      (state "Valid")
      (value 60999999.999)
     )
     (idComp
      (name "FREQUENCY")
      (typeStr "Real")
      (state "Valid")
      (value 2345)
     )
     (idComp
      (name "AMPLITUDE_LOWER_LIM")
      (typeStr "Real")
      (state "Valid")
      (value 0.001)
     )
     (idComp
      (name "AMPLITUDE_UPPER_LIM")
      (typeStr "Real")
      (state "Valid")
      (value 10)
     )
     (idComp
      (name "AMPLITUDE")
      (typeStr "Real")
      (state "Valid")
      (value 0.001)
     )
     (idComp
      (name "AUNITS")
      (typeStr "Enum")
      (state "Valid")
      (value "VPP")
     )
     (idComp
      (name "OFFSET_LOWER_LIM")
      (typeStr "Real")
      (state "Valid")
      (value -4.502)
     )
     (idComp
      (name "OFFSET_UPPER_LIM")
      (typeStr "Real")
      (state "Valid")
      (value 4.502)
     )
     (idComp
      (name "OFFSET")
      (typeStr "Real")
      (state "Valid")
      (value 0)
     )
     (idComp
      (name "PHASE")
      (typeStr "Real")
      (state "Valid")
      (value 0)
     )
     (idComp
      (name "START_FREQ")
      (typeStr "Real")
      (state "Valid")
      (value 1000000)
     )
     (idComp
      (name "STOP_FREQ")
      (typeStr "Real")
      (state "Valid")
      (value 10000000)
     )
     (idComp
      (name "MKR_FREQ")
      (typeStr "Real")
      (state "Valid")
      (value 5000000)
     )
     (idComp
      (name "SWEEP_TIME")
      (typeStr "Real")
      (state "Valid")
      (value 1)
     )
     (idComp
      (name "SWEEP_MODE")
      (typeStr "Enum")
      (state "Valid")
      (value "LIN")
     )
     (idComp
      (name "TERMINALS")
      (typeStr "Enum")
      (state "Valid")
      (value "FRONT")
     )
     (idComp
      (name "CALIBRATE")
      (typeStr "Enum")
      (state "Valid")
      (value "ENABLE")
     )
     (idComp
      (name "MOD_FUNCTION")
      (typeStr "Enum")
      (state "Valid")
      (value "OFF")
     )
     (idComp
      (name "MOD_FREQ_UPPER_LIM")
      (typeStr "Real")
      (state "Valid")
      (value 10000)
     )
     (idComp
      (name "MOD_FREQUENCY")
      (typeStr "Real")
      (state "Valid")
      (value 1000)
     )
     (idComp
      (name "MOD_AMP_UPPER_LIM")
      (typeStr "Real")
      (state "Valid")
      (value 12)
     )
     (idComp
      (name "MOD_AMPLITUDE")
      (typeStr "Real")
      (state "Valid")
      (value 0.1)
     )
     (idComp
      (name "MOD_AMPLITUDE_UNITS")
      (typeStr "Enum")
      (state "Valid")
      (value "VPP")
     )
     (idComp
      (name "AM")
      (typeStr "Enum")
      (state "Valid")
      (value "OFF")
     )
     (idComp
      (name "PM")
      (typeStr "Enum")
      (state "Valid")
      (value "OFF")
     )
     (idComp
      (name "INSTR_STATUS_MASK")
      (typeStr "Int")
      (state "Valid")
      (value 0)
     )
    )
   )
   (views
    (icon
     (origin 441 178)
     (extent 78 64)
     (iconImage inst.icon)
    )
    (detail
     (origin 718 224)
     (extent 214 213)
     (visiblePanels 5 "MAIN_PANEL" "ENTRY_PANEL" "STATE_SR" "CALIBRATE" "TOP_PANEL")
    )
    (terminals on)
    (active detail)
   )
  )
  (component 9 "IODevice"
   (name "fgen (hp3325b @ HP-IB 717)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (tag "A")
     (optional yes)
    )
   )
   (implementation
    (comp iopath "fgen")
    (procedure
      WRITE TEXT "FR",A,"HZ" EOL
    )
   )
   (views
    (icon
     (iconImage io.icon)
    )
    (detail
     (origin 643 602)
     (extent 284 96)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 10 "Note"
   (interface
   )
   (implementation
    (component text 93 5
     Purpose: To show the three methods in veetest
     for programming instruments.
     
     User Input Required: The .veeio file must
     contain an "fgen" device.
     
     Explanation:
     The three methods available in veetest for
     instrument programming are: "State Drivers",
     "Component Drivers", and "Direct I/O".  Any of
     these methods can used to control instruments
     which have been configured.  To use "State" or
     "Component Drivers", an Instrument Driver file
     must be available.  A library of Instrument
     Drives is provided with the product.  They
     are in /usr/lib/veetest/instruments.
     
     1. State Drivers - A State Driver provides
     one or more panels.  The fields on the panels
     behave much like fields in other objects in
     veetest.  Changing a field immediately sends
     commands over the interface to the instrument.
     
     Mutliple State Driver objects for the same
     instrument may appear in the same model. 
     Each instance represents a different state
     of the instrument.
     
     When a State Driver executes, veetest sends
     just enough commands to the instrument so 
     its state matches the state presented in all
     the panels, even the ones not visible.  If
     inputs are present, they are checked for 
     validity, copied to the internal state, then
     the instrument's state is programmed.
     
     This example shows an fgen "State Driver" 
     with an input added for the frequency 
     component.  When the model is run, the value 
     in the top real constant object is sent to
     the "State Driver".  The "State Driver" object
     programs the frequency of the fgen to that
     value.  If the instrument's state differs
     from any other value in a panel, that 
     component is also programmed.
     
     2. Component Driver - A "Component Driver"
     provides access through inputs to the same 
     components available with the "State Driver",
     but the panels are gone.  Thus, the overhead
     of maintaining the panels is obviated.
     
     Executing a Component Driver without inputs
     has no effect on the instrument.  Only the
     components which have inputs are programmed.
     
     In this example, when the middle real constant
     is executed, its value is sent to the 
     Component Driver.  Only the frequency of the
     fgen is programmed.
     
     3. Direct I/O - A "Direct I/O" object provides
     low level access to the instrument.  What is
     transmitted to and from the instrument is
     exactly specified in the transactions.  The
     codes and formats understood by the instrument
     must be handled properly.
     
     To program the frequency of the fgen, FR,
     followed by a number, followed by HZ must be
     sent.  
     
     Which to use when:
     1. State Driver - when lots of components
     change or the previous state is not exactly
     known, using a State Driver saves work.  
     Veetest tracks the current state of the 
     instrument so it knows the minimum number
     of commands to send.
     
     2. Component Driver - when only a few 
     components change, say inside a loop, the
     Component driver is a good choice.  It is 
     faster than the State Driver.
     
     3. Direct I/O - when an "Instrument Driver" is
     not available or maximum performance is 
     needed, "Direct I/O" is the right choice.
     Both "State" and "Component Drivers" know the
     codes and formats needed by the particular
     instrument.  With Direct I/O the proper codes
     and formats must be specified.
     
    )
   )
   (views
    (icon
    )
    (detail
     (origin 8 111)
     (extent 445 599)
     (editing disabled)
    )
    (active detail)
   )
  )
  (configuration
   (connect D1:0 D2:0)
   (connect D2:0 D3:0)
   (connect D3:1 D4:0)
   (connect D4:1 D5:1)
   (connect D4:0 D6:0)
   (connect D6:1 D7:0)
   (connect D2:1 D8:1)
   (connect D7:1 D9:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 977 658)
   (configuration
    (connect D1:0 D2:0
     (Point 510 211)
     (Point 510 230)
     (Point 530 230)
     (Point 530 253)
    )
    (connect D2:0 D3:0
     (Point 530 316)
     (Point 530 339)
    )
    (connect D3:1 D4:0
     (Point 561 360)
     (Point 580 360)
     (Point 580 400)
     (Point 530 400)
     (Point 530 443)
    )
    (connect D4:1 D5:1
     (Point 592 490)
     (Point 610 490)
     (Point 610 520)
     (Point 647 520)
    )
    (connect D4:0 D6:0
     (Point 530 506)
     (Point 530 519)
    )
    (connect D6:1 D7:0
     (Point 561 540)
     (Point 580 540)
     (Point 580 580)
     (Point 530 580)
     (Point 530 603)
    )
    (connect D2:1 D8:1
     (Point 592 300)
     (Point 600 300)
     (Point 600 330)
     (Point 615 330)
    )
    (connect D7:1 D9:1
     (Point 592 650)
     (Point 600 650)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
