#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name "Torsion Bar Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Note"
   (name "Note for Torsion Bar Example")
   (interface
   )
   (implementation
    (component text 6 5
     Calculates the angular deflection of a round
       shaft and displays results graphically.
     
     User Data required: None for example; click
      "Start" or "Run" to see example results.
     For more details, click "Info".
    )
   )
   (views
    (description 1 5
     Object "Display -> Note Pad"
    )
    (icon
     (origin 465 168)
     (extent 262 25)
    )
    (detail
     (origin 524 122)
     (extent 433 116)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 1 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 5 5
     This example is provided as an
     illustration "as is", and
     Hewlett-Packard Company makes
     no warranty of any kind with 
     regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 188 128)
     (extent 325 104)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 2 "IfThenElse"
   (name "!=0")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "A!=0")
   )
   (views
    (description 10 5
      This "Flow -> If/Then" object is being used with
      the "Info" toggle button to provide feedback
      control to prevent activation from "Run".  If
      the toggle has been activated to provide an
      output of one, then downstream objects will also
      be activated.  When the If/Then object has
      completed its function, the sequence output pin
      on the bottom will activate the Reset input pin 
      on the toggle button.
     
    )
    (icon
     (origin 87 108)
     (extent 46 25)
    )
    (detail
     (origin 183 111)
     (extent 64 59)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "Toggle"
   (name "Info")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type control)
     (name "Reset")
     (lock name constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Info")
     (values range 0 1)
     (datum 0)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (description 11 5
      This "Data -> Toggle" object, configured in the
      button mode, is used as a switch to activate the
      "Info" object.  Use of this object coupled with
      the "If/Then" object prevents activation of
      downstream objects when "Run" is used, instead
      of "Start".  "Run" normally activates all streams
      used in the model.  In this case, activation is
      prevented, since the button must be clicked to
      output a 1 value to the if/then object.  The
      Reset input pin ensures that activation will only
      occur once for each time the button is clicked.
    )
    (icon
     (origin 20 101)
     (extent 60 39)
     (format button)
    )
    (detail
     (origin 45 173)
     (extent 30 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "Start"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 46 191)
     (extent 69 39)
    )
    (detail
     (origin 309 110)
     (extent 82 20)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "TextDisplay"
   (name "Young\'s Mod.")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (description 8 5
     This "Display -> AlphaNumeric" object displays
     the modulus of elasticity value output by the
     "Modulus of Elasticity/Rigidity" object.  In
     this example, it is actually superfluous data,
     since it is not actually used.  It does confirm
     that the enum selection method can be employed
     to generate multiple output values from one
     selection input.
    )
    (icon
     (extent 118 0)
    )
    (detail
     (origin 494 283)
     (extent 192 35)
     (formatter
      (realFormat engineering)
      (realSigDigits 16)
      (realRadixSpec 1)
      (integerBase decimal)
     )
    )
    (active detail)
   )
  )
  (component 6 "ForRange"
   (name "MaxTorq in-lb")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component from 250)
    (component thru 2750)
    (component step 500)
   )
   (views
    (description 9 5
     This "Flow -> Repeat -> For Range" object is
     used to specify the Torque range values, in
     inch-pounds, to be applied to the torsion bar
     being considered as individual values under the
     control of a "for loop".  This method is another,
     simpler way of obtaining individual range values,
     as compared to the method used for the diameter
     range values above.
     
    )
    (icon
     (extent 127 0)
     (iconImage loop.icon)
    )
    (detail
     (origin 238 399)
     (extent 184 82)
    )
    (active detail)
   )
  )
  (component 7 "Constant"
   (name "MinDia.")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "MinDia.")
     (datum 0.5)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (description 7 5
     This "Data -> Constant -> Real" object is used
     to enter the value for the minimum diameter, in
     inches, for the torsion bar diameter range to be
     used in later calculations and plots.
     
     See also "step", and especially "MaxDia. in."
     for an alternative method.
    )
    (icon
     (origin 151 408)
     (extent 78 25)
    )
    (detail
     (origin 8 615)
     (extent 164 31)
    )
    (active detail)
   )
  )
  (component 8 "Constant"
   (name "MaxDia. in.")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "MaxDia. in.")
     (datum 2.5)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 1)
    )
   )
   (views
    (description 13 5
     This "Data -> Constant -> Real" object is used
     to enter the value for the maximum diameter, in
     inches, of the torsion bar diameter range to be
     used in later calculations and plots.
     
     For an alternative, simpler method of generating
     individual range values, which may be useful in
     many other situations, please check the
     "Show Description" for the "MaxTorq in-lb"
     object below.
     
     See also "step" and "MinDia."
     
    )
    (icon
     (extent 110 0)
    )
    (detail
     (origin 9 537)
     (extent 183 27)
    )
    (active detail)
   )
  )
  (component 9 "Constant"
   (name "step")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "step")
     (datum 0.1)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (description 8 5
     This "Data -> Constant -> Real" object is used
     to enter the value of the diameter step size, in
     inches, for the torsion bar diameter range to be
     used in later calculations and plots.
     
     See also "MinDia.", and especially "MaxDia. in." 
     for another method that is often simpler in some
     situations.
    )
    (icon
     (origin 107 288)
     (extent 46 25)
    )
    (detail
     (origin 7 695)
     (extent 166 31)
    )
    (active detail)
   )
  )
  (component 10 "Formula"
   (name "TotCount")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Dmax")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Dmin")
     (optional yes)
    )
    (input 3
     (type data)
     (name "Dstep")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "(Dmax-Dmin)/Dstep+1")
   )
   (views
    (description 5 5
     This "Math -> Formula" object determines the
     number of steps to be used with the diameter size
     range specified, and determines the array size to
     be created for later calculations, etc.
      
    )
    (icon
     (origin 235 613)
     (extent 110 34)
    )
    (detail
     (origin 243 283)
     (extent 205 154)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "Formula"
   (name "Generate Pts")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "max")
     (optional yes)
    )
    (input 2
     (type data)
     (name "min")
     (optional yes)
    )
    (input 3
     (type data)
     (name "numPts")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "ramp(numPts,min,max)")
   )
   (views
    (icon
     (origin 381 603)
     (extent 118 34)
    )
    (detail
     (origin 329 523)
     (extent 223 154)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 12 "TextDisplay"
   (name "Shear Mod.")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (description 7 5
     This "Display -> AlphaNumeric" object displays
     the shear modulus value generated by the
     "Modulus of Elasticity/Rigidity" object upstream.
     This object has been added to the panel view, to
     provide a confirmation of actual modulus value,
     after a "Matl" selection has been made.
     
    )
    (icon
     (extent 110 0)
    )
    (detail
     (origin 494 363)
     (extent 192 35)
     (formatter
      (realFormat engineering)
      (realSigDigits 16)
      (realRadixSpec 1)
      (integerBase decimal)
     )
    )
    (active detail)
   )
  )
  (component 13 "Constant"
   (name "Length, in.")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Length, in.")
     (datum 10)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 10)
    )
   )
   (views
    (description 3 5
     This "Data -> Constant -> Real" object is used
     to enter the value for the effective length, in
     inches, of the torsion bar under consideration.
    )
    (icon
     (extent 110 0)
    )
    (detail
     (origin 229 714)
     (extent 162 32)
    )
    (active detail)
   )
  )
  (component 14 "Note"
   (interface
   )
   (implementation
    (component text 2 5
     Multiple graphs
     based on Torque
    )
   )
   (views
    (description 4 5
     This "Display -> Note Pad" object is being used
     to annunciate the panel view of the X vs Y Plot
     device.  In that situation, it is shown without
     displaying the title.
    )
    (icon
    )
    (detail
     (origin 1014 248)
     (extent 152 45)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 15 "EnumConstant"
   (name "Matl")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Enum
     (name "Matl")
     (values
      ( "CrMoSteel" 0)
      ( "Steel" 1)
      ( "Brass" 2)
      ( "Alum" 3)
      ( "Enter Value" 4)
     )
     (datum "CrMoSteel")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Enum
     (shared yes)
     (datum "CrMoSteel")
    )
   )
   (views
    (description 12 5
     This is a "Data -> Enum" object, with the
     "Format -> Buttons" option on the object menu
     enabled.  It provides a means for a quick,
     graphical method of choosing defined, often used
     items from a list, rather than entering specific
     values.  However, it must be used with a means
     for deciphering the actual values used.
     
     See also the "Modulus of Elasticity/Rigidity"
     object iconized below, which provides the actual
     values.
     
    )
    (icon
     (extent 46 0)
    )
    (detail
     (origin 10 297)
     (extent 160 126)
     (format buttons)
    )
    (active detail)
   )
  )
  (component 16 "Context"
   (name "Overview of Torsion Bar Example")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Note"
     (name "Note Pad")
     (interface
     )
     (implementation
      (component text 41 7
       PURPOSE:  This example is designed to show the application of some of HP VEE's
       		  capability to a mechanical engineering problem setup and solution.  It shows
       		  various data entry and display methods, and the use of a calculation formula.
       
       USER INPUT REQUIRED: None, to run example data.  All data may be changed.
       
       EXPLANATION: The model uses a simple formula to calculate the angular deflection of a
        round torsion shaft, given a range of diameters, length, a range for applied torque,
        and material shear modulus value, which in this example is selected by clicking the
        button next to the type of material desired.  However, if "Enter Value" is selected,
        a "pop up" screen for entering values appears after "Start" is activated.  While both
        "Young's Modulus" and "Shear Modulus" appear, only the shear modulus is actually used
        in this example, it shows that multiple values may be selected with an Enum object.
       
        The data is displayed graphically as Deflection Degrees versus Shaft Diameter, with
        multiple graphs based on Torque range.  The graphical display object may be altered
        for appearance or functional reasons by selecting various options from the object
        menu.  For instance, by selecting "Traces & Scales.." and clicking on the X column
        "Linear" switch, the X values may also be shown on a log scale.  Note the triangular
        marker, which will indicate the exact values (shown at the bottom of display), when
        a desired location is clicked.
       
        The model was built using the "panel" approach for simplified data entry and viewing.
        More specifics of the model can be seen by clicking on the "Detail" button above the
        menu bar.  In this mode, specific objects used in model construction can be observed.
        Most objects have been iconized to save space.  Open by double clicking on icon.  
       
       To exit "Info", click on "OK" below.  Use the slider at right for additional text.
       
        Some icons are actually "UserObjects", which are used to group other sets of objects.
        All objects in a UserObject will be run when the UserObject is activated, before flow
        is passed to the next object beyond the UserObject.  To observe flow of execution and
        data flow, use the "Edit" menu, and select "Show Exec Flow" and/or "Show Data Flow".
        For example, the method of actuating the pop-up panel mentioned above requires a
        "Show on Exec" UserObject ("Enter Modulus") actually nested in the large iconized
        UserObject at the bottom of the work area, called "Modulus of Elasticity/Rigidity".
       
        Please use "Show Description" from the object menu of a specific object, since most
        objects in this example contain additional information on the "Show Description"
        pop-up panel. You may also use "Help" for further information on specific objects and
        concepts.
      )
     )
     (views
      (icon
       (origin 385 288)
       (extent 110 25)
      )
      (detail
       (origin 102 199)
       (extent 676 402)
       (editing disabled)
      )
      (active detail)
     )
    )
    (component 1 "Confirm"
     (name " OK ")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 31 222)
       (extent 58 37)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
    )
    (ShowOnExecPanel
     (origin 55 86)
     (extent 843 615)
     (panel
      (origin 1 112)
      (extent 839 577)
      (widget 1 icon
       (title off)
       (origin 381 644)
       (extent 58 37)
      )
      (widget 0 detail
       (title off)
       (origin 13 124)
       (extent 812 509)
       (editing disabled)
      )
     )
    )
   )
   (views
    (description 3 5
      This "Device -> UserObject" is used to display a
      panel containing the Note Pad used to provide an
      overview and details of this example.
    )
    (icon
     (origin 130 148)
     (extent 40 24)
     (label off)
    )
    (detail
     (origin 32 164)
     (extent 757 452)
     (configuration
     )
    )
    (active icon)
   )
  )
  (component 17 "Formula"
   (name "Formula")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "G")
     (optional yes)
    )
    (input 2
     (type data)
     (name "D")
     (optional yes)
    )
    (input 3
     (type data)
     (name "T")
     (optional yes)
    )
    (input 4
     (type data)
     (name "L")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "((180*32)/(pi)^2)*T*L/(G*(D^4))")
   )
   (views
    (description 5 5
     This "Math -> Formula" object calculates an
     array of deflection values over the range of
     diameter sizes specified, and becomes the 
     "Y input" value for the plot.
      
    )
    (icon
     (origin 541 638)
     (extent 78 64)
     (iconImage formula.icon)
    )
    (detail
     (origin 409 638)
     (extent 313 204)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 18 "XYPlot"
   (name "Angular Deflection vs. Diameter and Torque")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "XData")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "Deflection")
     (lock constraints)
    )
    (input 3
     (type control)
     (name "Next Curve")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 2)
    (component graphMode rectangular)
   )
   (views
    (description 5 5
     This is a "Display -> X vsY Plot" object, which
     displays the angular deflection in degrees for
     various shaft sizes in inches, and which uses a
     "Next Curve" input to show several graphs based
     on changes in shear modulus values.
    )
    (icon
     (origin 6 448)
     (extent 388 64)
     (iconImage display.icon)
    )
    (detail
     (origin 694 334)
     (extent 512 452)
     (displayMode scrollGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Degrees")
      (domainName "Shaft Diameter, inches")
      (color 0x909090)
      (show 1)
      (range 0.04279806797052348 42.79806797052348 3 log)
     )
     (domain 0.4 2.6 3 linear)
     (trace 0 onScale 0
      (name "Deflection")
      (color 0xffdd00)
      (lineType 1)
      (pointType 0)
     )
    )
    (active detail)
   )
  )
  (component 19 "Context"
   (name "Modulus of Elasticity/Rigidity")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Data")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "Data")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Junction"
     (name "JCT")
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
       (optional yes)
      )
      (input 3
       (type data)
       (name "C")
       (lock name constraints)
       (optional yes)
      )
      (input 4
       (type data)
       (name "D")
       (lock name constraints)
       (optional yes)
      )
      (input 5
       (type data)
       (name "E")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 727 253)
       (extent 46 54)
      )
      (detail
       (origin 695 168)
       (extent 42 204)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Junction"
     (name "JCT")
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
       (optional yes)
      )
      (input 3
       (type data)
       (name "C")
       (lock name constraints)
       (optional yes)
      )
      (input 4
       (type data)
       (name "D")
       (lock name constraints)
       (optional yes)
      )
      (input 5
       (type data)
       (name "E")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 727 573)
       (extent 46 54)
      )
      (detail
       (origin 855 678)
       (extent 42 204)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Constant"
     (name "Shear Mod.")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Shear Mod.")
       (datum 3700000)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 474 678)
       (extent 110 25)
      )
      (detail
       (origin 444 686)
       (extent 172 29)
      )
      (active icon)
     )
    )
    (component 3 "Constant"
     (name "Shear Mod.")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Shear Mod.")
       (datum 6000000)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 474 618)
       (extent 110 25)
      )
      (detail
       (origin 444 626)
       (extent 172 29)
      )
      (active icon)
     )
    )
    (component 4 "Constant"
     (name "Shear Mod.")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Shear Mod.")
       (datum 10600000)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 474 558)
       (extent 110 25)
      )
      (detail
       (origin 442 564)
       (extent 177 33)
      )
      (active icon)
     )
    )
    (component 5 "Constant"
     (name "Shear Mod.")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Shear Mod.")
       (datum 11900000)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 474 498)
       (extent 110 25)
      )
      (detail
       (origin 443 505)
       (extent 174 31)
      )
      (active icon)
     )
    )
    (component 6 "Constant"
     (name "Young\'s Mod.")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Young\'s Mod.")
       (datum 10000000)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (description 3 7
       This is a "Data, Constant, Real" object used to
       hold Young's Modulus for Alum.
       
      )
      (icon
       (origin 470 318)
       (extent 118 25)
      )
      (detail
       (origin 412 316)
       (extent 176 29)
      )
      (active icon)
     )
    )
    (component 7 "IfThenElse"
     (name "If/Then")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else If")
       (lock name constraints)
      )
      (output 3
       (type data)
       (name "Else If")
       (lock name constraints)
      )
      (output 4
       (type data)
       (name "Else If")
       (lock name constraints)
      )
      (output 5
       (type data)
       (name "Else If")
       (lock name constraints)
      )
      (output 6
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "A==\"CrMoSteel\"")
      (component expr "A==\"Steel\"")
      (component expr "A==\"Brass\"")
      (component expr "A==\"Alum\"")
      (component expr "A==\"Enter Value\"")
     )
     (views
      (icon
       (origin 441 378)
       (extent 78 25)
      )
      (detail
       (origin 105 178)
       (extent 172 184)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 8 "Constant"
     (name "Young\'s Mod.")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Young\'s Mod.")
       (datum 30000000)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (description 3 7
       This is a "Data, Constant, Real" object used to
       hold Young's Modulus for CrMoSteel.
       
      )
      (icon
       (origin 471 158)
       (extent 118 25)
      )
      (detail
       (origin 442 166)
       (extent 176 29)
      )
      (active icon)
     )
    )
    (component 9 "Constant"
     (name "Young\'s Mod.")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Young\'s Mod.")
       (datum 29000000)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (description 4 7
       This is a "Data, Constant, Real" object used to
       hold Young's Modulus for Steel.
       
       
      )
      (icon
       (origin 470 208)
       (extent 118 25)
      )
      (detail
       (origin 511 206)
       (extent 176 29)
      )
      (active icon)
     )
    )
    (component 10 "Constant"
     (name "Young\'s Mod.")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Young\'s Mod.")
       (datum 15900000)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (description 3 7
       This is a "Data, Constant, Real" object used to
       hold Young's Modulus for Brass.
       
      )
      (icon
       (origin 470 258)
       (extent 118 25)
      )
      (detail
       (origin 511 256)
       (extent 176 29)
      )
      (active icon)
     )
    )
    (component 11 "Context"
     (name "Enter Modulus")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "YMod")
       (lock constraints)
       (optional yes)
      )
      (output 2
       (type data)
       (name "SMod")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Constant"
       (name "Young\'s Mod.")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (lock name constraints)
        )
       )
       (implementation
        (component value Real
         (name "Young\'s Mod.")
         (datum 24400000)
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Real
         (datum 0)
        )
       )
       (views
        (description 4 9
         This is a "Data, Constant, Real" object.
         It is being used to enter Young's Modulus, and
         the initial value (24.4E6 psi) is an average for 
         Ductile Iron
        )
        (icon
         (extent 118 0)
        )
        (detail
         (origin 438 315)
         (extent 172 30)
         (showFormat real)
        )
        (active detail)
       )
      )
      (component 1 "Constant"
       (name "Shear Mod.")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (lock name constraints)
        )
       )
       (implementation
        (component value Real
         (name "Shear Mod.")
         (datum 9500000)
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Real
         (datum 0)
        )
       )
       (views
        (description 4 9
         This is a "Data, Constant, Real" object.
         It is being used to enter the Shear Modulus, and
         the initial value (9.0E6 psi) is an average for
         Ductile Iron.
        )
        (icon
         (extent 110 0)
        )
        (detail
         (origin 437 406)
         (extent 174 28)
         (showFormat real)
        )
        (active detail)
       )
      )
      (component 2 "Confirm"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 555 472)
         (extent 58 37)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (component 3 "Note"
       (name "Done")
       (interface
       )
       (implementation
        (component text 2 9
         "OK" executes the
           entered data.
        )
       )
       (views
        (icon
         (extent 46 0)
        )
        (detail
         (origin 430 483)
         (extent 120 35)
         (editing disabled)
        )
        (active detail)
       )
      )
      (configuration
       (connect D2:0 D0:0)
       (connect D2:0 D1:0)
       (connect D0:1 O1:1)
       (connect D1:1 O2:1)
      )
      (ShowOnExecPanel
       (origin 167 456)
       (extent 267 252)
       (panel
        (origin 409 303)
        (extent 263 214)
        (widget 2 icon
         (title off)
         (origin 606 462)
         (extent 48 39)
        )
        (widget 1 detail
         (title on)
         (origin 449 420)
         (extent 187 28)
         (showFormat real)
        )
        (widget 0 detail
         (title on)
         (origin 448 348)
         (extent 188 27)
         (showFormat real)
        )
        (widget 3 detail
         (title off)
         (origin 431 462)
         (extent 163 39)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 487 398)
       (extent 127 25)
      )
      (detail
       (origin 411 257)
       (extent 239 286)
       (configuration
        (connect D2:0 D0:0
         (Point 584 511)
         (Point 584 530)
         (Point 640 530)
         (Point 640 360)
         (Point 630 360)
         (Point 630 270)
         (Point 524 270)
         (Point 524 282)
        )
        (connect D2:0 D1:0
         (Point 584 511)
         (Point 584 530)
         (Point 640 530)
         (Point 640 360)
         (Point 524 360)
         (Point 524 373)
        )
        (connect D0:1 O1:1
         (Point 612 330)
         (Point 647 330)
        )
        (connect D1:1 O2:1
         (Point 613 420)
         (Point 630 420)
         (Point 630 490)
         (Point 647 490)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D8:1 D0:1)
     (connect D9:1 D0:2)
     (connect D10:1 D0:3)
     (connect D6:1 D0:4)
     (connect D11:1 D0:5)
     (connect D11:2 D1:1)
     (connect D5:1 D1:2)
     (connect D4:1 D1:3)
     (connect D3:1 D1:4)
     (connect D2:1 D1:5)
     (connect D7:3 D3:0)
     (connect D7:2 D4:0)
     (connect D7:1 D5:0)
     (connect D7:4 D6:0)
     (connect I1:1 D7:1)
     (connect D7:1 D8:0)
     (connect D7:2 D9:0)
     (connect D7:3 D10:0)
     (connect D7:5 D11:0)
     (connect D0:1 O1:1)
     (connect D1:1 O2:1)
    )
   )
   (views
    (description 11 5
     This "Device -> UserObject" is an object which
     allows a collection of objects to function as a
     unit, such as a subprogram.  In this case, the
     collection of objects deciphers the enum value
     of the "Matl" object, converting this to an
     actual value for the Modulus of Rigidity of the
     material selected, or allowing input of the
     modulus value, if "Enter Value" was chosen.
     
     Double clicking on the icon will enable the open
     view, so details may be seen.
    )
    (icon
     (origin 190 288)
     (extent 280 25)
    )
    (detail
     (origin 45 117)
     (extent 760 626)
     (configuration
      (connect D8:1 D0:1
       (Point 591 170)
       (Point 630 170)
       (Point 630 260)
       (Point 724 260)
      )
      (connect D9:1 D0:2
       (Point 590 220)
       (Point 620 220)
       (Point 620 270)
       (Point 724 270)
      )
      (connect D10:1 D0:3
       (Point 590 270)
       (Point 610 270)
       (Point 610 280)
       (Point 724 280)
      )
      (connect D6:1 D0:4
       (Point 590 330)
       (Point 610 330)
       (Point 610 290)
       (Point 724 290)
      )
      (connect D11:1 D0:5
       (Point 616 400)
       (Point 630 400)
       (Point 630 300)
       (Point 724 300)
      )
      (connect D11:2 D1:1
       (Point 616 420)
       (Point 630 420)
       (Point 630 580)
       (Point 724 580)
      )
      (connect D5:1 D1:2
       (Point 586 510)
       (Point 610 510)
       (Point 610 590)
       (Point 724 590)
      )
      (connect D4:1 D1:3
       (Point 586 570)
       (Point 600 570)
       (Point 600 600)
       (Point 724 600)
      )
      (connect D3:1 D1:4
       (Point 586 630)
       (Point 600 630)
       (Point 600 610)
       (Point 724 610)
      )
      (connect D2:1 D1:5
       (Point 586 690)
       (Point 610 690)
       (Point 610 620)
       (Point 724 620)
      )
      (connect D7:3 D3:0
       (Point 359 250)
       (Point 450 250)
       (Point 450 600)
       (Point 529 600)
       (Point 529 615)
      )
      (connect D7:2 D4:0
       (Point 359 220)
       (Point 380 220)
       (Point 380 270)
       (Point 370 270)
       (Point 370 540)
       (Point 529 540)
       (Point 529 555)
      )
      (connect D7:1 D5:0
       (Point 359 190)
       (Point 390 190)
       (Point 390 440)
       (Point 529 440)
       (Point 529 495)
      )
      (connect D7:4 D6:0
       (Point 359 280)
       (Point 380 280)
       (Point 380 300)
       (Point 529 300)
       (Point 529 315)
      )
      (connect I1:1 D7:1
       (Point 47 440)
       (Point 60 440)
       (Point 60 380)
       (Point 50 380)
       (Point 50 270)
       (Point 62 270)
      )
      (connect D7:1 D8:0
       (Point 359 190)
       (Point 380 190)
       (Point 380 140)
       (Point 530 140)
       (Point 530 155)
      )
      (connect D7:2 D9:0
       (Point 359 220)
       (Point 380 220)
       (Point 380 200)
       (Point 529 200)
       (Point 529 205)
      )
      (connect D7:3 D10:0
       (Point 359 250)
       (Point 529 250)
       (Point 529 255)
      )
      (connect D7:5 D11:0
       (Point 359 310)
       (Point 380 310)
       (Point 380 360)
       (Point 550 360)
       (Point 550 395)
      )
      (connect D0:1 O1:1
       (Point 775 280)
       (Point 802 280)
      )
      (connect D1:1 O2:1
       (Point 775 600)
       (Point 802 600)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (configuration
   (connect D3:1 D2:1)
   (connect D2:0 D3:1)
   (connect D19:1 D5:1)
   (connect D19:0 D6:0)
   (connect D8:1 D10:1)
   (connect D7:1 D10:2)
   (connect D9:1 D10:3)
   (connect D8:1 D11:1)
   (connect D7:1 D11:2)
   (connect D10:1 D11:3)
   (connect D19:2 D12:1)
   (connect D4:0 D15:0)
   (connect D2:1 D16:0)
   (connect D19:2 D17:1)
   (connect D11:1 D17:2)
   (connect D6:1 D17:3)
   (connect D13:1 D17:4)
   (connect D11:1 D18:1)
   (connect D17:1 D18:2)
   (connect D6:1 D18:3)
   (connect D15:1 D19:1)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 908 648)
   (widget 4 icon
    (title off)
    (origin 53 138)
    (extent 69 39)
   )
   (widget 3 icon
    (title off)
    (origin 54 85)
    (extent 69 38)
    (format button)
   )
   (widget 18 detail
    (title on)
    (origin 179 244)
    (extent 721 467)
    (displayMode annotGraph)
    (graphType cartesian)
    (gridType grid)
    (scale 0
     (name "Degrees")
     (domainName "Shaft Diameter, inches")
     (color 0x909090)
     (show 1)
     (range 0.01 100 4 log)
    )
    (domain 0.5 2 3 linear)
    (trace 0 onScale 0
     (name "Deflection")
     (color 0xffdd00)
     (lineType 1)
     (pointType 0)
    )
    (marker 0 onTrace 0)
   )
   (widget 14 detail
    (title off)
    (origin 693 296)
    (extent 152 45)
    (editing disabled)
   )
   (widget 12 detail
    (title on)
    (origin 9 679)
    (extent 152 32)
    (formatter
     (realFormat engineering)
     (realSigDigits 16)
     (realRadixSpec 1)
     (integerBase decimal)
    )
   )
   (widget 6 detail
    (title on)
    (origin 10 424)
    (extent 153 76)
   )
   (widget 13 detail
    (title on)
    (origin 11 359)
    (extent 153 25)
   )
   (widget 8 detail
    (title on)
    (origin 10 294)
    (extent 153 25)
   )
   (widget 7 detail
    (title on)
    (origin 10 230)
    (extent 153 24)
   )
   (widget 1 detail
    (title on)
    (origin 593 106)
    (extent 308 99)
    (editing disabled)
   )
   (widget 0 detail
    (title off)
    (origin 179 73)
    (extent 410 132)
    (editing disabled)
   )
   (widget 15 detail
    (title on)
    (origin 10 540)
    (extent 152 101)
    (format buttons)
   )
  )
  (detail
   (origin 0 67)
   (extent 980 638)
   (configuration
    (connect D3:1 D2:1
     (Point 82 120)
     (Point 90 120)
     (Point 90 110)
     (Point 70 110)
     (Point 70 120)
     (Point 84 120)
    )
    (connect D2:0 D3:1
     (Point 110 135)
     (Point 110 160)
     (Point 10 160)
     (Point 10 120)
     (Point 17 120)
    )
    (connect D19:1 D5:1
     (Point 472 290)
     (Point 480 290)
     (Point 480 300)
     (Point 491 300)
    )
    (connect D19:0 D6:0
     (Point 330 315)
     (Point 330 340)
     (Point 330 340)
     (Point 330 366)
    )
    (connect D8:1 D10:1
     (Point 194 550)
     (Point 210 550)
     (Point 210 620)
     (Point 232 620)
    )
    (connect D7:1 D10:2
     (Point 174 630)
     (Point 232 630)
    )
    (connect D9:1 D10:3
     (Point 175 710)
     (Point 200 710)
     (Point 200 640)
     (Point 232 640)
    )
    (connect D8:1 D11:1
     (Point 194 550)
     (Point 210 550)
     (Point 210 590)
     (Point 360 590)
     (Point 360 610)
     (Point 378 610)
    )
    (connect D7:1 D11:2
     (Point 174 630)
     (Point 220 630)
     (Point 220 600)
     (Point 350 600)
     (Point 350 620)
     (Point 378 620)
    )
    (connect D10:1 D11:3
     (Point 347 630)
     (Point 378 630)
    )
    (connect D19:2 D12:1
     (Point 472 310)
     (Point 480 310)
     (Point 480 320)
     (Point 470 320)
     (Point 470 380)
     (Point 491 380)
    )
    (connect D4:0 D15:0
     (Point 80 232)
     (Point 80 240)
     (Point 90 240)
     (Point 90 264)
    )
    (connect D2:1 D16:0
     (Point 135 110)
     (Point 150 110)
     (Point 150 145)
    )
    (connect D19:2 D17:1
     (Point 472 310)
     (Point 480 310)
     (Point 480 320)
     (Point 470 320)
     (Point 470 420)
     (Point 510 420)
     (Point 510 650)
     (Point 538 650)
    )
    (connect D11:1 D17:2
     (Point 501 620)
     (Point 520 620)
     (Point 520 660)
     (Point 538 660)
    )
    (connect D6:1 D17:3
     (Point 424 440)
     (Point 530 440)
     (Point 530 670)
     (Point 538 670)
    )
    (connect D13:1 D17:4
     (Point 393 730)
     (Point 410 730)
     (Point 410 680)
     (Point 538 680)
    )
    (connect D11:1 D18:1
     (Point 501 620)
     (Point 520 620)
     (Point 520 550)
     (Point 670 550)
     (Point 670 410)
     (Point 691 410)
    )
    (connect D17:1 D18:2
     (Point 621 670)
     (Point 640 670)
     (Point 640 560)
     (Point 691 560)
    )
    (connect D6:1 D18:3
     (Point 424 440)
     (Point 530 440)
     (Point 530 620)
     (Point 650 620)
     (Point 650 710)
     (Point 691 710)
    )
    (connect D15:1 D19:1
     (Point 172 360)
     (Point 180 360)
     (Point 180 300)
     (Point 187 300)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
