#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name "PID Control Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Formula"
   (name "Select 1st/2nd")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (optional yes)
    )
    (input 3
     (type data)
     (name "LOAD")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "(ordinal(load) ? b : a)")
   )
   (views
    (icon
     (origin 472 503)
     (extent 136 34)
    )
    (detail
     (origin 540 423)
     (extent 241 154)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 1 "EnumConstant"
   (name "SIMULATED LOAD")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Enum
     (name "SIMULATED LOAD")
     (values
      ( "1st Order" 0)
      ( "2nd Order" 1)
     )
     (datum "2nd Order")
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Enum
     (shared yes)
     (datum "2nd Order")
    )
   )
   (views
    (icon
     (origin 42 528)
     (extent 136 25)
    )
    (detail
     (origin 245 627)
     (extent 210 26)
     (format cyclic)
    )
    (active detail)
   )
  )
  (component 2 "Formula"
   (name "2nd Order Load1")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Zi")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "(A*5)+Zi")
   )
   (views
    (icon
     (origin 278 468)
     (extent 145 25)
    )
    (detail
     (origin 413 333)
     (extent 124 154)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "Formula"
   (name "2nd Order Load2")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Zi")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "((A*.52)+Zi)/2")
   )
   (views
    (icon
     (origin 278 518)
     (extent 145 25)
    )
    (detail
     (origin 382 383)
     (extent 187 154)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "RepeatUntilBreak"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 5 218)
     (extent 110 64)
     (iconImage loop.icon)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "Start"
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 27 162)
     (extent 67 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 532 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 7 "YPlot"
   (name "SETPOINT vs MEASURED LOAD")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "SETPT")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "ACTUAL")
     (lock constraints)
     (optional yes)
    )
    (input 3
     (type control)
     (name "Clear")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 0)
    (component tracePin 1)
    (component tracePin 2)
    (component graphMode strip)
   )
   (views
    (icon
     (origin 573 638)
     (extent 235 64)
     (iconImage display.icon)
    )
    (detail
     (origin 443 517)
     (extent 495 186)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType axis)
     (scale 0
      (name "LOAD")
      (domainName "    ")
      (color 0x909090)
      (show 1)
      (range -0.5 1.5 3 linear)
     )
     (domain 0 99.99999999999977 4 linear)
     (trace 0 onScale 0
      (name "SETPT")
      (color 0xffdd00)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "ACTUAL")
      (color 0xccff)
      (lineType 1)
      (pointType 0)
     )
     (stepSize 1)
     (trackingEnabled 1)
    )
    (active icon)
   )
  )
  (component 8 "Context"
   (name "PID Controller")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Setpt")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Actual")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Output")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "Locked")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Slider"
     (name "Ki")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "MaxValue")
       (tag "MaxValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (input 2
       (type control)
       (name "MinValue")
       (tag "MinValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Ki")
       (values range 0 1)
       (datum 0.169)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0.226)
      )
      (component detents 0.001)
     )
     (views
      (icon
       (extent 46 0)
      )
      (detail
       (origin 218 159)
       (extent 85 143)
      )
      (active detail)
     )
    )
    (component 1 "Slider"
     (name "Kd")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "MaxValue")
       (tag "MaxValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (input 2
       (type control)
       (name "MinValue")
       (tag "MinValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Kd")
       (values range 0 1)
       (datum 0.37)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0.376)
      )
      (component detents 0.001)
     )
     (views
      (icon
       (extent 46 0)
      )
      (detail
       (origin 330 158)
       (extent 80 144)
      )
      (active detail)
     )
    )
    (component 2 "Slider"
     (name "Kp")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "MaxValue")
       (tag "MaxValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (input 2
       (type control)
       (name "MinValue")
       (tag "MinValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Kp")
       (values range 0 1)
       (datum 0.408)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0.434)
      )
      (component detents 0.001)
     )
     (views
      (icon
       (extent 46 0)
      )
      (detail
       (origin 108 159)
       (extent 84 142)
      )
      (active detail)
     )
    )
    (component 3 "Formula"
     (name " - ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "Y")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "X-Y")
     )
     (views
      (icon
       (origin 107 358)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "Formula"
     (name "Sense Lock")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "(abs(a)+abs(b)<0.02 ? \"LOCKED\" : \"\")")
     )
     (views
      (icon
       (origin 375 408)
       (extent 110 25)
      )
      (detail
       (origin 287 390)
       (extent 367 60)
      )
      (active icon)
     )
    )
    (component 5 "TextDisplay"
     (name "lock")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
     )
     (views
      (icon
       (origin 567 408)
       (extent 46 25)
      )
      (detail
       (origin 667 403)
       (extent 126 34)
      )
      (active icon)
     )
    )
    (component 6 "ShiftRegister"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
      (output 1
       (type data)
       (name "Current")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "1 Prev")
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
     )
     (views
      (icon
       (origin 182 408)
       (extent 136 25)
      )
      (detail
       (origin 235 345)
       (extent 80 70)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "Formula"
     (name " - ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "Y")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "X-Y")
     )
     (views
      (icon
       (origin 377 368)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 8 "Formula"
     (name "Kp*P+Ki*I+Kd*D")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Kp")
       (optional yes)
      )
      (input 2
       (type data)
       (name "Ki")
       (optional yes)
      )
      (input 3
       (type data)
       (name "Kd")
       (optional yes)
      )
      (input 4
       (type data)
       (name "P")
       (optional yes)
      )
      (input 5
       (type data)
       (name "I")
       (optional yes)
      )
      (input 6
       (type data)
       (name "D")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "(Kp*P+Ki*I+Kd*D)")
     )
     (views
      (icon
       (origin 502 168)
       (extent 136 65)
      )
      (detail
       (origin 506 112)
       (extent 178 256)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 9 "Meter"
     (name "Error")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock name constraints)
      )
      (input 2
       (type control)
       (name "MinValue")
       (tag "MinValue")
       (lock constraints)
       (optional yes)
      )
      (input 3
       (type control)
       (name "MaxValue")
       (tag "MaxValue")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
      (component range -1 1)
     )
     (views
      (icon
       (origin 491 293)
       (extent 78 34)
      )
      (detail
       (origin 641 178)
       (extent 179 124)
      )
      (active icon)
     )
    )
    (component 10 "SlidingWindow"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
       (requires
        (shape "Scalar")
       )
       (lock constraints)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
     )
     (implementation
      (component vecSize 64)
      (component triggerSize 1)
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
     )
     (views
      (icon
       (origin 149 318)
       (extent 163 25)
      )
      (detail
       (origin 106 299)
       (extent 248 63)
      )
      (active icon)
     )
    )
    (component 11 "Formula"
     (name "sum(a)/64")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "sum(a)/64")
     )
     (views
      (icon
       (origin 325 318)
       (extent 110 25)
      )
      (detail
       (origin 297 301)
       (extent 166 58)
      )
      (active icon)
     )
    )
    (configuration
     (connect I1:1 D3:1)
     (connect I2:1 D3:2)
     (connect D6:1 D4:1)
     (connect D6:2 D4:2)
     (connect D4:1 D5:1)
     (connect D3:1 D6:1)
     (connect D6:1 D7:1)
     (connect D6:2 D7:2)
     (connect D2:1 D8:1)
     (connect D0:1 D8:2)
     (connect D1:1 D8:3)
     (connect D3:1 D8:4)
     (connect D11:1 D8:5)
     (connect D7:1 D8:6)
     (connect D3:1 D9:1)
     (connect D3:1 D10:1)
     (connect D10:1 D11:1)
     (connect D8:1 O1:1)
     (connect D4:1 O2:1)
    )
   )
   (views
    (icon
     (origin 275 291)
     (extent 150 59)
    )
    (panel
     (origin 82 121)
     (extent 537 279)
     (widget 2 detail
      (title on)
      (origin 95 166)
      (extent 90 142)
     )
     (widget 0 detail
      (title on)
      (origin 196 167)
      (extent 90 143)
     )
     (widget 1 detail
      (title on)
      (origin 298 168)
      (extent 90 144)
     )
     (widget 9 detail
      (title on)
      (origin 413 170)
      (extent 179 124)
     )
     (widget 5 detail
      (title off)
      (origin 441 310)
      (extent 126 34)
     )
    )
    (detail
     (origin 77 116)
     (extent 587 329)
     (configuration
      (connect I1:1 D3:1
       (Point 79 200)
       (Point 90 200)
       (Point 90 360)
       (Point 104 360)
      )
      (connect I2:1 D3:2
       (Point 79 380)
       (Point 91 380)
       (Point 91 380)
       (Point 104 380)
      )
      (connect D6:1 D4:1
       (Point 320 410)
       (Point 372 410)
      )
      (connect D6:2 D4:2
       (Point 320 430)
       (Point 372 430)
      )
      (connect D4:1 D5:1
       (Point 487 420)
       (Point 564 420)
      )
      (connect D3:1 D6:1
       (Point 155 370)
       (Point 155 420)
       (Point 179 420)
      )
      (connect D6:1 D7:1
       (Point 320 410)
       (Point 320 370)
       (Point 374 370)
      )
      (connect D6:2 D7:2
       (Point 320 430)
       (Point 340 430)
       (Point 340 390)
       (Point 374 390)
      )
      (connect D2:1 D8:1
       (Point 194 230)
       (Point 200 230)
       (Point 200 310)
       (Point 420 310)
       (Point 420 300)
       (Point 440 300)
       (Point 440 170)
       (Point 499 170)
      )
      (connect D0:1 D8:2
       (Point 305 230)
       (Point 320 230)
       (Point 320 120)
       (Point 430 120)
       (Point 430 180)
       (Point 499 180)
      )
      (connect D1:1 D8:3
       (Point 412 230)
       (Point 430 230)
       (Point 430 190)
       (Point 499 190)
      )
      (connect D3:1 D8:4
       (Point 155 370)
       (Point 170 370)
       (Point 170 360)
       (Point 470 360)
       (Point 470 270)
       (Point 510 270)
       (Point 510 200)
       (Point 499 200)
      )
      (connect D11:1 D8:5
       (Point 437 330)
       (Point 450 330)
       (Point 450 210)
       (Point 499 210)
      )
      (connect D7:1 D8:6
       (Point 425 380)
       (Point 460 380)
       (Point 460 220)
       (Point 499 220)
      )
      (connect D3:1 D9:1
       (Point 155 370)
       (Point 170 370)
       (Point 170 360)
       (Point 470 360)
       (Point 470 300)
       (Point 488 300)
      )
      (connect D3:1 D10:1
       (Point 155 370)
       (Point 170 370)
       (Point 170 350)
       (Point 140 350)
       (Point 140 330)
       (Point 146 330)
      )
      (connect D10:1 D11:1
       (Point 314 330)
       (Point 318 330)
       (Point 318 330)
       (Point 322 330)
      )
      (connect D8:1 O1:1
       (Point 640 200)
       (Point 650 200)
       (Point 650 200)
       (Point 661 200)
      )
      (connect D4:1 O2:1
       (Point 487 420)
       (Point 550 420)
       (Point 550 380)
       (Point 661 380)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "Formula"
   (name "1st Order Load")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Zi")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "(A*1.7)+Zi")
   )
   (views
    (icon
     (origin 282 418)
     (extent 136 25)
    )
    (detail
     (origin 273 353)
     (extent 124 154)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 10 "Context"
   (name "Generate Input")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Slider"
     (name "Setpt")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "MaxValue")
       (tag "MaxValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (input 2
       (type control)
       (name "MinValue")
       (tag "MinValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Setpt")
       (values range 0 1)
       (datum 0.907)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
      (component detents 0.001)
     )
     (views
      (icon
       (extent 78 0)
      )
      (detail
       (origin 41 170)
       (extent 109 141)
      )
      (active detail)
     )
    )
    (component 1 "EnumConstant"
     (name "SETPT MODE")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Enum
       (name "SETPT MODE")
       (values
        ( "CONTROL TO SETPOINT" 0)
        ( "ALT. SETPOINT/LOWPT" 1)
       )
       (datum "CONTROL TO SETPOINT")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Enum
       (shared yes)
       (datum "CONTROL TO SETPOINT")
      )
     )
     (views
      (icon
       (origin 42 528)
       (extent 110 25)
      )
      (detail
       (origin 224 470)
       (extent 232 60)
       (format buttons)
      )
      (active detail)
     )
    )
    (component 2 "Slider"
     (name "Lowpt")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "MaxValue")
       (tag "MaxValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (input 2
       (type control)
       (name "MinValue")
       (tag "MinValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Lowpt")
       (values range 0 1)
       (datum 0.148)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
      (component detents 0.001)
     )
     (views
      (icon
       (origin 181 268)
       (extent 78 25)
      )
      (detail
       (origin 46 412)
       (extent 129 157)
      )
      (active detail)
     )
    )
    (component 3 "Formula"
     (name "Operate/Tune 20 Lo, 20 Hi")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (optional yes)
      )
      (input 3
       (type data)
       (name "C")
       (optional yes)
      )
      (input 4
       (type data)
       (name "TUNE")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "((a MOD 40)<20 AND ordinal(TUNE) ? c : b)")
     )
     (views
      (icon
       (origin 223 338)
       (extent 235 45)
      )
      (detail
       (origin 129 258)
       (extent 403 204)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect I1:1 D3:1)
     (connect D0:1 D3:2)
     (connect D2:1 D3:3)
     (connect D1:1 D3:4)
     (connect D3:1 O1:1)
    )
   )
   (views
    (icon
     (origin 282 238)
     (extent 136 25)
    )
    (panel
     (origin 206 118)
     (extent 289 304)
     (widget 1 detail
      (title off)
      (origin 226 127)
      (extent 245 58)
      (format buttons)
     )
     (widget 0 detail
      (title on)
      (origin 227 230)
      (extent 108 180)
     )
     (widget 2 detail
      (title on)
      (origin 366 232)
      (extent 104 178)
     )
    )
    (detail
     (origin 66 115)
     (extent 548 470)
     (configuration
      (connect I1:1 D3:1
       (Point 68 360)
       (Point 120 360)
       (Point 120 340)
       (Point 220 340)
      )
      (connect D0:1 D3:2
       (Point 152 240)
       (Point 170 240)
       (Point 170 350)
       (Point 220 350)
      )
      (connect D2:1 D3:3
       (Point 177 490)
       (Point 200 490)
       (Point 200 360)
       (Point 220 360)
      )
      (connect D1:1 D3:4
       (Point 458 500)
       (Point 480 500)
       (Point 480 420)
       (Point 210 420)
       (Point 210 370)
       (Point 220 370)
      )
      (connect D3:1 O1:1
       (Point 460 360)
       (Point 595 360)
       (Point 595 360)
       (Point 611 360)
      )
     )
    )
    (active icon)
   )
  )
  (component 11 "ForCount"
   (name "2000")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component count 2000)
   )
   (views
    (icon
     (origin 141 268)
     (extent 78 64)
     (iconImage loop.icon)
    )
    (detail
     (origin 95 283)
     (extent 170 34)
    )
    (active icon)
   )
  )
  (component 12 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "RepeatUntilBreak"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 125 268)
       (extent 110 64)
       (iconImage loop.icon)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (description 7 9
         This tiny "thread" begins running when the 
         enclosing UserObject is executed.  When the user
         acknowledges the OK/DONE button, there is nothing
         left to execute, so the thread ends.  Since there
         are not other threads running, the User Object
         is completed and will exit, removing the Show on
         Execute pop-up display.
        )
        (icon
         (origin 421 482)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (interface
       )
       (implementation
        (component text 85 9
         PURPOSE:      A simple Proportional-Integral-Derivative controller for closed-loop
                       process control.
         
         USER INPUT REQUIRED:  After pressing RUN, you can operate the PID simulator in two modes;
                       Input Generated by SETPOINT lets the Setpoint slider be moved to change the
                       operating point of the process.  With ALT. SETPOINTT/LOWPT, the PID control
                       point will alternate between the Setpoint and the LOW PT values, allowing
                       you to adjust the three PID control parameters (Kp, Ki, Kd) for best loop
                       operation.
         
         EXPLANATION:  PID control is useful in systems that sample an output, compare the sample
                       to a desired result, and take corrective action to force the controlled
                       element closer to the desired result (setpoint).  In a well-tuned PID
                       control loop, the "load" reaches the desired value rapidly with minimal
                       over and undershoot. 
         
                       The words Proportional, Integral, and Derivative describe the correction
                       algorithms based on the error, the integrated error over time, and the
                       rate of change in the error term.  The general form of a PID control is:
         
                            OUTPUT = Kp * Error + Ki * sum(Error) + Kd * d(Error)/dt.  
         
                       The Kp, Ki, and Kd terms are coefficients that tune a PID loop to a
                       particular load system.  In this example, you can select either a first-
                       order load (similar to an R-C network) or a second-order load (2 cascaded
                       R-C networks).  The goal is to set Kp, Ki, and Kd to minimize the over
                       and undershoot of the simulated load, while minimizing the settling time
                       to reach stable (Locked) control.  (The values provided when the model is
                       first loaded are approximately correct for the second-order load; try to
                       tune the loop for a first order load, then try to retune the second order
                       load again.)  
         
                       To begin tuning a PID loop, set all three constants to 0.  To simulate
                       a sudden setpoint change, you can use the TUNE-JOG operating mode; this
                       alternates between the Setpoint value and the Tune -Lo value, allowing
                       you to concentrate on tuning rather than continually readjusting a setpt.
         
                       The first parameter to be adjusted is the Proportional constant, so named
                       because it's corrective action is proportional to the Error term derived
                       by subtracting the current load value from the Setpoint value.  Because
                       this coefficient operates only on the latest value, it is used to provide
                       fast correction.  When too small, the load approaches the setpoint too
                       slowly; when too large, the load overshoots the setpoint and reaches the
                       setpoint with damped oscillation. 
         
                       The second parameter to be adjusted is the Derivative constant, so named
                       because the amount of correction applied depends on the rate that the
                       error term is changing.   By adding appropriate Kd correction, the over-
                       shoot and oscillation caused by Kp can be cancelled.  Note that this
                       factor becomes unstable quickly if too large, resulting in undamped
                       oscillation itself.  One might think of this as "use sparingly and only
                       as needed".
         
                       The final parameter to be adjusted is the Integral constant, so named
                       because it represents the integrated error over a reasonable time period.
                       Because no setting of Kp and Kd can totally prevent over and undershoot,
                       the integral correction can be used to minimize the accumulated error at
                       the expense of settling time.  It is generally good to keep settling time
                       as short as possible, while also preventing excessive long-term errors
                       arising from system losses and instrument drift.
         
         
                       IMPLEMENTATION:
         
                       The PID controller is implemented as a User Object that accepts the Setpt
                       and measured load values as inputs, then calculates a corrective Output
                       value based on the Kp, Ki, and Kd parameters.  The Error term is obtained
                       by subtracting the Setpoint and Actual values.  The Integral term is found
                       by summing the last 256 Error values, normalizing by dividing by 256.  The
                       derivative term is computed using the current and previous Error terms with
                       a simple delta error/delta time approximation for Error slope.  
         
                       A formula box implements the Kp, Ki, Kd coefficient multiplication and 
                       output value summing.  An absolute magnitude error monitor senses when the
                       PID loop is within 0.002 of the desired setpoint.
         
                       THE SIMULATED LOADS:
         
                       Using techniques from the digitalfilter application example, the first and
                       second order loads were implemented using numeric filtering methods to
                       simulate load response to a corrective input.  With a first order load, any
                       oscillation problems are usually the result of excessive Kd correction. 
                       The phase shift of the second order load lends itself easily to instability
                       and oscillation, representing a more typical real world load.
         
        )
       )
       (views
        (description 2 9
         This notepad is displayed as a Show on Execute
         panel to present the information to the reader.
        )
        (icon
         (origin 410 415)
         (extent 78 25)
        )
        (detail
         (origin 25 209)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 55 78)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 45 174)
         (extent 832 463)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:1 D1:0)
     (connect D3:0 D1:1)
     (connect D0:1 D3:0)
    )
   )
   (views
    (icon
     (origin 175 368)
     (extent 110 25)
    )
    (panel
     (origin 181 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 283 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:1 D1:0
       (Point 237 300)
       (Point 258 300)
       (Point 258 340)
      )
      (connect D3:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D3:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D1:0 D0:0)
   (connect D9:1 D0:1)
   (connect D3:1 D0:2)
   (connect D1:1 D0:3)
   (connect D3:0 D1:0)
   (connect D9:0 D2:0)
   (connect D8:1 D2:1)
   (connect D2:1 D2:2)
   (connect D2:0 D3:0)
   (connect D2:1 D3:1)
   (connect D3:1 D3:2)
   (connect D5:0 D4:0)
   (connect D10:1 D7:1)
   (connect D0:1 D7:2)
   (connect D11:0 D7:3)
   (connect D10:1 D8:1)
   (connect D0:1 D8:2)
   (connect D8:1 D9:1)
   (connect D9:1 D9:2)
   (connect D11:1 D10:1)
   (connect D4:1 D11:0)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 998 667)
   (widget 12 panel
    (title on)
    (origin 66 108)
    (extent 267 69)
    (widget 1 icon
     (title off)
     (origin 141 122)
     (extent 114 39)
     (format button)
    )
   )
   (widget 1 detail
    (title on)
    (origin 64 222)
    (extent 272 57)
    (format buttons)
   )
   (widget 7 detail
    (title on)
    (origin 417 444)
    (extent 540 253)
    (displayMode annotGraph)
    (graphType cartesian)
    (gridType frame)
    (scale 0
     (name "LOAD")
     (domainName "    ")
     (color 0x909090)
     (show 1)
     (range -0.25 1.25 3 linear)
    )
    (domain 0 99.99999999999932 4 linear)
    (trace 0 onScale 0
     (name "SETPT")
     (color 0xffdd00)
     (lineType 1)
     (pointType 0)
    )
    (trace 1 onScale 0
     (name "ACTUAL")
     (color 0xccff)
     (lineType 1)
     (pointType 0)
    )
    (stepSize 1)
    (trackingEnabled 1)
   )
   (widget 8 panel
    (title on)
    (origin 416 113)
    (extent 537 279)
    (widget 9 detail
     (title on)
     (origin 754 165)
     (extent 179 124)
    )
    (widget 5 detail
     (title off)
     (origin 786 335)
     (extent 126 34)
    )
    (widget 1 detail
     (title on)
     (origin 645 162)
     (extent 84 213)
    )
    (widget 0 detail
     (title on)
     (origin 536 163)
     (extent 87 213)
    )
    (widget 2 detail
     (title on)
     (origin 430 163)
     (extent 88 216)
    )
   )
   (widget 10 panel
    (title on)
    (origin 63 323)
    (extent 270 285)
    (widget 1 detail
     (title off)
     (origin 76 332)
     (extent 244 56)
     (format buttons)
    )
    (widget 0 detail
     (title on)
     (origin 80 428)
     (extent 115 169)
    )
    (widget 2 detail
     (title on)
     (origin 210 430)
     (extent 109 168)
    )
   )
   (widget 6 detail
    (title on)
    (origin 9 650)
    (extent 397 82)
    (editing disabled)
   )
  )
  (detail
   (origin 0 67)
   (extent 981 635)
   (configuration
    (connect D1:0 D0:0
     (Point 350 655)
     (Point 350 680)
     (Point 490 680)
     (Point 490 480)
     (Point 540 480)
     (Point 540 500)
    )
    (connect D9:1 D0:1
     (Point 420 430)
     (Point 440 430)
     (Point 440 510)
     (Point 469 510)
    )
    (connect D3:1 D0:2
     (Point 425 530)
     (Point 440 530)
     (Point 440 520)
     (Point 469 520)
    )
    (connect D1:1 D0:3
     (Point 457 640)
     (Point 480 640)
     (Point 480 570)
     (Point 450 570)
     (Point 450 530)
     (Point 469 530)
    )
    (connect D3:0 D1:0
     (Point 350 545)
     (Point 350 594)
    )
    (connect D9:0 D2:0
     (Point 350 445)
     (Point 350 465)
    )
    (connect D8:1 D2:1
     (Point 427 300)
     (Point 450 300)
     (Point 450 380)
     (Point 240 380)
     (Point 240 470)
     (Point 275 470)
    )
    (connect D2:1 D2:2
     (Point 425 480)
     (Point 450 480)
     (Point 450 390)
     (Point 250 390)
     (Point 250 490)
     (Point 275 490)
    )
    (connect D2:0 D3:0
     (Point 350 495)
     (Point 350 515)
    )
    (connect D2:1 D3:1
     (Point 425 480)
     (Point 450 480)
     (Point 450 390)
     (Point 250 390)
     (Point 250 520)
     (Point 275 520)
    )
    (connect D3:1 D3:2
     (Point 425 530)
     (Point 440 530)
     (Point 440 560)
     (Point 270 560)
     (Point 270 540)
     (Point 275 540)
    )
    (connect D5:0 D4:0
     (Point 60 201)
     (Point 60 215)
    )
    (connect D10:1 D7:1
     (Point 420 250)
     (Point 440 250)
     (Point 440 290)
     (Point 640 290)
     (Point 640 570)
     (Point 560 570)
     (Point 560 650)
     (Point 570 650)
    )
    (connect D0:1 D7:2
     (Point 610 520)
     (Point 630 520)
     (Point 630 560)
     (Point 550 560)
     (Point 550 670)
     (Point 570 670)
    )
    (connect D11:0 D7:3
     (Point 180 334)
     (Point 180 700)
     (Point 550 700)
     (Point 550 690)
     (Point 570 690)
    )
    (connect D10:1 D8:1
     (Point 420 250)
     (Point 440 250)
     (Point 440 370)
     (Point 260 370)
     (Point 260 300)
     (Point 272 300)
    )
    (connect D0:1 D8:2
     (Point 610 520)
     (Point 630 520)
     (Point 630 560)
     (Point 550 560)
     (Point 550 670)
     (Point 540 670)
     (Point 540 690)
     (Point 220 690)
     (Point 220 370)
     (Point 240 370)
     (Point 240 340)
     (Point 272 340)
    )
    (connect D8:1 D9:1
     (Point 427 300)
     (Point 450 300)
     (Point 450 380)
     (Point 270 380)
     (Point 270 420)
     (Point 279 420)
    )
    (connect D9:1 D9:2
     (Point 420 430)
     (Point 440 430)
     (Point 440 400)
     (Point 260 400)
     (Point 260 440)
     (Point 279 440)
    )
    (connect D11:1 D10:1
     (Point 221 300)
     (Point 240 300)
     (Point 240 250)
     (Point 279 250)
    )
    (connect D4:1 D11:0
     (Point 117 250)
     (Point 180 250)
     (Point 180 265)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
