#! /usr/lib/veetest/veetest -d /usr/lib/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name "Fluidflow Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Constant"
   (name "SclDiv")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "SclDiv")
     (datum 10)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (description 5 5
     This "Data -> Constant -> Integer" object is
     being used to hold a constant that defines the
     size of the array and the "Max.Head, ft." value
     will be subdivided for use in calculation and
     plotting.
    )
    (icon
     (origin 161 737)
     (extent 78 25)
    )
    (detail
     (origin 127 646)
     (extent 147 28)
    )
    (active icon)
   )
  )
  (component 1 "Constant"
   (name "Coefficient")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Coefficient")
     (datum 0.82)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (description 10 5
     This "Data -> Constant -> Real" object is used
     to enter the Orifice Coefficient, which is
     dependent on the orifice structure.  For example,
     two coefficients for a cylindrical orifice:
     
       Thick plate, with a small orifice
       diameter:                    (4d>t>=2d) -> .82
     
       Beveled orifice, or thin plate with
       a large orifice diameter:    (t<d/4)    -> .61
    )
    (icon
     (extent 110 0)
    )
    (detail
     (origin 35 594)
     (extent 191 31)
    )
    (active detail)
   )
  )
  (component 2 "ForRange"
   (name "Orifice Dia. in.")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component from 0.2)
    (component thru 1)
    (component step 0.2)
   )
   (views
    (description 8 5
     This "Data -> Repeat -> For Count" object
     provides input to define the range of orifice
     diameters to be used in calculations, and 
     controls the number of graphs plotted.
     
     The "sequence in" connection from the "Build
     Array" object ensures that this object will not
     activate until the array is built.
    )
    (icon
     (extent 154 0)
     (iconImage loop.icon)
    )
    (detail
     (origin 28 433)
     (extent 205 93)
    )
    (active detail)
   )
  )
  (component 3 "IfThenElse"
   (name "!=0")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "A!=0")
   )
   (views
    (icon
     (origin 317 278)
     (extent 46 25)
    )
    (detail
     (origin 333 365)
     (extent 64 70)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "Formula"
   (name "Formula")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "H")
     (optional yes)
    )
    (input 2
     (type data)
     (name "D")
     (optional yes)
    )
    (input 3
     (type data)
     (name "C")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "19.64*C*(D^2)*(H^.5)")
   )
   (views
    (description 17 5
     This "Math -> Formula" object contains the basic
     formula for the model: (19.64*C)*(D^2)*(H^.5)
     where C is the orifice coefficient;
           D is the orifice diameter, inches;
       and H is the water height in the tank, feet.
     
     The constant 19.64 is derived from combining the
     gravity constant and various conversion constants
     to yield gallons per minute flow values:
      (((2*32.174)^.5)*(pi/576)*((12^3)/231)*60)
     
     Based on equation of flow: Q = C*Area*Velocity,
     which in terms of head and orifice diameter
     becomes, before simplification:
     
     (1728*60/231)*C*((PI/4)*(D/12)^2)*(2*32.174*H)^.5
     
    )
    (icon
     (origin 365 354)
     (extent 91 72)
     (iconImage formula.icon)
    )
    (detail
     (origin 158 335)
     (extent 214 150)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "Formula"
   (name "Generate Head Data")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "numPts")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "ramp(numPts,10,numPts*10)")
   )
   (views
    (description 13 5
     This formula box will generate the "Head" data
     used in the water flow calculation and on the 
     X-axis of the plot.
     
     The formula box demonstrates a way to generate
     data that is equidistantly spaced.  That is, the
     ramp function with correct choices of start and
     stop values will generate an array of data. 
     
     Math operations are many time faster when 
     operating on arrays of data than on a single value
     at a time.  Try to use them in your models to 
     speed up execution time.
    )
    (icon
     (origin 44 348)
     (extent 172 25)
    )
    (detail
     (origin 191 220)
     (extent 259 60)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "Start"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (description 3 5
     Start is a "Flow" object, used to signal when
     data entry is complete and calculation is to
     proceed.
    )
    (icon
     (origin 96 291)
     (extent 69 39)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "Formula"
   (name " / ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X/Y")
   )
   (views
    (description 5 5
     This is a "Math -> +-*/ -> /" object used to
     divide the "Max. Head, ft." value by a simple
     scaling divisor, to determine the size of the
     divisions between one value of "head" and
     another.
    )
    (icon
     (origin 287 698)
     (extent 46 25)
    )
    (detail
     (origin 277 838)
     (extent 79 104)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "Constant"
   (name "Max. Head, ft.")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Max. Head, ft.")
     (datum 200)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (description 4 5
     This "Data -> Constant -> Real" object contains
     the value input for the maximum height ("head")
     of water in a tank to be considered, and defines
     the upper limit for calculations and plots.
    )
    (icon
     (origin 62 568)
     (extent 136 25)
    )
    (detail
     (origin 35 684)
     (extent 210 33)
    )
    (active detail)
   )
  )
  (component 9 "Toggle"
   (name "Info")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type control)
     (name "Reset")
     (lock name constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Info")
     (values range 0 1)
     (datum 0)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (origin 240 271)
     (extent 60 39)
     (format button)
    )
    (detail
     (origin 687 225)
     (extent 7 71)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 10 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 5 5
     This example is provided as an
     illustration "as is", and Hewlett-
     Packard Company makes no warranty
     of any kind with regard to this
     example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 12 120)
     (extent 316 101)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 11 "Note"
   (name "Note Pad")
   (interface
   )
   (implementation
    (component text 3 5
     Each plot presents values 
     based on a specific orifice 
     diameter.
    )
   )
   (views
    (description 5 5
     This "Display -> Note Pad" object is used on the
     panel in an open view, as an enunciator, in order
     to clarify the meaning of the multiple lines on
     the plot display.
      
    )
    (icon
     (origin 345 178)
     (extent 110 25)
    )
    (detail
     (origin 273 146)
     (extent 274 68)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 12 "Note"
   (name "Overview of Example")
   (interface
   )
   (implementation
    (component text 15 5
     PURPOSE: Show Mechanical Engineering 
      capabilities of HP VEE using a 
      "flow from orifice in tank" example.
     
     REQUIRED USER INPUT:  None. 
      Click "Start" to run the model.  
      You may change the following values:
     
       Enter Maximum Fluid Head (feet)
        (Data points based on 1/10th of Max.)
       Enter Orifice Dia. (inches)
        ("From, Thru, Step Range" values)
       Enter Orifice Coefficient
     
      Click "Info" for more information.
    )
   )
   (views
    (description 5 5
     This is a "Display -> Note Pad" object, displayed
     on the panel in an open view, which is used to
     convey the basic information necessary to use
     this "Water Flow thru and Orifice" model.
     
    )
    (icon
     (origin 55 235)
     (extent 190 30)
    )
    (detail
     (origin 5 111)
     (extent 430 298)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 13 "Context"
   (name "Details of Fluidflow Example")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Confirm"
     (name " OK ")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 491 602)
       (extent 58 37)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Start"
     (name "Start")
     (interface
      (sequence out)
     )
     (implementation
     )
     (views
      (icon
       (origin 486 541)
       (extent 69 39)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Note"
     (name "Note Pad")
     (interface
     )
     (implementation
      (component text 38 7
       PURPOSE:  Show a simple Mechanical Engineering problem setup and solution. 
        It also shows methods of data entry and display, the use of arrays and calculation 
        formula, and simple sequence control.
       
       USER DATA REQUIRED: None.  Click on "Start" to run the model. You may change 
        any value by clicking on the entry field of an object and entering a new value.
       
       EXPLANATION: The model uses a simple formula to calculate the water flow volume (gpm)
        from an orifice in a tank wall, based on the height of water ("head", in feet) above
        the orifice (with diameter in inches).  The .82 orifice coefficient corresponds to a
        cylindrical hole in a tank wall of thickness two or three times the orifice diameter.
        (Another coefficient example would be .61 for a beveled orifice, or for a relatively
        large orifice in a thin wall.)
       
        This example also demonstrates some basic HP VEE capabilities, such as graphically
        displaying ranges of flow depending on various head and orifice values.  The model 
        was built using the panel approach for simplified entry and viewing of the data.  
        More specifics of the model can be seen by clicking on the "Detail" button, located 
        on the left side of the title bar.  The detail view shows the objects, some in an 
        iconized state, and the data and sequence interconnections.  To see the open view 
        of an icon, double-click on it with the left mouse button.
       
        The multiple generation of curves provides an example of the need for sequence control,
        which is done by using a "For Count" object (generates a range of values for orifice
        diameter) that has its sequence controlled by the "Generate Head Values" object, 
        which uses a "Ramp Formula" to generate evenly spaced values in an array.  This is
        necessary to ensure that the array (which contains "head" values) has been completed
        before the "For Count" object activates.  A specific diameter value is used along with
        the orifice coefficient and the "head" array as inputs to the "Formula" object, which
        then calculates an array output as an individual line on the plot display.  Each new
        diameter value also triggers a "Next Curve" input to the display, as well as the 
        calculation of a new output array.
       
        Select  "Show Description" from the object menu on each object to gain more 
        information about the function of the object.  From this menu you may also 
        directly access the "Help" information for the object.
       
        Click on "OK" to exit this information panel.
      )
     )
     (views
      (icon
       (origin 405 337)
       (extent 110 25)
      )
      (detail
       (origin 314 401)
       (extent 812 378)
       (editing disabled)
      )
      (active detail)
     )
    )
    (configuration
     (connect D1:0 D0:0)
    )
    (ShowOnExecPanel
     (origin 24 77)
     (extent 851 534)
     (panel
      (origin 7 112)
      (extent 847 496)
      (widget 2 detail
       (title off)
       (origin 20 126)
       (extent 822 419)
       (editing disabled)
      )
      (widget 0 icon
       (title off)
       (origin 399 558)
       (extent 58 37)
      )
     )
    )
   )
   (views
    (icon
     (origin 380 308)
     (extent 40 24)
     (label off)
    )
    (detail
     (origin 300 350)
     (extent 241 141)
     (configuration
      (connect D1:0 D0:0
       (Point 520 582)
       (Point 520 599)
      )
     )
    )
    (active icon)
   )
  )
  (component 14 "Note"
   (name "1\"")
   (interface
   )
   (implementation
   )
   (views
    (description 4 5
     This "Display -> Note Pad" object has had its
     title changed, and is being used as an icon to 
     provide a simple label to identify one of the
     plots.
    )
    (icon
     (origin 927 167)
     (extent 46 25)
    )
    (detail
     (origin 780 134)
     (extent 180 90)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 15 "Note"
   (name ".6\"")
   (interface
   )
   (implementation
   )
   (views
    (description 4 5
     This "Display -> Note Pad" object has had its
     title changed, and is being used as an icon to
     provide a simple label to identify one of the
     plots.
    )
    (icon
     (origin 927 437)
     (extent 46 25)
    )
    (detail
     (origin 780 404)
     (extent 180 90)
     (editing enabled)
    )
    (active icon)
   )
  )
  (component 16 "Note"
   (name ".2\"")
   (interface
   )
   (implementation
   )
   (views
    (description 4 5
     This "Display -> Note Pad" object has had its
     title changed, and is being used as an icon to
     provide a simple label to identify one of the
     plots.
    )
    (icon
     (origin 927 578)
     (extent 46 25)
    )
    (detail
     (origin 780 545)
     (extent 180 90)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 17 "XYPlot"
   (name "Water Flow vs. Head vs. Orifice Dia.")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "XData")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "Water Flow")
     (lock constraints)
    )
    (input 3
     (type control)
     (name "Next Curve")
     (lock name constraints)
     (optional yes)
    )
    (input 4
     (type control)
     (name "Auto Scale")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 2)
    (component graphMode rectangular)
   )
   (views
    (description 12 5
     This "Display -> X vs Y Plot" object is used to
     provide a plot of calculated results for each
     orifice diameter in the specified range, based on
     the input "head" array and orifice coefficient.
     The triangular marker in the display may be set
     to show the values of any point of interest by
     clicking on that point.  By using the display's
     object menu, you may observe various optional
     settings.  The appearance of the display can be
     significantly altered by changing some of these
     settings.
      
    )
    (icon
     (origin 493 407)
     (extent 334 64)
     (iconImage display.icon)
    )
    (detail
     (origin 489 143)
     (extent 503 592)
     (displayMode scrollGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Gal./Min.")
      (domainName "Water \"Head\" in Tank (feet)")
      (color 0x909090)
      (show 1)
      (range 0 250 3 linear)
     )
     (domain 0 200 3 linear)
     (trace 0 onScale 0
      (name "Water Flow")
      (color 0xffdd00)
      (lineType 1)
      (pointType 1)
     )
     (marker 0 onTrace 0)
    )
    (active detail)
   )
  )
  (configuration
   (connect D5:0 D2:0)
   (connect D9:1 D3:1)
   (connect D5:1 D4:1)
   (connect D2:1 D4:2)
   (connect D1:1 D4:3)
   (connect D6:0 D5:0)
   (connect D7:1 D5:1)
   (connect D8:1 D7:1)
   (connect D0:1 D7:2)
   (connect D3:0 D9:1)
   (connect D3:1 D13:0)
   (connect D5:1 D17:1)
   (connect D4:1 D17:2)
   (connect D2:1 D17:3)
   (connect D2:0 D17:4)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 972 580)
   (widget 8 detail
    (title on)
    (origin 5 522)
    (extent 180 32)
   )
   (widget 1 detail
    (title on)
    (origin 5 608)
    (extent 179 32)
   )
   (widget 2 detail
    (title on)
    (origin 194 522)
    (extent 179 118)
   )
   (widget 9 icon
    (title off)
    (origin 60 432)
    (extent 60 39)
    (format button)
   )
   (widget 6 icon
    (title off)
    (origin 242 434)
    (extent 69 39)
   )
   (widget 17 detail
    (title on)
    (origin 430 108)
    (extent 518 534)
    (displayMode scrollGraph)
    (graphType cartesian)
    (gridType grid)
    (scale 0
     (name "Flow, gpm")
     (domainName "Head (X)")
     (color 0x909090)
     (show 1)
     (range 0 250 3 linear)
    )
    (domain 0 200 3 linear)
    (trace 0 onScale 0
     (name "Water Flow")
     (color 0xffdd00)
     (lineType 1)
     (pointType 1)
    )
    (marker 0 onTrace 0)
   )
   (widget 14 icon
    (title off)
    (origin 878 134)
    (extent 35 20)
   )
   (widget 15 icon
    (title off)
    (origin 871 373)
    (extent 38 21)
   )
   (widget 16 icon
    (title off)
    (origin 879 493)
    (extent 37 19)
   )
   (widget 11 detail
    (title off)
    (origin 586 124)
    (extent 261 70)
    (editing disabled)
   )
   (widget 12 detail
    (title on)
    (origin 9 249)
    (extent 412 166)
    (editing disabled)
   )
   (widget 10 detail
    (title on)
    (origin 13 109)
    (extent 333 100)
    (editing disabled)
   )
  )
  (detail
   (origin 0 67)
   (extent 981 641)
   (configuration
    (connect D5:0 D2:0
     (Point 130 375)
     (Point 130 400)
    )
    (connect D9:1 D3:1
     (Point 302 290)
     (Point 314 290)
    )
    (connect D5:1 D4:1
     (Point 218 360)
     (Point 240 360)
     (Point 240 370)
     (Point 362 370)
    )
    (connect D2:1 D4:2
     (Point 235 479)
     (Point 260 479)
     (Point 260 390)
     (Point 362 390)
    )
    (connect D1:1 D4:3
     (Point 228 609)
     (Point 270 609)
     (Point 270 410)
     (Point 362 410)
    )
    (connect D6:0 D5:0
     (Point 130 332)
     (Point 130 345)
    )
    (connect D7:1 D5:1
     (Point 335 710)
     (Point 350 710)
     (Point 350 680)
     (Point 270 680)
     (Point 270 640)
     (Point 10 640)
     (Point 10 360)
     (Point 41 360)
    )
    (connect D8:1 D7:1
     (Point 247 700)
     (Point 284 700)
    )
    (connect D0:1 D7:2
     (Point 241 749)
     (Point 250 749)
     (Point 250 740)
     (Point 270 740)
     (Point 270 720)
     (Point 284 720)
    )
    (connect D3:0 D9:1
     (Point 340 305)
     (Point 340 330)
     (Point 220 330)
     (Point 220 290)
     (Point 237 290)
    )
    (connect D3:1 D13:0
     (Point 365 280)
     (Point 400 280)
     (Point 400 305)
    )
    (connect D5:1 D17:1
     (Point 218 360)
     (Point 240 360)
     (Point 240 370)
     (Point 350 370)
     (Point 350 340)
     (Point 440 340)
     (Point 440 229)
     (Point 486 229)
    )
    (connect D4:1 D17:2
     (Point 458 390)
     (Point 470 390)
     (Point 470 369)
     (Point 486 369)
    )
    (connect D2:1 D17:3
     (Point 235 479)
     (Point 260 479)
     (Point 260 509)
     (Point 486 509)
    )
    (connect D2:0 D17:4
     (Point 130 528)
     (Point 130 540)
     (Point 280 540)
     (Point 280 649)
     (Point 486 649)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
